/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin;

import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.plugin.model.Bean;
import org.ops4j.pax.cdi.api.OsgiServiceProvider;
import org.ops4j.pax.cdi.api.Properties;
import org.ops4j.pax.cdi.api.Property;

public class OsgiServiceProviderWriter {
    private XMLStreamWriter writer;

    public OsgiServiceProviderWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public void write(Collection<Bean> beans) throws XMLStreamException {
        for (Bean bean : beans) {
            this.write(bean);
        }
    }

    public void write(Bean bean) throws XMLStreamException {
        OsgiServiceProvider serviceProvider = bean.clazz.getAnnotation(OsgiServiceProvider.class);
        if (serviceProvider == null) {
            return;
        }
        if (serviceProvider.classes().length == 0) {
            throw new IllegalArgumentException("Need to provide the interface class in the @OsgiServiceProvider(classes={...}) annotation on " + bean.clazz);
        }
        Properties properties = bean.clazz.getAnnotation(Properties.class);
        if (properties == null) {
            this.writer.writeEmptyElement("service");
        } else {
            this.writer.writeStartElement("service");
        }
        this.writer.writeAttribute("ref", bean.id);
        Class serviceIf = serviceProvider.classes()[0];
        this.writer.writeAttribute("interface", serviceIf.getName());
        this.writer.writeCharacters("\n");
        if (properties != null) {
            this.writeProperties(properties);
            this.writer.writeEndElement();
            this.writer.writeCharacters("\n");
        }
    }

    private void writeProperties(Properties properties) throws XMLStreamException {
        this.writer.writeCharacters("    ");
        this.writer.writeStartElement("service-properties");
        this.writer.writeCharacters("\n");
        for (Property property : properties.value()) {
            this.writer.writeCharacters("        ");
            this.writer.writeEmptyElement("entry");
            this.writer.writeAttribute("key", property.name());
            this.writer.writeAttribute("value", property.value());
            this.writer.writeCharacters("\n");
        }
        this.writer.writeCharacters("    ");
        this.writer.writeEndElement();
        this.writer.writeCharacters("\n");
    }
}

