/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class NativeEnumDdlTypeImpl
implements DdlType {
    private final Dialect dialect;

    public NativeEnumDdlTypeImpl(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public int getSqlTypeCode() {
        return 6000;
    }

    @Override
    public String getTypeName(Size columnSize, Type type, DdlTypeRegistry ddlTypeRegistry) {
        return this.dialect.getEnumTypeDeclaration(type.getReturnedClass());
    }

    @Override
    public String getRawTypeName() {
        return "enum";
    }

    @Override
    public String getTypeName(Long size, Integer precision, Integer scale) {
        return "varchar(" + size + ")";
    }

    @Override
    public String getCastTypeName(JdbcType jdbcType, JavaType<?> javaType) {
        return "varchar";
    }

    @Override
    public String getCastTypeName(JdbcType jdbcType, JavaType<?> javaType, Long length, Integer precision, Integer scale) {
        return this.getTypeName(length, precision, scale);
    }
}

