/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.util;

import jakarta.persistence.FlushModeType;
import java.util.Locale;
import org.hibernate.AssertionFailure;
import org.hibernate.FlushMode;
import org.hibernate.MappingException;
import org.jboss.logging.Logger;

public class FlushModeTypeHelper {
    private static final Logger log = Logger.getLogger(FlushModeTypeHelper.class);

    private FlushModeTypeHelper() {
    }

    public static FlushModeType getFlushModeType(FlushMode flushMode) {
        if (flushMode == FlushMode.ALWAYS) {
            log.debug((Object)"Interpreting Hibernate FlushMode#ALWAYS to JPA FlushModeType#AUTO; may cause problems if relying on FlushMode#ALWAYS-specific behavior");
            return FlushModeType.AUTO;
        }
        if (flushMode == FlushMode.MANUAL) {
            log.debug((Object)"Interpreting Hibernate FlushMode#MANUAL to JPA FlushModeType#COMMIT; may cause problems if relying on FlushMode#MANUAL-specific behavior");
            return FlushModeType.COMMIT;
        }
        if (flushMode == FlushMode.COMMIT) {
            return FlushModeType.COMMIT;
        }
        if (flushMode == FlushMode.AUTO) {
            return FlushModeType.AUTO;
        }
        throw new AssertionFailure("unhandled FlushMode " + flushMode);
    }

    public static FlushMode getFlushMode(FlushModeType flushModeType) {
        if (flushModeType == FlushModeType.AUTO) {
            return FlushMode.AUTO;
        }
        if (flushModeType == FlushModeType.COMMIT) {
            return FlushMode.COMMIT;
        }
        throw new AssertionFailure("unhandled FlushModeType " + flushModeType);
    }

    public static FlushMode interpretFlushMode(Object value) {
        if (value == null) {
            return FlushMode.AUTO;
        }
        if (value instanceof FlushMode) {
            return (FlushMode)((Object)value);
        }
        if (value instanceof FlushModeType) {
            return FlushModeTypeHelper.getFlushMode((FlushModeType)value);
        }
        if (value instanceof String) {
            return FlushModeTypeHelper.interpretExternalSetting((String)value);
        }
        throw new IllegalArgumentException("Unknown FlushMode source : " + value);
    }

    public static FlushMode interpretExternalSetting(String externalName) {
        if (externalName == null) {
            return null;
        }
        try {
            log.debugf("Attempting to interpret external setting [%s] as FlushMode name", (Object)externalName);
            return FlushMode.valueOf(externalName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            log.debugf("Attempting to interpret external setting [%s] as FlushModeType name", (Object)externalName);
            try {
                return FlushModeTypeHelper.getFlushMode(FlushModeType.valueOf((String)externalName.toLowerCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MappingException("unknown FlushMode : " + externalName);
            }
        }
    }
}

