/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.service.credential.store;

import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.custos.core.commons.StatusUpdater;
import org.apache.custos.core.credential.store.api.CredentialMetadata;
import org.apache.custos.core.credential.store.api.Credentials;
import org.apache.custos.core.credential.store.api.DeleteCredentialRequest;
import org.apache.custos.core.credential.store.api.GetAllCredentialsRequest;
import org.apache.custos.core.credential.store.api.GetAllCredentialsResponse;
import org.apache.custos.core.credential.store.api.GetCredentialRequest;
import org.apache.custos.core.credential.store.api.GetNewCustosCredentialRequest;
import org.apache.custos.core.credential.store.api.GetOperationsMetadataRequest;
import org.apache.custos.core.credential.store.api.GetOperationsMetadataResponse;
import org.apache.custos.core.credential.store.api.GetOwnerIdResponse;
import org.apache.custos.core.credential.store.api.OperationMetadata;
import org.apache.custos.core.credential.store.api.OperationStatus;
import org.apache.custos.core.credential.store.api.TokenRequest;
import org.apache.custos.core.credential.store.api.Type;
import org.apache.custos.core.model.commons.StatusEntity;
import org.apache.custos.core.model.credential.store.CredentialEntity;
import org.apache.custos.core.repo.credential.store.CredentialRepository;
import org.apache.custos.service.credential.store.Credential;
import org.apache.custos.service.credential.store.CredentialManager;
import org.apache.custos.service.credential.store.CredentialTypes;
import org.apache.custos.service.credential.store.Operations;
import org.apache.custos.service.exceptions.AuthenticationException;
import org.apache.custos.service.exceptions.InternalServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultResponseSupport;

@Service
public class CredentialStoreService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialStoreService.class);
    private static final String BASE_PATH = "/secret/";
    private static final String KEY_PATH = "/secret/keys";
    private final VaultTemplate vaultTemplate;
    private final StatusUpdater statusUpdater;
    private final CredentialManager credentialManager;
    private final CredentialRepository repository;

    public CredentialStoreService(VaultTemplate vaultTemplate, StatusUpdater statusUpdater, CredentialManager credentialManager, CredentialRepository repository) {
        this.vaultTemplate = vaultTemplate;
        this.statusUpdater = statusUpdater;
        this.credentialManager = credentialManager;
        this.repository = repository;
    }

    public OperationStatus putCredential(CredentialMetadata request) {
        try {
            LOGGER.debug("Calling putSecret API for owner " + request.getOwnerId() + " with credentials Id " + request.getId() + " Secret " + request.getSecret());
            String path = BASE_PATH + request.getOwnerId() + "/" + request.getType().name();
            Credential credential = new Credential(request.getId(), request.getSecret());
            credential.setSuperTenant(request.getSuperTenant());
            this.vaultTemplate.write(path, (Object)credential);
            VaultResponseSupport response = this.vaultTemplate.read(path, Credential.class);
            if (response != null && response.getData() != null && ((Credential)response.getData()).getId() != null) {
                this.statusUpdater.updateStatus(Operations.PUT_CREDENTIAL.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getOwnerId(), null);
                return OperationStatus.newBuilder().setState(true).build();
            }
            String msg = "PutSecret operation failed for " + request.getOwnerId() + "with credentials Id " + request.getId() + " Secret " + request.getSecret() + " Type " + request.getType().name();
            LOGGER.error(msg);
            this.statusUpdater.updateStatus(Operations.PUT_CREDENTIAL.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getOwnerId(), null);
            throw new RuntimeException(msg);
        }
        catch (Exception ex) {
            String msg = "PutSecret operation failed for " + request.getOwnerId() + "with credentials Id " + request.getId() + " Secret " + request.getSecret() + " Type " + request.getType().name();
            LOGGER.error(msg);
            this.statusUpdater.updateStatus(Operations.PUT_CREDENTIAL.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getOwnerId(), null);
            throw new InternalServerException(msg);
        }
    }

    public CredentialMetadata getCredential(GetCredentialRequest request) {
        try {
            Optional entity;
            LOGGER.debug("Calling getSecret API for owner " + request.getOwnerId() + " for type " + String.valueOf(request.getType()));
            String path = BASE_PATH + request.getOwnerId() + "/" + request.getType().name();
            VaultResponseSupport response = this.vaultTemplate.read(path, Credential.class);
            if (response == null || response.getData() == null) {
                String msg = "Cannot find credentials for " + request.getOwnerId() + " for type " + String.valueOf(request.getType());
                LOGGER.error(msg);
                return CredentialMetadata.newBuilder().build();
            }
            Credential credential = (Credential)response.getData();
            CredentialMetadata.Builder secret = CredentialMetadata.newBuilder().setSecret(credential.getSecret()).setId(credential.getId()).setOwnerId(request.getOwnerId());
            if (request.getType() == Type.CUSTOS && (entity = this.repository.findByOwnerIdAndClientId(request.getOwnerId(), credential.getId())).isPresent()) {
                secret.setClientIdIssuedAt(((CredentialEntity)entity.get()).getIssuedAt().getTime());
                secret.setClientSecretExpiredAt(((CredentialEntity)entity.get()).getClientSecretExpiredAt());
            }
            return secret.build();
        }
        catch (Exception ex) {
            String msg = " operation failed for " + request.getOwnerId() + "with credentials Id " + request.getId() + " Type " + request.getType().name();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetAllCredentialsResponse getAllCredentials(GetAllCredentialsRequest request) {
        try {
            LOGGER.debug("Calling getAllSecrets API for owner " + request.getOwnerId());
            String subPath = BASE_PATH + request.getOwnerId();
            List paths = this.vaultTemplate.list(subPath);
            ArrayList<CredentialMetadata> credentialMetadata = new ArrayList<CredentialMetadata>();
            if (paths != null && !paths.isEmpty()) {
                for (String key : paths) {
                    String path;
                    VaultResponseSupport crRe;
                    if (!this.isMainType(key) || (crRe = this.vaultTemplate.read(path = subPath + "/" + key, Credential.class)) == null || crRe.getData() == null) continue;
                    CredentialMetadata metadata = this.convertToCredentialMetadata((Credential)crRe.getData(), request.getOwnerId(), key);
                    credentialMetadata.add(metadata);
                }
            }
            return GetAllCredentialsResponse.newBuilder().addAllSecretList(credentialMetadata).build();
        }
        catch (Exception ex) {
            String msg = " operation failed for " + request.getOwnerId() + " " + String.valueOf(ex);
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public OperationStatus deleteCredential(DeleteCredentialRequest request) {
        try {
            LOGGER.debug("Calling deleteSecret API for owner " + request.getOwnerId());
            String subPath = BASE_PATH + request.getOwnerId() + (String)(request.getType() != null ? "/" + request.getType().name() : "");
            List paths = this.vaultTemplate.list(subPath);
            if (paths != null && !paths.isEmpty()) {
                for (String key : paths) {
                    String path = subPath + "/" + key;
                    this.vaultTemplate.delete(path);
                }
            }
            this.statusUpdater.updateStatus(Operations.DELETE_CREDENTIAL.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getOwnerId(), null);
            return OperationStatus.newBuilder().setState(true).build();
        }
        catch (Exception ex) {
            String msg = " operation failed for " + request.getOwnerId();
            this.statusUpdater.updateStatus(Operations.DELETE_CREDENTIAL.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getOwnerId(), null);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetOperationsMetadataResponse getOperationMetadata(GetOperationsMetadataRequest request) {
        try {
            LOGGER.debug("Calling getOperationMetadata API for traceId " + request.getTraceId());
            ArrayList<OperationMetadata> metadata = new ArrayList<OperationMetadata>();
            List entities = this.statusUpdater.getOperationStatus(request.getTraceId());
            if (entities != null && !entities.isEmpty()) {
                for (StatusEntity statusEntity : entities) {
                    OperationMetadata data = this.convertFromEntity(statusEntity);
                    metadata.add(data);
                }
            }
            return GetOperationsMetadataResponse.newBuilder().addAllMetadata(metadata).build();
        }
        catch (Exception ex) {
            String msg = " operation failed for " + request.getTraceId();
            throw new InternalServerException(msg, ex);
        }
    }

    public CredentialMetadata getNewCustosCredential(GetNewCustosCredentialRequest request) {
        try {
            LOGGER.debug("Generating custos credentials for  " + request.getOwnerId());
            Credential credential = this.credentialManager.generateCredential(request.getOwnerId(), CredentialTypes.CUSTOS, 0L);
            String path = BASE_PATH + request.getOwnerId() + "/" + CredentialTypes.CUSTOS.name() + "/" + credential.getId();
            this.vaultTemplate.write(path, (Object)credential);
            VaultResponseSupport response = this.vaultTemplate.read(path, Credential.class);
            if (response == null || response.getData() == null || ((Credential)response.getData()).getId() == null) {
                String msg = "Get new custos operation failed for " + request.getOwnerId();
                LOGGER.error(msg);
                this.statusUpdater.updateStatus(Operations.GENERATE_CUSTOS_CREDENTIAL.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getOwnerId(), null);
                throw new InternalServerException(msg);
            }
            this.statusUpdater.updateStatus(Operations.GENERATE_CUSTOS_CREDENTIAL.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getOwnerId(), null);
            Optional entity = this.repository.findByOwnerIdAndClientId(request.getOwnerId(), credential.getId());
            if (entity.isEmpty()) {
                String msg = "Credential is not persisted" + request.getOwnerId();
                LOGGER.error(msg);
                this.statusUpdater.updateStatus(Operations.GENERATE_CUSTOS_CREDENTIAL.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getOwnerId(), null);
                throw new InternalServerException(msg);
            }
            CredentialEntity en = (CredentialEntity)entity.get();
            return CredentialMetadata.newBuilder().setOwnerId(request.getOwnerId()).setSecret(credential.getSecret()).setClientIdIssuedAt(en.getIssuedAt().getTime()).setClientSecretExpiredAt(en.getClientSecretExpiredAt()).setId(credential.getId()).build();
        }
        catch (Exception ex) {
            String msg = " Credential generation failed for tenant " + request.getOwnerId();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetOwnerIdResponse getOwnerIdFromToken(TokenRequest request) {
        try {
            LOGGER.debug("Get ownerId for    " + request.getToken());
            String token = request.getToken();
            Credential credential = CredentialManager.decodeToken(token);
            if (credential == null || credential.getId() == null) {
                LOGGER.error("Invalid access token");
                throw new EntityNotFoundException("Could not find a token");
            }
            CredentialEntity entity = this.repository.findByClientId(credential.getId());
            if (entity != null) {
                return GetOwnerIdResponse.newBuilder().setOwnerId(entity.getOwnerId()).build();
            }
            LOGGER.error("Could not find a token");
            throw new EntityNotFoundException("Could not find a token");
        }
        catch (Exception ex) {
            String msg = "operation failed";
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public CredentialMetadata getCustosCredentialFromToken(TokenRequest request) {
        try {
            LOGGER.debug("Get credential for " + request.getToken());
            String token = request.getToken();
            Credential credential = CredentialManager.decodeToken(token);
            if (credential == null || credential.getId() == null) {
                LOGGER.error("Invalid access token");
                throw new EntityNotFoundException("Could not find a token");
            }
            CredentialEntity entity = this.repository.findByClientId(credential.getId());
            if (entity == null) {
                LOGGER.error("Could not find a token");
                throw new EntityNotFoundException("Could not find a token");
            }
            String path = BASE_PATH + entity.getOwnerId() + "/" + Type.CUSTOS.name();
            VaultResponseSupport response = this.vaultTemplate.read(path, Credential.class);
            if (response == null || response.getData() == null || !((Credential)response.getData()).getSecret().equals(credential.getSecret())) {
                String msg = "Invalid secret for Id: " + credential.getId();
                LOGGER.error(msg);
                throw new AuthenticationException(msg);
            }
            return CredentialMetadata.newBuilder().setSecret(credential.getSecret()).setId(credential.getId()).setOwnerId(entity.getOwnerId()).setClientSecretExpiredAt(entity.getClientSecretExpiredAt()).setClientIdIssuedAt(entity.getIssuedAt().getTime()).setType(Type.CUSTOS).build();
        }
        catch (Exception ex) {
            String msg = "Error while extracting token from the CUSTOS credentials ";
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public CredentialMetadata getCustosCredentialFromClientId(GetCredentialRequest request) {
        try {
            String clientId = request.getId();
            CredentialEntity entity = this.repository.findByClientId(clientId);
            if (entity == null) {
                String msg = " Credentials not found for clientId " + clientId;
                LOGGER.error(msg);
                throw new EntityNotFoundException(msg);
            }
            String path = BASE_PATH + entity.getOwnerId() + "/" + Type.CUSTOS.name() + "/" + clientId;
            VaultResponseSupport response = this.vaultTemplate.read(path, Credential.class);
            if (!(response != null && response.getData() != null || (response = this.vaultTemplate.read(path = BASE_PATH + entity.getOwnerId() + "/" + Type.CUSTOS.name(), Credential.class)) != null && response.getData() != null)) {
                String msg = "Cannot find credentials for " + entity.getOwnerId() + " for type " + Type.CUSTOS.name();
                LOGGER.error(msg);
                throw new EntityNotFoundException(msg);
            }
            return CredentialMetadata.newBuilder().setSecret(((Credential)response.getData()).getSecret()).setId(request.getId()).setOwnerId(entity.getOwnerId()).setClientSecretExpiredAt(entity.getClientSecretExpiredAt()).setClientIdIssuedAt(entity.getIssuedAt().getTime()).setSuperTenant(((Credential)response.getData()).isSuperTenant()).setType(Type.CUSTOS).build();
        }
        catch (Exception ex) {
            String msg = "Error while extracting the credentials for Owner Id: " + request.getOwnerId();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetAllCredentialsResponse getAllCredentialsFromToken(TokenRequest request) {
        try {
            String token = request.getToken();
            Credential credential = CredentialManager.decodeToken(token);
            if (credential == null || credential.getId() == null) {
                LOGGER.error("Invalid access token");
                throw new EntityNotFoundException("Invalid access token");
            }
            CredentialEntity entity = this.repository.findByClientId(credential.getId());
            if (entity == null) {
                LOGGER.error("Client not found");
                throw new EntityNotFoundException("Client not found");
            }
            String subPath = BASE_PATH + entity.getOwnerId();
            String validatingPath = BASE_PATH + entity.getOwnerId() + "/" + Type.CUSTOS.name();
            VaultResponseSupport validationResponse = this.vaultTemplate.read(validatingPath, Credential.class);
            if (validationResponse == null || validationResponse.getData() == null || !((Credential)validationResponse.getData()).getSecret().equals(credential.getSecret())) {
                String msg = "Invalid secret for Id: " + credential.getId();
                LOGGER.error(msg);
                throw new AuthenticationException(msg);
            }
            List paths = this.vaultTemplate.list(subPath);
            ArrayList<CredentialMetadata> credentialMetadata = new ArrayList<CredentialMetadata>();
            if (paths != null && !paths.isEmpty()) {
                for (String key : paths) {
                    String path;
                    VaultResponseSupport crRe;
                    if (!this.isMainType(key) || (crRe = this.vaultTemplate.read(path = subPath + "/" + key, Credential.class)) == null || crRe.getData() == null) continue;
                    CredentialMetadata metadata = this.convertToCredentialMetadata((Credential)crRe.getData(), entity.getOwnerId(), key);
                    if (key.equals(Type.CUSTOS.name())) {
                        metadata = metadata.toBuilder().setClientIdIssuedAt(entity.getIssuedAt().getTime()).setClientSecretExpiredAt(entity.getClientSecretExpiredAt()).build();
                    }
                    credentialMetadata.add(metadata);
                }
            }
            return GetAllCredentialsResponse.newBuilder().addAllSecretList(credentialMetadata).build();
        }
        catch (Exception ex) {
            String msg = "Operation failed " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public Credentials getBasicCredentials(TokenRequest request) {
        try {
            String token = request.getToken();
            Credential credential = CredentialManager.decodeToken(token);
            if (credential == null || credential.getId() == null) {
                LOGGER.error("Invalid access token");
                throw new EntityNotFoundException("Invalid access token");
            }
            CredentialEntity entity = this.repository.findByClientId(credential.getId());
            if (entity == null) {
                LOGGER.error("Could not find the credential entity with the Id: {}", (Object)credential.getId());
                throw new EntityNotFoundException("Could not find the credential entity with the Id: " + credential.getId());
            }
            String subPath = BASE_PATH + entity.getOwnerId();
            List paths = this.vaultTemplate.list(subPath);
            Credentials.Builder credentialsBuilder = Credentials.newBuilder();
            if (paths != null && !paths.isEmpty()) {
                for (String key : paths) {
                    String path = subPath + "/" + key;
                    VaultResponseSupport crRe = this.vaultTemplate.read(path, Credential.class);
                    if (crRe == null || crRe.getData() == null || ((Credential)crRe.getData()).getSecret() == null) {
                        LOGGER.error("Cannot find Credential with the Id: " + credential.getId() + " in the Secret store");
                        throw new EntityNotFoundException("Cannot find Credential with the Id: " + credential.getId() + " in the Secret store");
                    }
                    if (key.equals(Type.CUSTOS.name())) {
                        if (!((Credential)crRe.getData()).getSecret().equals(credential.getSecret())) {
                            String msg = "Invalid secret for id" + credential.getId();
                            LOGGER.error(msg);
                            throw new AuthenticationException(msg);
                        }
                        credentialsBuilder.setCustosClientId(((Credential)crRe.getData()).getId()).setCustosClientSecret(((Credential)crRe.getData()).getSecret()).setCustosClientIdIssuedAt((double)entity.getIssuedAt().getTime()).setCustosClientSecretExpiredAt((double)entity.getClientSecretExpiredAt());
                        continue;
                    }
                    if (key.equals(Type.IAM.name())) {
                        credentialsBuilder.setIamClientId(((Credential)crRe.getData()).getId()).setIamClientSecret(((Credential)crRe.getData()).getSecret());
                        continue;
                    }
                    if (!key.equals(Type.CILOGON.name())) continue;
                    credentialsBuilder.setCiLogonClientId(((Credential)crRe.getData()).getId()).setCiLogonClientSecret(((Credential)crRe.getData()).getSecret());
                }
            }
            return credentialsBuilder.build();
        }
        catch (Exception ex) {
            String msg = "Operation failed " + String.valueOf(ex);
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetAllCredentialsResponse getAllCredentialsFromJWTToken(TokenRequest request) {
        try {
            String token = request.getToken();
            Credential credential = this.credentialManager.decodeJWTToken(token);
            if (credential == null || credential.getId() == null) {
                LOGGER.error("Invalid access token");
                throw new EntityNotFoundException("Invalid access token");
            }
            CredentialEntity entity = this.repository.findByClientId(credential.getId());
            if (entity == null) {
                LOGGER.error("Cannot find a CredentialEntity with the Id: " + credential.getId());
                throw new EntityNotFoundException("Cannot find a CredentialEntity with the Id: " + credential.getId());
            }
            String subPath = BASE_PATH + entity.getOwnerId();
            List paths = this.vaultTemplate.list(subPath);
            ArrayList<CredentialMetadata> credentialMetadata = new ArrayList<CredentialMetadata>();
            if (paths != null && !paths.isEmpty()) {
                for (String key : paths) {
                    if (!this.isMainType(key)) continue;
                    String path = subPath + "/" + key;
                    VaultResponseSupport crRe = this.vaultTemplate.read(path, Credential.class);
                    CredentialMetadata metadata = this.convertToCredentialMetadata((Credential)crRe.getData(), entity.getOwnerId(), key);
                    if (key.equals(Type.CUSTOS.name())) {
                        metadata = metadata.toBuilder().setClientIdIssuedAt(entity.getIssuedAt().getTime()).setClientSecretExpiredAt(entity.getClientSecretExpiredAt()).setSuperAdmin(credential.isAdmin()).setSuperTenant(((Credential)crRe.getData()).isSuperTenant()).build();
                    }
                    credentialMetadata.add(metadata);
                }
            }
            return GetAllCredentialsResponse.newBuilder().addAllSecretList(credentialMetadata).setRequesterUserEmail(credential.getEmail()).setRequesterUsername(credential.getUsername()).build();
        }
        catch (Exception ex) {
            String msg = "Operation failed  " + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetAllCredentialsResponse getMasterCredentials(GetCredentialRequest request) {
        try {
            String subPath = "/secret/master";
            List paths = this.vaultTemplate.list(subPath);
            ArrayList<CredentialMetadata> credentialMetadata = new ArrayList<CredentialMetadata>();
            if (paths != null && !paths.isEmpty()) {
                for (String key : paths) {
                    if (!this.isMainType(key)) continue;
                    String path = subPath + "/" + key;
                    VaultResponseSupport crRe = this.vaultTemplate.read(path, Credential.class);
                    CredentialMetadata metadata = this.convertToCredentialMetadata((Credential)crRe.getData(), 0L, key);
                    credentialMetadata.add(metadata);
                }
            }
            return GetAllCredentialsResponse.newBuilder().addAllSecretList(credentialMetadata).build();
        }
        catch (Exception ex) {
            String msg = "Error while extracting the master credentials";
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public void storeKeyPair(String privateKey, String publicKey) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("privateKey", privateKey);
        keys.put("publicKey", publicKey);
        HashMap<String, HashMap<String, String>> data = new HashMap<String, HashMap<String, String>>();
        data.put("data", keys);
        this.vaultTemplate.write(KEY_PATH, data);
    }

    public Map<String, String> retrieveKeyPair() {
        VaultResponse response = this.vaultTemplate.read(KEY_PATH);
        if (response != null && response.getData() != null) {
            return (Map)((Map)response.getData()).get("data");
        }
        return null;
    }

    private OperationMetadata convertFromEntity(StatusEntity entity) {
        return OperationMetadata.newBuilder().setEvent(entity.getEvent()).setStatus(entity.getState()).setPerformedBy(entity.getPerformedBy()).setTimeStamp(entity.getTime().toString()).build();
    }

    private CredentialMetadata convertToCredentialMetadata(Credential credential, long ownerId, String type) {
        return CredentialMetadata.newBuilder().setOwnerId(ownerId).setType(Type.valueOf((String)type)).setId(credential.getId()).setSuperTenant(credential.isSuperTenant()).setSecret(credential.getSecret()).build();
    }

    private boolean isMainType(String str) {
        for (Type type : Type.values()) {
            if (!type.name().equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }
}

