/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.airavata.workflow.model.utils;


public class WorkflowConstants {

    /**
     * The name of the application
     */
    public static final String APPLICATION_NAME_ = "XBaya Dashboard";

    /**
     * Namespace URI
     */
    public static final String NS_URI_XBAYA = "http://airavata.apache.org/xbaya/";

    /**
     * Format name for png image
     */
    public static final String PNG_FORMAT_NAME = "PNG";

    /**
     * ODE URL
     */
    public static final String DEFAULT_ODE_URL = "https://pagodatree.cs.indiana.edu:17443";

    /**
     * WORKFLOW Namespace
     */
    public static final String LEAD_NS = "http://extreme.indiana.edu/lead/workflow";


    public static final String APPLICATION_COMPONENT_DESCRIPTION = "description";
    public static final String APPLICATION_COMPONENT_NAME = "name";
    public static final String APPLICATION_COMPONENT_APPLICATION = "application";

    public static final String APPLICATION_DATA_DESCRIPTION = "description";
    public static final String APPLICATION_DATA_NAME = "name";
    public static final String APPLICATION_DATA_DEFAULT_VALUE = "defaultValue";
    public static final String APPLICATION_DATA_DATA_TYPE = "dataType";
    public static final String APPLICATION_DATA_INPUT_ORDER = "inputOrder";
    public static final String APPLICATION_DATA_APP_ARGUMENT = "appArgument";
    public static final String APPLICATION_INPUT = "Input";
    public static final String APPLICATION_OUTPUT = "Output";

}