<?php
namespace Airavata\Service\Profile\User\CPI;
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;


interface UserProfileServiceIf {
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\User\UserProfile $userProfile
   * @return string
   * @throws \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addUserProfile(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\User\UserProfile $userProfile);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\User\UserProfile $userProfile
   * @return bool
   * @throws \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateUserProfile(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\User\UserProfile $userProfile);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayId
   * @return \Airavata\Model\User\UserProfile * A structure holding the user profile and its child models.
   * *
   * * Notes:
   * *  The model does not include passwords as it is assumed an external identity provider is used to authenticate user.
   * *  References:
   * *     NSF Demographic Information - http://www.nsf.gov/pubs/2000/00form1225/00form1225.doc
   * *     LDAP Schema - https://tools.ietf.org/html/rfc4519
   * *     SCIM 2.0 - https://tools.ietf.org/html/rfc7643
   * *
   * * userModelVersion:
   * *  Version number of profile
   * *
   * * airavataInternalUserId:
   * *  internal to Airavata, not intended to be used outside of the Airavata platform or possibly by gateways
   * *  (that is, never shown to users), never reassigned, REQUIRED
   * *
   * * userId:
   * *  Externally assertable unique identifier. SAML (primarly in higher education, academic) tends to keep
   * *   user name less opaque. OpenID Connect maintains them to be opaque.
   * *
   * * firstName, middleName, lastName:
   * *  First and Last names as assertede by the user
   * *
   * * namePrefix, nameSuffix:
   * *  prefix and suffix to the users name as asserted by the user
   * *
   * * emails:
   * *   Email identifier are Verified, REQUIRED and MULTIVALUED
   * *
   * * userName:
   * *  Name-based identifiers can be multivalues. To keep it simple, Airavata will make it a string.
   * *   In the future these can be enumerated as:
   *     *   Official name (as asserted possibly by some external identity provider)
   *     *   Prefered name (as asserted or suggested by user directly)
   *     *   Components:
   *     *      givenName
   *     *      surname (familyName)
   *     *      displayName (often asserted by user to handle things like middle names, suffix, prefix, and the like)
   * *
   * * orcidId: ORCID ID - http://orcid.org/about/what-is-orcid)
   * *
   * * phones: Telephone MULTIVALUED
   * *
   * * country: Country of Residance
   * *
   * * nationality Countries of citizenship
   * *
   * * comments:
   * *   Free-form information (treated as opaque by Airavata and simply passed to resource).
   * *
   * * labeledURI:
   *   * Google Scholar, Web of Science, ACS, e.t.c
   * *
   * * timeZone:
   * *  User’s preferred timezone - IANA Timezone Databases - http://www.iana.org/time-zones.
   * *
   * 
   * @throws \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getUserProfileById(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayId
   * @return bool
   * @throws \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteUserProfile(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param int $offset
   * @param int $limit
   * @return \Airavata\Model\User\UserProfile[]
   * @throws \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllUserProfilesInGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $offset, $limit);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayId
   * @return bool
   * @throws \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function doesUserExist(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayId);
}

class UserProfileServiceClient implements \Airavata\Service\Profile\User\CPI\UserProfileServiceIf {
  protected $input_ = null;
  protected $output_ = null;

  protected $seqid_ = 0;

  public function __construct($input, $output=null) {
    $this->input_ = $input;
    $this->output_ = $output ? $output : $input;
  }

  public function addUserProfile(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\User\UserProfile $userProfile)
  {
    $this->send_addUserProfile($authzToken, $userProfile);
    return $this->recv_addUserProfile();
  }

  public function send_addUserProfile(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\User\UserProfile $userProfile)
  {
    $args = new \Airavata\Service\Profile\User\CPI\UserProfileService_addUserProfile_args();
    $args->authzToken = $authzToken;
    $args->userProfile = $userProfile;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addUserProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addUserProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addUserProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\Service\Profile\User\CPI\UserProfileService_addUserProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\Service\Profile\User\CPI\UserProfileService_addUserProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->upe !== null) {
      throw $result->upe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addUserProfile failed: unknown result");
  }

  public function updateUserProfile(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\User\UserProfile $userProfile)
  {
    $this->send_updateUserProfile($authzToken, $userProfile);
    return $this->recv_updateUserProfile();
  }

  public function send_updateUserProfile(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\User\UserProfile $userProfile)
  {
    $args = new \Airavata\Service\Profile\User\CPI\UserProfileService_updateUserProfile_args();
    $args->authzToken = $authzToken;
    $args->userProfile = $userProfile;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateUserProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateUserProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateUserProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\Service\Profile\User\CPI\UserProfileService_updateUserProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\Service\Profile\User\CPI\UserProfileService_updateUserProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->upe !== null) {
      throw $result->upe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateUserProfile failed: unknown result");
  }

  public function getUserProfileById(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayId)
  {
    $this->send_getUserProfileById($authzToken, $userId, $gatewayId);
    return $this->recv_getUserProfileById();
  }

  public function send_getUserProfileById(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayId)
  {
    $args = new \Airavata\Service\Profile\User\CPI\UserProfileService_getUserProfileById_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getUserProfileById', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getUserProfileById', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getUserProfileById()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\Service\Profile\User\CPI\UserProfileService_getUserProfileById_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\Service\Profile\User\CPI\UserProfileService_getUserProfileById_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->upe !== null) {
      throw $result->upe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getUserProfileById failed: unknown result");
  }

  public function deleteUserProfile(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayId)
  {
    $this->send_deleteUserProfile($authzToken, $userId, $gatewayId);
    return $this->recv_deleteUserProfile();
  }

  public function send_deleteUserProfile(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayId)
  {
    $args = new \Airavata\Service\Profile\User\CPI\UserProfileService_deleteUserProfile_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteUserProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteUserProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteUserProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\Service\Profile\User\CPI\UserProfileService_deleteUserProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\Service\Profile\User\CPI\UserProfileService_deleteUserProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->upe !== null) {
      throw $result->upe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteUserProfile failed: unknown result");
  }

  public function getAllUserProfilesInGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $offset, $limit)
  {
    $this->send_getAllUserProfilesInGateway($authzToken, $gatewayId, $offset, $limit);
    return $this->recv_getAllUserProfilesInGateway();
  }

  public function send_getAllUserProfilesInGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $offset, $limit)
  {
    $args = new \Airavata\Service\Profile\User\CPI\UserProfileService_getAllUserProfilesInGateway_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->offset = $offset;
    $args->limit = $limit;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllUserProfilesInGateway', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllUserProfilesInGateway', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllUserProfilesInGateway()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\Service\Profile\User\CPI\UserProfileService_getAllUserProfilesInGateway_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\Service\Profile\User\CPI\UserProfileService_getAllUserProfilesInGateway_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->upe !== null) {
      throw $result->upe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllUserProfilesInGateway failed: unknown result");
  }

  public function doesUserExist(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayId)
  {
    $this->send_doesUserExist($authzToken, $userId, $gatewayId);
    return $this->recv_doesUserExist();
  }

  public function send_doesUserExist(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayId)
  {
    $args = new \Airavata\Service\Profile\User\CPI\UserProfileService_doesUserExist_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'doesUserExist', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('doesUserExist', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_doesUserExist()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\Service\Profile\User\CPI\UserProfileService_doesUserExist_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\Service\Profile\User\CPI\UserProfileService_doesUserExist_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->upe !== null) {
      throw $result->upe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("doesUserExist failed: unknown result");
  }

}

// HELPER FUNCTIONS AND STRUCTURES

class UserProfileService_addUserProfile_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var \Airavata\Model\User\UserProfile
   */
  public $userProfile = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'userProfile',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\User\UserProfile',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['userProfile'])) {
        $this->userProfile = $vals['userProfile'];
      }
    }
  }

  public function getName() {
    return 'UserProfileService_addUserProfile_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->userProfile = new \Airavata\Model\User\UserProfile();
            $xfer += $this->userProfile->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('UserProfileService_addUserProfile_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userProfile !== null) {
      if (!is_object($this->userProfile)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('userProfile', TType::STRUCT, 2);
      $xfer += $this->userProfile->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class UserProfileService_addUserProfile_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException
   */
  public $upe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'upe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException',
          ),
        2 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['upe'])) {
        $this->upe = $vals['upe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'UserProfileService_addUserProfile_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->upe = new \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException();
            $xfer += $this->upe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('UserProfileService_addUserProfile_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->upe !== null) {
      $xfer += $output->writeFieldBegin('upe', TType::STRUCT, 1);
      $xfer += $this->upe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 2);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class UserProfileService_updateUserProfile_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var \Airavata\Model\User\UserProfile
   */
  public $userProfile = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'userProfile',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\User\UserProfile',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['userProfile'])) {
        $this->userProfile = $vals['userProfile'];
      }
    }
  }

  public function getName() {
    return 'UserProfileService_updateUserProfile_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->userProfile = new \Airavata\Model\User\UserProfile();
            $xfer += $this->userProfile->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('UserProfileService_updateUserProfile_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userProfile !== null) {
      if (!is_object($this->userProfile)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('userProfile', TType::STRUCT, 2);
      $xfer += $this->userProfile->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class UserProfileService_updateUserProfile_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException
   */
  public $upe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'upe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException',
          ),
        2 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['upe'])) {
        $this->upe = $vals['upe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'UserProfileService_updateUserProfile_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->upe = new \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException();
            $xfer += $this->upe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('UserProfileService_updateUserProfile_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->upe !== null) {
      $xfer += $output->writeFieldBegin('upe', TType::STRUCT, 1);
      $xfer += $this->upe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 2);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class UserProfileService_getUserProfileById_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $userId = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'userId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['userId'])) {
        $this->userId = $vals['userId'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'UserProfileService_getUserProfileById_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('UserProfileService_getUserProfileById_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userId !== null) {
      $xfer += $output->writeFieldBegin('userId', TType::STRING, 2);
      $xfer += $output->writeString($this->userId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 3);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class UserProfileService_getUserProfileById_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\User\UserProfile
   */
  public $success = null;
  /**
   * @var \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException
   */
  public $upe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\User\UserProfile',
          ),
        1 => array(
          'var' => 'upe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException',
          ),
        2 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['upe'])) {
        $this->upe = $vals['upe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'UserProfileService_getUserProfileById_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\User\UserProfile();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->upe = new \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException();
            $xfer += $this->upe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('UserProfileService_getUserProfileById_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->upe !== null) {
      $xfer += $output->writeFieldBegin('upe', TType::STRUCT, 1);
      $xfer += $this->upe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 2);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class UserProfileService_deleteUserProfile_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $userId = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'userId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['userId'])) {
        $this->userId = $vals['userId'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'UserProfileService_deleteUserProfile_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('UserProfileService_deleteUserProfile_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userId !== null) {
      $xfer += $output->writeFieldBegin('userId', TType::STRING, 2);
      $xfer += $output->writeString($this->userId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 3);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class UserProfileService_deleteUserProfile_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException
   */
  public $upe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'upe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException',
          ),
        2 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['upe'])) {
        $this->upe = $vals['upe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'UserProfileService_deleteUserProfile_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->upe = new \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException();
            $xfer += $this->upe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('UserProfileService_deleteUserProfile_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->upe !== null) {
      $xfer += $output->writeFieldBegin('upe', TType::STRUCT, 1);
      $xfer += $this->upe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 2);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class UserProfileService_getAllUserProfilesInGateway_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var int
   */
  public $offset = null;
  /**
   * @var int
   */
  public $limit = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'offset',
          'type' => TType::I32,
          ),
        4 => array(
          'var' => 'limit',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['offset'])) {
        $this->offset = $vals['offset'];
      }
      if (isset($vals['limit'])) {
        $this->limit = $vals['limit'];
      }
    }
  }

  public function getName() {
    return 'UserProfileService_getAllUserProfilesInGateway_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->offset);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->limit);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('UserProfileService_getAllUserProfilesInGateway_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->offset !== null) {
      $xfer += $output->writeFieldBegin('offset', TType::I32, 3);
      $xfer += $output->writeI32($this->offset);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->limit !== null) {
      $xfer += $output->writeFieldBegin('limit', TType::I32, 4);
      $xfer += $output->writeI32($this->limit);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class UserProfileService_getAllUserProfilesInGateway_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\User\UserProfile[]
   */
  public $success = null;
  /**
   * @var \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException
   */
  public $upe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\User\UserProfile',
            ),
          ),
        1 => array(
          'var' => 'upe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException',
          ),
        2 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['upe'])) {
        $this->upe = $vals['upe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'UserProfileService_getAllUserProfilesInGateway_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size0 = 0;
            $_etype3 = 0;
            $xfer += $input->readListBegin($_etype3, $_size0);
            for ($_i4 = 0; $_i4 < $_size0; ++$_i4)
            {
              $elem5 = null;
              $elem5 = new \Airavata\Model\User\UserProfile();
              $xfer += $elem5->read($input);
              $this->success []= $elem5;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->upe = new \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException();
            $xfer += $this->upe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('UserProfileService_getAllUserProfilesInGateway_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter6)
          {
            $xfer += $iter6->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->upe !== null) {
      $xfer += $output->writeFieldBegin('upe', TType::STRUCT, 1);
      $xfer += $this->upe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 2);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class UserProfileService_doesUserExist_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $userId = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'userId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['userId'])) {
        $this->userId = $vals['userId'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'UserProfileService_doesUserExist_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('UserProfileService_doesUserExist_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userId !== null) {
      $xfer += $output->writeFieldBegin('userId', TType::STRING, 2);
      $xfer += $output->writeString($this->userId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 3);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class UserProfileService_doesUserExist_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException
   */
  public $upe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'upe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException',
          ),
        2 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['upe'])) {
        $this->upe = $vals['upe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'UserProfileService_doesUserExist_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->upe = new \Airavata\Service\Profile\User\CPI\Error\UserProfileServiceException();
            $xfer += $this->upe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('UserProfileService_doesUserExist_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->upe !== null) {
      $xfer += $output->writeFieldBegin('upe', TType::STRUCT, 1);
      $xfer += $this->upe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 2);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}


