/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ro extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arab\u0103";
        final String metaValue_bn = "bengalez\u0103";
        final String metaValue_bo = "tibetan\u0103";
        final String metaValue_el = "greac\u0103";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebraic\u0103";
        final String metaValue_hy = "armean\u0103";
        final String metaValue_ja = "japonez\u0103";
        final String metaValue_jv = "javanez\u0103";
        final String metaValue_ka = "georgian\u0103";
        final String metaValue_km = "khmer\u0103";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "coreean\u0103";
        final String metaValue_la = "latin\u0103";
        final String metaValue_lo = "lao\u021bian\u0103";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongol\u0103";
        final String metaValue_or = "oriya";
        final String metaValue_ta = "tamil\u0103";
        final String metaValue_te = "telugu";
        final String metaValue_th = "thailandez\u0103";
        final String metaValue_ban = "balinez\u0103";
        final String metaValue_cop = "copt\u0103";
        final String metaValue_got = "gotic\u0103";
        final String metaValue_peo = "persan\u0103 veche";
        final String metaValue_phn = "fenician\u0103";
        final String metaValue_syr = "siriac\u0103";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f6lsch" },
            { "mwl", "mirandez\u0103" },
            { "Zsym", "simboluri" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "egy", "egiptean\u0103 veche" },
            { "raj", "rajasthani" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Insula Ascension" },
            { "rar", "rarotongan" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Emiratele Arabe Unite" },
            { "nl_BE", "flamand\u0103" },
            { "AF", "Afganistan" },
            { "AG", "Antigua \u0219i Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "AS", "Samoa American\u0103" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "englez\u0103 american\u0103" },
            { "AX", "Insulele \u00c5land" },
            { "mye", "myene" },
            { "AZ", "Azerbaidjan" },
            { "BA", "Bosnia \u0219i Her\u021begovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "kumyk" },
            { "BE", "Belgia" },
            { "gmh", "german\u0103 mijlocie \u00eenalt\u0103" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sf\u00e2ntul Bartolomeu" },
            { "BM", "Bermuda" },
            { "kut", "kutenai" },
            { "myv", "erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Insulele Caraibe Olandeze" },
            { "BR", "Brazilia" },
            { "BS", "Bahamas" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Insula Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Insulele Cocos (Keeling)" },
            { "mzn", "mazanderani" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Republica Centrafrican\u0103" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Elve\u021bia" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Insulele Cook" },
            { "CL", "Chile" },
            { "CM", "Camerun" },
            { "CN", "China" },
            { "CO", "Columbia" },
            { "CP", "Insula Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Capul Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Insula Christmas" },
            { "CY", "Cipru" },
            { "CZ", "Republica Ceh\u0103" },
            { "eka", "ekajuk" },
            { "DE", "Germania" },
            { "goh", "german\u0103 veche \u00eenalt\u0103" },
            { "ace", "aceh" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danemarca" },
            { "ach", "acoli" },
            { "gon", "gondi" },
            { "Brai", "braille" },
            { "DM", "Dominica" },
            { "DO", "Republica Dominican\u0103" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "zun", "zuni" },
            { "tig", "tigre" },
            { "DZ", "Algeria" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "EA", "Ceuta \u0219i Melilla" },
            { "chb", "chibcha" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estonia" },
            { "tiv", "tiv" },
            { "EG", "Egipt" },
            { "EH", "Sahara Occidental\u0103" },
            { "chg", "chagatai" },
            { "pau", "palauan\u0103" },
            { "chk", "chuukese" },
            { "chn", "jargon chinook" },
            { "chm", "mari" },
            { "chp", "chipewyan" },
            { "cho", "choctaw" },
            { "chr", "cherokee" },
            { "ER", "Eritreea" },
            { "ES", "Spania" },
            { "ET", "Etiopia" },
            { "EU", "Uniunea European\u0103" },
            { "elx", "elamit\u0103" },
            { "chy", "cheyenne" },
            { "Inds", "indus" },
            { "ady", "adyghe" },
            { "FI", "Finlanda" },
            { "FJ", "Fiji" },
            { "FK", "Insulele Falkland" },
            { "FM", "Micronezia" },
            { "FO", "Insulele Feroe" },
            { "Taml", metaValue_ta },
            { "FR", "Fran\u021ba" },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "root", "root" },
            { "grc", "greac\u0103 veche" },
            { "GA", "Gabon" },
            { "vot", "votic" },
            { "GB", "Regatul Unit" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyana Francez\u0103" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Groenlanda" },
            { "enm", "englez\u0103 mijlocie" },
            { "GM", "Gambia" },
            { "GN", "Guineea" },
            { "GP", "Guadelupa" },
            { "GQ", "Guineea Ecuatorial\u0103" },
            { "GR", "Grecia" },
            { "GS", "Georgia de Sud \u0219i Insulele Sandwich de Sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guineea-Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingonian\u0103" },
            { "GY", "Guyana" },
            { "ckb", "kurd\u0103 sorani" },
            { "zxx", "far\u0103 con\u021binut lingvistic" },
            { "de_AT", "german\u0103 austriac\u0103" },
            { "HK", "R.A.S. Hong Kong a Chinei" },
            { "HM", "Insula Heard \u0219i Insulele McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croa\u021bia" },
            { "agq", "aghem" },
            { "gsw", "german\u0103 elve\u021bian\u0103" },
            { "HT", "Haiti" },
            { "HU", "Ungaria" },
            { "tmh", "tamashek" },
            { "IC", "Insulele Canare" },
            { "peo", metaValue_peo },
            { "ID", "Indonezia" },
            { "IE", "Irlanda" },
            { "nap", "napolitan\u0103" },
            { "naq", "nama" },
            { "zza", "zaza" },
            { "IL", "Israel" },
            { "IM", "Insula Man" },
            { "IN", "India" },
            { "IO", "Teritoriul Britanic din Oceanul Indian" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islanda" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "JO", "Iordania" },
            { "JP", "Japonia" },
            { "ain", "ainu" },
            { "guz", "gusii" },
            { "tog", "nyasa tonga" },
            { "de_CH", "german\u0103 standard elve\u021bian\u0103" },
            { "KE", "Kenya" },
            { "419", "America Latin\u0103" },
            { "KG", "K\u00e2rg\u00e2zstan" },
            { "KH", "Cambodgia" },
            { "KI", "Kiribati" },
            { "KM", "Comore" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts \u0219i Nevis" },
            { "Zinh", "mo\u0219tenit\u0103" },
            { "fr_CA", "francez\u0103 canadian\u0103" },
            { "KP", "Coreea de Nord" },
            { "KR", "Coreea de Sud" },
            { "fr_CH", "francez\u0103 elve\u021bian\u0103" },
            { "KW", "Kuweit" },
            { "tpi", "tok pisin" },
            { "KY", "Insulele Cayman" },
            { "KZ", "Kazahstan" },
            { "Cyrl", "chirilic\u0103" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "phn", metaValue_phn },
            { "LC", "Sf\u00e2nta Lucia" },
            { "Cyrs", "chirilic\u0103 slavon\u0103 bisericeasc\u0103 veche" },
            { "gwi", "gwich\u02bcin" },
            { "nds", "germana de jos" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akkadian\u0103" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luxemburg" },
            { "LV", "Letonia" },
            { "Kana", "katakana" },
            { "LY", "Libia" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "lah", "lahnda" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Maroc" },
            { "MC", "Monaco" },
            { "MD", "Republica Moldova" },
            { "ME", "Muntenegru" },
            { "MF", "Sf\u00e2ntul Martin" },
            { "lam", "lamba" },
            { "MG", "Madagascar" },
            { "Thai", metaValue_th },
            { "MH", "Insulele Marshall" },
            { "ale", "aleut\u0103" },
            { "MK", "Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "R.A.S. Macao a Chinei" },
            { "MP", "Insulele Mariane de Nord" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "alt", "altaic\u0103 meridional\u0103" },
            { "MV", "Maldive" },
            { "MW", "Malawi" },
            { "MX", "Mexic" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambic" },
            { "NA", "Namibia" },
            { "NC", "Noua Caledonie" },
            { "%%WADEGILE", "Wade-Giles" },
            { "NE", "Niger" },
            { "NF", "Insula Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "NI", "Nicaragua" },
            { "NL", "\u021a\u0103rile de Jos" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "Noua Zeeland\u0103" },
            { "rom", "romani" },
            { "crh", "turc\u0103 crimeean\u0103" },
            { "ang", "englez\u0103 veche" },
            { "OM", "Oman" },
            { "anp", "angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "csb", "ca\u0219ubian\u0103" },
            { "en_GB", "englez\u0103 britanic\u0103" },
            { "PE", "Peru" },
            { "PF", "Polinezia Francez\u0103" },
            { "PG", "Papua-Noua Guinee" },
            { "PH", "Filipine" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "ewo", "ewondo" },
            { "PM", "Saint-Pierre \u0219i Miquelon" },
            { "PN", "Insulele Pitcairn" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Teritoriile Palestiniene" },
            { "PT", "Portugalia" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "englez\u0103 standard sco\u021bian\u0103" },
            { "niu", "niuean\u0103" },
            { "QO", "Oceania Periferic\u0103" },
            { "lez", "lezghian" },
            { "tvl", "tuvalu" },
            { "001", "Lume" },
            { "002", "Africa" },
            { "003", "America de Nord" },
            { "RE", "R\u00e9union" },
            { "005", "America de Sud" },
            { "jbo", "lojban" },
            { "009", "Oceania" },
            { "RO", "Rom\u00e2nia" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Rwanda" },
            { "SA", "Arabia Saudit\u0103" },
            { "pon", "pohnpeian\u0103" },
            { "SB", "Insulele Solomon" },
            { "twq", "tasawaq" },
            { "011", "Africa Occidental\u0103" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "013", "America Central\u0103" },
            { "SE", "Suedia" },
            { "014", "Africa Oriental\u0103" },
            { "arc", "aramaic\u0103" },
            { "015", "Africa Septentrional\u0103" },
            { "SG", "Singapore" },
            { "SH", "Sf\u00e2nta Elena" },
            { "017", "Africa Central\u0103" },
            { "SI", "Slovenia" },
            { "018", "Africa Meridional\u0103" },
            { "SJ", "Svalbard \u0219i Jan Mayen" },
            { "019", "Americi" },
            { "SK", "Slovacia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "SR", "Suriname" },
            { "SS", "Sudanul de Sud" },
            { "ST", "Sao Tome \u0219i Principe" },
            { "SV", "El Salvador" },
            { "SX", "Sint-Maarten" },
            { "SY", "Siria" },
            { "yao", "yao" },
            { "SZ", "Swaziland" },
            { "arw", "arawak" },
            { "yap", "yapez\u0103" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "021", "America Septentrional\u0103" },
            { "TC", "Insulele Turks \u0219i Caicos" },
            { "yav", "yangben" },
            { "TD", "Ciad" },
            { "TF", "Teritoriile Australe \u0219i Antarctice Franceze" },
            { "TG", "Togo" },
            { "TH", "Thailanda" },
            { "TJ", "Tadjikistan" },
            { "029", "Caraibe" },
            { "TK", "Tokelau" },
            { "TL", "Timorul de Est" },
            { "ybb", "yemba" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turcia" },
            { "TT", "Trinidad \u0219i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturian\u0103" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasio" },
            { "Zzzz", "scriere necunoscut\u0103" },
            { "UA", "Ucraina" },
            { "rup", "arom\u00e2n\u0103" },
            { "030", "Asia Oriental\u0103" },
            { "tyv", "tuvan\u0103" },
            { "sw_CD", "swahili Congo" },
            { "034", "Asia Meridional\u0103" },
            { "hai", "haida" },
            { "035", "Asia de Sud-Est" },
            { "UG", "Uganda" },
            { "039", "Europa Meridional\u0103" },
            { "Sinh", "singalez\u0103" },
            { "UM", "Insulele \u00cendep\u0103rtate ale S.U.A." },
            { "US", "Statele Unite ale Americii" },
            { "haw", "hawaiian\u0103" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "tzm", "tamazight central marocan\u0103" },
            { "nnh", "ngiemboon" },
            { "VA", "Statul Cet\u0103\u021bii Vaticanului" },
            { "pro", "provensal\u0103 veche" },
            { "VC", "Saint Vincent \u0219i Grenadinele" },
            { "VE", "Venezuela" },
            { "VG", "Insulele Virgine Britanice" },
            { "VI", "Insulele Virgine S.U.A." },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "non", "nordic\u0103 veche" },
            { "053", "Australasia" },
            { "054", "Melanezia" },
            { "WF", "Wallis \u0219i Futuna" },
            { "057", "Regiunea Micronezia" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "wal", "walamo" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polinezia" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "nescris\u0103" },
            { "wbp", "warlpiri" },
            { "YE", "Yemen" },
            { "nqo", "n\u2019ko" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "YT", "Mayotte" },
            { "ZA", "Africa de Sud" },
            { "Deva", "devanagari" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Regiune necunoscut\u0103" },
            { "Runr", "runic\u0103" },
            { "lol", "mongo" },
            { "nso", "sotho de nord" },
            { "loz", "lozi" },
            { "jmc", "machame" },
            { "hil", "hiligaynon" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "hit", "hitit\u0103" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "Maya", "hieroglife maya" },
            { "lrc", "luri de nord" },
            { "Copt", metaValue_cop },
            { "nwc", "newari clasic\u0103" },
            { "udm", "udmurt" },
            { "Khmr", metaValue_km },
            { "sad", "sandawe" },
            { "sah", "sakha" },
            { "sam", "aramaic\u0103 samaritean\u0103" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "berber\u0103" },
            { "jpr", "iudeo-persan\u0103" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "lua", "luba-lulua" },
            { "sbp", "sangu" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filipinez\u0103" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "lusahi" },
            { "bal", "baluchi" },
            { "den", "slave" },
            { "ban", metaValue_ban },
            { "uga", "ugaritic\u0103" },
            { "luy", "luyia" },
            { "bas", "basaa" },
            { "bax", "bamun" },
            { "jrb", "iudeo-arab\u0103" },
            { "es_ES", "spaniol\u0103 european\u0103" },
            { "nzi", "nzima" },
            { "sco", "scots" },
            { "scn", "sicilian\u0103" },
            { "aa", "afar" },
            { "ab", "abhaz\u0103" },
            { "ae", "avestan\u0103" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "bbj", "ghomala" },
            { "am", "amharic\u0103" },
            { "Arab", metaValue_ar },
            { "an", "aragonez\u0103" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "katakana sau hiragana" },
            { "as", "asamez\u0103" },
            { "Lina", "linear\u0103 A" },
            { "av", "avar\u0103" },
            { "Linb", "linear\u0103 B" },
            { "sdh", "kurd\u0103 de sud" },
            { "ay", "aymara" },
            { "az", "azer\u0103" },
            { "ba", "ba\u0219kir\u0103" },
            { "be", "bielorus\u0103" },
            { "bg", "bulgar\u0103" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "breton\u0103" },
            { "bs", "bosniac\u0103" },
            { "see", "seneca" },
            { "Mymr", "birman\u0103" },
            { "seh", "sena" },
            { "sel", "selkup" },
            { "ca", "catalan\u0103" },
            { "ses", "koyraboro Senni" },
            { "ce", "cecen\u0103" },
            { "ch", "chamorro" },
            { "co", "corsican\u0103" },
            { "Orya", metaValue_or },
            { "cr", "cree" },
            { "cs", "ceh\u0103" },
            { "cu", "slavon\u0103" },
            { "cv", "ciuva\u0219\u0103" },
            { "cy", "galez\u0103" },
            { "da", "danez\u0103" },
            { "pt_PT", "portughez\u0103 european\u0103" },
            { "de", "german\u0103" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "bem", "bemba" },
            { "sga", "irlandez\u0103 veche" },
            { "dv", "divehi" },
            { "es_419", "spaniol\u0103 latino-american\u0103" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "dje", "zarma" },
            { "ee", "ewe" },
            { "bfd", "bafut" },
            { "ro_MD", "moldoveneasc\u0103" },
            { "el", metaValue_el },
            { "en", "englez\u0103" },
            { "eo", "esperanto" },
            { "es", "spaniol\u0103" },
            { "et", "estonian\u0103" },
            { "eu", "basc\u0103" },
            { "Hang", "hangul" },
            { "shi", "tachelhit" },
            { "hsb", "sorab\u0103 de sus" },
            { "Hani", "han" },
            { "shn", "shan" },
            { "fa", "persan\u0103" },
            { "Hans", "simplificat\u0103" },
            { "Hant", "tradi\u021bional\u0103" },
            { "ff", "fulah" },
            { "shu", "arab\u0103 ciadian\u0103" },
            { "fi", "finlandez\u0103" },
            { "fj", "fijian\u0103" },
            { "fon", "fon" },
            { "bgn", "baluchi occidental\u0103" },
            { "yue", "cantonez\u0103" },
            { "fo", "faroez\u0103" },
            { "umb", "umbundu" },
            { "fr", "francez\u0103" },
            { "sid", "sidamo" },
            { "fy", "frizon\u0103 occidental\u0103" },
            { "ga", "irlandez\u0103" },
            { "gd", "gaelic\u0103 sco\u021bian\u0103" },
            { "gl", "galician\u0103" },
            { "gn", "guarani" },
            { "bho", "bhojpuri" },
            { "und", "limb\u0103 necunoscut\u0103" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "croat\u0103" },
            { "ht", "haitian\u0103" },
            { "hu", "maghiar\u0103" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonezian\u0103" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "frm", "francez\u0103 mijlocie" },
            { "ik", "inupiak" },
            { "fro", "francez\u0103 veche" },
            { "io", "ido" },
            { "frs", "frizon\u0103 oriental\u0103" },
            { "frr", "frizon\u0103 nordic\u0103" },
            { "is", "islandez\u0103" },
            { "it", "italian\u0103" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "doi", "dogri" },
            { "bkm", "kom" },
            { "sma", "sami de sud" },
            { "jv", metaValue_jv },
            { "mad", "madurez\u0103" },
            { "smj", "lule sami" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "inari sami" },
            { "ka", metaValue_ka },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "sms", "skolt sami" },
            { "man", "mandingo" },
            { "kg", "congolez\u0103" },
            { "Goth", metaValue_got },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kj", "kuanyama" },
            { "kk", "kazah\u0103" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "ca\u0219mir\u0103" },
            { "ku", "kurd\u0103" },
            { "kv", "komi" },
            { "kw", "cornic\u0103" },
            { "ky", "k\u00e2rg\u00e2z\u0103" },
            { "snk", "soninke" },
            { "la", metaValue_la },
            { "lb", "luxemburghez\u0103" },
            { "lg", "ganda" },
            { "li", "limburghez\u0103" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friulan\u0103" },
            { "lo", metaValue_lo },
            { "lt", "lituanian\u0103" },
            { "lu", "luba-katanga" },
            { "lv", "leton\u0103" },
            { "sog", "sogdien" },
            { "mg", "malga\u0219\u0103" },
            { "mh", "marshallez\u0103" },
            { "mi", "maori" },
            { "mk", "macedonean\u0103" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malaez\u0103" },
            { "mt", "maltez\u0103" },
            { "my", "birmanez\u0103" },
            { "Armn", metaValue_hy },
            { "mdf", "moksha" },
            { "mde", "maba" },
            { "dsb", "sorab\u0103 de jos" },
            { "na", "nauru" },
            { "nb", "norvegian\u0103 bokm\u00e5l" },
            { "nd", "ndebele de nord" },
            { "ne", "nepalez\u0103" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "neerlandez\u0103" },
            { "nn", "norvegian\u0103 nynorsk" },
            { "no", "norvegian\u0103" },
            { "nr", "ndebele de sud" },
            { "nv", "navajo" },
            { "kaa", "karakalpak" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "kabyle" },
            { "oc", "occitan\u0103" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "oj", "ojibwa" },
            { "mer", "meru" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "or", metaValue_or },
            { "os", "oset\u0103" },
            { "kbd", "kabardian" },
            { "mfe", "morisyen" },
            { "srn", "sranan tongo" },
            { "pa", "punjabi" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "kbl", "kanembu" },
            { "pi", "pali" },
            { "pl", "polonez\u0103" },
            { "dum", "olandez\u0103 mijlocie" },
            { "ps", "pa\u0219tun\u0103" },
            { "pt", "portughez\u0103" },
            { "mga", "irlandez\u0103 mijlocie" },
            { "pt_BR", "portughez\u0103 brazilian\u0103" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "bra", "braj" },
            { "Laoo", metaValue_lo },
            { "mgo", "meta\u2019" },
            { "ssy", "saho" },
            { "qu", "quechua" },
            { "zap", "zapotec\u0103" },
            { "brx", "bodo" },
            { "kde", "makonde" },
            { "Ethi", "etiopian\u0103" },
            { "rm", "roman\u0219\u0103" },
            { "rn", "kirundi" },
            { "ro", "rom\u00e2n\u0103" },
            { "ru", "rus\u0103" },
            { "bss", "akoose" },
            { "rw", "kinyarwanda" },
            { "zbl", "simboluri Bilss" },
            { "kea", "kabuverdianu" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "englez\u0103 australian\u0103" },
            { "sa", "sanscrit\u0103" },
            { "sc", "sardinian\u0103" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "sami de nord" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "s\u00e2rbo-croat\u0103" },
            { "si", "singhalez\u0103" },
            { "sux", "sumerian\u0103" },
            { "sk", "slovac\u0103" },
            { "sl", "sloven\u0103" },
            { "sm", "samoan\u0103" },
            { "sn", "shona" },
            { "so", "somalez\u0103" },
            { "sq", "albanez\u0103" },
            { "sr", "s\u00e2rb\u0103" },
            { "ss", "swati" },
            { "Java", metaValue_jv },
            { "st", "sesotho" },
            { "su", "sundanez\u0103" },
            { "sv", "suedez\u0103" },
            { "sw", "swahili" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "Asia" },
            { "bua", "buriat" },
            { "143", "Asia Central\u0103" },
            { "te", metaValue_te },
            { "145", "Asia Occidental\u0103" },
            { "tg", "tadjic\u0103" },
            { "th", metaValue_th },
            { "ti", "tigrin\u0103" },
            { "bug", "buginez\u0103" },
            { "kfo", "koro" },
            { "en_CA", "englez\u0103 canadian\u0103" },
            { "tk", "turkmen\u0103" },
            { "tl", "tagalog" },
            { "tn", "setswana" },
            { "to", "tonga" },
            { "bum", "bulu" },
            { "dyo", "jola-fonyi" },
            { "tr", "turc\u0103" },
            { "ts", "tsonga" },
            { "swb", "comorez\u0103" },
            { "tt", "t\u0103tar\u0103" },
            { "dyu", "dyula" },
            { "tw", "twi" },
            { "ty", "tahitian\u0103" },
            { "150", "Europa" },
            { "151", "Europa Oriental\u0103" },
            { "154", "Europa Septentrional\u0103" },
            { "dzg", "dazaga" },
            { "155", "Europa Occidental\u0103" },
            { "ug", "uigur\u0103" },
            { "Kore", metaValue_ko },
            { "Ital", "italic\u0103 veche" },
            { "Zyyy", "comun\u0103" },
            { "uk", "ucrainean\u0103" },
            { "ur", "urdu" },
            { "xal", "calmuc\u0103" },
            { "zen", "zenaga" },
            { "uz", "uzbec\u0103" },
            { "kha", "khasi" },
            { "nds_NL", "saxona de jos" },
            { "ve", "venda" },
            { "vi", "vietnamez\u0103" },
            { "kho", "limbp khotanez\u0103" },
            { "khq", "koyra chiini" },
            { "vo", "volapuk" },
            { "syc", "siriac\u0103 clasic\u0103" },
            { "quc", "quich\u00e9" },
            { "gaa", "ga" },
            { "wa", "valon\u0103" },
            { "gag", "g\u0103g\u0103uz\u0103" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "Lydi", "lidian\u0103" },
            { "Xsux", "cuneiform\u0103 sumero-akkadian\u0103" },
            { "wo", "wolof" },
            { "zgh", "tamazight standard marocan\u0103" },
            { "ar_001", "arab\u0103 standard modern\u0103" },
            { "Cans", "silabic\u0103 aborigen\u0103 canadian\u0103 unificat\u0103" },
            { "gay", "gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "manciurian\u0103" },
            { "Latf", "latin\u0103 Fraktur" },
            { "gba", "gbaya" },
            { "mni", "manipur" },
            { "Latn", metaValue_la },
            { "Latg", "latin\u0103 gaelic\u0103" },
            { "xh", "xhosa" },
            { "byn", "blin" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "Syrc", metaValue_syr },
            { "yi", "idi\u0219" },
            { "mos", "mossi" },
            { "Dsrt", "mormon\u0103" },
            { "yo", "yoruba" },
            { "es_MX", "spaniol\u0103 mexican\u0103" },
            { "Syrj", "siriac\u0103 occidental\u0103" },
            { "ota", "turc\u0103 otoman\u0103" },
            { "vai", "vai" },
            { "za", "zhuang" },
            { "kln", "kalenjin" },
            { "zh", "chinez\u0103" },
            { "Bopo", "bopomofo" },
            { "zu", "zulu" },
            { "Geor", metaValue_ka },
            { "kmb", "kimbundu" },
            { "gez", "geez" },
            { "Syrn", "siriac\u0103 oriental\u0103" },
            { "Egyd", "demotic\u0103 egiptean\u0103" },
            { "Egyh", "hieratic\u0103 egiptean\u0103" },
            { "ebu", "embu" },
            { "Egyp", "hieroglife egiptene" },
            { "Geok", "georgian\u0103 bisericeasc\u0103" },
            { "zh_Hans", "chinez\u0103 simplificat\u0103" },
            { "koi", "komi-permiak" },
            { "Hung", "maghiar\u0103 veche" },
            { "kok", "konkani" },
            { "kos", "kosrae" },
            { "zh_Hant", "chinez\u0103 tradi\u021bional\u0103" },
            { "kpe", "kpelle" },
            { "ilo", "iloko" },
            { "Cprt", "cipriot\u0103" },
            { "mua", "mundang" },
            { "mul", "limbi multiple" },
            { "cad", "caddo" },
            { "mus", "creek" },
            { "Glag", "glagolitic\u0103" },
            { "gil", "gilbertin\u0103" },
            { "car", "carib" },
            { "cay", "cayuga" },
            { "krc", "karaceai-balkar" },
            { "inh", "ingu\u0219\u0103" },
            { "krl", "karelian\u0103" },
            { "efi", "efik" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
