/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.shared.Utils;
import com.azul.crs.shared.models.VMEvent;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;

public class ClassLoadMonitor
implements ClientService {
    private static ClassLoadMonitor instance = new ClassLoadMonitor();
    private Client client;
    private volatile boolean started;
    private volatile boolean stopped;
    private long _count;
    private final PrintWriter traceOut;
    private static final char[] digit = "0123456789abcdef".toCharArray();

    private ClassLoadMonitor() {
        PrintWriter out = null;
        if (this.logger().isEnabled(Logger.Level.TRACE)) {
            try {
                Path traceOutFileName = Files.createTempFile("CRSClassLoadMonitor", ".log", new FileAttribute[0]);
                this.logger().trace("writing ClassLoadMonitor trace to file %s", traceOutFileName);
                out = new PrintWriter(Files.newBufferedWriter(traceOutFileName, new OpenOption[0]));
            }
            catch (IOException ignored) {
                ignored.printStackTrace();
            }
        }
        this.traceOut = out;
    }

    public static ClassLoadMonitor getInstance(Client client) {
        ClassLoadMonitor.instance.client = client;
        return instance;
    }

    private VMEvent classLoadEvent(String className, String hashString, int classId, int loaderId, String source, long eventTime) {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("className", className);
        payload.put("hash", hashString);
        payload.put("classId", Integer.toString(classId));
        payload.put("loaderId", Integer.toString(loaderId));
        if (source != null) {
            payload.put("source", source);
        }
        return new VMEvent().randomEventId().eventType(VMEvent.Type.VM_CLASS_LOADED).eventTime(eventTime).eventPayload(payload);
    }

    @Override
    public synchronized void start() {
        this.started = true;
    }

    @Override
    public synchronized void stop(long deadline) {
        this.logger().debug("total classes loaded count " + this._count, new Object[0]);
        PerformanceMetrics.logClassLoads(this._count);
        if (this.traceOut != null) {
            this.traceOut.close();
        }
        this.started = false;
        this.stopped = true;
    }

    private static String encodeToString(byte[] hash) {
        char[] str = new char[hash.length * 2];
        for (int i = 0; i < hash.length; ++i) {
            byte b = hash[i];
            str[i * 2] = digit[b >>> 4 & 0xF];
            str[i * 2 + 1] = digit[b & 0xF];
        }
        return new String(str);
    }

    public void notifyClassLoad(String className, byte[] hash, int classId, int loaderId, String source) {
        ++this._count;
        if (this.stopped) {
            return;
        }
        if (!this.started) {
            Logger.getLogger(ClassLoadMonitor.class).error("service is not yet started", new Object[0]);
        }
        long eventTime = Utils.currentTimeMillis();
        String hashString = ClassLoadMonitor.encodeToString(hash);
        this.client.postVMEvent(this.classLoadEvent(className, hashString, classId, loaderId, source, eventTime));
        if (this.traceOut != null) {
            this.traceOut.printf("%s [%d:%d]", className, loaderId, classId);
        }
    }
}

