/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.com.sun.crypto.provider;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Objects;
import sun.security.util.math.IntegerFieldModuloP;
import sun.security.util.math.IntegerModuloP;
import sun.security.util.math.MutableIntegerModuloP;
import sun.security.util.math.intpoly.IntegerPolynomial1305;

final class Poly1305 {
    private static final int KEY_LENGTH = 32;
    private static final int RS_LENGTH = 16;
    private static final int BLOCK_LENGTH = 16;
    private static final int TAG_LENGTH = 16;
    private static final IntegerFieldModuloP ipl1305 = new IntegerPolynomial1305();
    private byte[] keyBytes;
    private final byte[] block = new byte[16];
    private int blockOffset;
    private IntegerModuloP r;
    private IntegerModuloP s;
    private MutableIntegerModuloP a;
    private final MutableIntegerModuloP n = ipl1305.get1().mutable();

    Poly1305() {
    }

    void engineInit(Key newKey, AlgorithmParameterSpec params) throws InvalidKeyException {
        Objects.requireNonNull(newKey, "Null key provided during init");
        this.keyBytes = newKey.getEncoded();
        if (this.keyBytes == null) {
            throw new InvalidKeyException("Key does not support encoding");
        }
        if (this.keyBytes.length != 32) {
            throw new InvalidKeyException("Incorrect length for key: " + this.keyBytes.length);
        }
        this.engineReset();
        this.setRSVals();
    }

    int engineGetMacLength() {
        return 16;
    }

    void engineReset() {
        Arrays.fill(this.block, (byte)0);
        this.blockOffset = 0;
        this.a = ipl1305.get0().mutable();
    }

    void engineUpdate(ByteBuffer buf) {
        int bytesToWrite;
        for (int remaining = buf.remaining(); remaining > 0; remaining -= bytesToWrite) {
            bytesToWrite = Integer.min(remaining, 16 - this.blockOffset);
            if (bytesToWrite >= 16) {
                this.processBlock(buf, bytesToWrite);
                continue;
            }
            buf.get(this.block, this.blockOffset, bytesToWrite);
            this.blockOffset += bytesToWrite;
            if (this.blockOffset < 16) continue;
            this.processBlock(this.block, 0, 16);
            this.blockOffset = 0;
        }
    }

    void engineUpdate(byte[] input, int offset, int len) {
        this.checkFromIndexSize(offset, len, input.length);
        if (this.blockOffset > 0) {
            int blockSpaceLeft = 16 - this.blockOffset;
            if (len < blockSpaceLeft) {
                System.arraycopy(input, offset, this.block, this.blockOffset, len);
                this.blockOffset += len;
                return;
            }
            System.arraycopy(input, offset, this.block, this.blockOffset, blockSpaceLeft);
            offset += blockSpaceLeft;
            len -= blockSpaceLeft;
            this.processBlock(this.block, 0, 16);
            this.blockOffset = 0;
        }
        while (len >= 16) {
            this.processBlock(input, offset, 16);
            offset += 16;
            len -= 16;
        }
        if (len > 0) {
            System.arraycopy(input, offset, this.block, 0, len);
            this.blockOffset = len;
        }
    }

    void engineUpdate(byte input) {
        assert (this.blockOffset < 16);
        this.block[this.blockOffset++] = input;
        if (this.blockOffset == 16) {
            this.processBlock(this.block, 0, 16);
            this.blockOffset = 0;
        }
    }

    byte[] engineDoFinal() {
        byte[] tag = new byte[16];
        if (this.blockOffset > 0) {
            this.processBlock(this.block, 0, this.blockOffset);
            this.blockOffset = 0;
        }
        this.a.addModPowerTwo(this.s, tag);
        this.engineReset();
        return tag;
    }

    private void processBlock(ByteBuffer buf, int len) {
        this.n.setValue(buf, len, (byte)1);
        this.a.setSum(this.n);
        this.a.setProduct(this.r);
    }

    private void processBlock(byte[] block, int offset, int length) {
        this.checkFromIndexSize(offset, length, block.length);
        this.n.setValue(block, offset, length, (byte)1);
        this.a.setSum(this.n);
        this.a.setProduct(this.r);
    }

    private void setRSVals() {
        this.keyBytes[3] = (byte)(this.keyBytes[3] & 0xF);
        this.keyBytes[7] = (byte)(this.keyBytes[7] & 0xF);
        this.keyBytes[11] = (byte)(this.keyBytes[11] & 0xF);
        this.keyBytes[15] = (byte)(this.keyBytes[15] & 0xF);
        this.keyBytes[4] = (byte)(this.keyBytes[4] & 0xFC);
        this.keyBytes[8] = (byte)(this.keyBytes[8] & 0xFC);
        this.keyBytes[12] = (byte)(this.keyBytes[12] & 0xFC);
        this.r = ipl1305.getElement(this.keyBytes, 0, 16, (byte)0);
        this.s = ipl1305.getElement(this.keyBytes, 16, 16, (byte)0);
    }

    private int checkFromIndexSize(int fromIndex, int size, int length) throws IndexOutOfBoundsException {
        if ((length | fromIndex | size) < 0 || size > length - fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        return fromIndex;
    }
}

