/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.Exported;
import jdk.jfr.AnnotationElement;
import jdk.jfr.ContentType;
import jdk.jfr.internal.AnnotationConstruct;
import jdk.jfr.internal.Type;

@Exported
public final class SettingDescriptor {
    private final AnnotationConstruct annotationConstruct;
    private final Type type;
    private final String name;
    private final String defaultValue;

    SettingDescriptor(Type type, String string, String string2, List<AnnotationElement> list) {
        Objects.requireNonNull(list);
        this.name = Objects.requireNonNull(string, "Name of value descriptor can't be null");
        this.type = Objects.requireNonNull(type);
        this.annotationConstruct = new AnnotationConstruct(list);
        this.defaultValue = Objects.requireNonNull(string2);
    }

    void setAnnotations(List<AnnotationElement> list) {
        this.annotationConstruct.setAnnotationElements(list);
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        String string = this.annotationConstruct.getLabel();
        if (string == null) {
            string = this.type.getLabel();
        }
        return string;
    }

    public String getDescription() {
        String string = this.annotationConstruct.getDescription();
        if (string == null) {
            string = this.type.getDescription();
        }
        return string;
    }

    public String getContentType() {
        for (AnnotationElement annotationElement : this.getAnnotationElements()) {
            for (AnnotationElement annotationElement2 : annotationElement.getAnnotationElements()) {
                if (!annotationElement2.getTypeName().equals(ContentType.class.getName())) continue;
                return annotationElement.getTypeName();
            }
        }
        for (AnnotationElement annotationElement : this.type.getAnnotationElements()) {
            for (AnnotationElement annotationElement2 : annotationElement.getAnnotationElements()) {
                if (!annotationElement2.getTypeName().equals(ContentType.class.getName())) continue;
                return annotationElement.getTypeName();
            }
        }
        return null;
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public long getTypeId() {
        return this.type.getId();
    }

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        Objects.requireNonNull(clazz);
        return (A)((Annotation)this.annotationConstruct.getAnnotation(clazz));
    }

    public List<AnnotationElement> getAnnotationElements() {
        return Collections.unmodifiableList(this.annotationConstruct.getUnmodifiableAnnotationElements());
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    Type getType() {
        return this.type;
    }
}

