/*
 * Decompiled with CFR 0.152.
 */
package sun.security.spec;

import java.security.spec.AlgorithmParameterSpec;

public final class DSAGenParameterSpec
implements AlgorithmParameterSpec {
    private final int pLen;
    private final int qLen;
    private final int seedLen;

    public DSAGenParameterSpec(int n, int n2) {
        this(n, n2, n2);
    }

    public DSAGenParameterSpec(int n, int n2, int n3) {
        switch (n) {
            case 1024: {
                if (n2 == 160) break;
                throw new IllegalArgumentException("subprimeQLen must be 160 when primePLen=1024");
            }
            case 2048: {
                if (n2 == 224 || n2 == 256) break;
                throw new IllegalArgumentException("subprimeQLen must be 224 or 256 when primePLen=2048");
            }
            case 3072: {
                if (n2 == 256) break;
                throw new IllegalArgumentException("subprimeQLen must be 256 when primePLen=3072");
            }
            default: {
                throw new IllegalArgumentException("primePLen must be 1024, 2048, or 3072");
            }
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("seedLen must be equal to or greater than subprimeQLen");
        }
        this.pLen = n;
        this.qLen = n2;
        this.seedLen = n3;
    }

    public int getPrimePLength() {
        return this.pLen;
    }

    public int getSubprimeQLength() {
        return this.qLen;
    }

    public int getSeedLength() {
        return this.seedLen;
    }
}

