/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarVerifier;

public class Manifest
implements Cloneable {
    private final Attributes attr = new Attributes();
    private final Map<String, Attributes> entries = new HashMap<String, Attributes>();
    private final JarVerifier jv;

    public Manifest() {
        this.jv = null;
    }

    public Manifest(InputStream inputStream) throws IOException {
        this(null, inputStream);
    }

    Manifest(JarVerifier jarVerifier, InputStream inputStream) throws IOException {
        this.read(inputStream);
        this.jv = jarVerifier;
    }

    public Manifest(Manifest manifest) {
        this.attr.putAll((Map<?, ?>)manifest.getMainAttributes());
        this.entries.putAll(manifest.getEntries());
        this.jv = manifest.jv;
    }

    public Attributes getMainAttributes() {
        return this.attr;
    }

    public Map<String, Attributes> getEntries() {
        return this.entries;
    }

    public Attributes getAttributes(String string) {
        return this.getEntries().get(string);
    }

    Attributes getTrustedAttributes(String string) {
        Attributes attributes = this.getAttributes(string);
        if (attributes != null && this.jv != null && !this.jv.isTrustedManifestEntry(string)) {
            throw new SecurityException("Untrusted manifest entry: " + string);
        }
        return attributes;
    }

    public void clear() {
        this.attr.clear();
        this.entries.clear();
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.attr.writeMain(dataOutputStream);
        for (Map.Entry<String, Attributes> entry : this.entries.entrySet()) {
            StringBuffer stringBuffer = new StringBuffer("Name: ");
            String string = entry.getKey();
            if (string != null) {
                byte[] byArray = string.getBytes("UTF8");
                string = new String(byArray, 0, 0, byArray.length);
            }
            stringBuffer.append(string);
            stringBuffer.append("\r\n");
            Manifest.make72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
            entry.getValue().write(dataOutputStream);
        }
        dataOutputStream.flush();
    }

    static void make72Safe(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (n > 72) {
            int n2 = 70;
            while (n2 < n - 2) {
                stringBuffer.insert(n2, "\r\n ");
                n2 += 72;
                n += 3;
            }
        }
    }

    public void read(InputStream inputStream) throws IOException {
        int n;
        FastInputStream fastInputStream = new FastInputStream(inputStream);
        byte[] byArray = new byte[512];
        this.attr.read(fastInputStream, byArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = 2;
        String string = null;
        boolean bl = true;
        Object object = null;
        while ((n = fastInputStream.readLine(byArray)) != -1) {
            Object object2;
            if (byArray[--n] != 10) {
                throw new IOException("manifest line too long");
            }
            if (n > 0 && byArray[n - 1] == 13) {
                --n;
            }
            if (n == 0 && bl) continue;
            bl = false;
            if (string == null) {
                string = this.parseName(byArray, n);
                if (string == null) {
                    throw new IOException("invalid manifest format");
                }
                if (fastInputStream.peek() == 32) {
                    object = new byte[n - 6];
                    System.arraycopy(byArray, 6, object, 0, n - 6);
                    continue;
                }
            } else {
                object2 = new byte[(object).length + n - 1];
                System.arraycopy(object, 0, object2, 0, (object).length);
                System.arraycopy(byArray, 1, object2, ((byte[])object).length, n - 1);
                if (fastInputStream.peek() == 32) {
                    object = object2;
                    continue;
                }
                string = new String((byte[])object2, 0, ((Object)object2).length, "UTF8");
                object = null;
            }
            if ((object2 = (Object)this.getAttributes(string)) == null) {
                object2 = new Attributes(n4);
                this.entries.put(string, (Attributes)object2);
            }
            ((Attributes)object2).read(fastInputStream, byArray);
            n4 = Math.max(2, (n3 += ((Attributes)object2).size()) / ++n2);
            string = null;
            bl = true;
        }
    }

    private String parseName(byte[] byArray, int n) {
        if (this.toLower(byArray[0]) == 110 && this.toLower(byArray[1]) == 97 && this.toLower(byArray[2]) == 109 && this.toLower(byArray[3]) == 101 && byArray[4] == 58 && byArray[5] == 32) {
            try {
                return new String(byArray, 6, n - 6, "UTF8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private int toLower(int n) {
        return n >= 65 && n <= 90 ? 97 + (n - 65) : n;
    }

    public boolean equals(Object object) {
        if (object instanceof Manifest) {
            Manifest manifest = (Manifest)object;
            return this.attr.equals(manifest.getMainAttributes()) && this.entries.equals(manifest.getEntries());
        }
        return false;
    }

    public int hashCode() {
        return this.attr.hashCode() + this.entries.hashCode();
    }

    public Object clone() {
        return new Manifest(this);
    }

    static class FastInputStream
    extends FilterInputStream {
        private byte[] buf;
        private int count = 0;
        private int pos = 0;

        FastInputStream(InputStream inputStream) {
            this(inputStream, 8192);
        }

        FastInputStream(InputStream inputStream, int n) {
            super(inputStream);
            this.buf = new byte[n];
        }

        @Override
        public int read() throws IOException {
            if (this.pos >= this.count) {
                this.fill();
                if (this.pos >= this.count) {
                    return -1;
                }
            }
            return this.buf[this.pos++] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.count - this.pos;
            if (n3 <= 0) {
                if (n2 >= this.buf.length) {
                    return this.in.read(byArray, n, n2);
                }
                this.fill();
                n3 = this.count - this.pos;
                if (n3 <= 0) {
                    return -1;
                }
            }
            if (n2 > n3) {
                n2 = n3;
            }
            System.arraycopy(this.buf, this.pos, byArray, n, n2);
            this.pos += n2;
            return n2;
        }

        public int readLine(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4;
            byte[] byArray2 = this.buf;
            for (n3 = 0; n3 < n2; n3 += n4) {
                int n5 = this.count - this.pos;
                if (n5 <= 0) {
                    this.fill();
                    n5 = this.count - this.pos;
                    if (n5 <= 0) {
                        return -1;
                    }
                }
                if ((n4 = n2 - n3) > n5) {
                    n4 = n5;
                }
                int n6 = this.pos;
                int n7 = n6 + n4;
                while (n6 < n7 && byArray2[n6++] != 10) {
                }
                n4 = n6 - this.pos;
                System.arraycopy(byArray2, this.pos, byArray, n, n4);
                n += n4;
                this.pos = n6;
                if (byArray2[n6 - 1] != 10) continue;
                break;
            }
            return n3;
        }

        public byte peek() throws IOException {
            if (this.pos == this.count) {
                this.fill();
            }
            if (this.pos == this.count) {
                return -1;
            }
            return this.buf[this.pos];
        }

        public int readLine(byte[] byArray) throws IOException {
            return this.readLine(byArray, 0, byArray.length);
        }

        @Override
        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            long l2 = this.count - this.pos;
            if (l2 <= 0L) {
                return this.in.skip(l);
            }
            if (l > l2) {
                l = l2;
            }
            this.pos = (int)((long)this.pos + l);
            return l;
        }

        @Override
        public int available() throws IOException {
            return this.count - this.pos + this.in.available();
        }

        @Override
        public void close() throws IOException {
            if (this.in != null) {
                this.in.close();
                this.in = null;
                this.buf = null;
            }
        }

        private void fill() throws IOException {
            this.pos = 0;
            this.count = 0;
            int n = this.in.read(this.buf, 0, this.buf.length);
            if (n > 0) {
                this.count = n;
            }
        }
    }
}

