/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.gsskerb;

import com.sun.security.sasl.gsskerb.GssKrb5Base;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;

final class GssKrb5Server
extends GssKrb5Base
implements SaslServer {
    private static final String MY_CLASS_NAME = GssKrb5Server.class.getName();
    private int handshakeStage = 0;
    private String peer;
    private String authzid;
    private CallbackHandler cbh;

    GssKrb5Server(String string, String string2, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        super(map, MY_CLASS_NAME);
        this.cbh = callbackHandler;
        String string3 = string + "@" + string2;
        logger.log(Level.FINE, "KRB5SRV01:Using service name: {0}", string3);
        try {
            GSSManager gSSManager = GSSManager.getInstance();
            GSSName gSSName = gSSManager.createName(string3, GSSName.NT_HOSTBASED_SERVICE, KRB5_OID);
            GSSCredential gSSCredential = gSSManager.createCredential(gSSName, Integer.MAX_VALUE, KRB5_OID, 2);
            this.secCtx = gSSManager.createContext(gSSCredential);
            if ((this.allQop & 2) != 0) {
                this.secCtx.requestInteg(true);
            }
            if ((this.allQop & 4) != 0) {
                this.secCtx.requestConf(true);
            }
        }
        catch (GSSException gSSException) {
            throw new SaslException("Failure to initialize security context", gSSException);
        }
        logger.log(Level.FINE, "KRB5SRV02:Initialization complete");
    }

    @Override
    public byte[] evaluateResponse(byte[] byArray) throws SaslException {
        if (this.completed) {
            throw new SaslException("SASL authentication already complete");
        }
        if (logger.isLoggable(Level.FINER)) {
            GssKrb5Server.traceOutput(MY_CLASS_NAME, "evaluateResponse", "KRB5SRV03:Response [raw]:", byArray);
        }
        switch (this.handshakeStage) {
            case 1: {
                return this.doHandshake1(byArray);
            }
            case 2: {
                return this.doHandshake2(byArray);
            }
        }
        try {
            byte[] byArray2 = this.secCtx.acceptSecContext(byArray, 0, byArray.length);
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Server.traceOutput(MY_CLASS_NAME, "evaluateResponse", "KRB5SRV04:Challenge: [after acceptSecCtx]", byArray2);
            }
            if (this.secCtx.isEstablished()) {
                this.handshakeStage = 1;
                this.peer = this.secCtx.getSrcName().toString();
                logger.log(Level.FINE, "KRB5SRV05:Peer name is : {0}", this.peer);
                if (byArray2 == null) {
                    return this.doHandshake1(EMPTY);
                }
            }
            return byArray2;
        }
        catch (GSSException gSSException) {
            throw new SaslException("GSS initiate failed", gSSException);
        }
    }

    private byte[] doHandshake1(byte[] byArray) throws SaslException {
        try {
            if (byArray != null && byArray.length > 0) {
                throw new SaslException("Handshake expecting no response data from server");
            }
            byte[] byArray2 = new byte[4];
            byArray2[0] = this.allQop;
            GssKrb5Server.intToNetworkByteOrder(this.recvMaxBufSize, byArray2, 1, 3);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "KRB5SRV06:Supported protections: {0}; recv max buf size: {1}", new Object[]{new Byte(this.allQop), new Integer(this.recvMaxBufSize)});
            }
            this.handshakeStage = 2;
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Server.traceOutput(MY_CLASS_NAME, "doHandshake1", "KRB5SRV07:Challenge [raw]", byArray2);
            }
            byte[] byArray3 = this.secCtx.wrap(byArray2, 0, byArray2.length, new MessageProp(0, false));
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Server.traceOutput(MY_CLASS_NAME, "doHandshake1", "KRB5SRV08:Challenge [after wrap]", byArray3);
            }
            return byArray3;
        }
        catch (GSSException gSSException) {
            throw new SaslException("Problem wrapping handshake1", gSSException);
        }
    }

    private byte[] doHandshake2(byte[] byArray) throws SaslException {
        try {
            byte by;
            MessageProp messageProp = new MessageProp(false);
            byte[] byArray2 = this.secCtx.unwrap(byArray, 0, byArray.length, messageProp);
            this.checkMessageProp("Handshake failure: ", messageProp);
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Server.traceOutput(MY_CLASS_NAME, "doHandshake2", "KRB5SRV09:Response [after unwrap]", byArray2);
            }
            if (((by = byArray2[0]) & this.allQop) == 0) {
                throw new SaslException("Client selected unsupported protection: " + by);
            }
            if ((by & 4) != 0) {
                this.privacy = true;
                this.integrity = true;
            } else if ((by & 2) != 0) {
                this.integrity = true;
            }
            int n = GssKrb5Server.networkByteOrderToInt(byArray2, 1, 3);
            this.sendMaxBufSize = this.sendMaxBufSize == 0 ? n : Math.min(this.sendMaxBufSize, n);
            this.rawSendSize = this.secCtx.getWrapSizeLimit(0, this.privacy, this.sendMaxBufSize);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "KRB5SRV10:Selected protection: {0}; privacy: {1}; integrity: {2}", new Object[]{new Byte(by), this.privacy, this.integrity});
                logger.log(Level.FINE, "KRB5SRV11:Client max recv size: {0}; server max send size: {1}; rawSendSize: {2}", new Object[]{new Integer(n), new Integer(this.sendMaxBufSize), new Integer(this.rawSendSize)});
            }
            if (byArray2.length > 4) {
                try {
                    this.authzid = new String(byArray2, 4, byArray2.length - 4, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SaslException("Cannot decode authzid", unsupportedEncodingException);
                }
            } else {
                this.authzid = this.peer;
            }
            logger.log(Level.FINE, "KRB5SRV12:Authzid: {0}", this.authzid);
            AuthorizeCallback authorizeCallback = new AuthorizeCallback(this.peer, this.authzid);
            this.cbh.handle(new Callback[]{authorizeCallback});
            if (!authorizeCallback.isAuthorized()) {
                throw new SaslException(this.peer + " is not authorized to connect as " + this.authzid);
            }
            this.authzid = authorizeCallback.getAuthorizedID();
            this.completed = true;
            return null;
        }
        catch (GSSException gSSException) {
            throw new SaslException("Final handshake step failed", gSSException);
        }
        catch (IOException iOException) {
            throw new SaslException("Problem with callback handler", iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new SaslException("Problem with callback handler", unsupportedCallbackException);
        }
    }

    @Override
    public String getAuthorizationID() {
        if (this.completed) {
            return this.authzid;
        }
        throw new IllegalStateException("Authentication incomplete");
    }
}

