/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;
import sun.security.ec.ECOperations;
import sun.security.ec.ECPrivateKeyImpl;
import sun.security.ec.ECPublicKeyImpl;
import sun.security.ec.point.AffinePoint;
import sun.security.ec.point.MutablePoint;
import sun.security.jca.JCAUtil;
import sun.security.util.ECUtil;
import sun.security.util.Optional;
import sun.security.util.SecurityProviderConstants;
import sun.security.util.math.ImmutableIntegerModuloP;
import sun.security.util.math.IntegerFieldModuloP;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int KEY_SIZE_MIN = 112;
    private static final int KEY_SIZE_MAX = 571;
    private SecureRandom random;
    private int keySize;
    private AlgorithmParameterSpec params = null;

    public ECKeyPairGenerator() {
        this.initialize(SecurityProviderConstants.DEF_EC_KEY_SIZE, null);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.checkKeySize(n);
        this.params = ECUtil.getECParameterSpec(null, n);
        if (this.params == null) {
            throw new InvalidParameterException("No EC parameters available for key size " + n + " bits");
        }
        this.random = secureRandom;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        ECParameterSpec eCParameterSpec = null;
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            ECParameterSpec eCParameterSpec2 = (ECParameterSpec)algorithmParameterSpec;
            eCParameterSpec = ECUtil.getECParameterSpec(null, eCParameterSpec2);
            if (eCParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("Unsupported curve: " + algorithmParameterSpec);
            }
        } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            String string = ((ECGenParameterSpec)algorithmParameterSpec).getName();
            eCParameterSpec = ECUtil.getECParameterSpec(null, string);
            if (eCParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("Unknown curve name: " + string);
            }
        } else {
            throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
        }
        ECKeyPairGenerator.ensureCurveIsSupported(eCParameterSpec);
        this.params = eCParameterSpec;
        this.keySize = eCParameterSpec.getCurve().getField().getFieldSize();
        this.random = secureRandom;
    }

    private static void ensureCurveIsSupported(ECParameterSpec eCParameterSpec) throws InvalidAlgorithmParameterException {
        byte[] byArray;
        AlgorithmParameters algorithmParameters = ECUtil.getECParameters(null);
        try {
            algorithmParameters.init(eCParameterSpec);
            byArray = algorithmParameters.getEncoded();
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException("Unsupported curve: " + eCParameterSpec.toString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (!ECKeyPairGenerator.isCurveSupported(byArray)) {
            throw new InvalidAlgorithmParameterException("Unsupported curve: " + algorithmParameters.toString());
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        try {
            Optional<KeyPair> optional = this.generateKeyPairImpl(this.random);
            if (optional.isPresent()) {
                return (KeyPair)optional.get();
            }
            return this.generateKeyPairNative(this.random);
        }
        catch (Exception exception) {
            throw new ProviderException(exception);
        }
    }

    private byte[] generatePrivateScalar(SecureRandom secureRandom, ECOperations eCOperations, int n) {
        int n2 = 128;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n2; ++i) {
            secureRandom.nextBytes(byArray);
            try {
                return eCOperations.seedToScalar(byArray);
            }
            catch (ECOperations.IntermediateValueException intermediateValueException) {
                continue;
            }
        }
        throw new ProviderException("Unable to produce private key after " + n2 + " attempts");
    }

    private Optional<KeyPair> generateKeyPairImpl(SecureRandom secureRandom) throws InvalidKeyException {
        ECParameterSpec eCParameterSpec = (ECParameterSpec)this.params;
        Optional<ECOperations> optional = ECOperations.forParameters(eCParameterSpec);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        ECOperations eCOperations = (ECOperations)optional.get();
        IntegerFieldModuloP integerFieldModuloP = eCOperations.getField();
        int n = eCParameterSpec.getOrder().bitLength();
        int n2 = n + 64;
        int n3 = (n2 + 7) / 8;
        byte[] byArray = this.generatePrivateScalar(secureRandom, eCOperations, n3);
        ECPoint eCPoint = eCParameterSpec.getGenerator();
        ImmutableIntegerModuloP immutableIntegerModuloP = integerFieldModuloP.getElement(eCPoint.getAffineX());
        ImmutableIntegerModuloP immutableIntegerModuloP2 = integerFieldModuloP.getElement(eCPoint.getAffineY());
        AffinePoint affinePoint = new AffinePoint(immutableIntegerModuloP, immutableIntegerModuloP2);
        MutablePoint mutablePoint = eCOperations.multiply(affinePoint, byArray);
        AffinePoint affinePoint2 = mutablePoint.asAffine();
        ECPrivateKeyImpl eCPrivateKeyImpl = new ECPrivateKeyImpl(byArray, eCParameterSpec);
        ECPoint eCPoint2 = new ECPoint(affinePoint2.getX().asBigInteger(), affinePoint2.getY().asBigInteger());
        ECPublicKeyImpl eCPublicKeyImpl = new ECPublicKeyImpl(eCPoint2, eCParameterSpec);
        return Optional.of((Object)new KeyPair(eCPublicKeyImpl, eCPrivateKeyImpl));
    }

    private KeyPair generateKeyPairNative(SecureRandom secureRandom) throws Exception {
        ECParameterSpec eCParameterSpec = (ECParameterSpec)this.params;
        byte[] byArray = ECUtil.encodeECParameterSpec(null, eCParameterSpec);
        byte[] byArray2 = new byte[((this.keySize + 7 >> 3) + 1) * 2];
        secureRandom.nextBytes(byArray2);
        Object[] objectArray = ECKeyPairGenerator.generateECKeyPair(this.keySize, byArray, byArray2);
        BigInteger bigInteger = new BigInteger(1, (byte[])objectArray[0]);
        ECPrivateKeyImpl eCPrivateKeyImpl = new ECPrivateKeyImpl(bigInteger, eCParameterSpec);
        byte[] byArray3 = (byte[])objectArray[1];
        ECPoint eCPoint = ECUtil.decodePoint(byArray3, eCParameterSpec.getCurve());
        ECPublicKeyImpl eCPublicKeyImpl = new ECPublicKeyImpl(eCPoint, eCParameterSpec);
        return new KeyPair(eCPublicKeyImpl, eCPrivateKeyImpl);
    }

    private void checkKeySize(int n) throws InvalidParameterException {
        if (n < 112) {
            throw new InvalidParameterException("Key size must be at least 112 bits");
        }
        if (n > 571) {
            throw new InvalidParameterException("Key size must be at most 571 bits");
        }
        this.keySize = n;
    }

    private static native boolean isCurveSupported(byte[] var0);

    private static native Object[] generateECKeyPair(int var0, byte[] var1, byte[] var2) throws GeneralSecurityException;
}

