/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_cs extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Moskevsk\u00fd standardn\u00ed \u010das",
               "",
               "Moskevsk\u00fd letn\u00ed \u010das",
               "",
               "Moskevsk\u00fd \u010das",
               "",
            };
        final String[] Pakistan = new String[] {
               "P\u00e1kist\u00e1nsk\u00fd standardn\u00ed \u010das",
               "",
               "P\u00e1kist\u00e1nsk\u00fd letn\u00ed \u010das",
               "",
               "P\u00e1kist\u00e1nsk\u00fd \u010das",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadansk\u00fd standardn\u00ed \u010das",
               "",
               "Magadansk\u00fd letn\u00ed \u010das",
               "",
               "Magadansk\u00fd \u010das",
               "",
            };
        final String[] Europe_Central = new String[] {
               "St\u0159edoevropsk\u00fd standardn\u00ed \u010das",
               "SE\u010c",
               "St\u0159edoevropsk\u00fd letn\u00ed \u010das",
               "SEL\u010c",
               "St\u0159edoevropsk\u00fd \u010das",
               "SE\u010c",
            };
        final String[] Acre = new String[] {
               "Acrejsk\u00fd standardn\u00ed \u010das",
               "",
               "Acrejsk\u00fd letn\u00ed \u010das",
               "",
               "Acrejsk\u00fd \u010das",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Severoamerick\u00fd v\u00fdchodn\u00ed standardn\u00ed \u010das",
               "EST",
               "Severoamerick\u00fd v\u00fdchodn\u00ed letn\u00ed \u010das",
               "EDT",
               "Severoamerick\u00fd v\u00fdchodn\u00ed \u010das",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Standardn\u00ed \u010das ostrova lorda Howa",
               "",
               "Letn\u00ed \u010das ostrova lorda Howa",
               "",
               "\u010cas ostrova lorda Howa",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Novoz\u00e9landsk\u00fd standardn\u00ed \u010das",
               "",
               "Novoz\u00e9landsk\u00fd letn\u00ed \u010das",
               "",
               "Novoz\u00e9landsk\u00fd \u010das",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indickooce\u00e1nsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsk\u00fd standardn\u00ed \u010das",
               "",
               "Jakutsk\u00fd letn\u00ed \u010das",
               "",
               "Jakutsk\u00fd \u010das",
               "",
            };
        final String[] East_Timor = new String[] {
               "V\u00fdchodotimorsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Kosrajsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "V\u00fdchodoevropsk\u00fd standardn\u00ed \u010das",
               "",
               "V\u00fdchodoevropsk\u00fd letn\u00ed \u010das",
               "",
               "V\u00fdchodoevropsk\u00fd \u010das",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "Z\u00e1padoargentinsk\u00fd standardn\u00ed \u010das",
               "",
               "Z\u00e1padoargentinsk\u00fd letn\u00ed \u010das",
               "",
               "Z\u00e1padoargentinsk\u00fd \u010das",
               "",
            };
        final String[] Ponape = new String[] {
               "Ponapsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivijsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Pierre-miquelonsk\u00fd standardn\u00ed \u010das",
               "",
               "Pierre-miquelonsk\u00fd letn\u00ed \u010das",
               "",
               "Pierre-miquelonsk\u00fd \u010das",
               "",
            };
        final String[] Indochina = new String[] {
               "Indo\u010d\u00ednsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekat\u011brinbursk\u00fd standardn\u00ed \u010das",
               "",
               "Jekat\u011brinbursk\u00fd letn\u00ed \u010das",
               "",
               "Jekat\u011brinbursk\u00fd \u010das",
               "",
            };
        final String[] Maldives = new String[] {
               "Maledivsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahitsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "\u010cas ostrov\u016f Wallis a Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Jihoafrick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "\u010cas stanice \u0160\u00f3wa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "\u010cas Rovn\u00edkov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbeck\u00fd standardn\u00ed \u010das",
               "",
               "Uzbeck\u00fd letn\u00ed \u010das",
               "",
               "Uzbeck\u00fd \u010das",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ul\u00e1nb\u00e1tarsk\u00fd standardn\u00ed \u010das",
               "",
               "Ul\u00e1nb\u00e1tarsk\u00fd letn\u00ed \u010das",
               "",
               "Ul\u00e1nb\u00e1tarsk\u00fd \u010das",
               "",
            };
        final String[] America_Central = new String[] {
               "Severoamerick\u00fd centr\u00e1ln\u00ed standardn\u00ed \u010das",
               "CST",
               "Severoamerick\u00fd centr\u00e1ln\u00ed letn\u00ed \u010das",
               "CDT",
               "Severoamerick\u00fd centr\u00e1ln\u00ed \u010das",
               "CT",
            };
        final String[] Niue = new String[] {
               "Niuejsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "\u010cas ostrova Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandsk\u00fd standardn\u00ed \u010das",
               "",
               "Falklandsk\u00fd letn\u00ed \u010das",
               "",
               "Falklandsk\u00fd \u010das",
               "",
            };
        final String[] Apia = new String[] {
               "Apijsk\u00fd standardn\u00ed \u010das",
               "",
               "Apijsk\u00fd letn\u00ed \u010das",
               "",
               "Apijsk\u00fd \u010das",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bh\u00fat\u00e1nsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Naursk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Z\u00e1padokazachst\u00e1nsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "\u010cas V\u00e1no\u010dn\u00edho ostrova",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9unionsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "\u010cas Kokosov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chathamsk\u00fd standardn\u00ed \u010das",
               "",
               "Chathamsk\u00fd letn\u00ed \u010das",
               "",
               "Chathamsk\u00fd \u010das",
               "",
            };
        final String[] Vostok = new String[] {
               "\u010cas stanice Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentinsk\u00fd standardn\u00ed \u010das",
               "",
               "Argentinsk\u00fd letn\u00ed \u010das",
               "",
               "Argentinsk\u00fd \u010das",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiersk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galap\u00e1\u017esk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuelsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u010cas F\u00e9nixov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kapverdsk\u00fd standardn\u00ed \u010das",
               "",
               "Kapverdsk\u00fd letn\u00ed \u010das",
               "",
               "Kapverdsk\u00fd \u010das",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samojsk\u00fd standardn\u00ed \u010das",
               "",
               "Samojsk\u00fd letn\u00ed \u010das",
               "",
               "Samojsk\u00fd \u010das",
               "",
            };
        final String[] Davis = new String[] {
               "\u010cas Davisovy stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Kub\u00e1nsk\u00fd standardn\u00ed \u010das",
               "",
               "Kub\u00e1nsk\u00fd letn\u00ed \u010das",
               "",
               "Kub\u00e1nsk\u00fd \u010das",
               "",
            };
        final String[] GMT = new String[] {
               "Greenwichsk\u00fd st\u0159edn\u00ed \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Filip\u00ednsk\u00fd standardn\u00ed \u010das",
               "",
               "Filip\u00ednsk\u00fd letn\u00ed \u010das",
               "",
               "Filip\u00ednsk\u00fd \u010das",
               "",
            };
        final String[] French_Southern = new String[] {
               "\u010cas Francouzsk\u00fdch ji\u017en\u00edch a antarktick\u00fdch \u00fazem\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Novokaledonsk\u00fd standardn\u00ed \u010das",
               "",
               "Novokaledonsk\u00fd letn\u00ed \u010das",
               "",
               "Novokaledonsk\u00fd \u010das",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunejsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "\u00cdr\u00e1nsk\u00fd standardn\u00ed \u010das",
               "",
               "\u00cdr\u00e1nsk\u00fd letn\u00ed \u010das",
               "",
               "\u00cdr\u00e1nsk\u00fd \u010das",
               "",
            };
        final String[] Tajikistan = new String[] {
               "T\u00e1d\u017eick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Ton\u017esk\u00fd standardn\u00ed \u010das",
               "",
               "Ton\u017esk\u00fd letn\u00ed \u010das",
               "",
               "Ton\u017esk\u00fd \u010das",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Banglad\u00e9\u0161sk\u00fd standardn\u00ed \u010das",
               "",
               "Banglad\u00e9\u0161sk\u00fd letn\u00ed \u010das",
               "",
               "Banglad\u00e9\u0161sk\u00fd \u010das",
               "",
            };
        final String[] Peru = new String[] {
               "Peru\u00e1nsk\u00fd standardn\u00ed \u010das",
               "",
               "Peru\u00e1nsk\u00fd letn\u00ed \u010das",
               "",
               "Peru\u00e1nsk\u00fd \u010das",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "V\u00fdchodogr\u00f3nsk\u00fd standardn\u00ed \u010das",
               "",
               "V\u00fdchodogr\u00f3nsk\u00fd letn\u00ed \u010das",
               "",
               "V\u00fdchodogr\u00f3nsk\u00fd \u010das",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "V\u00fdchodoindon\u00e9sk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kyrgyzsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "V\u00fdchodoaustralsk\u00fd standardn\u00ed \u010das",
               "",
               "V\u00fdchodoaustralsk\u00fd letn\u00ed \u010das",
               "",
               "V\u00fdchodoaustralsk\u00fd \u010das",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Francouzskoguyansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Kolumbijsk\u00fd standardn\u00ed \u010das",
               "",
               "Kolumbijsk\u00fd letn\u00ed \u010das",
               "",
               "Kolumbijsk\u00fd \u010das",
               "",
            };
        final String[] Chile = new String[] {
               "Chilsk\u00fd standardn\u00ed \u010das",
               "",
               "Chilsk\u00fd letn\u00ed \u010das",
               "",
               "Chilsk\u00fd \u010das",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u010cas Gilbertov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk\u00fd standardn\u00ed \u010das",
               "",
               "Irkutsk\u00fd letn\u00ed \u010das",
               "",
               "Irkutsk\u00fd \u010das",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruz\u00ednsk\u00fd standardn\u00ed \u010das",
               "",
               "Gruz\u00ednsk\u00fd letn\u00ed \u010das",
               "",
               "Gruz\u00ednsk\u00fd \u010das",
               "",
            };
        final String[] Choibalsan = new String[] {
               "\u010cojbalsansk\u00fd standardn\u00ed \u010das",
               "",
               "\u010cojbalsansk\u00fd letn\u00ed \u010das",
               "",
               "\u010cojbalsansk\u00fd \u010das",
               "",
            };
        final String[] China = new String[] {
               "\u010c\u00ednsk\u00fd standardn\u00ed \u010das",
               "",
               "\u010c\u00ednsk\u00fd letn\u00ed \u010das",
               "",
               "\u010c\u00ednsk\u00fd \u010das",
               "",
            };
        final String[] Armenia = new String[] {
               "Arm\u00e9nsk\u00fd standardn\u00ed \u010das",
               "",
               "Arm\u00e9nsk\u00fd letn\u00ed \u010das",
               "",
               "Arm\u00e9nsk\u00fd \u010das",
               "",
            };
        final String[] Africa_Central = new String[] {
               "St\u0159edoafrick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Japonsk\u00fd standardn\u00ed \u010das",
               "",
               "Japonsk\u00fd letn\u00ed \u010das",
               "",
               "Japonsk\u00fd \u010das",
               "",
            };
        final String[] Taipei = new String[] {
               "Tchajpejsk\u00fd standardn\u00ed \u010das",
               "",
               "Tchajpejsk\u00fd letn\u00ed \u010das",
               "",
               "Tchajpejsk\u00fd \u010das",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovdsk\u00fd standardn\u00ed \u010das",
               "",
               "Hovdsk\u00fd letn\u00ed \u010das",
               "",
               "Hovdsk\u00fd \u010das",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "St\u0159edoz\u00e1padn\u00ed australsk\u00fd standardn\u00ed \u010das",
               "",
               "St\u0159edoz\u00e1padn\u00ed australsk\u00fd letn\u00ed \u010das",
               "",
               "St\u0159edoz\u00e1padn\u00ed australsk\u00fd \u010das",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sachalinsk\u00fd standardn\u00ed \u010das",
               "",
               "Sachalinsk\u00fd letn\u00ed \u010das",
               "",
               "Sachalinsk\u00fd \u010das",
               "",
            };
        final String[] Paraguay = new String[] {
               "Paraguaysk\u00fd standardn\u00ed \u010das",
               "",
               "Paraguaysk\u00fd letn\u00ed \u010das",
               "",
               "Paraguaysk\u00fd \u010das",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malajsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Koordinovan\u00fd sv\u011btov\u00fd \u010das",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauricijsk\u00fd standardn\u00ed \u010das",
               "",
               "Mauricijsk\u00fd letn\u00ed \u010das",
               "",
               "Mauricijsk\u00fd \u010das",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "V\u00fdchodoafrick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "\u010cas \u0160alamounov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "\u010cas Marshallov\u00fdch ostrov\u016f",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundlandsk\u00fd standardn\u00ed \u010das",
               "",
               "Newfoundlandsk\u00fd letn\u00ed \u010das",
               "",
               "Newfoundlandsk\u00fd \u010das",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afgh\u00e1nsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongsk\u00fd standardn\u00ed \u010das",
               "",
               "Hongkongsk\u00fd letn\u00ed \u010das",
               "",
               "Hongkongsk\u00fd \u010das",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantick\u00fd standardn\u00ed \u010das",
               "AST",
               "Atlantick\u00fd letn\u00ed \u010das",
               "ADT",
               "Atlantick\u00fd \u010das",
               "AT",
            };
        final String[] Israel = new String[] {
               "Izraelsk\u00fd standardn\u00ed \u010das",
               "",
               "Izraelsk\u00fd letn\u00ed \u010das",
               "",
               "Izraelsk\u00fd \u010das",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "St\u0159edoindon\u00e9sk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk\u00fd standardn\u00ed \u010das",
               "",
               "Omsk\u00fd letn\u00ed \u010das",
               "",
               "Omsk\u00fd \u010das",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguaysk\u00fd standardn\u00ed \u010das",
               "",
               "Uruguaysk\u00fd letn\u00ed \u010das",
               "",
               "Uruguaysk\u00fd \u010das",
               "",
            };
        final String[] Nepal = new String[] {
               "Nep\u00e1lsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuksk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatsk\u00fd standardn\u00ed \u010das",
               "",
               "Vanuatsk\u00fd letn\u00ed \u010das",
               "",
               "Vanuatsk\u00fd \u010das",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk\u00fd standardn\u00ed \u010das",
               "",
               "Novosibirsk\u00fd letn\u00ed \u010das",
               "",
               "Novosibirsk\u00fd \u010das",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapursk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Azorsk\u00fd standardn\u00ed \u010das",
               "",
               "Azorsk\u00fd letn\u00ed \u010das",
               "",
               "Azorsk\u00fd \u010das",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinamsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk\u00fd standardn\u00ed \u010das",
               "",
               "Krasnojarsk\u00fd letn\u00ed \u010das",
               "",
               "Krasnojarsk\u00fd \u010das",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmarsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Amazonsk\u00fd standardn\u00ed \u010das",
               "",
               "Amazonsk\u00fd letn\u00ed \u010das",
               "",
               "Amazonsk\u00fd \u010das",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "V\u00fdchodokazachst\u00e1nsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Fid\u017eijsk\u00fd standardn\u00ed \u010das",
               "",
               "Fid\u017eijsk\u00fd letn\u00ed \u010das",
               "",
               "Fid\u017eijsk\u00fd \u010das",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsko-kam\u010datsk\u00fd standardn\u00ed \u010das",
               "",
               "Petropavlovsko-kam\u010datsk\u00fd letn\u00ed \u010das",
               "",
               "Petropavlovsko-kam\u010datsk\u00fd \u010das",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "\u010cas ostrova Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havajsko-aleutsk\u00fd standardn\u00ed \u010das",
               "",
               "Havajsko-aleutsk\u00fd letn\u00ed \u010das",
               "",
               "Havajsko-aleutsk\u00fd \u010das",
               "",
            };
        final String[] Australia_Central = new String[] {
               "St\u0159edoaustralsk\u00fd standardn\u00ed \u010das",
               "",
               "St\u0159edoaustralsk\u00fd letn\u00ed \u010das",
               "",
               "St\u0159edoaustralsk\u00fd \u010das",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Severoamerick\u00fd pacifick\u00fd standardn\u00ed \u010das",
               "PST",
               "Severoamerick\u00fd pacifick\u00fd letn\u00ed \u010das",
               "PDT",
               "Severoamerick\u00fd pacifick\u00fd \u010das",
               "PT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmensk\u00fd standardn\u00ed \u010das",
               "",
               "Turkmensk\u00fd letn\u00ed \u010das",
               "",
               "Turkmensk\u00fd \u010das",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Z\u00e1padoevropsk\u00fd standardn\u00ed \u010das",
               "",
               "Z\u00e1padoevropsk\u00fd letn\u00ed \u010das",
               "",
               "Z\u00e1padoevropsk\u00fd \u010das",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "\u010cas Pitcairnova ostrova",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "\u010cas Rotherovy stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palausk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "\u00c1zerb\u00e1jd\u017e\u00e1nsk\u00fd standardn\u00ed \u010das",
               "",
               "\u00c1zerb\u00e1jd\u017e\u00e1nsk\u00fd letn\u00ed \u010das",
               "",
               "\u00c1zerb\u00e1jd\u017e\u00e1nsk\u00fd \u010das",
               "",
            };
        final String[] Mawson = new String[] {
               "\u010cas Mawsonovy stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexick\u00fd pacifick\u00fd standardn\u00ed \u010das",
               "",
               "Mexick\u00fd pacifick\u00fd letn\u00ed \u010das",
               "",
               "Mexick\u00fd pacifick\u00fd \u010das",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Z\u00e1padoafrick\u00fd standardn\u00ed \u010das",
               "",
               "Z\u00e1padoafrick\u00fd letn\u00ed \u010das",
               "",
               "Z\u00e1padoafrick\u00fd \u010das",
               "",
            };
        final String[] South_Georgia = new String[] {
               "\u010cas Ji\u017en\u00ed Georgie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgogradsk\u00fd standardn\u00ed \u010das",
               "",
               "Volgogradsk\u00fd letn\u00ed \u010das",
               "",
               "Volgogradsk\u00fd \u010das",
               "",
            };
        final String[] Easter = new String[] {
               "Standardn\u00ed \u010das Velikono\u010dn\u00edho ostrova",
               "",
               "Letn\u00ed \u010das Velikono\u010dn\u00edho ostrova",
               "",
               "\u010cas Velikono\u010dn\u00edho ostrova",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Severoz\u00e1padn\u00ed mexick\u00fd standardn\u00ed \u010das",
               "",
               "Severoz\u00e1padn\u00ed mexick\u00fd letn\u00ed \u010das",
               "",
               "Severoz\u00e1padn\u00ed mexick\u00fd \u010das",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "\u010cas stanice Dumonta d\u2019Urvilla",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Z\u00e1padogr\u00f3nsk\u00fd standardn\u00ed \u010das",
               "",
               "Z\u00e1padogr\u00f3nsk\u00fd letn\u00ed \u010das",
               "",
               "Z\u00e1padogr\u00f3nsk\u00fd \u010das",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekv\u00e1dorsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "Standardn\u00ed \u010das Persk\u00e9ho z\u00e1livu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Korejsk\u00fd standardn\u00ed \u010das",
               "",
               "Korejsk\u00fd letn\u00ed \u010das",
               "",
               "Korejsk\u00fd \u010das",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Z\u00e1padoaustralsk\u00fd standardn\u00ed \u010das",
               "",
               "Z\u00e1padoaustralsk\u00fd letn\u00ed \u010das",
               "",
               "Z\u00e1padoaustralsk\u00fd \u010das",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Z\u00e1padoindon\u00e9sk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Severoamerick\u00fd horsk\u00fd standardn\u00ed \u010das",
               "MST",
               "Severoamerick\u00fd horsk\u00fd letn\u00ed \u010das",
               "MDT",
               "Severoamerick\u00fd horsk\u00fd \u010das",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Mark\u00e9zsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabsk\u00fd standardn\u00ed \u010das",
               "",
               "Arabsk\u00fd letn\u00ed \u010das",
               "",
               "Arabsk\u00fd \u010das",
               "",
            };
        final String[] Alaska = new String[] {
               "Alja\u0161sk\u00fd standardn\u00ed \u010das",
               "AKST",
               "Alja\u0161sk\u00fd letn\u00ed \u010das",
               "AKDT",
               "Alja\u0161sk\u00fd \u010das",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostock\u00fd standardn\u00ed \u010das",
               "",
               "Vladivostock\u00fd letn\u00ed \u010das",
               "",
               "Vladivostock\u00fd \u010das",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorrsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelausk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u010cas Papuy-Nov\u00e9 Guiney",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Standardn\u00ed \u010das souostrov\u00ed Fernando de Noronha",
               "",
               "Letn\u00ed \u010das souostrov\u00ed Fernando de Noronha",
               "",
               "\u010cas souostrov\u00ed Fernando de Noronha",
               "",
            };
        final String[] Brasilia = new String[] {
               "Brasilijsk\u00fd standardn\u00ed \u010das",
               "",
               "Brasilijsk\u00fd letn\u00ed \u010das",
               "",
               "Brasilijsk\u00fd \u010das",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyrsk\u00fd standardn\u00ed \u010das",
               "",
               "Anadyrsk\u00fd letn\u00ed \u010das",
               "",
               "Anadyrsk\u00fd \u010das",
               "",
            };
        final String[] Samara = new String[] {
               "Samarsk\u00fd standardn\u00ed \u010das",
               "",
               "Samarsk\u00fd letn\u00ed \u010das",
               "",
               "Samarsk\u00fd \u010das",
               "",
            };
        final String[] India = new String[] {
               "Indick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Standardn\u00ed \u010das Cookov\u00fdch ostrov\u016f",
               "",
               "Letn\u00ed \u010das Cookov\u00fdch ostrov\u016f",
               "",
               "\u010cas Cookov\u00fdch ostrov\u016f",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Havajsko-aleutsk\u00fd standardn\u00ed \u010das",
                    "HST",
                    "Havajsko-aleutsk\u00fd letn\u00ed \u010das",
                    "HDT",
                    "Havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.Asia/Katmandu", "K\u00e1thm\u00e1nd\u00fa" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "Lubla\u0148" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Mark\u00e9zy" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "",
                    "Britsk\u00fd letn\u00ed \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Severn\u00ed Dakota" },
            { "JST", Japan },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "timezone.excity.Pacific/Truk", "Chuuksk\u00e9 ostrovy" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "BET", Brasilia },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Lond\u00fdn" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairnovy ostrovy" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nome" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "\u010cojbalsan" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "Svat\u00e1 Lucie" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuzn\u011bck" },
            { "timezone.excity.Europe/Berlin", "Berl\u00edn" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Martinik" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Severn\u00ed Dakota" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Belize" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.Atlantic/South_Georgia", "Ji\u017en\u00ed Georgie" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnompenh" },
            { "timezone.excity.Europe/Rome", "\u0158\u00edm" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Kar\u00e1\u010d\u00ed" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.Africa/Nouakchott", "Nuak\u0161ott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "El Aaiun" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Severn\u00ed Dakota" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Curych" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "timezone.excity.America/New_York", "New York" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Etc/Unknown", "nezn\u00e1m\u00e9 m\u011bsto" },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Europe/Uzhgorod", "U\u017ehorod" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.Africa/Algiers", "Al\u017e\u00edr" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Chart\u00fam" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Galap\u00e1gy" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucuman" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "",
                    "Irsk\u00fd letn\u00ed \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "\u00c9fat\u00e9" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Svat\u00e1 Helena" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Lucemburk" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahrajn" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "timezone.excity.Europe/Isle_of_Man", "Ostrov Man" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Pa\u0159\u00ed\u017e" },
            { "timezone.excity.Europe/Zagreb", "Z\u00e1h\u0159eb" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budape\u0161\u0165" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.Asia/Chita", "\u010cita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Helsinky" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Urumqi", "Urum\u010di" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogadi\u0161u" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Kuvajt" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Tchaj-pej" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Greenwichsk\u00fd st\u0159edn\u00ed \u010das",
                    "",
                    "Britsk\u00fd letn\u00ed \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dh\u00e1ka" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ul\u00e1nb\u00e1tar" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Sredn\u011bkolymsk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kapverdy" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Eirunepe", "Eirunepe" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiaba" },
            { "Pacific/Noumea", New_Caledonia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "Azorsk\u00e9 ostrovy" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "V\u00e1no\u010dn\u00ed ostrov" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Qostanay", "Kostanaj" },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Cancun", "Canc\u00fan" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161in\u011bv" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Africa/Djibouti", "D\u017eibuti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Shanghai", "\u0160anghaj" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Velikono\u010dn\u00ed ostrov" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Atlantic/Canary", "Kan\u00e1rsk\u00e9 ostrovy" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Africa/Cairo", "K\u00e1hira" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Var\u0161ava" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "Svat\u00fd Tom\u00e1\u0161" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.Africa/Abidjan", "Abid\u017ean" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Guadeloupe" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Vatik\u00e1n" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.Asia/Beirut", "Bejr\u00fat" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagd\u00e1d" },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Maceio" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "Svat\u00fd Vincenc" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelenovy ostrovy" },
            { "CNT", Newfoundland },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tripolis" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Asia/Pyongyang", "Pchjongjang" },
            { "timezone.excity.Europe/Bucharest", "Bukure\u0161\u0165" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Ath\u00e9ny" },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "NET", Armenia },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Koda\u0148" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Jeruzal\u00e9m" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Rij\u00e1d" },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Asia/Damascus", "Dama\u0161ek" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Bah\u00eda" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teher\u00e1n" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "timezone.excity.America/St_Kitts", "Svat\u00fd Kry\u0161tof" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Ho \u010ci Minovo m\u011bsto" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Jekat\u011brinburg" },
            { "CST", America_Central },
            { "timezone.excity.Europe/Sofia", "Sofie" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astracha\u0148" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "B\u011blehrad" },
            { "timezone.excity.America/Puerto_Rico", "Portoriko" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Kalkata" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.America/Mexico_City", "Ciudad de M\u00e9xico" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisabon" },
            { "timezone.excity.Pacific/Gambier", "Gambierovy ostrovy" },
            { "timezone.excity.America/Boise", "Boise" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Z\u00e1poro\u017e\u00ed" },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chathamsk\u00e9 ostrovy" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10",
                new String[] {
                    "Havajsko-aleutsk\u00fd standardn\u00ed \u010das",
                    "HST",
                    "Havajsko-aleutsk\u00fd letn\u00ed \u010das",
                    "HDT",
                    "Havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Mauricius" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.America/St_Barthelemy", "Svat\u00fd Bartolom\u011bj" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Uralsk" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Soul" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "Svat\u00fd Tom\u00e1\u0161 (Karibik)" },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "America/Rio_Branco", Acre },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "Nd\u017eamena" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "NST", New_Zealand },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "V\u00edde\u0148" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Kajmansk\u00e9 ostrovy" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Nik\u00f3sie" },
            { "timezone.excity.Europe/Kiev", "Kyjev" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.Asia/Brunei", "Brunej" },
            { "timezone.excity.Atlantic/Faeroe", "Faersk\u00e9 ostrovy" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Asia/Kuching", "Ku\u010ding" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Merida", "Merida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "A\u0161chabad" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.America/Jamaica", "Jamajka" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "Rang\u00fan" },
            { "timezone.excity.Asia/Thimphu", "Thimb\u00fa" },
            { "timezone.excity.Asia/Dubai", "Dubaj" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "K\u00e1bul" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudy" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Indian/Cocos", "Kokosov\u00e9 ostrovy" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amm\u00e1n" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Brusel" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Komory" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Stockholm" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.Indian/Maldives", "Maledivy" },
        };
        return data;
    }
}
