/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_en extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Central Africa Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moscow Standard Time",
               "",
               "Moscow Summer Time",
               "",
               "Moscow Time",
               "",
            };
        final String[] Japan = new String[] {
               "Japan Standard Time",
               "",
               "Japan Daylight Time",
               "",
               "Japan Time",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan Standard Time",
               "",
               "Pakistan Summer Time",
               "",
               "Pakistan Time",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei Standard Time",
               "",
               "Taipei Daylight Time",
               "",
               "Taipei Time",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd Standard Time",
               "",
               "Hovd Summer Time",
               "",
               "Hovd Time",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan Standard Time",
               "",
               "Magadan Summer Time",
               "",
               "Magadan Time",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australian Central Western Standard Time",
               "",
               "Australian Central Western Daylight Time",
               "",
               "Australian Central Western Time",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Central European Standard Time",
               "",
               "Central European Summer Time",
               "",
               "Central European Time",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin Standard Time",
               "",
               "Sakhalin Summer Time",
               "",
               "Sakhalin Time",
               "",
            };
        final String[] Paraguay = new String[] {
               "Paraguay Standard Time",
               "",
               "Paraguay Summer Time",
               "",
               "Paraguay Time",
               "",
            };
        final String[] Acre = new String[] {
               "Acre Standard Time",
               "",
               "Acre Summer Time",
               "",
               "Acre Time",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaysia Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Coordinated Universal Time",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Eastern Standard Time",
               "EST",
               "Eastern Daylight Time",
               "EDT",
               "Eastern Time",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe Standard Time",
               "",
               "Lord Howe Daylight Time",
               "",
               "Lord Howe Time",
               "",
            };
        final String[] New_Zealand = new String[] {
               "New Zealand Standard Time",
               "",
               "New Zealand Daylight Time",
               "",
               "New Zealand Time",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indian Ocean Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk Standard Time",
               "",
               "Yakutsk Summer Time",
               "",
               "Yakutsk Time",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritius Standard Time",
               "",
               "Mauritius Summer Time",
               "",
               "Mauritius Time",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "East Africa Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "East Timor Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Solomon Islands Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Kosrae Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall Islands Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Eastern European Standard Time",
               "",
               "Eastern European Summer Time",
               "",
               "Eastern European Time",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland Standard Time",
               "",
               "Newfoundland Daylight Time",
               "",
               "Newfoundland Time",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong Standard Time",
               "",
               "Hong Kong Summer Time",
               "",
               "Hong Kong Time",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "Western Argentina Standard Time",
               "",
               "Western Argentina Summer Time",
               "",
               "Western Argentina Time",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantic Standard Time",
               "AST",
               "Atlantic Daylight Time",
               "ADT",
               "Atlantic Time",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponape Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivia Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St. Pierre & Miquelon Standard Time",
               "",
               "St. Pierre & Miquelon Daylight Time",
               "",
               "St. Pierre & Miquelon Time",
               "",
            };
        final String[] Indochina = new String[] {
               "Indochina Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburg Standard Time",
               "",
               "Yekaterinburg Summer Time",
               "",
               "Yekaterinburg Time",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldives Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israel Standard Time",
               "",
               "Israel Daylight Time",
               "",
               "Israel Time",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Central Indonesia Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis & Futuna Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "South Africa Standard Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Syowa Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Line Islands Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistan Standard Time",
               "",
               "Uzbekistan Summer Time",
               "",
               "Uzbekistan Time",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk Standard Time",
               "",
               "Omsk Summer Time",
               "",
               "Omsk Time",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelles Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguay Standard Time",
               "",
               "Uruguay Summer Time",
               "",
               "Uruguay Time",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepal Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar Standard Time",
               "",
               "Ulaanbaatar Summer Time",
               "",
               "Ulaanbaatar Time",
               "",
            };
        final String[] America_Central = new String[] {
               "Central Standard Time",
               "CST",
               "Central Daylight Time",
               "CDT",
               "Central Time",
               "CT",
            };
        final String[] Truk = new String[] {
               "Chuuk Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Niue = new String[] {
               "Niue Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake Island Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Falkland Islands Standard Time",
               "",
               "Falkland Islands Summer Time",
               "",
               "Falkland Islands Time",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu Standard Time",
               "",
               "Vanuatu Summer Time",
               "",
               "Vanuatu Time",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk Standard Time",
               "",
               "Novosibirsk Summer Time",
               "",
               "Novosibirsk Time",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapore Standard Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Azores Standard Time",
               "",
               "Azores Summer Time",
               "",
               "Azores Time",
               "",
            };
        final String[] Apia = new String[] {
               "Apia Standard Time",
               "",
               "Apia Daylight Time",
               "",
               "Apia Time",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutan Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Nauru Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk Standard Time",
               "",
               "Krasnoyarsk Summer Time",
               "",
               "Krasnoyarsk Time",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "West Kazakhstan Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmar Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Christmas Island Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Amazon Standard Time",
               "",
               "Amazon Summer Time",
               "",
               "Amazon Time",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "East Kazakhstan Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Fiji Standard Time",
               "",
               "Fiji Summer Time",
               "",
               "Fiji Time",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Cocos Islands Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham Standard Time",
               "",
               "Chatham Daylight Time",
               "",
               "Chatham Time",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentina Standard Time",
               "",
               "Argentina Summer Time",
               "",
               "Argentina Time",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kamchatski Standard Time",
               "",
               "Petropavlovsk-Kamchatski Summer Time",
               "",
               "Petropavlovsk-Kamchatski Time",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Macquarie Island Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleutian Standard Time",
               "HAST",
               "Hawaii-Aleutian Daylight Time",
               "HADT",
               "Hawaii-Aleutian Time",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Australian Central Standard Time",
               "",
               "Australian Central Daylight Time",
               "",
               "Central Australia Time",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Pacific Standard Time",
               "PST",
               "Pacific Daylight Time",
               "PDT",
               "Pacific Time",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenix Islands Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan Standard Time",
               "",
               "Turkmenistan Summer Time",
               "",
               "Turkmenistan Time",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Western European Standard Time",
               "",
               "Western European Summer Time",
               "",
               "Western European Time",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Cape Verde Standard Time",
               "",
               "Cape Verde Summer Time",
               "",
               "Cape Verde Time",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolk Island Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyana Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa Standard Time",
               "",
               "Samoa Daylight Time",
               "",
               "Samoa Time",
               "",
            };
        final String[] Palau = new String[] {
               "Palau Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaijan Standard Time",
               "",
               "Azerbaijan Summer Time",
               "",
               "Azerbaijan Time",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexican Pacific Standard Time",
               "",
               "Mexican Pacific Daylight Time",
               "",
               "Mexican Pacific Time",
               "",
            };
        final String[] Davis = new String[] {
               "Davis Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Cuba Standard Time",
               "",
               "Cuba Daylight Time",
               "",
               "Cuba Time",
               "",
            };
        final String[] Africa_Western = new String[] {
               "West Africa Standard Time",
               "",
               "West Africa Summer Time",
               "",
               "West Africa Time",
               "",
            };
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "GMT",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Philippine Standard Time",
               "",
               "Philippine Summer Time",
               "",
               "Philippine Time",
               "",
            };
        final String[] French_Southern = new String[] {
               "French Southern & Antarctic Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] South_Georgia = new String[] {
               "South Georgia Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "New Caledonia Standard Time",
               "",
               "New Caledonia Summer Time",
               "",
               "New Caledonia Time",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgograd Standard Time",
               "",
               "Volgograd Summer Time",
               "",
               "Volgograd Time",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Iran Standard Time",
               "",
               "Iran Daylight Time",
               "",
               "Iran Time",
               "",
            };
        final String[] Easter = new String[] {
               "Easter Island Standard Time",
               "",
               "Easter Island Summer Time",
               "",
               "Easter Island Time",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Northwest Mexico Standard Time",
               "",
               "Northwest Mexico Daylight Time",
               "",
               "Northwest Mexico Time",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tajikistan Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga Standard Time",
               "",
               "Tonga Summer Time",
               "",
               "Tonga Time",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesh Standard Time",
               "",
               "Bangladesh Summer Time",
               "",
               "Bangladesh Time",
               "",
            };
        final String[] Peru = new String[] {
               "Peru Standard Time",
               "",
               "Peru Summer Time",
               "",
               "Peru Time",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "West Greenland Standard Time",
               "",
               "West Greenland Summer Time",
               "",
               "West Greenland Time",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuador Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "East Greenland Standard Time",
               "",
               "East Greenland Summer Time",
               "",
               "East Greenland Time",
               "",
            };
        final String[] Gulf = new String[] {
               "Gulf Standard Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eastern Indonesia Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Korean Standard Time",
               "",
               "Korean Daylight Time",
               "",
               "Korean Time",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Australian Western Standard Time",
               "",
               "Australian Western Daylight Time",
               "",
               "Western Australia Time",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kyrgyzstan Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Western Indonesia Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Australian Eastern Standard Time",
               "",
               "Australian Eastern Daylight Time",
               "",
               "Eastern Australia Time",
               "",
            };
        final String[] French_Guiana = new String[] {
               "French Guiana Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Colombia Standard Time",
               "",
               "Colombia Summer Time",
               "",
               "Colombia Time",
               "",
            };
        final String[] Chile = new String[] {
               "Chile Standard Time",
               "",
               "Chile Summer Time",
               "",
               "Chile Time",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert Islands Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Mountain Standard Time",
               "MST",
               "Mountain Daylight Time",
               "MDT",
               "Mountain Time",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Marquesas Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabian Standard Time",
               "",
               "Arabian Daylight Time",
               "",
               "Arabian Time",
               "",
            };
        final String[] Alaska = new String[] {
               "Alaska Standard Time",
               "AKST",
               "Alaska Daylight Time",
               "AKDT",
               "Alaska Time",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok Standard Time",
               "",
               "Vladivostok Summer Time",
               "",
               "Vladivostok Time",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro Standard Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk Standard Time",
               "",
               "Irkutsk Summer Time",
               "",
               "Irkutsk Time",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgia Standard Time",
               "",
               "Georgia Summer Time",
               "",
               "Georgia Time",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua New Guinea Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha Standard Time",
               "",
               "Fernando de Noronha Summer Time",
               "",
               "Fernando de Noronha Time",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsan Standard Time",
               "",
               "Choibalsan Summer Time",
               "",
               "Choibalsan Time",
               "",
            };
        final String[] Brasilia = new String[] {
               "Brasilia Standard Time",
               "",
               "Brasilia Summer Time",
               "",
               "Brasilia Time",
               "",
            };
        final String[] China = new String[] {
               "China Standard Time",
               "",
               "China Daylight Time",
               "",
               "China Time",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenia Standard Time",
               "",
               "Armenia Summer Time",
               "",
               "Armenia Time",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyr Standard Time",
               "",
               "Anadyr Summer Time",
               "",
               "Anadyr Time",
               "",
            };
        final String[] Samara = new String[] {
               "Samara Standard Time",
               "",
               "Samara Summer Time",
               "",
               "Samara Time",
               "",
            };
        final String[] India = new String[] {
               "India Standard Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Cook Islands Standard Time",
               "",
               "Cook Islands Half Summer Time",
               "",
               "Cook Islands Time",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Hawaii-Aleutian Standard Time",
                    "HST",
                    "Hawaii-Aleutian Daylight Time",
                    "HDT",
                    "Hawaii-Aleutian Time",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "British Summer Time",
                    "",
                    "",
                    "",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "JST", Japan },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "BET", Brasilia },
            { "America/Araguaina", Brasilia },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Etc/GMT", GMT },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "CNT", Newfoundland },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "NET", Armenia },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Etc/Unknown", "Unknown City" },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.Europe/Uzhgorod", "Uzhhorod" },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "SystemV/MST7", America_Mountain },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Ho Chi Minh City" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "CST", America_Central },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Irish Standard Time",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "SystemV/CST6", America_Central },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "SystemV/YST9", Gambier },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10",
                new String[] {
                    "Hawaii-Aleutian Standard Time",
                    "HST",
                    "Hawaii-Aleutian Daylight Time",
                    "HDT",
                    "Hawaii-Aleutian Time",
                    "HST",
                }
            },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "British Summer Time",
                    "",
                    "",
                    "",
                }
            },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "timezone.excity.America/St_Barthelemy", "St. Barth\u00e9lemy" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "NST", New_Zealand },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Johannesburg", Africa_Southern },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "ECT", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "SystemV/PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Anadyr },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "SystemV/AST4ADT", Atlantic },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
