#import "FilteringArrayController.h"
#import <Foundation/NSKeyValueObserving.h>


@implementation FilteringArrayController


- (void)search:(id)sender
{
    [self setSearchString:[sender stringValue]];
    [self rearrangeObjects];    
}

- (void)searchForString:(NSString *)text
{
	[searchField setStringValue:text];
    [self setSearchString:text];
    [self rearrangeObjects];    
}

- (NSArray *)arrangeObjects:(NSArray *)objects
{
	
    if ((searchString == nil) ||
		([searchString isEqualToString:@""]))
	{
		return [super arrangeObjects:objects];   
	}
	
	/*
	 Create array of objects that match search string.
	 Also add any newly-created object unconditionally:
	 (a) You'll get an error if a newly-added object isn't added to
	 arrangedObjects.
	 (b) The user will see newly-added objects even if they don't
	 match the search term.
	 */
	
    NSMutableArray *matchedObjects = [NSMutableArray arrayWithCapacity:[objects count]];
    // case-insensitive search
    NSString *lowerSearch = [searchString lowercaseString];
    
	NSEnumerator *oEnum = [objects objectEnumerator];
    id item;	
    while (item = [oEnum nextObject])
	{
		// Use of local autorelease pool here is probably overkill,
		// but may be useful in a larger-scale application.
		NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
		NSString *lowerName = [[item valueForKeyPath:@"acronym"] lowercaseString];
		if ([lowerName rangeOfString:lowerSearch].location != NSNotFound)
		{
			[matchedObjects addObject:item];
		}
		else
		{
			lowerName = [[item valueForKeyPath:@"translation"] lowercaseString];
			if ([lowerName rangeOfString:lowerSearch].location != NSNotFound)
			{
				[matchedObjects addObject:item];
			}
		}
		[pool release];
		
    }
    return [super arrangeObjects:matchedObjects];
}


//  - dealloc:
- (void)dealloc
{
    [self setSearchString: nil];    
    [super dealloc];
}


// - searchString:
- (NSString *)searchString
{
	return searchString;
}
// - setSearchString:
- (void)setSearchString:(NSString *)newSearchString
{
    if (searchString != newSearchString)
	{
        [searchString autorelease];
        searchString = [newSearchString copy];
    }
}


@end
