/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "eu" locale.
 */
public class LocalizedNamesImpl_eu extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "CF",
        "AI",
        "AX",
        "AL",
        "DE",
        "DZ",
        "US",
        "UM",
        "AD",
        "AO",
        "AQ",
        "AG",
        "AE",
        "AR",
        "AM",
        "AW",
        "AC",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BY",
        "VI",
        "VG",
        "CI",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "CV",
        "EA",
        "CX",
        "CP",
        "CC",
        "CK",
        "CR",
        "CW",
        "DK",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EG",
        "TL",
        "EC",
        "GQ",
        "SV",
        "ER",
        "GB",
        "RO",
        "RU",
        "SK",
        "SI",
        "ES",
        "EE",
        "ET",
        "EZ",
        "EU",
        "FK",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GN",
        "GW",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GY",
        "GF",
        "HT",
        "HM",
        "ZA",
        "GS",
        "TF",
        "KR",
        "SS",
        "NL",
        "HN",
        "HK",
        "HU",
        "IN",
        "IO",
        "ID",
        "KP",
        "MP",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "KY",
        "NC",
        "CM",
        "CA",
        "IC",
        "KH",
        "BQ",
        "KZ",
        "KE",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "HR",
        "CU",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "IM",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MK",
        "EH",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "QO",
        "MM",
        "NA",
        "NR",
        "UN",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NF",
        "NO",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PT",
        "PR",
        "QA",
        "RE",
        "RW",
        "BL",
        "KN",
        "PM",
        "VC",
        "SB",
        "WS",
        "AS",
        "SM",
        "MF",
        "SH",
        "LC",
        "ST",
        "SA",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "SY",
        "SO",
        "LK",
        "SD",
        "SE",
        "CH",
        "SR",
        "SJ",
        "SZ",
        "TW",
        "TJ",
        "TZ",
        "TH",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TC",
        "TR",
        "TM",
        "TV",
        "TD",
        "CZ",
        "CL",
        "CN",
        "UG",
        "UA",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "XA",
        "XB",
        "YE",
        "ZM",
        "NZ",
        "ZW",
        "CY",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mundua");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Ipar Amerika");
    namesMap.put("005", "Hego Amerika");
    namesMap.put("009", "Ozeania");
    namesMap.put("011", "Afrika mendebaldea");
    namesMap.put("013", "Erdialdeko Amerika");
    namesMap.put("014", "Afrika ekialdea");
    namesMap.put("015", "Afrika iparraldea");
    namesMap.put("017", "Erdialdeko Afrika");
    namesMap.put("018", "Afrika hegoaldea");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Amerikako iparraldea");
    namesMap.put("029", "Karibea");
    namesMap.put("030", "Asia ekialdea");
    namesMap.put("034", "Asia hegoaldea");
    namesMap.put("035", "Asiako hego-ekialdea");
    namesMap.put("039", "Europa hegoaldea");
    namesMap.put("057", "Mikronesia eskualdea");
    namesMap.put("061", "Polinesia");
    namesMap.put("143", "Asia erdialdea");
    namesMap.put("145", "Asia mendebaldea");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa ekialdea");
    namesMap.put("154", "Europa iparraldea");
    namesMap.put("155", "Europa mendebaldea");
    namesMap.put("202", "Saharaz hegoaldeko Afrika");
    namesMap.put("419", "Latinoamerika");
    namesMap.put("AC", "Ascension uhartea");
    namesMap.put("AE", "Arabiar Emirerri Batuak");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua eta Barbuda");
    namesMap.put("AI", "Aingira");
    namesMap.put("AQ", "Antartika");
    namesMap.put("AS", "Samoa Estatubatuarra");
    namesMap.put("AX", "Åland");
    namesMap.put("BA", "Bosnia-Herzegovina");
    namesMap.put("BE", "Belgika");
    namesMap.put("BL", "Saint Barthélemy");
    namesMap.put("BQ", "Karibeko Herbehereak");
    namesMap.put("BR", "Brasil");
    namesMap.put("BS", "Bahamak");
    namesMap.put("BV", "Bouvet uhartea");
    namesMap.put("BY", "Bielorrusia");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Cocos (Keeling) uharteak");
    namesMap.put("CD", "Kongoko Errepublika Demokratikoa");
    namesMap.put("CF", "Afrika Erdiko Errepublika");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Suitza");
    namesMap.put("CI", "Boli Kosta");
    namesMap.put("CK", "Cook uharteak");
    namesMap.put("CL", "Txile");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Txina");
    namesMap.put("CO", "Kolonbia");
    namesMap.put("CP", "Clipperton uhartea");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Cabo Verde");
    namesMap.put("CX", "Christmas uhartea");
    namesMap.put("CY", "Zipre");
    namesMap.put("CZ", "Txekia");
    namesMap.put("DE", "Alemania");
    namesMap.put("DG", "Diego García");
    namesMap.put("DJ", "Djibuti");
    namesMap.put("DK", "Danimarka");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikar Errepublika");
    namesMap.put("DZ", "Aljeria");
    namesMap.put("EA", "Ceuta eta Melilla");
    namesMap.put("EC", "Ekuador");
    namesMap.put("EG", "Egipto");
    namesMap.put("EH", "Mendebaldeko Sahara");
    namesMap.put("ES", "Espainia");
    namesMap.put("ET", "Etiopia");
    namesMap.put("EU", "Europar Batasuna");
    namesMap.put("EZ", "Eurogunea");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FK", "Falklandak");
    namesMap.put("FM", "Mikronesia");
    namesMap.put("FO", "Faroe uharteak");
    namesMap.put("FR", "Frantzia");
    namesMap.put("GB", "Erresuma Batua");
    namesMap.put("GF", "Guyana Frantsesa");
    namesMap.put("GG", "Guernesey");
    namesMap.put("GL", "Groenlandia");
    namesMap.put("GN", "Ginea");
    namesMap.put("GP", "Guadalupe");
    namesMap.put("GQ", "Ekuatore Ginea");
    namesMap.put("GR", "Grezia");
    namesMap.put("GS", "Hegoaldeko Georgia eta Hegoaldeko Sandwich uharteak");
    namesMap.put("GW", "Ginea Bissau");
    namesMap.put("HK", "Hong Kong Txinako AEB");
    namesMap.put("HM", "Heard eta McDonald uharteak");
    namesMap.put("HR", "Kroazia");
    namesMap.put("HU", "Hungaria");
    namesMap.put("IC", "Kanariak");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IM", "Man uhartea");
    namesMap.put("IO", "Indiako Ozeanoko lurralde britainiarra");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Islandia");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Jordania");
    namesMap.put("JP", "Japonia");
    namesMap.put("KG", "Kirgizistan");
    namesMap.put("KH", "Kanbodia");
    namesMap.put("KM", "Komoreak");
    namesMap.put("KN", "Saint Kitts eta Nevis");
    namesMap.put("KP", "Ipar Korea");
    namesMap.put("KR", "Hego Korea");
    namesMap.put("KY", "Kaiman uharteak");
    namesMap.put("LB", "Libano");
    namesMap.put("LC", "Santa Luzia");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Luxenburgo");
    namesMap.put("LV", "Letonia");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Moldavia");
    namesMap.put("MF", "San Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshall Uharteak");
    namesMap.put("MK", "Mazedonia");
    namesMap.put("MM", "Myanmar (Birmania)");
    namesMap.put("MO", "Macau Txinako AEB");
    namesMap.put("MP", "Ipar Mariana uharteak");
    namesMap.put("MQ", "Martinika");
    namesMap.put("MU", "Maurizio");
    namesMap.put("MV", "Maldivak");
    namesMap.put("MX", "Mexiko");
    namesMap.put("MZ", "Mozambike");
    namesMap.put("NC", "Kaledonia Berria");
    namesMap.put("NF", "Norfolk uhartea");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Herbehereak");
    namesMap.put("NO", "Norvegia");
    namesMap.put("NZ", "Zeelanda Berria");
    namesMap.put("PF", "Polinesia Frantsesa");
    namesMap.put("PG", "Papua Ginea Berria");
    namesMap.put("PH", "Filipinak");
    namesMap.put("PL", "Polonia");
    namesMap.put("PM", "Saint-Pierre eta Mikelune");
    namesMap.put("PN", "Pitcairn uharteak");
    namesMap.put("PS", "Palestinar Lurralde Okupatuak");
    namesMap.put("PY", "Paraguai");
    namesMap.put("QO", "Mugaz kanpoko Ozeania");
    namesMap.put("RE", "Reunion");
    namesMap.put("RO", "Errumania");
    namesMap.put("RU", "Errusia");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SB", "Salomon Uharteak");
    namesMap.put("SC", "Seychelleak");
    namesMap.put("SE", "Suedia");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Santa Helena");
    namesMap.put("SI", "Eslovenia");
    namesMap.put("SJ", "Svalbard eta Jan Mayen uharteak");
    namesMap.put("SK", "Eslovakia");
    namesMap.put("SL", "Sierra Leona");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Hego Sudan");
    namesMap.put("ST", "Sao Tome eta Principe");
    namesMap.put("SY", "Siria");
    namesMap.put("SZ", "Swazilandia");
    namesMap.put("TC", "Turk eta Caico uharteak");
    namesMap.put("TD", "Txad");
    namesMap.put("TF", "Hegoaldeko lurralde frantsesak");
    namesMap.put("TH", "Thailandia");
    namesMap.put("TL", "Ekialdeko Timor");
    namesMap.put("TR", "Turkia");
    namesMap.put("TT", "Trinidad eta Tobago");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "Ameriketako Estatu Batuetako Kanpoaldeko Uharte Txikiak");
    namesMap.put("UN", "Nazio Batuak");
    namesMap.put("US", "Ameriketako Estatu Batuak");
    namesMap.put("UY", "Uruguai");
    namesMap.put("VA", "Vatikano Hiria");
    namesMap.put("VC", "Saint Vincent eta Grenadinak");
    namesMap.put("VG", "Birjina uharte britainiarrak");
    namesMap.put("VI", "Birjina uharte amerikarrak");
    namesMap.put("WF", "Wallis eta Futuna");
    namesMap.put("ZA", "Hegoafrika");
    namesMap.put("ZZ", "Eskualde ezezaguna");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mundua",
        "002": "Afrika",
        "003": "Ipar Amerika",
        "005": "Hego Amerika",
        "009": "Ozeania",
        "011": "Afrika mendebaldea",
        "013": "Erdialdeko Amerika",
        "014": "Afrika ekialdea",
        "015": "Afrika iparraldea",
        "017": "Erdialdeko Afrika",
        "018": "Afrika hegoaldea",
        "019": "Amerika",
        "021": "Amerikako iparraldea",
        "029": "Karibea",
        "030": "Asia ekialdea",
        "034": "Asia hegoaldea",
        "035": "Asiako hego-ekialdea",
        "039": "Europa hegoaldea",
        "057": "Mikronesia eskualdea",
        "061": "Polinesia",
        "143": "Asia erdialdea",
        "145": "Asia mendebaldea",
        "150": "Europa",
        "151": "Europa ekialdea",
        "154": "Europa iparraldea",
        "155": "Europa mendebaldea",
        "202": "Saharaz hegoaldeko Afrika",
        "419": "Latinoamerika",
        "AC": "Ascension uhartea",
        "AE": "Arabiar Emirerri Batuak",
        "AF": "Afganistan",
        "AG": "Antigua eta Barbuda",
        "AI": "Aingira",
        "AQ": "Antartika",
        "AS": "Samoa Estatubatuarra",
        "AX": "Åland",
        "BA": "Bosnia-Herzegovina",
        "BE": "Belgika",
        "BL": "Saint Barthélemy",
        "BQ": "Karibeko Herbehereak",
        "BR": "Brasil",
        "BS": "Bahamak",
        "BV": "Bouvet uhartea",
        "BY": "Bielorrusia",
        "CA": "Kanada",
        "CC": "Cocos (Keeling) uharteak",
        "CD": "Kongoko Errepublika Demokratikoa",
        "CF": "Afrika Erdiko Errepublika",
        "CG": "Kongo",
        "CH": "Suitza",
        "CI": "Boli Kosta",
        "CK": "Cook uharteak",
        "CL": "Txile",
        "CM": "Kamerun",
        "CN": "Txina",
        "CO": "Kolonbia",
        "CP": "Clipperton uhartea",
        "CU": "Kuba",
        "CV": "Cabo Verde",
        "CX": "Christmas uhartea",
        "CY": "Zipre",
        "CZ": "Txekia",
        "DE": "Alemania",
        "DG": "Diego García",
        "DJ": "Djibuti",
        "DK": "Danimarka",
        "DM": "Dominika",
        "DO": "Dominikar Errepublika",
        "DZ": "Aljeria",
        "EA": "Ceuta eta Melilla",
        "EC": "Ekuador",
        "EG": "Egipto",
        "EH": "Mendebaldeko Sahara",
        "ES": "Espainia",
        "ET": "Etiopia",
        "EU": "Europar Batasuna",
        "EZ": "Eurogunea",
        "FI": "Finlandia",
        "FK": "Falklandak",
        "FM": "Mikronesia",
        "FO": "Faroe uharteak",
        "FR": "Frantzia",
        "GB": "Erresuma Batua",
        "GF": "Guyana Frantsesa",
        "GG": "Guernesey",
        "GL": "Groenlandia",
        "GN": "Ginea",
        "GP": "Guadalupe",
        "GQ": "Ekuatore Ginea",
        "GR": "Grezia",
        "GS": "Hegoaldeko Georgia eta Hegoaldeko Sandwich uharteak",
        "GW": "Ginea Bissau",
        "HK": "Hong Kong Txinako AEB",
        "HM": "Heard eta McDonald uharteak",
        "HR": "Kroazia",
        "HU": "Hungaria",
        "IC": "Kanariak",
        "IE": "Irlanda",
        "IM": "Man uhartea",
        "IO": "Indiako Ozeanoko lurralde britainiarra",
        "IQ": "Irak",
        "IS": "Islandia",
        "IT": "Italia",
        "JM": "Jamaika",
        "JO": "Jordania",
        "JP": "Japonia",
        "KG": "Kirgizistan",
        "KH": "Kanbodia",
        "KM": "Komoreak",
        "KN": "Saint Kitts eta Nevis",
        "KP": "Ipar Korea",
        "KR": "Hego Korea",
        "KY": "Kaiman uharteak",
        "LB": "Libano",
        "LC": "Santa Luzia",
        "LT": "Lituania",
        "LU": "Luxenburgo",
        "LV": "Letonia",
        "LY": "Libia",
        "MA": "Maroko",
        "MC": "Monako",
        "MD": "Moldavia",
        "MF": "San Martin",
        "MG": "Madagaskar",
        "MH": "Marshall Uharteak",
        "MK": "Mazedonia",
        "MM": "Myanmar (Birmania)",
        "MO": "Macau Txinako AEB",
        "MP": "Ipar Mariana uharteak",
        "MQ": "Martinika",
        "MU": "Maurizio",
        "MV": "Maldivak",
        "MX": "Mexiko",
        "MZ": "Mozambike",
        "NC": "Kaledonia Berria",
        "NF": "Norfolk uhartea",
        "NI": "Nikaragua",
        "NL": "Herbehereak",
        "NO": "Norvegia",
        "NZ": "Zeelanda Berria",
        "PF": "Polinesia Frantsesa",
        "PG": "Papua Ginea Berria",
        "PH": "Filipinak",
        "PL": "Polonia",
        "PM": "Saint-Pierre eta Mikelune",
        "PN": "Pitcairn uharteak",
        "PS": "Palestinar Lurralde Okupatuak",
        "PY": "Paraguai",
        "QO": "Mugaz kanpoko Ozeania",
        "RE": "Reunion",
        "RO": "Errumania",
        "RU": "Errusia",
        "RW": "Ruanda",
        "SB": "Salomon Uharteak",
        "SC": "Seychelleak",
        "SE": "Suedia",
        "SG": "Singapur",
        "SH": "Santa Helena",
        "SI": "Eslovenia",
        "SJ": "Svalbard eta Jan Mayen uharteak",
        "SK": "Eslovakia",
        "SL": "Sierra Leona",
        "SR": "Surinam",
        "SS": "Hego Sudan",
        "ST": "Sao Tome eta Principe",
        "SY": "Siria",
        "SZ": "Swazilandia",
        "TC": "Turk eta Caico uharteak",
        "TD": "Txad",
        "TF": "Hegoaldeko lurralde frantsesak",
        "TH": "Thailandia",
        "TL": "Ekialdeko Timor",
        "TR": "Turkia",
        "TT": "Trinidad eta Tobago",
        "UA": "Ukraina",
        "UM": "Ameriketako Estatu Batuetako Kanpoaldeko Uharte Txikiak",
        "UN": "Nazio Batuak",
        "US": "Ameriketako Estatu Batuak",
        "UY": "Uruguai",
        "VA": "Vatikano Hiria",
        "VC": "Saint Vincent eta Grenadinak",
        "VG": "Birjina uharte britainiarrak",
        "VI": "Birjina uharte amerikarrak",
        "WF": "Wallis eta Futuna",
        "ZA": "Hegoafrika",
        "ZZ": "Eskualde ezezaguna"
    };
  }-*/;
}
