/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CollectionFactory;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class Iterables {
    private Iterables() {
    }

    public static <K, V> Iterable<V> transform(final Iterable<K> iterable, final Function<? super K, ? extends V> function) {
        return () -> new Iterator<V>(){
            Iterator inner;
            {
                this.inner = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.inner.hasNext();
            }

            @Override
            public V next() {
                return function.apply(this.inner.next());
            }

            @Override
            public void remove() {
                this.inner.remove();
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> iterable, final Predicate<T> accept) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<T> inner;
                    boolean queued;
                    T next;
                    {
                        this.inner = iterable.iterator();
                        this.queued = false;
                        this.next = null;
                    }

                    @Override
                    public boolean hasNext() {
                        this.prepare();
                        return this.queued;
                    }

                    @Override
                    public T next() {
                        this.prepare();
                        if (!this.queued) {
                            throw new RuntimeException("Filter .next() called with no next");
                        }
                        Object rv = this.next;
                        this.next = null;
                        this.queued = false;
                        return rv;
                    }

                    public void prepare() {
                        if (this.queued) {
                            return;
                        }
                        while (this.inner.hasNext()) {
                            Object next = this.inner.next();
                            if (!accept.test(next)) continue;
                            this.next = next;
                            this.queued = true;
                            return;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> cast(final Iterable<?> iterable, final Class<? extends T> type) {
        return () -> new Iterator<T>(){
            Iterator inner;
            {
                this.inner = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.inner.hasNext();
            }

            @Override
            public T next() {
                return type.cast(this.inner.next());
            }

            @Override
            public void remove() {
                this.inner.remove();
            }
        };
    }

    public static <T> Iterable<T> take(T[] array, int max) {
        return Iterables.take(Arrays.asList(array), max);
    }

    public static <T> Iterable<T> take(final Iterable<T> iterable, final int max) {
        return new Iterable<T>(){
            final Iterator<T> iterator;
            {
                this.iterator = iterable.iterator();
            }

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < max && iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        ++this.i;
                        return iterator.next();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> drop(T[] array, int toDrop) {
        return Iterables.drop(Arrays.asList(array), toDrop);
    }

    public static <T> Iterable<T> drop(final Iterable<T> iterable, final int toDrop) {
        return new Iterable<T>(){
            final Iterator<T> iterator;
            {
                this.iterator = iterable.iterator();
            }

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int skipped = 0;

                    @Override
                    public boolean hasNext() {
                        while (this.skipped < toDrop && iterator.hasNext()) {
                            iterator.next();
                            ++this.skipped;
                        }
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        while (this.skipped < toDrop && iterator.hasNext()) {
                            iterator.next();
                            ++this.skipped;
                        }
                        return iterator.next();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    public static <T, U> Iterable<U> flatMap(Iterable<? extends Iterable<T>> iterables, Function<? super T, U> trans) {
        return Iterables.transform(Iterables.chain(iterables), trans);
    }

    public static <T> Iterable<T> chain(final Iterable<? extends Iterable<T>> iterables) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterators = iterables.iterator();
                return new Iterator<T>(){
                    private Iterator<T> current = null;

                    @Override
                    public boolean hasNext() {
                        while (this.current == null || !this.current.hasNext()) {
                            if (iterators.hasNext()) {
                                this.current = ((Iterable)iterators.next()).iterator();
                                continue;
                            }
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public T next() {
                        return this.current.next();
                    }

                    @Override
                    public void remove() {
                        this.current.remove();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> chain(Iterable<T> ... iterables) {
        return Iterables.chain(Arrays.asList(iterables));
    }

    public static <T> Iterable<T> chain(T[] ... arrays) {
        LinkedList<List<T>> iterables = new LinkedList<List<T>>();
        for (T[] array : arrays) {
            iterables.add(Arrays.asList(array));
        }
        return Iterables.chain(iterables);
    }

    public static <T1, T2> Iterable<Pair<T1, T2>> zip(Iterable<T1> iter1, Iterable<T2> iter2) {
        return () -> Iterables.zip(iter1.iterator(), iter2.iterator());
    }

    public static <T1, T2> Iterable<Pair<T1, T2>> zip(Iterable<T1> iter, T2[] array) {
        return Iterables.zip(iter, Arrays.asList(array));
    }

    public static <T1, T2> Iterable<Pair<T1, T2>> zip(T1[] array, Iterable<T2> iter) {
        return Iterables.zip(Arrays.asList(array), iter);
    }

    public static <T1, T2> Iterable<Pair<T1, T2>> zip(T1[] array1, T2[] array2) {
        return Iterables.zip(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static <T1, T2> Iterator<Pair<T1, T2>> zip(final Iterator<T1> iter1, final Iterator<T2> iter2) {
        return new Iterator<Pair<T1, T2>>(){

            @Override
            public boolean hasNext() {
                return iter1.hasNext() && iter2.hasNext();
            }

            @Override
            public Pair<T1, T2> next() {
                return new Pair(iter1.next(), iter2.next());
            }

            @Override
            public void remove() {
                iter1.remove();
                iter2.remove();
            }
        };
    }

    public static <V1, V2> Iterable<Pair<V1, V2>> merge(final Iterable<V1> iter1, final Iterable<V2> iter2, final IncrementComparator<V1, V2> comparator) {
        return new Iterable<Pair<V1, V2>>(){
            Iterator<V1> iterA;
            Iterator<V2> iterB;
            {
                this.iterA = iter1.iterator();
                this.iterB = iter2.iterator();
            }

            @Override
            public Iterator<Pair<V1, V2>> iterator() {
                return new Iterator<Pair<V1, V2>>(){
                    boolean ready = false;
                    Pair<V1, V2> pending = null;

                    @Override
                    public boolean hasNext() {
                        if (!this.ready) {
                            this.pending = this.nextPair();
                            this.ready = true;
                        }
                        return this.pending != null;
                    }

                    @Override
                    public Pair<V1, V2> next() {
                        if (!this.ready && !this.hasNext()) {
                            throw new IllegalAccessError("Called next without hasNext");
                        }
                        this.ready = false;
                        return this.pending;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove pairs from a merged iterator");
                    }

                    private Pair<V1, V2> nextPair() {
                        Object nextA = null;
                        Object nextB = null;
                        while (iterA.hasNext() && iterB.hasNext()) {
                            int cmp;
                            if (nextA == null) {
                                nextA = iterA.next();
                            }
                            if (nextB == null) {
                                nextB = iterB.next();
                            }
                            if ((cmp = comparator.compare(nextA, nextB)) < 0) {
                                nextA = null;
                                continue;
                            }
                            if (cmp > 0) {
                                nextB = null;
                                continue;
                            }
                            return new Pair<Object, Object>(nextA, nextB);
                        }
                        return null;
                    }
                };
            }
        };
    }

    public static <V> Iterable<Pair<V, V>> merge(Iterable<V> iter1, Iterable<V> iter2, Comparator<V> comparator) {
        IncrementComparator<Object, Object> inc = (a, b) -> comparator.compare(a, b);
        return Iterables.merge(iter1, iter2, inc);
    }

    public static <V1, V2, V3> Iterable<Triple<V1, V2, V3>> merge(Iterable<V1> iter1, Iterable<V2> iter2, Iterable<V3> iter3, IncrementComparator<V1, V2> comparatorA, final IncrementComparator<V1, V3> comparatorB) {
        Iterable<Pair<V1, V2>> partial = Iterables.merge(iter1, iter2, comparatorA);
        IncrementComparator inc = new IncrementComparator<Pair<V1, V2>, V3>(){

            @Override
            public int compare(Pair<V1, V2> a, V3 b) {
                return comparatorB.compare(a.first, b);
            }
        };
        Function<Pair, Triple> flatten = in -> new Triple(((Pair)in.first).first, ((Pair)in.first).second, in.second);
        return Iterables.transform(Iterables.merge(partial, iter3, inc), flatten);
    }

    public static <V> Iterable<Triple<V, V, V>> merge(Iterable<V> iter1, Iterable<V> iter2, Iterable<V> iter3, Comparator<V> comparator) {
        IncrementComparator<Object, Object> inc = (a, b) -> comparator.compare(a, b);
        return Iterables.merge(iter1, iter2, iter3, inc, inc);
    }

    public static <V> Iterable<Iterable<V>> group(final Iterable<V> iterable, final Comparator<V> comparator) {
        return new Iterable<Iterable<V>>(){

            @Override
            public Iterator<Iterable<V>> iterator() {
                return new Iterator<Iterable<V>>(){
                    Iterator<V> it;
                    V next;
                    {
                        this.it = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null || this.it.hasNext();
                    }

                    @Override
                    public Iterable<V> next() {
                        return () -> new Iterator<V>(){
                            Object last = null;

                            @Override
                            public boolean hasNext() {
                                if (next == null && it.hasNext()) {
                                    next = it.next();
                                }
                                if (this.last != null && next != null) {
                                    return comparator.compare(this.last, next) == 0;
                                }
                                return next != null;
                            }

                            @Override
                            public V next() {
                                if (!this.hasNext()) {
                                    throw new IllegalStateException("Didn't have next");
                                }
                                Object rv = next;
                                this.last = next;
                                next = null;
                                return rv;
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <E> String toString(Iterable<E> iter, String glue) {
        StringBuilder builder = new StringBuilder();
        Iterator<E> it = iter.iterator();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append(glue);
        }
        return builder.toString();
    }

    public static <T> Iterable<T> sample(Iterable<T> items, int n, int k, Random random) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            indexes.add(i);
        }
        Collections.shuffle(indexes, random);
        final Set indexSet = Generics.newHashSet(indexes.subList(0, k));
        return Iterables.filter(items, new Predicate<T>(){
            private int index = -1;

            @Override
            public boolean test(T item) {
                ++this.index;
                return indexSet.contains(this.index);
            }
        });
    }

    public static <T> ArrayList<T> asArrayList(Iterator<? extends T> iter) {
        ArrayList al = new ArrayList();
        return (ArrayList)Iterables.addAll(iter, al);
    }

    public static <T> HashSet<T> asHashSet(Iterator<? extends T> iter) {
        HashSet hs = new HashSet();
        return (HashSet)Iterables.addAll(iter, hs);
    }

    public static <E> Collection<E> asCollection(Iterator<? extends E> iter, CollectionFactory<E> cf) {
        Collection<E> c = cf.newCollection();
        return Iterables.addAll(iter, c);
    }

    public static <T> Collection<T> addAll(Iterator<? extends T> iter, Collection<T> c) {
        while (iter.hasNext()) {
            c.add(iter.next());
        }
        return c;
    }

    public static void main(String[] args) {
        String[] test = new String[]{"a", "b", "c"};
        List<String> l = Arrays.asList(test);
        System.out.println(Iterables.asArrayList(l.iterator()));
        System.out.println(Iterables.asHashSet(l.iterator()));
        System.out.println(Iterables.asCollection(l.iterator(), CollectionFactory.hashSetFactory()));
        ArrayList<String> al = new ArrayList<String>();
        al.add("d");
        System.out.println(Iterables.addAll(l.iterator(), al));
    }

    public static interface IncrementComparator<V1, V2> {
        public int compare(V1 var1, V2 var2);
    }
}

