/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.spanish;

import edu.stanford.nlp.international.spanish.SpanishVerbStripper;
import edu.stanford.nlp.international.spanish.process.AnCoraPronounDisambiguator;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.international.spanish.SpanishTreebankLanguagePack;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpanishTreeNormalizer
extends BobChrisTreeNormalizer {
    public static final String MW_TAG = "MW?";
    public static final String MW_PHRASE_TAG = "MW_PHRASE?";
    public static final String EMPTY_LEAF_VALUE = "=NONE=";
    public static final String LEFT_PARENTHESIS = "=LRB=";
    public static final String RIGHT_PARENTHESIS = "=RRB=";
    private static final Map<String, String> spellingFixes = new HashMap<String, String>();
    private static final Predicate<Tree> emptyFilter;
    private static final TreeTransformer constituentRenamer;
    private static final Pair<String, String>[] cleanupStrs;
    private static final List<Pair<TregexPattern, TsurgeonPattern>> cleanup;
    private static final Set<String> mergeWithConstituentWhenPossible;
    private boolean simplifiedTagset;
    private boolean aggressiveNormalization;
    private boolean retainNER;
    private static final String VERB_LEAF_WITH_PRONOUNS_TREGEX = "/(?:(?:[aei\u00e1\u00e9\u00ed]r|[\u00e1\u00e9]ndo|[ae\u00e1\u00e9]n?|[aei\u00e1\u00e9\u00ed](?:d(?!os)|(?=os)))|^(?:d[i\u00ed]|h[a\u00e1]z|v[e\u00e9]|p[o\u00f3]n|s[a\u00e1]l|s\u00e9|t[e\u00e9]n|v[e\u00e9]n|(?:id(?=os$))))(?:(?:(?:[mts]e|n?os|les?)(?:l[oa]s?)?)|l[oa]s?)$/=vb > (/^vm[gmn]0000$/";
    private static final TregexPattern verbWithCliticPronouns;
    private static final TregexPattern verbWithCliticPronounsAndSiblings;
    private static final TregexPattern clauselessVerbWithCliticPronouns;
    private static final TsurgeonPattern clausifyVerbWithCliticPronouns;
    private static final SpanishVerbStripper verbStripper;
    private static final List<Pair<TregexPattern, TsurgeonPattern>> markSimpleNEs;
    private static final Pattern pQuoted;
    private static final String WORD_SEPARATORS = ",-_\u00a1!\u00bf?()/%";
    private static final String WORD_SEPARATORS_DROP = "_";
    private static final Set<String> hyphenBoundMorphemes;
    private static final Pair<String, String>[] elisionExpansionStrs;
    private static final List<Pair<TregexPattern, TsurgeonPattern>> elisionExpansions;
    private static TregexPattern conmigoPattern;

    public SpanishTreeNormalizer() {
        this(true, false, false);
    }

    public SpanishTreeNormalizer(boolean simplifiedTagset, boolean aggressiveNormalization, boolean retainNER) {
        super(new SpanishTreebankLanguagePack());
        if (retainNER && !simplifiedTagset) {
            throw new IllegalArgumentException("retainNER argument only valid when simplified tagset is used");
        }
        this.simplifiedTagset = simplifiedTagset;
        this.aggressiveNormalization = aggressiveNormalization;
        this.retainNER = retainNER;
    }

    @Override
    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        tree = tree.prune(emptyFilter).spliceOut(this.aOverAFilter).transform(constituentRenamer);
        tree = Tsurgeon.processPatternsOnTree(cleanup, tree);
        tree = tree.spliceOut(this.aOverAFilter);
        if (this.retainNER) {
            this.markSimpleNamedEntities(tree);
        }
        for (Tree t : tree) {
            if (this.simplifiedTagset && t.isPreTerminal()) {
                CoreLabel label = (CoreLabel)t.label();
                String pos = label.value();
                pos = this.simplifyPOSTag(pos).intern();
                label.setValue(pos);
                label.setTag(pos);
                continue;
            }
            if (!this.aggressiveNormalization || !this.isMultiWordCandidate(t)) continue;
            this.normalizeForMultiWord(t, tf);
        }
        tree = this.expandElisions(tree);
        tree = SpanishTreeNormalizer.expandConmigo(tree);
        tree = SpanishTreeNormalizer.expandCliticPronouns(tree);
        String rootLabel = this.tlp.startSymbol();
        if (!tree.value().equals(rootLabel)) {
            tree = tf.newTreeNode(rootLabel, Collections.singletonList(tree));
        }
        return tree;
    }

    @Override
    public String normalizeTerminal(String word) {
        if (spellingFixes.containsKey(word)) {
            return spellingFixes.get(word);
        }
        return word;
    }

    private String simplifyPOSTag(String pos) {
        if (pos.length() == 0) {
            return pos;
        }
        switch (pos.charAt(0)) {
            case 'd': {
                return pos.substring(0, 2) + "0000";
            }
            case 's': {
                return pos.substring(0, 2) + "000";
            }
            case 'p': {
                return pos.substring(0, 2) + "000000";
            }
            case 'a': {
                return pos.substring(0, 3) + "000";
            }
            case 'n': {
                char ner = this.retainNER && pos.length() == 7 ? (char)pos.charAt(6) : (char)'0';
                return pos.substring(0, 2) + '0' + pos.charAt(3) + "00" + ner;
            }
            case 'v': {
                return pos.substring(0, 4) + "000";
            }
        }
        return pos;
    }

    private static Tree expandCliticPronouns(Tree t) {
        t = Tsurgeon.processPattern(clauselessVerbWithCliticPronouns, clausifyVerbWithCliticPronouns, t);
        t = SpanishTreeNormalizer.expandCliticPronounsInner(t, verbWithCliticPronouns);
        t = SpanishTreeNormalizer.expandCliticPronounsInner(t, verbWithCliticPronounsAndSiblings);
        return t;
    }

    private static Tree expandCliticPronounsInner(Tree t, TregexPattern pattern) {
        TregexMatcher matcher = pattern.matcher(t);
        while (matcher.find()) {
            Pair<String, List<String>> split;
            Tree verbNode = matcher.getNode("vb");
            String verb = verbNode.value();
            if (!SpanishVerbStripper.isStrippable(verb) || (split = verbStripper.separatePronouns(verb)) == null) continue;
            StringBuilder clauseYieldBuilder = new StringBuilder();
            for (Label label : matcher.getNode("clause").yield()) {
                clauseYieldBuilder.append(label.value()).append(" ");
            }
            String clauseYield = clauseYieldBuilder.toString();
            clauseYield = clauseYield.substring(0, clauseYield.length() - 1);
            List<String> pronouns = split.second();
            for (int i = pronouns.size() - 1; i >= 0; --i) {
                String pronoun = pronouns.get(i);
                String newTreeStr = null;
                if (AnCoraPronounDisambiguator.isAmbiguous(pronoun)) {
                    AnCoraPronounDisambiguator.PersonalPronounType type = AnCoraPronounDisambiguator.disambiguatePersonalPronoun(split, i, clauseYield);
                    switch (type) {
                        case OBJECT: {
                            newTreeStr = "(sn (grup.nom (pp000000 %s)))";
                            break;
                        }
                        case REFLEXIVE: {
                            newTreeStr = "(morfema.pronominal (pp000000 %s))";
                            break;
                        }
                        case UNKNOWN: {
                            newTreeStr = "(PRONOUN? (pp000000 %s))";
                        }
                    }
                } else {
                    newTreeStr = "(sn (grup.nom (pp000000 %s)))";
                }
                String patternString = "[insert " + String.format(newTreeStr, pronoun) + " $- target]";
                TsurgeonPattern insertPattern = Tsurgeon.parseOperation(patternString);
                t = insertPattern.matcher().evaluate(t, matcher);
            }
            TsurgeonPattern relabelOperation = Tsurgeon.parseOperation(String.format("[relabel vb /%s/]", split.first()));
            t = relabelOperation.matcher().evaluate(t, matcher);
        }
        return t;
    }

    void markSimpleNamedEntities(Tree t) {
        Tsurgeon.processPatternsOnTree(markSimpleNEs, t);
    }

    boolean isMultiWordCandidate(Tree t) {
        for (Tree child : t.children()) {
            for (Tree grandchild : child.children()) {
                if (!grandchild.isLeaf()) continue;
                return true;
            }
        }
        return false;
    }

    void normalizeForMultiWord(Tree t, TreeFactory tf) {
        Tree[] preterminals = t.children();
        for (int i = 0; i < preterminals.length; ++i) {
            boolean shouldMerge;
            Tree leaf;
            String leafValue;
            String[] words;
            if (!preterminals[i].isPreTerminal() || (words = this.getMultiWords(leafValue = ((CoreLabel)(leaf = preterminals[i].firstChild()).label()).value())).length == 1) continue;
            ArrayList<Tree> newNodes = new ArrayList<Tree>(words.length);
            for (int j = 0; j < words.length; ++j) {
                Tree newNode;
                String word = this.normalizeTerminal(words[j]);
                Tree newLeaf = tf.newLeaf(word);
                if (newLeaf.label() instanceof HasWord) {
                    ((HasWord)((Object)newLeaf.label())).setWord(word);
                }
                if ((newNode = tf.newTreeNode(MW_TAG, Arrays.asList(newLeaf))).label() instanceof HasTag) {
                    ((HasTag)((Object)newNode.label())).setTag(MW_TAG);
                }
                newNodes.add(newNode);
            }
            String phraseValue = "MW_PHRASE?_" + this.simplifyPOSTag(preterminals[i].value());
            boolean bl = shouldMerge = preterminals.length == 1 && mergeWithConstituentWhenPossible.contains(t.value());
            if (shouldMerge) {
                t.setChildren(newNodes);
                t.setValue(phraseValue);
                continue;
            }
            Tree newHead = tf.newTreeNode(phraseValue, newNodes);
            t.setChild(i, newHead);
        }
    }

    private String prepareForMultiWordExtraction(String token) {
        return token.replaceAll("-fpa-", "(").replaceAll("-fpt-", ")");
    }

    private String[] getMultiWords(String token) {
        Matcher quoteMatcher = pQuoted.matcher(token = this.prepareForMultiWordExtraction(token));
        if (quoteMatcher.matches()) {
            String[] ret = new String[]{"\"", quoteMatcher.group(1), "\""};
            return ret;
        }
        StringTokenizer splitter = new StringTokenizer(token, WORD_SEPARATORS, true);
        int remainingTokens = splitter.countTokens();
        ArrayList<String> words = new ArrayList<String>();
        while (splitter.hasMoreTokens()) {
            int prevIndex;
            String prevWord;
            String word = splitter.nextToken();
            --remainingTokens;
            if (this.shouldDropWord(word)) continue;
            if (remainingTokens >= 2 && hyphenBoundMorphemes.contains(word)) {
                String hyphen = splitter.nextToken();
                --remainingTokens;
                if (!hyphen.equals("-")) {
                    words.add(word);
                    if (this.shouldDropWord(hyphen)) continue;
                    words.add(hyphen);
                    continue;
                }
                String freeMorpheme = splitter.nextToken();
                --remainingTokens;
                words.add(word + hyphen + freeMorpheme);
                continue;
            }
            if (word.equals(",") && remainingTokens >= 1 && words.size() > 0 && StringUtils.isNumeric(prevWord = (String)words.get(prevIndex = words.size() - 1))) {
                String nextWord = splitter.nextToken();
                --remainingTokens;
                if (StringUtils.isNumeric(nextWord)) {
                    words.set(prevIndex, prevWord + ',' + nextWord);
                    continue;
                }
                words.add(word);
                words.add(nextWord);
                continue;
            }
            words.add(word);
        }
        return words.toArray(new String[words.size()]);
    }

    private boolean shouldDropWord(String word) {
        return word.length() == 1 && WORD_SEPARATORS_DROP.indexOf(word.charAt(0)) != -1;
    }

    private Tree expandElisions(Tree t) {
        return Tsurgeon.processPatternsOnTree(elisionExpansions, t);
    }

    private static Tree expandConmigo(Tree t) {
        TregexMatcher matcher = conmigoPattern.matcher(t);
        while (matcher.find()) {
            Tree conmigoNode = matcher.getNode("conmigo");
            String word = conmigoNode.value();
            String newPronoun = null;
            if (word.equalsIgnoreCase("conmigo")) {
                newPronoun = "m\u00ed";
            } else if (word.equalsIgnoreCase("contigo")) {
                newPronoun = "ti";
            } else if (word.equalsIgnoreCase("consigo")) {
                newPronoun = "s\u00ed";
            }
            if (word.charAt(0) == 'C') {
                newPronoun = newPronoun.toUpperCase();
            }
            String tsurgeon = String.format("[relabel conmigo /%s/][adjoinF (sp (prep (sp000 con)) foot@) sn]", newPronoun);
            TsurgeonPattern pattern = Tsurgeon.parseOperation(tsurgeon);
            t = pattern.matcher().evaluate(t, matcher);
        }
        return t;
    }

    private static List<Pair<TregexPattern, TsurgeonPattern>> compilePatterns(Pair<String, String>[] patterns) {
        ArrayList<Pair<TregexPattern, TsurgeonPattern>> ret = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>(patterns.length);
        for (Pair<String, String> pattern : patterns) {
            ret.add(new Pair<TregexPattern, TsurgeonPattern>(TregexPattern.compile(pattern.first()), Tsurgeon.parseOperation(pattern.second())));
        }
        return ret;
    }

    static {
        spellingFixes.put("embargp", "embargo");
        spellingFixes.put("jucio", "juicio");
        spellingFixes.put("m\u00e9xico", "M\u00e9xico");
        spellingFixes.put("reirse", "re\u00edrse");
        spellingFixes.put("tambien", "tambi\u00e9n");
        spellingFixes.put("Intitute", "Institute");
        spellingFixes.put("(", LEFT_PARENTHESIS);
        spellingFixes.put(")", RIGHT_PARENTHESIS);
        emptyFilter = new Predicate<Tree>(){

            @Override
            public boolean test(Tree tree) {
                return !tree.isPreTerminal() || !tree.firstChild().value().equals(SpanishTreeNormalizer.EMPTY_LEAF_VALUE);
            }
        };
        constituentRenamer = new TreeTransformer(){

            @Override
            public Tree transformTree(Tree t) {
                if (t.isLeaf()) {
                    return t;
                }
                String value = t.value();
                if (value == null) {
                    return t;
                }
                if (value.equals("sa")) {
                    t.setValue("s.a");
                }
                return t;
            }
        };
        cleanupStrs = new Pair[]{new Pair<String, String>("sp < (sp=sp <: prep=prep)", "replace sp prep"), new Pair<String, String>("fpa > __=grandparent $++ (__=ancestor <<` fpt=fpt >` =grandparent)", "move fpt $- ancestor"), new Pair<String, String>("/^s\\.a$/ <: (/^grup\\.nom$/=gn <: /^a/)", "relabel gn /grup.a/"), new Pair<String, String>("sadv !< /^grup\\.adv$/ <: /^(rg|neg)$/=adv", "adjoinF (grup.adv foot@) adv"), new Pair<String, String>("z=z <: (__ !< __)", "relabel z z0"), new Pair<String, String>("/^grup\\.c/=grup > conj <: sp=sp", "replace grup sp"), new Pair<String, String>("__=N <<` (fp|fs=fp <: (/^\\.$/ !. __)) > sentence=sentence", "move fp $- N"), new Pair<String, String>("(pi000000 <: __ !$+ S >` (/^grup\\.nom/=gn >` sn=sn)). ((que >: (__=queTag $- =sn)) . (__=vb !< __ >>: (__=vbContainer $- =queTag)))", "[insert (S (relatiu (pr000000 que)) (infinitiu vmn0000=vbFoot)) >-1 gn][move vb >0 vbFoot][delete queTag][delete vbContainer]"), new Pair<String, String>("sn=sn <: (/^grup\\.nom/=gn <<: Nada)$+ (infinitiu=inf <<, que=que <<` (ver , =que) $+ sp=sp)", "[delete inf] [insert (S (relatiu (pr000000 que)) (infinitiu (vmn0000 ver))) >-1 gn][move sp >-1 sn]"), new Pair<String, String>("sentence <<, (sn=sn <, (/^grup\\.w$/ $+ fp))", "delete sn"), new Pair<String, String>("conj=conj <: fp=fp", "replace conj fp"), new Pair<String, String>("fit=fit <: \u00bf", "relabel fit fia")};
        cleanup = SpanishTreeNormalizer.compilePatterns(cleanupStrs);
        mergeWithConstituentWhenPossible = new HashSet<String>(Arrays.asList("grup.adv", "grup.nom", "grup.nom.loc", "grup.nom.org", "grup.nom.otros", "grup.nom.pers", "grup.verb", "spec"));
        verbWithCliticPronouns = TregexPattern.compile("/(?:(?:[aei\u00e1\u00e9\u00ed]r|[\u00e1\u00e9]ndo|[ae\u00e1\u00e9]n?|[aei\u00e1\u00e9\u00ed](?:d(?!os)|(?=os)))|^(?:d[i\u00ed]|h[a\u00e1]z|v[e\u00e9]|p[o\u00f3]n|s[a\u00e1]l|s\u00e9|t[e\u00e9]n|v[e\u00e9]n|(?:id(?=os$))))(?:(?:(?:[mts]e|n?os|les?)(?:l[oa]s?)?)|l[oa]s?)$/=vb > (/^vm[gmn]0000$/ !$ __)>+(/^[^S]/) (/^(infinitiu|gerundi|grup\\.verb)$/=target > /^(sentence|S|grup\\.verb|infinitiu|gerundi)$/=clause << =vb !<< (/^(infinitiu|gerundi|grup\\.verb)$/ << =vb))");
        verbWithCliticPronounsAndSiblings = TregexPattern.compile("/(?:(?:[aei\u00e1\u00e9\u00ed]r|[\u00e1\u00e9]ndo|[ae\u00e1\u00e9]n?|[aei\u00e1\u00e9\u00ed](?:d(?!os)|(?=os)))|^(?:d[i\u00ed]|h[a\u00e1]z|v[e\u00e9]|p[o\u00f3]n|s[a\u00e1]l|s\u00e9|t[e\u00e9]n|v[e\u00e9]n|(?:id(?=os$))))(?:(?:(?:[mts]e|n?os|les?)(?:l[oa]s?)?)|l[oa]s?)$/=vb > (/^vm[gmn]0000$/=target $ __) >+(/^[^S]/) (/^(infinitiu|gerundi|grup\\.verb)$/ > /^(sentence|S|grup\\.verb|infinitiu|gerundi)$/=clause << =vb !<< (/^(infinitiu|gerundi|grup\\.verb)$/ << =vb))");
        clauselessVerbWithCliticPronouns = TregexPattern.compile("/(?:(?:[aei\u00e1\u00e9\u00ed]r|[\u00e1\u00e9]ndo|[ae\u00e1\u00e9]n?|[aei\u00e1\u00e9\u00ed](?:d(?!os)|(?=os)))|^(?:d[i\u00ed]|h[a\u00e1]z|v[e\u00e9]|p[o\u00f3]n|s[a\u00e1]l|s\u00e9|t[e\u00e9]n|v[e\u00e9]n|(?:id(?=os$))))(?:(?:(?:[mts]e|n?os|les?)(?:l[oa]s?)?)|l[oa]s?)$/=vb > (/^vm[gmn]0000$/) > (/^vmn/ > (/^infinitiu$/=target > /^sp$/))");
        clausifyVerbWithCliticPronouns = Tsurgeon.parseOperation("adjoinF (S foot@) target");
        verbStripper = SpanishVerbStripper.getInstance();
        Pair[] patternTemplates = new Pair[]{new Pair<String, String>("/^grup\\.nom$/=target <: (/np0000%c/ < __)", "[relabel target /grup.nom.%s/]"), new Pair<String, String>("/^grup\\.nom$/ < ((/np0000%c/=target < __) $+ __)", "[adjoinF (grup.nom.%s foot@) target]"), new Pair<String, String>("/^grup\\.nom$/ < ((/np0000%c/=target < __) $- __)", "[adjoinF (grup.nom.%s foot@) target]")};
        Pair[] namedEntityTypes = new Pair[]{new Pair<Character, String>(Character.valueOf('0'), "otros"), new Pair<Character, String>(Character.valueOf('l'), "lug"), new Pair<Character, String>(Character.valueOf('o'), "org"), new Pair<Character, String>(Character.valueOf('p'), "pers")};
        markSimpleNEs = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>(patternTemplates.length * namedEntityTypes.length);
        for (Pair template : patternTemplates) {
            for (Pair namedEntityType : namedEntityTypes) {
                String tregex = String.format((String)template.first(), namedEntityType.first());
                String tsurgeon = String.format((String)template.second(), namedEntityType.second());
                markSimpleNEs.add(new Pair<TregexPattern, TsurgeonPattern>(TregexPattern.compile(tregex), Tsurgeon.parseOperation(tsurgeon)));
            }
        }
        pQuoted = Pattern.compile("\"(.+)\"");
        hyphenBoundMorphemes = new HashSet<String>(Arrays.asList("anti", "co", "ex", "meso", "neo", "pre", "pro", "quasi", "re", "semi", "sub"));
        elisionExpansionStrs = new Pair[]{new Pair<String, String>("/^(prep|sadv|conj)$/ <+(/^(prep|grup\\.(adv|cc|prep))$/) (sp000=sp < /(?i)^(del|al)$/=elided) <<` =sp $+ (sn > (__ <+(sn) (sn=sn !< sn) << =sn) !$- sn)", "[relabel elided /(?i)l//] [insert (spec (da0000 el)) >0 sn]"), new Pair<String, String>("prep < (sp000 < /(?i)^(del|al)$/=elided) $+ /grup\\.nom/=target", "[relabel elided /(?i)l//] [adjoinF (sn (spec (da0000 el)) foot@) target]"), new Pair<String, String>("prep < (sp000 < /(?i)^(del|al)$/=elided) $+ /s\\.a/=target", "[relabel elided /(?i)l//] [adjoinF (sn (spec (da0000 el)) (grup.nom foot@)) target]"), new Pair<String, String>("sp < (prep=prep < (sp000 < /(?i)^(a|de)l$/=elided) $+ (S=S <<, relatiu))", "[relabel elided /(?i)l//] [adjoinF (sn (spec (da0000 el)) (grup.nom foot@)) S]"), new Pair<String, String>("prep < (sp000 < /(?i)^(al|del)$/=elided) $+ (S=target <+(S) infinitiu=inf <<, =inf)", "[relabel elided /(?i)l//] [adjoinF (sn (spec (da0000 el)) foot@) target]"), new Pair<String, String>("prep < (sp000 < /(?i)^al$/=elided) $+ (S=target <, neg <2 infinitiu)", "[relabel elided a] [adjoinF (sn (spec (da0000 el)) foot@) target]"), new Pair<String, String>("prep < (sp000 < /(?i)^al$/=elided) $+ relatiu=target", "[relabel elided a] [adjoinF (sn (spec (da0000 el)) foot@) target]"), new Pair<String, String>("prep < (sp000 < /(?i)^al$/=elided) $+ (sp=target <, prep)", "[relabel elided a] [adjoinF (sn (spec (da0000 el)) (grup.nom foot@)) target]"), new Pair<String, String>("prep < (sp000 < /(?i)^(del|al)$/=elided) $+ (/grup\\.nom/=target <, /s\\.a/ <2 /sn|nc0[sp]000/)", "[relabel elided /(?i)l//] [adjoinF (sn (spec (da0000 el)) foot@) target]"), new Pair<String, String>("prep < (sp000 < /(?i)^(al|del)$/=elided) $+ (S=target < participi)", "[relabel elided /(?i)l//] [adjoinF (sn (spec (da0000 lo)) foot@) target]"), new Pair<String, String>("spec < (sp000=target < /(?i)^del$/=elided) > sn $+ /grup\\.nom/", "[relabel elided /(?i)l//] [insert (da0000 el) $- target]"), new Pair<String, String>("sp000=kill < /(?i)^(del|al)$/ $+ w=target", "[delete kill] [adjoinF (sp (prep (sp000 de)) (sn (spec (da0000 el)) foot@)) target]"), new Pair<String, String>("sp000 < /(?i)^(a|de)l$/=contraction >: (prep >` (/^grup\\.prep$/ >` (prep=prep > sp $+ (sn=sn <, /^grup\\.(nom|[wz])/))))", "[relabel contraction /(?i)l//] [insert (spec (da0000 el)) >0 sn]"), new Pair<String, String>("sp000 < /(?i)^(a|de)l$/=contraction >: (prep >` (sp >: (conj $+ (sn=sn <, /^grup\\.(nom|[wz])/))))", "[relabel contraction /(?i)l//] [insert (spec (da0000 el)) >0 sn]"), new Pair<String, String>("sp000 < /(?i)^(a|de)l$/=contraction >: (prep >` (/^grup\\.prep$/ >` (prep=prep > sp $+ (sn <, (sn=sn <, /^grup\\.(nom|[wz])/)))))", "[relabel contraction /(?i)l//] [insert (spec (da0000 el)) >0 sn]"), new Pair<String, String>("sp000 < /(?i)^(a|de)l$/=contraction >: (prep >` (/^grup\\.prep$/ >` (prep > sp $+ (sn=sn <, spec=spec))))", "[relabel contraction /(?i)l//] [insert (da0000 el) >0 spec]"), new Pair<String, String>("sp000 < /(?i)^(a|de)l$/=contraction >: (prep >` (/^grup\\.prep$/ >` (prep > sp $+ /^grup\\.(nom|[wz])$/=ng)))", "[adjoinF (sn (spec (da0000 el)) foot@) ng] [relabel contraction /(?i)l//]"), new Pair<String, String>("sp000 < /(?i)^(de|a)l$/=elided >` (/^grup\\.cc$/ >: (conj $+ /^grup\\.nom/=gn))", "[relabel elided /(?i)l//] [adjoinF (sn (spec (da0000 el)) foot@) gn]"), new Pair<String, String>("sp000=sp < /(?i)^al$/=elided $+ /^vmp/", "[relabel elided /(?i)l//] [insert (da0000 el) $- sp]"), new Pair<String, String>("prep < (sp000 < /(?i)^(al|del)$/=elided) $+ (S=S <+(S) (/^f/=punct $+ (S <+(S) (S <, infinitiu))))", "[relabel elided /(?i)l//] [adjoinF (sn (spec (da0000 el)) (grup.nom foot@)) S]"), new Pair<String, String>("__=sp < del=contraction >, __=parent $+ (__ < todo >` =parent)", "[relabel contraction de] [insert (da0000 el) $- sp]")};
        elisionExpansions = SpanishTreeNormalizer.compilePatterns(elisionExpansionStrs);
        conmigoPattern = TregexPattern.compile("/(?i)^con[mst]igo$/=conmigo > (/^pp/ > (/^grup\\.nom$/ > sn=sn))");
    }
}

