/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Pair;
import java.io.IOException;
import java.util.List;

public class UniversalPOSMapper {
    public static final String DEFAULT_TSURGEON_FILE = "edu/stanford/nlp/models/upos/ENUniversalPOS.tsurgeon";
    private static boolean loaded = false;
    private static List<Pair<TregexPattern, TsurgeonPattern>> operations = null;

    private UniversalPOSMapper() {
    }

    public static void load() {
        UniversalPOSMapper.load(DEFAULT_TSURGEON_FILE);
    }

    public static void load(String filename) {
        loaded = true;
        try {
            operations = Tsurgeon.getOperationsFromFile(filename, "UTF-8", new TregexPatternCompiler());
        }
        catch (IOException e) {
            System.err.printf("%s: Warning - could not load Tsurgeon file from %s.%n", UniversalPOSMapper.class.getSimpleName(), filename);
        }
    }

    public static Tree mapTree(Tree t) {
        if (!loaded) {
            UniversalPOSMapper.load();
        }
        if (operations == null) {
            return t;
        }
        return Tsurgeon.processPatternsOnTree(operations, t.deepCopy());
    }
}

