/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CategoryWordTagFactory;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.trees.CollinsHeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;

public class TreeFunctions {
    private TreeFunctions() {
    }

    public static Function<Tree, Tree> getLabeledTreeToStringLabeledTreeFunction() {
        return new LabeledTreeToStringLabeledTreeFunction();
    }

    public static Function<Tree, Tree> getLabeledTreeToCategoryWordTagTreeFunction() {
        return new LabeledTreeToCategoryWordTagTreeFunction();
    }

    public static Function<Tree, Tree> getLabeledToDescriptiveCoreLabelTreeFunction() {
        return new LabeledToDescriptiveCoreLabelTreeFunction();
    }

    public static void main(String[] args) {
        Tree stringyTree = null;
        try {
            stringyTree = new PennTreeReader(new StringReader("(S (VP (VBZ Try) (NP (DT this))) (. .))"), new LabeledScoredTreeFactory(new StringLabelFactory())).readTree();
        }
        catch (IOException e) {
            // empty catch block
        }
        System.out.println(stringyTree);
        Function<Tree, Tree> a = TreeFunctions.getLabeledTreeToCategoryWordTagTreeFunction();
        Tree adaptyTree = a.apply(stringyTree);
        System.out.println(adaptyTree);
        adaptyTree.percolateHeads(new CollinsHeadFinder());
        System.out.println(adaptyTree);
        Function<Tree, Tree> b = TreeFunctions.getLabeledTreeToStringLabeledTreeFunction();
        Tree stringLabelTree = b.apply(adaptyTree);
        System.out.println(stringLabelTree);
    }

    private static class LabeledToDescriptiveCoreLabelTreeFunction
    implements Function<Tree, Tree> {
        protected TreeFactory tf = new LabeledScoredTreeFactory(CoreLabel.factory());

        private LabeledToDescriptiveCoreLabelTreeFunction() {
        }

        @Override
        public Tree apply(Tree t) {
            if (t == null) {
                return null;
            }
            if (t.isLeaf()) {
                return this.tf.newLeaf(t.label().toString());
            }
            if (t.isPreTerminal()) {
                return this.tf.newTreeNode(t.label().toString(), Collections.singletonList(this.apply(t.children()[0])));
            }
            int numKids = t.numChildren();
            ArrayList<Tree> children = new ArrayList<Tree>(numKids);
            for (int k = 0; k < numKids; ++k) {
                children.add(this.apply(t.children()[k]));
            }
            return this.tf.newTreeNode(t.label().toString(), children);
        }
    }

    private static class LabeledTreeToCategoryWordTagTreeFunction
    implements Function<Tree, Tree> {
        protected TreeFactory tf = new LabeledScoredTreeFactory(new CategoryWordTagFactory());

        private LabeledTreeToCategoryWordTagTreeFunction() {
        }

        public Tree helper(Tree t) {
            if (t == null) {
                return null;
            }
            if (t.isLeaf()) {
                return this.tf.newLeaf(t.label().value());
            }
            if (t.isPreTerminal()) {
                return this.tf.newTreeNode(t.label().value(), Collections.singletonList(this.helper(t.children()[0])));
            }
            int numKids = t.numChildren();
            ArrayList<Tree> children = new ArrayList<Tree>(numKids);
            for (int k = 0; k < numKids; ++k) {
                children.add(this.helper(t.children()[k]));
            }
            return this.tf.newTreeNode(t.label().value(), children);
        }

        @Override
        public Tree apply(Tree o) {
            return this.helper(o);
        }
    }

    private static class LabeledTreeToStringLabeledTreeFunction
    implements Function<Tree, Tree> {
        protected TreeFactory tf = new LabeledScoredTreeFactory();

        private LabeledTreeToStringLabeledTreeFunction() {
        }

        public Tree helper(Tree t) {
            if (t == null) {
                return null;
            }
            if (t.isLeaf()) {
                return this.tf.newLeaf(new StringLabel(t.label().value()));
            }
            if (t.isPreTerminal()) {
                return this.tf.newTreeNode(new StringLabel(t.label().value()), Collections.singletonList(this.helper(t.children()[0])));
            }
            int numKids = t.numChildren();
            ArrayList<Tree> children = new ArrayList<Tree>(numKids);
            for (int k = 0; k < numKids; ++k) {
                children.add(this.helper(t.children()[k]));
            }
            return this.tf.newTreeNode(new StringLabel(t.label().value()), children);
        }

        @Override
        public Tree apply(Tree t) {
            return this.helper(t);
        }
    }
}

