/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.tagger.io.TaggedFileReader;
import edu.stanford.nlp.tagger.io.TaggedFileRecord;
import edu.stanford.nlp.tagger.maxent.DataWordTag;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.TaggerConfig;
import edu.stanford.nlp.util.Generics;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReadDataTagged {
    private final ArrayList<DataWordTag> v = new ArrayList();
    private int numElements = 0;
    private int totalSentences = 0;
    private int totalWords = 0;
    private final PairsHolder pairs;
    private final MaxentTagger maxentTagger;

    protected ReadDataTagged(TaggerConfig config, MaxentTagger maxentTagger, PairsHolder pairs) throws IOException {
        this.maxentTagger = maxentTagger;
        this.pairs = pairs;
        List<TaggedFileRecord> fileRecords = TaggedFileRecord.createRecords(config, config.getFile());
        Map<String, IntCounter<String>> wordTagCounts = Generics.newHashMap();
        for (TaggedFileRecord record : fileRecords) {
            this.loadFile(record.reader(), wordTagCounts);
        }
        maxentTagger.dict.fillWordTagCounts(wordTagCounts);
    }

    void release() {
        this.v.clear();
    }

    DataWordTag get(int index) {
        return this.v.get(index);
    }

    private void loadFile(TaggedFileReader reader, Map<String, IntCounter<String>> wordTagCounts) {
        System.err.println("Loading tagged words from " + reader.filename());
        ArrayList<String> words = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        int numSentences = 0;
        int numWords = 0;
        int maxLen = Integer.MIN_VALUE;
        int minLen = Integer.MAX_VALUE;
        for (Object sentence : reader) {
            Object newSentence;
            if (this.maxentTagger.wordFunction != null) {
                newSentence = new ArrayList(sentence.size());
                Iterator iterator = sentence.iterator();
                while (iterator.hasNext()) {
                    TaggedWord word = (TaggedWord)iterator.next();
                    TaggedWord newWord = new TaggedWord(this.maxentTagger.wordFunction.apply(word.word()), word.tag());
                    newSentence.add(newWord);
                }
                sentence = newSentence;
            }
            newSentence = sentence.iterator();
            while (newSentence.hasNext()) {
                TaggedWord tw = (TaggedWord)newSentence.next();
                if (tw == null) continue;
                words.add(tw.word());
                tags.add(tw.tag());
                if (!this.maxentTagger.tagTokens.containsKey(tw.tag())) {
                    this.maxentTagger.tagTokens.put(tw.tag(), Generics.newHashSet());
                }
                this.maxentTagger.tagTokens.get(tw.tag()).add(tw.word());
            }
            maxLen = sentence.size() > maxLen ? sentence.size() : maxLen;
            minLen = sentence.size() < minLen ? sentence.size() : minLen;
            words.add(".$.");
            tags.add(".$$.");
            this.numElements = this.numElements + sentence.size() + 1;
            for (int i = 0; i < sentence.size() + 1; ++i) {
                History h = new History(this.totalWords + this.totalSentences, this.totalWords + this.totalSentences + sentence.size(), this.totalWords + this.totalSentences + i, this.pairs, this.maxentTagger.extractors);
                String tag = (String)tags.get(i);
                String word = (String)words.get(i);
                this.pairs.add(new WordTag(word, tag));
                int y = this.maxentTagger.addTag(tag);
                DataWordTag dat = new DataWordTag(h, y, tag);
                this.v.add(dat);
                IntCounter<String> tagCounts = wordTagCounts.get(word);
                if (tagCounts == null) {
                    tagCounts = new IntCounter();
                    wordTagCounts.put(word, tagCounts);
                }
                tagCounts.incrementCount(tag, 1);
            }
            ++this.totalSentences;
            this.totalWords += sentence.size();
            numWords += sentence.size();
            words.clear();
            tags.clear();
            if (++numSentences % 100000 != 0) continue;
            System.err.println("Read " + numSentences + " sentences, min " + minLen + " words, max " + maxLen + " words ... [still reading]");
        }
        System.err.println("Read " + numWords + " words from " + reader.filename() + " [done].");
        System.err.println("Read " + numSentences + " sentences, min " + minLen + " words, max " + maxLen + " words.");
    }

    public int getSize() {
        return this.numElements;
    }
}

