/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.TestOptions;
import edu.stanford.nlp.parser.lexparser.TrainOptions;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.trees.CompositeTreeTransformer;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.function.Function;

public class Options
implements Serializable {
    public LexOptions lexOptions = new LexOptions();
    public TreebankLangParserParams tlpParams;
    public boolean forceCNF = false;
    public boolean doPCFG = true;
    public boolean doDep = true;
    public boolean freeDependencies = false;
    public boolean directional = true;
    public boolean genStop = true;
    public boolean useSmoothTagProjection = false;
    public boolean useUnigramWordSmoothing = false;
    public boolean distance = true;
    public boolean coarseDistance = false;
    public boolean dcTags = true;
    public boolean nodePrune = false;
    public TrainOptions trainOptions = this.newTrainOptions();
    public transient TestOptions testOptions = this.newTestOptions();
    public Function<String, String> wordFunction = null;
    public int rerankerKBest = 100;
    public double baseParserWeight = 0.0;
    private static final long serialVersionUID = 4L;

    public Options() {
        this(new EnglishTreebankParserParams());
    }

    public Options(TreebankLangParserParams tlpParams) {
        this.tlpParams = tlpParams;
    }

    public void setOptions(String ... flags) {
        this.setOptions(flags, 0, flags.length);
    }

    public void setOptions(String[] flags, int startIndex, int endIndexPlusOne) {
        int i = startIndex;
        while (i < endIndexPlusOne) {
            i = this.setOption(flags, i);
        }
    }

    public void setOptionsOrWarn(String ... flags) {
        this.setOptionsOrWarn(flags, 0, flags.length);
    }

    public void setOptionsOrWarn(String[] flags, int startIndex, int endIndexPlusOne) {
        int i = startIndex;
        while (i < endIndexPlusOne) {
            i = this.setOptionOrWarn(flags, i);
        }
    }

    public int setOptionOrWarn(String[] flags, int i) {
        int j = this.setOptionFlag(flags, i);
        if (j == i) {
            j = this.tlpParams.setOptionFlag(flags, i);
        }
        if (j == i) {
            System.err.println("WARNING! lexparser.Options: Unknown option ignored: " + flags[i]);
            ++j;
        }
        return j;
    }

    public int setOption(String[] flags, int i) {
        int j = this.setOptionFlag(flags, i);
        if (j == i) {
            j = this.tlpParams.setOptionFlag(flags, i);
        }
        if (j == i) {
            throw new IllegalArgumentException("Unknown option: " + flags[i]);
        }
        return j;
    }

    protected int setOptionFlag(String[] args, int i) {
        if (args[i].equalsIgnoreCase("-PCFG")) {
            this.doDep = false;
            this.doPCFG = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-dep")) {
            this.doDep = true;
            this.doPCFG = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-factored")) {
            this.doDep = true;
            this.doPCFG = true;
            this.testOptions.useFastFactored = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-fastFactored")) {
            this.doDep = true;
            this.doPCFG = true;
            this.testOptions.useFastFactored = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noRecoveryTagging")) {
            this.testOptions.noRecoveryTagging = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-useLexiconToScoreDependencyPwGt")) {
            this.testOptions.useLexiconToScoreDependencyPwGt = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-useSmoothTagProjection")) {
            this.useSmoothTagProjection = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-useUnigramWordSmoothing")) {
            this.useUnigramWordSmoothing = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-useNonProjectiveDependencyParser")) {
            this.testOptions.useNonProjectiveDependencyParser = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-maxLength") && i + 1 < args.length) {
            this.testOptions.maxLength = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-MAX_ITEMS") && i + 1 < args.length) {
            this.testOptions.MAX_ITEMS = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-trainLength") && i + 1 < args.length) {
            this.trainOptions.trainLengthLimit = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-lengthNormalization")) {
            this.testOptions.lengthNormalization = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-iterativeCKY")) {
            this.testOptions.iterativeCKY = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-vMarkov") && i + 1 < args.length) {
            int order = Integer.parseInt(args[i + 1]);
            if (order <= 1) {
                this.trainOptions.PA = false;
                this.trainOptions.gPA = false;
            } else if (order == 2) {
                this.trainOptions.PA = true;
                this.trainOptions.gPA = false;
            } else if (order >= 3) {
                this.trainOptions.PA = true;
                this.trainOptions.gPA = true;
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-vSelSplitCutOff") && i + 1 < args.length) {
            this.trainOptions.selectiveSplitCutOff = Double.parseDouble(args[i + 1]);
            this.trainOptions.selectiveSplit = this.trainOptions.selectiveSplitCutOff > 0.0;
            i += 2;
        } else if (args[i].equalsIgnoreCase("-vSelPostSplitCutOff") && i + 1 < args.length) {
            this.trainOptions.selectivePostSplitCutOff = Double.parseDouble(args[i + 1]);
            this.trainOptions.selectivePostSplit = this.trainOptions.selectivePostSplitCutOff > 0.0;
            i += 2;
        } else if (args[i].equalsIgnoreCase("-deleteSplitters") && i + 1 < args.length) {
            String[] toDel = args[i + 1].split(" *, *");
            this.trainOptions.deleteSplitters = Generics.newHashSet(Arrays.asList(toDel));
            i += 2;
        } else if (args[i].equalsIgnoreCase("-postSplitWithBaseCategory")) {
            this.trainOptions.postSplitWithBaseCategory = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-vPostMarkov") && i + 1 < args.length) {
            int order = Integer.parseInt(args[i + 1]);
            if (order <= 1) {
                this.trainOptions.postPA = false;
                this.trainOptions.postGPA = false;
            } else if (order == 2) {
                this.trainOptions.postPA = true;
                this.trainOptions.postGPA = false;
            } else if (order >= 3) {
                this.trainOptions.postPA = true;
                this.trainOptions.postGPA = true;
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-hMarkov") && i + 1 < args.length) {
            int order = Integer.parseInt(args[i + 1]);
            if (order >= 0) {
                this.trainOptions.markovOrder = order;
                this.trainOptions.markovFactor = true;
            } else {
                this.trainOptions.markovFactor = false;
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-distanceBins") && i + 1 < args.length) {
            int numBins = Integer.parseInt(args[i + 1]);
            if (numBins <= 1) {
                this.distance = false;
            } else if (numBins == 4) {
                this.distance = true;
                this.coarseDistance = true;
            } else if (numBins == 5) {
                this.distance = true;
                this.coarseDistance = false;
            } else {
                throw new IllegalArgumentException("Invalid value for -distanceBin: " + args[i + 1]);
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-noStop")) {
            this.genStop = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-nonDirectional")) {
            this.directional = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-depWeight") && i + 1 < args.length) {
            this.testOptions.depWeight = Double.parseDouble(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-printPCFGkBest") && i + 1 < args.length) {
            this.testOptions.printPCFGkBest = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-evalPCFGkBest") && i + 1 < args.length) {
            this.testOptions.evalPCFGkBest = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-printFactoredKGood") && i + 1 < args.length) {
            this.testOptions.printFactoredKGood = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-smoothTagsThresh") && i + 1 < args.length) {
            this.lexOptions.smoothInUnknownsThreshold = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-unseenSmooth") && i + 1 < args.length) {
            this.testOptions.unseenSmooth = Double.parseDouble(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-fractionBeforeUnseenCounting") && i + 1 < args.length) {
            this.trainOptions.fractionBeforeUnseenCounting = Double.parseDouble(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-hSelSplitThresh") && i + 1 < args.length) {
            this.trainOptions.HSEL_CUT = Integer.parseInt(args[i + 1]);
            this.trainOptions.hSelSplit = this.trainOptions.HSEL_CUT > 0;
            i += 2;
        } else if (args[i].equalsIgnoreCase("-nohSelSplit")) {
            this.trainOptions.hSelSplit = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-tagPA")) {
            this.trainOptions.tagPA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noTagPA")) {
            this.trainOptions.tagPA = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-tagSelSplitCutOff") && i + 1 < args.length) {
            this.trainOptions.tagSelectiveSplitCutOff = Double.parseDouble(args[i + 1]);
            this.trainOptions.tagSelectiveSplit = this.trainOptions.tagSelectiveSplitCutOff > 0.0;
            i += 2;
        } else if (args[i].equalsIgnoreCase("-tagSelPostSplitCutOff") && i + 1 < args.length) {
            this.trainOptions.tagSelectivePostSplitCutOff = Double.parseDouble(args[i + 1]);
            this.trainOptions.tagSelectivePostSplit = this.trainOptions.tagSelectivePostSplitCutOff > 0.0;
            i += 2;
        } else if (args[i].equalsIgnoreCase("-noTagSplit")) {
            this.trainOptions.noTagSplit = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-uwm") && i + 1 < args.length) {
            this.lexOptions.useUnknownWordSignatures = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-unknownSuffixSize") && i + 1 < args.length) {
            this.lexOptions.unknownSuffixSize = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-unknownPrefixSize") && i + 1 < args.length) {
            this.lexOptions.unknownPrefixSize = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-uwModelTrainer") && i + 1 < args.length) {
            this.lexOptions.uwModelTrainer = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-openClassThreshold") && i + 1 < args.length) {
            this.trainOptions.openClassTypesThreshold = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-unary") && i + 1 < args.length) {
            this.trainOptions.markUnary = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-unaryTags")) {
            this.trainOptions.markUnaryTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-mutate")) {
            this.lexOptions.smartMutation = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-useUnicodeType")) {
            this.lexOptions.useUnicodeType = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-rightRec")) {
            this.trainOptions.rightRec = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noRightRec")) {
            this.trainOptions.rightRec = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-preTag")) {
            this.testOptions.preTag = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-forceTags")) {
            this.testOptions.forceTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-taggerSerializedFile")) {
            this.testOptions.taggerSerializedFile = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-forceTagBeginnings")) {
            this.testOptions.forceTagBeginnings = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noFunctionalForcing")) {
            this.testOptions.noFunctionalForcing = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-scTags")) {
            this.dcTags = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-dcTags")) {
            this.dcTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-basicCategoryTagsInDependencyGrammar")) {
            this.trainOptions.basicCategoryTagsInDependencyGrammar = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-evalb")) {
            this.testOptions.evalb = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-v") || args[i].equalsIgnoreCase("-verbose")) {
            this.testOptions.verbose = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-outputFilesDirectory") && i + 1 < args.length) {
            this.testOptions.outputFilesDirectory = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-outputFilesExtension") && i + 1 < args.length) {
            this.testOptions.outputFilesExtension = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-outputFilesPrefix") && i + 1 < args.length) {
            this.testOptions.outputFilesPrefix = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-outputkBestEquivocation") && i + 1 < args.length) {
            this.testOptions.outputkBestEquivocation = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-writeOutputFiles")) {
            this.testOptions.writeOutputFiles = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-printAllBestParses")) {
            this.testOptions.printAllBestParses = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-outputTreeFormat") || args[i].equalsIgnoreCase("-outputFormat")) {
            this.testOptions.outputFormat = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-outputTreeFormatOptions") || args[i].equalsIgnoreCase("-outputFormatOptions")) {
            this.testOptions.outputFormatOptions = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-addMissingFinalPunctuation")) {
            this.testOptions.addMissingFinalPunctuation = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-flexiTag")) {
            this.lexOptions.flexiTag = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-lexiTag")) {
            this.lexOptions.flexiTag = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-useSignatureForKnownSmoothing")) {
            this.lexOptions.useSignatureForKnownSmoothing = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-wordClassesFile")) {
            this.lexOptions.wordClassesFile = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-compactGrammar")) {
            this.trainOptions.compactGrammar = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markFinalStates")) {
            this.trainOptions.markFinalStates = args[i + 1].equalsIgnoreCase("true");
            i += 2;
        } else if (args[i].equalsIgnoreCase("-leftToRight")) {
            this.trainOptions.leftToRight = args[i + 1].equals("true");
            i += 2;
        } else if (args[i].equalsIgnoreCase("-cnf")) {
            this.forceCNF = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-smoothRules")) {
            this.trainOptions.ruleSmoothing = true;
            this.trainOptions.ruleSmoothingAlpha = Double.valueOf(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-nodePrune") && i + 1 < args.length) {
            this.nodePrune = args[i + 1].equalsIgnoreCase("true");
            i += 2;
        } else if (args[i].equalsIgnoreCase("-noDoRecovery")) {
            this.testOptions.doRecovery = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-acl03chinese")) {
            this.trainOptions.markovOrder = 1;
            this.trainOptions.markovFactor = true;
        } else if (args[i].equalsIgnoreCase("-wordFunction")) {
            this.wordFunction = (Function)ReflectionLoading.loadByReflection(args[i + 1], new Object[0]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-acl03pcfg")) {
            this.doDep = false;
            this.doPCFG = true;
            this.trainOptions.markUnary = 1;
            this.trainOptions.PA = true;
            this.trainOptions.gPA = false;
            this.trainOptions.tagPA = true;
            this.trainOptions.tagSelectiveSplit = false;
            this.trainOptions.rightRec = true;
            this.trainOptions.selectiveSplit = true;
            this.trainOptions.selectiveSplitCutOff = 400.0;
            this.trainOptions.markovFactor = true;
            this.trainOptions.markovOrder = 2;
            this.trainOptions.hSelSplit = true;
            this.lexOptions.useUnknownWordSignatures = 2;
            this.lexOptions.flexiTag = true;
            this.dcTags = false;
        } else if (args[i].equalsIgnoreCase("-jenny")) {
            this.doDep = false;
            this.doPCFG = true;
            this.trainOptions.markUnary = 1;
            this.trainOptions.PA = false;
            this.trainOptions.gPA = false;
            this.trainOptions.tagPA = false;
            this.trainOptions.tagSelectiveSplit = false;
            this.trainOptions.rightRec = true;
            this.trainOptions.selectiveSplit = false;
            this.trainOptions.markovFactor = false;
            this.trainOptions.hSelSplit = false;
            this.lexOptions.useUnknownWordSignatures = 2;
            this.lexOptions.flexiTag = true;
            this.dcTags = false;
        } else if (args[i].equalsIgnoreCase("-goodPCFG")) {
            this.doDep = false;
            this.doPCFG = true;
            this.trainOptions.markUnary = 1;
            this.trainOptions.PA = true;
            this.trainOptions.gPA = false;
            this.trainOptions.tagPA = true;
            this.trainOptions.tagSelectiveSplit = false;
            this.trainOptions.rightRec = true;
            this.trainOptions.selectiveSplit = true;
            this.trainOptions.selectiveSplitCutOff = 400.0;
            this.trainOptions.markovFactor = true;
            this.trainOptions.markovOrder = 2;
            this.trainOptions.hSelSplit = true;
            this.lexOptions.useUnknownWordSignatures = 2;
            this.lexOptions.flexiTag = true;
            this.dcTags = false;
            String[] delSplit = new String[]{"-deleteSplitters", "VP^NP,VP^VP,VP^SINV,VP^SQ"};
            if (this.setOptionFlag(delSplit, 0) != 2) {
                System.err.println("Error processing deleteSplitters");
            }
        } else if (args[i].equalsIgnoreCase("-linguisticPCFG")) {
            this.doDep = false;
            this.doPCFG = true;
            this.trainOptions.markUnary = 1;
            this.trainOptions.PA = true;
            this.trainOptions.gPA = false;
            this.trainOptions.tagPA = true;
            this.trainOptions.tagSelectiveSplit = false;
            this.trainOptions.rightRec = false;
            this.trainOptions.selectiveSplit = true;
            this.trainOptions.selectiveSplitCutOff = 400.0;
            this.trainOptions.markovFactor = true;
            this.trainOptions.markovOrder = 2;
            this.trainOptions.hSelSplit = true;
            this.lexOptions.useUnknownWordSignatures = 5;
            this.lexOptions.flexiTag = false;
            this.dcTags = false;
        } else if (args[i].equalsIgnoreCase("-ijcai03")) {
            this.doDep = true;
            this.doPCFG = true;
            this.trainOptions.markUnary = 0;
            this.trainOptions.PA = true;
            this.trainOptions.gPA = false;
            this.trainOptions.tagPA = false;
            this.trainOptions.tagSelectiveSplit = false;
            this.trainOptions.rightRec = false;
            this.trainOptions.selectiveSplit = true;
            this.trainOptions.selectiveSplitCutOff = 300.0;
            this.trainOptions.markovFactor = true;
            this.trainOptions.markovOrder = 2;
            this.trainOptions.hSelSplit = true;
            this.trainOptions.compactGrammar = 0;
            this.lexOptions.useUnknownWordSignatures = 2;
            this.lexOptions.flexiTag = false;
            this.dcTags = true;
        } else if (args[i].equalsIgnoreCase("-goodFactored")) {
            this.doDep = true;
            this.doPCFG = true;
            this.trainOptions.markUnary = 0;
            this.trainOptions.PA = true;
            this.trainOptions.gPA = false;
            this.trainOptions.tagPA = false;
            this.trainOptions.tagSelectiveSplit = false;
            this.trainOptions.rightRec = false;
            this.trainOptions.selectiveSplit = true;
            this.trainOptions.selectiveSplitCutOff = 300.0;
            this.trainOptions.markovFactor = true;
            this.trainOptions.markovOrder = 2;
            this.trainOptions.hSelSplit = true;
            this.trainOptions.compactGrammar = 0;
            this.lexOptions.useUnknownWordSignatures = 5;
            this.lexOptions.flexiTag = false;
            this.dcTags = true;
        } else if (args[i].equalsIgnoreCase("-chineseFactored")) {
            this.dcTags = false;
            this.lexOptions.useUnicodeType = true;
            this.trainOptions.markovOrder = 2;
            this.trainOptions.hSelSplit = true;
            this.trainOptions.markovFactor = true;
            this.trainOptions.HSEL_CUT = 50;
        } else if (args[i].equalsIgnoreCase("-arabicFactored")) {
            this.doDep = true;
            this.doPCFG = true;
            this.dcTags = false;
            this.trainOptions.markovFactor = true;
            this.trainOptions.markovOrder = 2;
            this.trainOptions.hSelSplit = true;
            this.trainOptions.HSEL_CUT = 75;
            this.trainOptions.PA = true;
            this.trainOptions.gPA = false;
            this.trainOptions.selectiveSplit = true;
            this.trainOptions.selectiveSplitCutOff = 300.0;
            this.trainOptions.markUnary = 1;
            this.lexOptions.useUnknownWordSignatures = 9;
            this.lexOptions.unknownPrefixSize = 1;
            this.lexOptions.unknownSuffixSize = 1;
            this.testOptions.MAX_ITEMS = 500000;
        } else if (args[i].equalsIgnoreCase("-frenchFactored")) {
            this.doDep = true;
            this.doPCFG = true;
            this.dcTags = false;
            this.trainOptions.markovFactor = true;
            this.trainOptions.markovOrder = 2;
            this.trainOptions.hSelSplit = true;
            this.trainOptions.HSEL_CUT = 75;
            this.trainOptions.PA = true;
            this.trainOptions.gPA = false;
            this.trainOptions.selectiveSplit = true;
            this.trainOptions.selectiveSplitCutOff = 300.0;
            this.trainOptions.markUnary = 0;
            this.lexOptions.useUnknownWordSignatures = 1;
            this.lexOptions.unknownPrefixSize = 1;
            this.lexOptions.unknownSuffixSize = 2;
        } else if (args[i].equalsIgnoreCase("-chinesePCFG")) {
            this.trainOptions.markovOrder = 2;
            this.trainOptions.markovFactor = true;
            this.trainOptions.HSEL_CUT = 5;
            this.trainOptions.PA = true;
            this.trainOptions.gPA = true;
            this.trainOptions.selectiveSplit = false;
            this.doDep = false;
            this.doPCFG = true;
            this.dcTags = false;
        } else if (args[i].equalsIgnoreCase("-printTT") && i + 1 < args.length) {
            this.trainOptions.printTreeTransformations = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-printAnnotatedRuleCounts")) {
            this.trainOptions.printAnnotatedRuleCounts = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-printAnnotatedStateCounts")) {
            this.trainOptions.printAnnotatedStateCounts = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-printAnnotated") && i + 1 < args.length) {
            try {
                this.trainOptions.printAnnotatedPW = this.tlpParams.pw(new FileOutputStream(args[i + 1]));
            }
            catch (IOException ioe) {
                this.trainOptions.printAnnotatedPW = null;
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-printBinarized") && i + 1 < args.length) {
            try {
                this.trainOptions.printBinarizedPW = this.tlpParams.pw(new FileOutputStream(args[i + 1]));
            }
            catch (IOException ioe) {
                this.trainOptions.printBinarizedPW = null;
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-printStates")) {
            this.trainOptions.printStates = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-preTransformer") && i + 1 < args.length) {
            String[] classes = args[i + 1].split(",");
            i += 2;
            if (classes.length == 1) {
                this.trainOptions.preTransformer = (TreeTransformer)ReflectionLoading.loadByReflection(classes[0], this);
            } else if (classes.length > 1) {
                CompositeTreeTransformer composite = new CompositeTreeTransformer();
                this.trainOptions.preTransformer = composite;
                for (String clazz : classes) {
                    TreeTransformer transformer = (TreeTransformer)ReflectionLoading.loadByReflection(clazz, this);
                    composite.addTransformer(transformer);
                }
            }
        } else if (args[i].equalsIgnoreCase("-taggedFiles") && i + 1 < args.length) {
            this.trainOptions.taggedFiles = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-predictSplits")) {
            this.trainOptions.predictSplits = true;
            this.trainOptions.compactGrammar = 0;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitCount")) {
            this.trainOptions.splitCount = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitRecombineRate")) {
            this.trainOptions.splitRecombineRate = Double.parseDouble(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-trainingThreads") || args[i].equalsIgnoreCase("-nThreads")) {
            this.trainOptions.trainingThreads = Integer.parseInt(args[i + 1]);
            this.testOptions.testingThreads = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-testingThreads")) {
            this.testOptions.testingThreads = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-evals")) {
            this.testOptions.evals = StringUtils.stringToProperties(args[i + 1], this.testOptions.evals);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-fastFactoredCandidateMultiplier")) {
            this.testOptions.fastFactoredCandidateMultiplier = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-fastFactoredCandidateAddend")) {
            this.testOptions.fastFactoredCandidateAddend = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-quietEvaluation")) {
            this.testOptions.quietEvaluation = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noquietEvaluation")) {
            this.testOptions.quietEvaluation = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-simpleBinarizedLabels")) {
            this.trainOptions.simpleBinarizedLabels = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noRebinarization")) {
            this.trainOptions.noRebinarization = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-dvKBest")) {
            this.rerankerKBest = this.trainOptions.dvKBest = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-regCost")) {
            this.trainOptions.regCost = Double.parseDouble(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-dvIterations") || args[i].equalsIgnoreCase("-trainingIterations")) {
            this.trainOptions.trainingIterations = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-stalledIterationLimit")) {
            this.trainOptions.stalledIterationLimit = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-dvBatchSize") || args[i].equalsIgnoreCase("-batchSize")) {
            this.trainOptions.batchSize = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-qnIterationsPerBatch")) {
            this.trainOptions.qnIterationsPerBatch = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-qnEstimates")) {
            this.trainOptions.qnEstimates = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-qnTolerance")) {
            this.trainOptions.qnTolerance = Double.parseDouble(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-debugOutputFrequency")) {
            this.trainOptions.debugOutputFrequency = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-maxTrainTimeSeconds")) {
            this.trainOptions.maxTrainTimeSeconds = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-dvSeed") || args[i].equalsIgnoreCase("-randomSeed")) {
            this.trainOptions.randomSeed = Long.parseLong(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-wordVectorFile")) {
            this.lexOptions.wordVectorFile = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-numHid")) {
            this.lexOptions.numHid = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-learningRate")) {
            this.trainOptions.learningRate = Double.parseDouble(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-deltaMargin")) {
            this.trainOptions.deltaMargin = Double.parseDouble(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-unknownNumberVector")) {
            this.trainOptions.unknownNumberVector = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noUnknownNumberVector")) {
            this.trainOptions.unknownNumberVector = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unknownDashedWordVectors")) {
            this.trainOptions.unknownDashedWordVectors = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noUnknownDashedWordVectors")) {
            this.trainOptions.unknownDashedWordVectors = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unknownCapsVector")) {
            this.trainOptions.unknownCapsVector = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noUnknownCapsVector")) {
            this.trainOptions.unknownCapsVector = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unknownChineseYearVector")) {
            this.trainOptions.unknownChineseYearVector = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noUnknownChineseYearVector")) {
            this.trainOptions.unknownChineseYearVector = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unknownChineseNumberVector")) {
            this.trainOptions.unknownChineseNumberVector = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noUnknownChineseNumberVector")) {
            this.trainOptions.unknownChineseNumberVector = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unknownChinesePercentVector")) {
            this.trainOptions.unknownChinesePercentVector = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noUnknownChinesePercentVector")) {
            this.trainOptions.unknownChinesePercentVector = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-dvSimplifiedModel")) {
            this.trainOptions.dvSimplifiedModel = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-scalingForInit")) {
            this.trainOptions.scalingForInit = Double.parseDouble(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-rerankerKBest")) {
            this.rerankerKBest = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-baseParserWeight")) {
            this.baseParserWeight = Double.parseDouble(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-unkWord")) {
            this.trainOptions.unkWord = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-lowercaseWordVectors")) {
            this.trainOptions.lowercaseWordVectors = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noLowercaseWordVectors")) {
            this.trainOptions.lowercaseWordVectors = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-transformMatrixType")) {
            this.trainOptions.transformMatrixType = TrainOptions.TransformMatrixType.valueOf(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-useContextWords")) {
            this.trainOptions.useContextWords = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noUseContextWords")) {
            this.trainOptions.useContextWords = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-trainWordVectors")) {
            this.trainOptions.trainWordVectors = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noTrainWordVectors")) {
            this.trainOptions.trainWordVectors = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markStrahler")) {
            this.trainOptions.markStrahler = true;
            ++i;
        }
        return i;
    }

    public TreebankLanguagePack langpack() {
        return this.tlpParams.treebankLanguagePack();
    }

    public TrainOptions newTrainOptions() {
        return new TrainOptions();
    }

    public TestOptions newTestOptions() {
        return new TestOptions();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.testOptions = this.newTestOptions();
    }

    public void display() {
        System.err.println("Options parameters:");
        this.writeData(new PrintWriter(System.err));
    }

    public void writeData(Writer w) {
        PrintWriter out2 = new PrintWriter(w);
        StringBuilder sb = new StringBuilder();
        sb.append(this.lexOptions.toString());
        sb.append("parserParams ").append(this.tlpParams.getClass().getName()).append("\n");
        sb.append("forceCNF ").append(this.forceCNF).append("\n");
        sb.append("doPCFG ").append(this.doPCFG).append("\n");
        sb.append("doDep ").append(this.doDep).append("\n");
        sb.append("freeDependencies ").append(this.freeDependencies).append("\n");
        sb.append("directional ").append(this.directional).append("\n");
        sb.append("genStop ").append(this.genStop).append("\n");
        sb.append("distance ").append(this.distance).append("\n");
        sb.append("coarseDistance ").append(this.coarseDistance).append("\n");
        sb.append("dcTags ").append(this.dcTags).append("\n");
        sb.append("nPrune ").append(this.nodePrune).append("\n");
        out2.print(sb.toString());
        out2.flush();
    }

    public void readData(BufferedReader in) throws IOException {
        this.lexOptions.readData(in);
        String line = in.readLine();
        String value = line.substring(line.indexOf(32) + 1);
        try {
            this.tlpParams = (TreebankLangParserParams)Class.forName(value).newInstance();
        }
        catch (Exception e) {
            IOException ioe = new IOException("Problem instantiating parserParams: " + line);
            ioe.initCause(e);
            throw ioe;
        }
        line = in.readLine();
        if (line.matches("^forceCNF.*")) {
            value = line.substring(line.indexOf(32) + 1);
            this.forceCNF = Boolean.parseBoolean(value);
            line = in.readLine();
        }
        value = line.substring(line.indexOf(32) + 1);
        this.doPCFG = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.doDep = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.freeDependencies = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.directional = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.genStop = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.distance = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.coarseDistance = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.dcTags = Boolean.parseBoolean(value);
        line = in.readLine();
        if (!line.matches("^nPrune.*")) {
            throw new RuntimeException("Expected nPrune, found: " + line);
        }
        value = line.substring(line.indexOf(32) + 1);
        this.nodePrune = Boolean.parseBoolean(value);
        line = in.readLine();
        if (line.length() != 0) {
            throw new RuntimeException("Expected blank line, found: " + line);
        }
    }

    public static class LexOptions
    implements Serializable {
        public int useUnknownWordSignatures = 0;
        public static final String DEFAULT_WORD_VECTOR_FILE = "/scr/nlp/deeplearning/datasets/turian/embeddings-scaled.EMBEDDING_SIZE=25.txt";
        public String wordVectorFile = "/scr/nlp/deeplearning/datasets/turian/embeddings-scaled.EMBEDDING_SIZE=25.txt";
        public int numHid = 0;
        public int smoothInUnknownsThreshold = 100;
        public boolean smartMutation = false;
        public boolean useUnicodeType = false;
        public int unknownSuffixSize = 1;
        public int unknownPrefixSize = 1;
        public String uwModelTrainer;
        public boolean flexiTag = false;
        public boolean useSignatureForKnownSmoothing;
        public String wordClassesFile;
        private static final long serialVersionUID = 2805351374506855632L;
        private static final String[] params = new String[]{"useUnknownWordSignatures", "smoothInUnknownsThreshold", "smartMutation", "useUnicodeType", "unknownSuffixSize", "unknownPrefixSize", "flexiTag", "useSignatureForKnownSmoothing", "wordClassesFile"};

        public String toString() {
            return params[0] + " " + this.useUnknownWordSignatures + "\n" + params[1] + " " + this.smoothInUnknownsThreshold + "\n" + params[2] + " " + this.smartMutation + "\n" + params[3] + " " + this.useUnicodeType + "\n" + params[4] + " " + this.unknownSuffixSize + "\n" + params[5] + " " + this.unknownPrefixSize + "\n" + params[6] + " " + this.flexiTag + "\n" + params[7] + " " + this.useSignatureForKnownSmoothing + "\n" + params[8] + " " + this.wordClassesFile + "\n";
        }

        public void readData(BufferedReader in) throws IOException {
            block11: for (int i = 0; i < params.length; ++i) {
                String line = in.readLine();
                int idx = line.indexOf(32);
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1);
                if (!key.equalsIgnoreCase(params[i])) {
                    System.err.println("Yikes!!! Expected " + params[i] + " got " + key);
                }
                switch (i) {
                    case 0: {
                        this.useUnknownWordSignatures = Integer.parseInt(value);
                        continue block11;
                    }
                    case 1: {
                        this.smoothInUnknownsThreshold = Integer.parseInt(value);
                        continue block11;
                    }
                    case 2: {
                        this.smartMutation = Boolean.parseBoolean(value);
                        continue block11;
                    }
                    case 3: {
                        this.useUnicodeType = Boolean.parseBoolean(value);
                        continue block11;
                    }
                    case 4: {
                        this.unknownSuffixSize = Integer.parseInt(value);
                        continue block11;
                    }
                    case 5: {
                        this.unknownPrefixSize = Integer.parseInt(value);
                        continue block11;
                    }
                    case 6: {
                        this.flexiTag = Boolean.parseBoolean(value);
                        continue block11;
                    }
                    case 7: {
                        this.useSignatureForKnownSmoothing = Boolean.parseBoolean(value);
                        continue block11;
                    }
                    case 8: {
                        this.wordClassesFile = value;
                    }
                }
            }
        }
    }
}

