/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeNode;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeFunctions;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MutableInteger;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class Trees {
    private static final LabeledScoredTreeFactory defaultTreeFactory = new LabeledScoredTreeFactory();

    private Trees() {
    }

    public static int leftEdge(Tree t, Tree root) {
        MutableInteger i = new MutableInteger(0);
        if (Trees.leftEdge(t, root, i)) {
            return i.intValue();
        }
        throw new RuntimeException("Tree is not a descendant of root.");
    }

    static boolean leftEdge(Tree t, Tree t1, MutableInteger i) {
        if (t == t1) {
            return true;
        }
        if (t1.isLeaf()) {
            int j = t1.yield().size();
            i.set(i.intValue() + j);
            return false;
        }
        for (Tree kid : t1.children()) {
            if (!Trees.leftEdge(t, kid, i)) continue;
            return true;
        }
        return false;
    }

    public static int rightEdge(Tree t, Tree root) {
        MutableInteger i = new MutableInteger(root.yield().size());
        if (Trees.rightEdge(t, root, i)) {
            return i.intValue();
        }
        throw new RuntimeException("Tree is not a descendant of root.");
    }

    static boolean rightEdge(Tree t, Tree t1, MutableInteger i) {
        if (t == t1) {
            return true;
        }
        if (t1.isLeaf()) {
            int j = t1.yield().size();
            i.set(i.intValue() - j);
            return false;
        }
        Tree[] kids = t1.children();
        for (int j = kids.length - 1; j >= 0; --j) {
            if (!Trees.rightEdge(t, kids[j], i)) continue;
            return true;
        }
        return false;
    }

    public static Tree lexicalize(Tree t, HeadFinder hf) {
        Function<Tree, Tree> a = TreeFunctions.getLabeledTreeToCategoryWordTagTreeFunction();
        Tree t1 = a.apply(t);
        t1.percolateHeads(hf);
        return t1;
    }

    public static List<Tree> leaves(Tree t) {
        ArrayList<Tree> l = new ArrayList<Tree>();
        Trees.leaves(t, l);
        return l;
    }

    private static void leaves(Tree t, List<Tree> l) {
        if (t.isLeaf()) {
            l.add(t);
        } else {
            for (Tree kid : t.children()) {
                Trees.leaves(kid, l);
            }
        }
    }

    public static List<Tree> preTerminals(Tree t) {
        ArrayList<Tree> l = new ArrayList<Tree>();
        Trees.preTerminals(t, l);
        return l;
    }

    private static void preTerminals(Tree t, List<Tree> l) {
        if (t.isPreTerminal()) {
            l.add(t);
        } else {
            for (Tree kid : t.children()) {
                Trees.preTerminals(kid, l);
            }
        }
    }

    public static List<Label> leafLabels(Tree t) {
        ArrayList<Label> l = new ArrayList<Label>();
        Trees.leafLabels(t, l);
        return l;
    }

    private static void leafLabels(Tree t, List<Label> l) {
        if (t.isLeaf()) {
            l.add(t.label());
        } else {
            for (Tree kid : t.children()) {
                Trees.leafLabels(kid, l);
            }
        }
    }

    public static List<CoreLabel> taggedLeafLabels(Tree t) {
        ArrayList<CoreLabel> l = new ArrayList<CoreLabel>();
        Trees.taggedLeafLabels(t, l);
        return l;
    }

    private static void taggedLeafLabels(Tree t, List<CoreLabel> l) {
        if (t.isPreTerminal()) {
            CoreLabel fl = (CoreLabel)t.getChild(0).label();
            fl.set(CoreAnnotations.TagLabelAnnotation.class, t.label());
            l.add(fl);
        } else {
            for (Tree kid : t.children()) {
                Trees.taggedLeafLabels(kid, l);
            }
        }
    }

    public static void setLeafTagsIfUnset(Tree tree) {
        if (tree.isPreTerminal()) {
            Tree leaf = tree.children()[0];
            if (!(leaf.label() instanceof HasTag)) {
                return;
            }
            HasTag label = (HasTag)((Object)leaf.label());
            if (label.tag() == null) {
                label.setTag(tree.value());
            }
        } else {
            for (Tree child : tree.children()) {
                Trees.setLeafTagsIfUnset(child);
            }
        }
    }

    public static void setLeafLabels(Tree tree, List<Label> labels) {
        Iterator leafIterator = tree.getLeaves().iterator();
        Iterator<Label> labelIterator = labels.iterator();
        while (leafIterator.hasNext() && labelIterator.hasNext()) {
            Tree leaf = (Tree)leafIterator.next();
            Label label = labelIterator.next();
            leaf.setLabel(label);
        }
        if (leafIterator.hasNext()) {
            throw new IllegalArgumentException("Tree had more leaves than the labels provided");
        }
        if (labelIterator.hasNext()) {
            throw new IllegalArgumentException("More labels provided than tree had leaves");
        }
    }

    public static Tree maximalProjection(Tree head, Tree root, HeadFinder hf) {
        Tree projection = head;
        if (projection == root) {
            return root;
        }
        Tree parent = projection.parent(root);
        while (hf.determineHead(parent) == projection) {
            projection = parent;
            if (projection == root) {
                return root;
            }
            parent = projection.parent(root);
        }
        return projection;
    }

    public static Tree applyToProjections(TreeVisitor v, Tree head, Tree root, HeadFinder hf) {
        Tree projection = head;
        Tree parent = projection.parent(root);
        if (parent == null && projection != root) {
            return null;
        }
        v.visitTree(projection);
        if (projection == root) {
            return root;
        }
        while (hf.determineHead(parent) == projection) {
            projection = parent;
            v.visitTree(projection);
            if (projection == root) {
                return root;
            }
            parent = projection.parent(root);
        }
        return projection;
    }

    public static Tree getTerminal(Tree tree, int n) {
        return Trees.getTerminal(tree, new MutableInteger(0), n);
    }

    static Tree getTerminal(Tree tree, MutableInteger i, int n) {
        if (i.intValue() == n) {
            if (tree.isLeaf()) {
                return tree;
            }
            return Trees.getTerminal(tree.children()[0], i, n);
        }
        if (tree.isLeaf()) {
            i.set(i.intValue() + tree.yield().size());
            return null;
        }
        for (Tree kid : tree.children()) {
            Tree result = Trees.getTerminal(kid, i, n);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Tree getPreTerminal(Tree tree, int n) {
        return Trees.getPreTerminal(tree, new MutableInteger(0), n);
    }

    static Tree getPreTerminal(Tree tree, MutableInteger i, int n) {
        if (i.intValue() == n) {
            if (tree.isPreTerminal()) {
                return tree;
            }
            return Trees.getPreTerminal(tree.children()[0], i, n);
        }
        if (tree.isPreTerminal()) {
            i.set(i.intValue() + tree.yield().size());
            return null;
        }
        for (Tree kid : tree.children()) {
            Tree result = Trees.getPreTerminal(kid, i, n);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static List<String> localTreeAsCatList(Tree t) {
        ArrayList<String> l = new ArrayList<String>(t.children().length + 1);
        l.add(t.label().value());
        for (int i = 0; i < t.children().length; ++i) {
            l.add(t.children()[i].label().value());
        }
        return l;
    }

    public static int objectEqualityIndexOf(Tree parent, Tree daughter) {
        for (int i = 0; i < parent.children().length; ++i) {
            if (daughter != parent.children()[i]) continue;
            return i;
        }
        return -1;
    }

    public static String toStructureDebugString(Tree t) {
        String tCl = StringUtils.getShortClassName(t);
        String tfCl = StringUtils.getShortClassName(t.treeFactory());
        String lCl = StringUtils.getShortClassName(t.label());
        String lfCl = StringUtils.getShortClassName(t.label().labelFactory());
        Set<String> otherClasses = Generics.newHashSet();
        String leafLabels = null;
        String tagLabels = null;
        String phraseLabels = null;
        String leaves = null;
        String nodes = null;
        for (Tree st : t) {
            String stCl = StringUtils.getShortClassName(st);
            String stfCl = StringUtils.getShortClassName(st.treeFactory());
            String slCl = StringUtils.getShortClassName(st.label());
            String slfCl = StringUtils.getShortClassName(st.label().labelFactory());
            if (!tCl.equals(stCl)) {
                otherClasses.add(stCl);
            }
            if (!tfCl.equals(stfCl)) {
                otherClasses.add(stfCl);
            }
            if (!lCl.equals(slCl)) {
                otherClasses.add(slCl);
            }
            if (!lfCl.equals(slfCl)) {
                otherClasses.add(slfCl);
            }
            if (st.isPhrasal()) {
                if (nodes == null) {
                    nodes = stCl;
                } else if (!nodes.equals(stCl)) {
                    nodes = "mixed";
                }
                if (phraseLabels == null) {
                    phraseLabels = slCl;
                    continue;
                }
                if (phraseLabels.equals(slCl)) continue;
                phraseLabels = "mixed";
                continue;
            }
            if (st.isPreTerminal()) {
                if (nodes == null) {
                    nodes = stCl;
                } else if (!nodes.equals(stCl)) {
                    nodes = "mixed";
                }
                if (tagLabels == null) {
                    tagLabels = StringUtils.getShortClassName(slCl);
                    continue;
                }
                if (tagLabels.equals(slCl)) continue;
                tagLabels = "mixed";
                continue;
            }
            if (st.isLeaf()) {
                if (leaves == null) {
                    leaves = stCl;
                } else if (!leaves.equals(stCl)) {
                    leaves = "mixed";
                }
                if (leafLabels == null) {
                    leafLabels = slCl;
                    continue;
                }
                if (leafLabels.equals(slCl)) continue;
                leafLabels = "mixed";
                continue;
            }
            throw new IllegalStateException("Bad tree state: " + t);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Tree with root of class ").append(tCl).append(" and factory ").append(tfCl);
        sb.append(" and root label class ").append(lCl).append(" and factory ").append(lfCl);
        if (!otherClasses.isEmpty()) {
            sb.append(" and the following classes also found within the tree: ").append(otherClasses);
            return " with " + nodes + " interior nodes and " + leaves + " leaves, and " + phraseLabels + " phrase labels, " + tagLabels + " tag labels, and " + leafLabels + " leaf labels.";
        }
        sb.append(" (and uniform use of these Tree and Label classes throughout the tree).");
        return sb.toString();
    }

    public static Tree toFlatTree(List<HasWord> s) {
        return Trees.toFlatTree(s, new StringLabelFactory());
    }

    public static Tree toFlatTree(List<? extends HasWord> s, LabelFactory lf) {
        ArrayList<Tree> daughters = new ArrayList<Tree>(s.size());
        for (HasWord hasWord : s) {
            LabeledScoredTreeNode wordNode = new LabeledScoredTreeNode(lf.newLabel(hasWord.word()));
            if (hasWord instanceof TaggedWord) {
                TaggedWord taggedWord = (TaggedWord)hasWord;
                wordNode = new LabeledScoredTreeNode((Label)new StringLabel(taggedWord.tag()), Collections.singletonList(wordNode));
            } else {
                wordNode = new LabeledScoredTreeNode(lf.newLabel("WD"), Collections.singletonList(wordNode));
            }
            daughters.add(wordNode);
        }
        return new LabeledScoredTreeNode((Label)new StringLabel("S"), daughters);
    }

    public static String treeToLatex(Tree t) {
        StringBuilder connections = new StringBuilder();
        StringBuilder hierarchy = new StringBuilder();
        Trees.treeToLatexHelper(t, connections, hierarchy, 0, 1, 0);
        return "\\tree" + hierarchy + '\n' + connections + '\n';
    }

    private static int treeToLatexHelper(Tree t, StringBuilder c, StringBuilder h, int n, int nextN, int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        h.append('\n').append((CharSequence)sb);
        h.append("{\\").append(t.isLeaf() ? "" : "n").append("tnode{z").append(n).append("}{").append(t.label()).append('}');
        if (!t.isLeaf()) {
            for (int k = 0; k < t.children().length; ++k) {
                h.append(", ");
                c.append("\\nodeconnect{z").append(n).append("}{z").append(nextN).append("}\n");
                nextN = Trees.treeToLatexHelper(t.children()[k], c, h, nextN, nextN + 1, indent + 1);
            }
        }
        h.append('}');
        return nextN;
    }

    public static String treeToLatexEven(Tree t) {
        StringBuilder connections = new StringBuilder();
        StringBuilder hierarchy = new StringBuilder();
        int maxDepth = t.depth();
        Trees.treeToLatexEvenHelper(t, connections, hierarchy, 0, 1, 0, 0, maxDepth);
        return "\\tree" + hierarchy + '\n' + connections + '\n';
    }

    private static int treeToLatexEvenHelper(Tree t, StringBuilder c, StringBuilder h, int n, int nextN, int indent, int curDepth, int maxDepth) {
        int pad;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        h.append('\n').append((CharSequence)sb);
        int tDepth = t.depth();
        if (tDepth == 0 && tDepth + curDepth < maxDepth) {
            for (pad = 0; pad < maxDepth - tDepth - curDepth; ++pad) {
                h.append("{\\ntnode{pad}{}, ");
            }
        }
        h.append("{\\ntnode{z").append(n).append("}{").append(t.label()).append('}');
        if (!t.isLeaf()) {
            for (int k = 0; k < t.children().length; ++k) {
                h.append(", ");
                c.append("\\nodeconnect{z").append(n).append("}{z").append(nextN).append("}\n");
                nextN = Trees.treeToLatexEvenHelper(t.children()[k], c, h, nextN, nextN + 1, indent + 1, curDepth + 1, maxDepth);
            }
        }
        if (tDepth == 0 && tDepth + curDepth < maxDepth) {
            for (pad = 0; pad < maxDepth - tDepth - curDepth; ++pad) {
                h.append('}');
            }
        }
        h.append('}');
        return nextN;
    }

    static String texTree(Tree t) {
        return Trees.treeToLatex(t);
    }

    static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '^') {
                sb.append('\\');
            }
            sb.append(c);
            if (c != '^') continue;
            sb.append("{}");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        Tree tree;
        int i;
        for (i = 0; i < args.length; ++i) {
            tree = Tree.valueOf(args[i]);
            if (tree == null) {
                tree = Tree.valueOf(IOUtils.slurpFile(args[i]));
            }
            if (tree == null) continue;
            System.out.println(Trees.escape(Trees.texTree(tree)));
        }
        if (i == 0) {
            tree = new PennTreeReader(new BufferedReader(new InputStreamReader(System.in)), new LabeledScoredTreeFactory(new StringLabelFactory())).readTree();
            System.out.println(Trees.escape(Trees.texTree(tree)));
        }
    }

    public static Tree normalizeTree(Tree tree, TreeNormalizer tn, TreeFactory tf) {
        for (Tree node : tree) {
            if (node.isLeaf()) {
                node.label().setValue(tn.normalizeTerminal(node.label().value()));
                continue;
            }
            node.label().setValue(tn.normalizeNonterminal(node.label().value()));
        }
        return tn.normalizeWholeTree(tree, tf);
    }

    public static Tree getLeaf(Tree tree, int i) {
        int count = -1;
        for (Tree next : tree) {
            if (next.isLeaf()) {
                ++count;
            }
            if (count != i) continue;
            return next;
        }
        return null;
    }

    public static Tree getLowestCommonAncestor(List<Tree> nodes, Tree root) {
        ArrayList<List<Tree>> paths = new ArrayList<List<Tree>>();
        int min = Integer.MAX_VALUE;
        for (Tree t : nodes) {
            List<Tree> path = Trees.pathFromRoot(t, root);
            if (path == null) {
                return null;
            }
            min = Math.min(min, path.size());
            paths.add(path);
        }
        Tree commonAncestor = null;
        for (int i = 0; i < min; ++i) {
            Tree ancestor = (Tree)((List)paths.get(0)).get(i);
            boolean quit = false;
            for (List list : paths) {
                if (((Tree)list.get(i)).equals(ancestor)) continue;
                quit = true;
                break;
            }
            if (quit) break;
            commonAncestor = ancestor;
        }
        return commonAncestor;
    }

    public static List<String> pathNodeToNode(Tree from, Tree to, Tree root) {
        int last;
        List<Tree> fromPath = Trees.pathFromRoot(from, root);
        if (fromPath == null) {
            return null;
        }
        List<Tree> toPath = Trees.pathFromRoot(to, root);
        if (toPath == null) {
            return null;
        }
        int min = fromPath.size() <= toPath.size() ? fromPath.size() : toPath.size();
        Tree lastNode = null;
        for (last = 0; last < min && fromPath.get(last).equals(toPath.get(last)); ++last) {
            lastNode = fromPath.get(last);
        }
        ArrayList<String> totalPath = new ArrayList<String>();
        for (int i = fromPath.size() - 1; i >= last; --i) {
            Tree t = fromPath.get(i);
            totalPath.add("up-" + t.label().value());
        }
        if (lastNode != null) {
            totalPath.add("up-" + lastNode.label().value());
        }
        for (Tree t : toPath) {
            totalPath.add("down-" + t.label().value());
        }
        return totalPath;
    }

    public static List<Tree> pathFromRoot(Tree t, Tree root) {
        if (t == root) {
            ArrayList<Tree> l = new ArrayList<Tree>(1);
            l.add(t);
            return l;
        }
        if (root == null) {
            return null;
        }
        return root.dominationPath(t);
    }

    public static void replaceNode(Tree node, Tree node1, Tree t) {
        if (t.isLeaf()) {
            return;
        }
        Tree[] kids = t.children();
        ArrayList<Tree> newKids = new ArrayList<Tree>(kids.length);
        for (Tree kid : kids) {
            if (kid != node) {
                newKids.add(kid);
                Trees.replaceNode(node, node1, kid);
                continue;
            }
            newKids.add(node1);
        }
        t.setChildren(newKids);
    }

    public static Tree getLowestCommonAncestor(Tree t1, Tree t2, Tree root) {
        List<Tree> t1Path = Trees.pathFromRoot(t1, root);
        List<Tree> t2Path = Trees.pathFromRoot(t2, root);
        if (t1Path == null || t2Path == null) {
            return null;
        }
        int min = Math.min(t1Path.size(), t2Path.size());
        Tree commonAncestor = null;
        for (int i = 0; i < min && t1Path.get(i).equals(t2Path.get(i)); ++i) {
            commonAncestor = t1Path.get(i);
        }
        return commonAncestor;
    }

    public static Tree readTree(String ptbTreeString, TreeFactory treeFactory) {
        try {
            PennTreeReader ptr = new PennTreeReader(new StringReader(ptbTreeString), treeFactory);
            return ptr.readTree();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Tree readTree(String str) {
        return Trees.readTree(str, defaultTreeFactory);
    }

    public static void outputTreeLabels(Tree tree) {
        Trees.outputTreeLabels(tree, 0);
    }

    public static void outputTreeLabels(Tree tree, int depth) {
        for (int i = 0; i < depth; ++i) {
            System.out.print(" ");
        }
        System.out.println(tree.label());
        for (Tree child : tree.children()) {
            Trees.outputTreeLabels(child, depth + 1);
        }
    }

    public static void convertToCoreLabels(Tree tree) {
        Label l = tree.label();
        if (!(l instanceof CoreLabel)) {
            CoreLabel cl = new CoreLabel();
            cl.setValue(l.value());
            tree.setLabel(cl);
        }
        for (Tree kid : tree.children()) {
            Trees.convertToCoreLabels(kid);
        }
    }

    public static void setSentIndex(Tree tree, int sentIndex) {
        ArrayList<Label> leaves = tree.yield();
        for (Label leaf : leaves) {
            if (!(leaf instanceof CoreLabel)) {
                throw new IllegalArgumentException("Only works on CoreLabel");
            }
            ((CoreLabel)leaf).setSentIndex(sentIndex);
        }
    }
}

