/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.io.EncodingPrintWriter;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.process.AbstractTokenizer;
import edu.stanford.nlp.trees.international.pennchinese.CHTBLexer;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class CHTBTokenizer
extends AbstractTokenizer<String> {
    private static final Redwood.RedwoodChannels log = Redwood.channels(CHTBTokenizer.class);
    private final CHTBLexer lexer;

    public CHTBTokenizer(Reader r) {
        this.lexer = new CHTBLexer(r);
    }

    @Override
    protected String getNext() {
        try {
            int a;
            while ((a = this.lexer.yylex()) == 0) {
            }
            if (a == -1) {
                return null;
            }
            return this.lexer.match();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            log.error("Usage: CHTBTokenizer inputFile encoding");
        }
        String encoding = args[1];
        BufferedReader in = IOUtils.readerFromString(args[0], encoding);
        CHTBTokenizer st = new CHTBTokenizer(in);
        while (st.hasNext()) {
            String s = (String)st.next();
            EncodingPrintWriter.out.println(s, encoding);
        }
    }
}

