/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.io;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.tagger.io.TaggedFileReader;
import edu.stanford.nlp.tagger.io.TaggedFileRecord;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Treebank;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class TreeTaggedFileReader
implements TaggedFileReader {
    private final Treebank treebank;
    private final String filename;
    private final TreeReaderFactory trf;
    private final TreeTransformer transformer;
    private final TreeNormalizer normalizer;
    private final Predicate<Tree> treeFilter;
    private final Iterator<Tree> treeIterator;
    private Tree next = null;

    public TreeTaggedFileReader(TaggedFileRecord record) {
        this.filename = record.filename();
        this.trf = record.trf == null ? new LabeledScoredTreeReaderFactory() : record.trf;
        this.transformer = record.treeTransformer;
        this.normalizer = record.treeNormalizer;
        this.treeFilter = record.treeFilter;
        this.treebank = new DiskTreebank(this.trf, record.encoding);
        if (record.treeRange != null) {
            this.treebank.loadPath(this.filename, (FileFilter)record.treeRange);
        } else {
            this.treebank.loadPath(this.filename);
        }
        this.treeIterator = this.treebank.iterator();
        this.findNext();
    }

    @Override
    public Iterator<List<TaggedWord>> iterator() {
        return this;
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public List<TaggedWord> next() {
        if (this.next == null) {
            throw new NoSuchElementException("Iterator exhausted.");
        }
        Tree t = this.next;
        if (this.normalizer != null) {
            t = this.normalizer.normalizeWholeTree(t, t.treeFactory());
        }
        if (this.transformer != null) {
            t = t.transform(this.transformer);
        }
        this.findNext();
        return t.taggedYield();
    }

    private void findNext() {
        while (this.treeIterator.hasNext()) {
            this.next = this.treeIterator.next();
            if (this.treeFilter != null && !this.treeFilter.test(this.next)) continue;
            return;
        }
        this.next = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

