/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.AdjoinNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.AuxiliaryTree;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Map;

public class AdjoinToFootNode
extends AdjoinNode {
    private static Redwood.RedwoodChannels log = Redwood.channels(AdjoinToFootNode.class);

    public AdjoinToFootNode(AuxiliaryTree t, TsurgeonPattern p) {
        super("adjoinF", t, p);
    }

    @Override
    public TsurgeonMatcher matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
        return new Matcher(newNodeNames, coindexer);
    }

    private class Matcher
    extends TsurgeonMatcher {
        public Matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
            super(AdjoinToFootNode.this, newNodeNames, coindexer);
        }

        @Override
        public Tree evaluate(Tree tree, TregexMatcher tregex) {
            Tree targetNode = this.childMatcher[0].evaluate(tree, tregex);
            Tree parent = targetNode.parent(tree);
            AuxiliaryTree ft = AdjoinToFootNode.this.adjunctionTree().copy(this, tree.treeFactory(), tree.label().labelFactory());
            Tree parentOfFoot = ft.foot.parent(ft.tree);
            if (parentOfFoot == null) {
                log.info("Warning: adjoin to foot for depth-1 auxiliary tree has no effect.");
                return tree;
            }
            int i = parentOfFoot.objectIndexOf(ft.foot);
            if (parent == null) {
                parentOfFoot.setChild(i, targetNode);
                return ft.tree;
            }
            int j = parent.objectIndexOf(targetNode);
            parent.setChild(j, ft.tree);
            parentOfFoot.setChild(i, targetNode);
            return tree;
        }
    }
}

