/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.optimization.AbstractStochasticCachingDiffFunction;
import edu.stanford.nlp.optimization.Evaluator;
import edu.stanford.nlp.optimization.Function;
import edu.stanford.nlp.optimization.HasEvaluators;
import edu.stanford.nlp.optimization.Minimizer;
import edu.stanford.nlp.optimization.StochasticCalculateMethods;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class StochasticMinimizer<T extends Function>
implements Minimizer<T>,
HasEvaluators {
    private static Redwood.RedwoodChannels log = Redwood.channels(StochasticMinimizer.class);
    public boolean outputIterationsToFile = false;
    public int outputFrequency = 1000;
    public double gain = 0.1;
    protected double[] x;
    protected double[] newX;
    protected double[] grad;
    protected double[] newGrad;
    protected double[] v;
    protected int numBatches;
    protected int k;
    protected int bSize = 15;
    protected boolean quiet = false;
    protected List<double[]> gradList = null;
    protected int memory = 10;
    protected int numPasses = -1;
    protected Random gen = new Random(1L);
    protected PrintWriter file = null;
    protected PrintWriter infoFile = null;
    protected long maxTime = Long.MAX_VALUE;
    private int evaluateIters = 0;
    private Evaluator[] evaluators;
    protected static final NumberFormat nf = new DecimalFormat("0.000E0");

    public void shutUp() {
        this.quiet = true;
    }

    protected abstract String getName();

    protected abstract void takeStep(AbstractStochasticCachingDiffFunction var1);

    @Override
    public void setEvaluators(int iters, Evaluator[] evaluators) {
        this.evaluateIters = iters;
        this.evaluators = evaluators;
    }

    protected static double gainSchedule(int it, double tau) {
        return tau / (tau + (double)it);
    }

    protected static double[] smooth(List<double[]> toSmooth) {
        double[] smoothed = new double[toSmooth.get(0).length];
        for (double[] thisArray : toSmooth) {
            ArrayMath.pairwiseAddInPlace(smoothed, thisArray);
        }
        ArrayMath.multiplyInPlace(smoothed, 1.0 / (double)toSmooth.size());
        return smoothed;
    }

    private void initFiles() {
        if (this.outputIterationsToFile) {
            String fileName = this.getName() + ".output";
            String infoName = this.getName() + ".info";
            try {
                this.file = new PrintWriter(new FileOutputStream(fileName), true);
                this.infoFile = new PrintWriter(new FileOutputStream(infoName), true);
            }
            catch (IOException e) {
                log.info("Caught IOException outputting data to file: " + e.getMessage());
                System.exit(1);
            }
        }
    }

    public abstract Pair<Integer, Double> tune(Function var1, double[] var2, long var3);

    public double tuneDouble(Function function, double[] initial, long msPerTest, PropertySetter<Double> ps, double lower, double upper) {
        return this.tuneDouble(function, initial, msPerTest, ps, lower, upper, 0.001 * Math.abs(upper - lower));
    }

    public double tuneDouble(Function function, double[] initial, long msPerTest, PropertySetter<Double> ps, double lower, double upper, double TOL) {
        double[] xtest = new double[initial.length];
        this.maxTime = msPerTest;
        if (!(function instanceof AbstractStochasticCachingDiffFunction)) {
            throw new UnsupportedOperationException();
        }
        AbstractStochasticCachingDiffFunction dfunction = (AbstractStochasticCachingDiffFunction)function;
        ArrayList<Pair<Double, Double>> res = new ArrayList<Pair<Double, Double>>();
        Pair<Double, Double> best = new Pair<Double, Double>(lower, Double.POSITIVE_INFINITY);
        Pair<Double, Double> low = new Pair<Double, Double>(lower, Double.POSITIVE_INFINITY);
        Pair<Double, Double> high = new Pair<Double, Double>(upper, Double.POSITIVE_INFINITY);
        Pair<Double, Double> cur = new Pair<Double, Double>();
        Pair<Double, Double> tmp = new Pair<Double, Double>();
        ArrayList<Double> queue = new ArrayList<Double>();
        queue.add(lower);
        queue.add(upper);
        boolean toContinue = true;
        this.numPasses = 10000;
        do {
            System.arraycopy(initial, 0, xtest, 0, initial.length);
            cur.first = queue.size() != 0 ? queue.remove(0) : Double.valueOf(0.5 * (low.first() + high.first()));
            ps.set((Double)cur.first());
            log.info("");
            log.info("About to test with batch size:  " + this.bSize + "  gain: " + this.gain + " and  " + ps.toString() + " set to  " + cur.first());
            xtest = this.minimize(function, 1.0E-100, xtest);
            cur.second = Double.isNaN(xtest[0]) ? Double.valueOf(Double.POSITIVE_INFINITY) : Double.valueOf(dfunction.valueAt(xtest));
            if ((Double)cur.second() < best.second()) {
                StochasticMinimizer.copyPair(best, tmp);
                StochasticMinimizer.copyPair(cur, best);
                if (tmp.first() > best.first()) {
                    StochasticMinimizer.copyPair(tmp, high);
                } else {
                    StochasticMinimizer.copyPair(tmp, low);
                }
                queue.add(0.5 * (cur.first() + high.first()));
            } else if ((Double)cur.first() < best.first()) {
                StochasticMinimizer.copyPair(cur, low);
            } else if (cur.first() > best.first()) {
                StochasticMinimizer.copyPair(cur, high);
            }
            if (Math.abs(low.first() - high.first()) < TOL) {
                toContinue = false;
            }
            res.add(new Pair<Double, Double>(cur.first(), cur.second()));
            log.info("");
            log.info("Final value is: " + nf.format(cur.second()));
            log.info("Optimal so far using " + ps.toString() + " is: " + best.first());
        } while (toContinue);
        log.info("-------------");
        log.info(" RESULTS          ");
        log.info(ps.getClass().toString());
        log.info("-------------");
        log.info("  val    ,    function after " + msPerTest + " ms");
        for (Pair pair : res) {
            log.info(pair.first() + "    ,    " + pair.second());
        }
        log.info("");
        log.info("");
        return best.first();
    }

    private static void copyPair(Pair<Double, Double> from, Pair<Double, Double> to) {
        to.first = from.first();
        to.second = from.second();
    }

    public double tuneGain(Function function, double[] initial, long msPerTest, double lower, double upper) {
        return this.tuneDouble(function, initial, msPerTest, new setGain(this), lower, upper);
    }

    public int tuneBatch(Function function, double[] initial, long msPerTest, int bStart) {
        double[] xTest = new double[initial.length];
        int bOpt = 0;
        double min = Double.POSITIVE_INFINITY;
        this.maxTime = msPerTest;
        double prev = Double.POSITIVE_INFINITY;
        if (!(function instanceof AbstractStochasticCachingDiffFunction)) {
            throw new UnsupportedOperationException();
        }
        AbstractStochasticCachingDiffFunction dFunction = (AbstractStochasticCachingDiffFunction)function;
        int b = bStart;
        boolean toContinue = true;
        do {
            System.arraycopy(initial, 0, xTest, 0, initial.length);
            log.info("");
            log.info("Testing with batch size:  " + b);
            this.bSize = b;
            this.shutUp();
            this.minimize(function, 1.0E-5, xTest);
            double result = dFunction.valueAt(xTest);
            if (result < min) {
                min = result;
                bOpt = this.bSize;
                b *= 2;
                prev = result;
            } else if (result < prev) {
                b *= 2;
                prev = result;
            } else if (result > prev) {
                toContinue = false;
            }
            log.info("");
            log.info("Final value is: " + nf.format(result));
            log.info("Optimal so far is:  batch size: " + bOpt);
        } while (toContinue);
        return bOpt;
    }

    public Pair<Integer, Double> tune(Function function, double[] initial, long msPerTest, List<Integer> batchSizes, List<Double> gains) {
        double[] xtest = new double[initial.length];
        int bOpt = 0;
        double gOpt = 0.0;
        double min = Double.POSITIVE_INFINITY;
        double[][] results = new double[batchSizes.size()][gains.size()];
        this.maxTime = msPerTest;
        for (int b = 0; b < batchSizes.size(); ++b) {
            for (int g = 0; g < gains.size(); ++g) {
                System.arraycopy(initial, 0, xtest, 0, initial.length);
                this.bSize = batchSizes.get(b);
                this.gain = gains.get(g);
                log.info("");
                log.info("Testing with batch size: " + this.bSize + "    gain:  " + nf.format(this.gain));
                this.quiet = true;
                this.minimize(function, 1.0E-100, xtest);
                results[b][g] = function.valueAt(xtest);
                if (results[b][g] < min) {
                    min = results[b][g];
                    bOpt = this.bSize;
                    gOpt = this.gain;
                }
                log.info("");
                log.info("Final value is: " + nf.format(results[b][g]));
                log.info("Optimal so far is:  batch size: " + bOpt + "   gain:  " + nf.format(gOpt));
            }
        }
        return new Pair<Integer, Double>(bOpt, gOpt);
    }

    protected void init(AbstractStochasticCachingDiffFunction func) {
    }

    private void doEvaluation(double[] x) {
        if (this.evaluators == null) {
            return;
        }
        for (Evaluator eval : this.evaluators) {
            this.sayln("  Evaluating: " + eval.toString());
            eval.evaluate(x);
        }
    }

    @Override
    public double[] minimize(Function function, double functionTolerance, double[] initial) {
        return this.minimize(function, functionTolerance, initial, -1);
    }

    @Override
    public double[] minimize(Function function, double functionTolerance, double[] initial, int maxIterations) {
        boolean have_max;
        if (!(function instanceof AbstractStochasticCachingDiffFunction)) {
            throw new UnsupportedOperationException();
        }
        AbstractStochasticCachingDiffFunction dfunction = (AbstractStochasticCachingDiffFunction)function;
        dfunction.method = StochasticCalculateMethods.GradientOnly;
        this.x = initial;
        this.grad = new double[this.x.length];
        this.newX = new double[this.x.length];
        this.gradList = new ArrayList<double[]>();
        this.numBatches = dfunction.dataDimension() / this.bSize;
        this.outputFrequency = (int)Math.ceil((double)this.numBatches / (double)this.outputFrequency);
        this.init(dfunction);
        this.initFiles();
        boolean bl = have_max = maxIterations > 0 || this.numPasses > 0;
        if (!have_max) {
            throw new UnsupportedOperationException("No maximum number of iterations has been specified.");
        }
        maxIterations = Math.max(maxIterations, this.numPasses) * this.numBatches;
        this.sayln("       Batchsize of: " + this.bSize);
        this.sayln("       Data dimension of: " + dfunction.dataDimension());
        this.sayln("       Batches per pass through data:  " + this.numBatches);
        this.sayln("       Max iterations is = " + maxIterations);
        if (this.outputIterationsToFile) {
            this.infoFile.println(function.domainDimension() + "; DomainDimension ");
            this.infoFile.println(this.bSize + "; batchSize ");
            this.infoFile.println(maxIterations + "; maxIterations");
            this.infoFile.println(this.numBatches + "; numBatches ");
            this.infoFile.println(this.outputFrequency + "; outputFrequency");
        }
        Timing total = new Timing();
        Timing current = new Timing();
        total.start();
        current.start();
        this.k = 0;
        while (this.k < maxIterations) {
            try {
                boolean doEval;
                boolean bl2 = doEval = this.k > 0 && this.evaluateIters > 0 && this.k % this.evaluateIters == 0;
                if (doEval) {
                    this.doEvaluation(this.x);
                }
                int pass = this.k / this.numBatches;
                int batch = this.k % this.numBatches;
                this.say("Iter: " + this.k + " pass " + pass + " batch " + batch);
                this.newGrad = this.k > 0 && this.gradList.size() >= this.memory ? this.gradList.remove(0) : new double[this.grad.length];
                dfunction.hasNewVals = true;
                System.arraycopy(dfunction.derivativeAt(this.x, this.v, this.bSize), 0, this.newGrad, 0, this.newGrad.length);
                ArrayMath.assertFinite(this.newGrad, "newGrad");
                this.gradList.add(this.newGrad);
                this.grad = StochasticMinimizer.smooth(this.gradList);
                this.takeStep(dfunction);
                ArrayMath.assertFinite(this.newX, "newX");
                if (this.outputIterationsToFile && this.k % this.outputFrequency == 0 && this.k != 0) {
                    double curVal = dfunction.valueAt(this.x);
                    this.say(" TrueValue{ " + curVal + " } ");
                    this.file.println(this.k + " , " + curVal + " , " + total.report());
                }
                if (this.k >= maxIterations) {
                    this.sayln("Stochastic Optimization complete.  Stopped after max iterations");
                    this.x = this.newX;
                    break;
                }
                if (total.report() >= this.maxTime) {
                    this.sayln("Stochastic Optimization complete.  Stopped after max time");
                    this.x = this.newX;
                    break;
                }
                System.arraycopy(this.newX, 0, this.x, 0, this.x.length);
                this.say("[" + (double)total.report() / 1000.0 + " s ");
                this.say("{" + (double)current.restart() / 1000.0 + " s}] ");
                this.say(" " + dfunction.lastValue());
                if (this.quiet) {
                    log.info(".");
                } else {
                    this.sayln("");
                }
            }
            catch (ArrayMath.InvalidElementException e) {
                log.info(e.toString());
                for (int i = 0; i < this.x.length; ++i) {
                    this.x[i] = Double.NaN;
                }
                break;
            }
            ++this.k;
        }
        if (this.evaluateIters > 0) {
            this.doEvaluation(this.x);
        }
        if (this.outputIterationsToFile) {
            this.infoFile.println(this.k + "; Iterations");
            this.infoFile.println((double)total.report() / 1000.0 + "; Completion Time");
            this.infoFile.println(dfunction.valueAt(this.x) + "; Finalvalue");
            this.infoFile.close();
            this.file.close();
            log.info("Output Files Closed");
        }
        this.say("Completed in: " + (double)total.report() / 1000.0 + " s");
        return this.x;
    }

    protected void sayln(String s) {
        if (!this.quiet) {
            log.info(s);
        }
    }

    protected void say(String s) {
        if (!this.quiet) {
            log.info(s);
        }
    }

    public static interface PropertySetter<T1> {
        public void set(T1 var1);
    }

    private class setGain
    implements PropertySetter<Double> {
        StochasticMinimizer<T> parent = null;

        public setGain(StochasticMinimizer<T> min) {
            this.parent = min;
        }

        @Override
        public void set(Double in) {
            StochasticMinimizer.this.gain = in;
        }
    }
}

