/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import org.ejml.EjmlParameters;
import org.ejml.data.D1Matrix64F;
import org.ejml.ops.MatrixIO;

public class BlockMatrix64F
extends D1Matrix64F {
    public int blockLength;

    public BlockMatrix64F(int n, int n2, int n3) {
        this.data = new double[n * n2];
        this.blockLength = n3;
        this.numRows = n;
        this.numCols = n2;
    }

    public BlockMatrix64F(int n, int n2) {
        this(n, n2, EjmlParameters.BLOCK_WIDTH);
    }

    public BlockMatrix64F() {
    }

    public void set(BlockMatrix64F blockMatrix64F) {
        this.blockLength = blockMatrix64F.blockLength;
        this.numRows = blockMatrix64F.numRows;
        this.numCols = blockMatrix64F.numCols;
        int n = this.numCols * this.numRows;
        if (this.data.length < n) {
            this.data = new double[n];
        }
        System.arraycopy(blockMatrix64F.data, 0, this.data, 0, n);
    }

    public static BlockMatrix64F wrap(double[] dArray, int n, int n2, int n3) {
        BlockMatrix64F blockMatrix64F = new BlockMatrix64F();
        blockMatrix64F.data = dArray;
        blockMatrix64F.numRows = n;
        blockMatrix64F.numCols = n2;
        blockMatrix64F.blockLength = n3;
        return blockMatrix64F;
    }

    @Override
    public double[] getData() {
        return this.data;
    }

    @Override
    public void reshape(int n, int n2, boolean bl) {
        if (n * n2 <= this.data.length) {
            this.numRows = n;
            this.numCols = n2;
        } else {
            double[] dArray = new double[n * n2];
            if (bl) {
                System.arraycopy(this.data, 0, dArray, 0, this.getNumElements());
            }
            this.numRows = n;
            this.numCols = n2;
            this.data = dArray;
        }
    }

    public void reshape(int n, int n2, int n3, boolean bl) {
        this.blockLength = n3;
        this.reshape(n, n2, bl);
    }

    @Override
    public int getIndex(int n, int n2) {
        int n3 = n / this.blockLength;
        int n4 = n2 / this.blockLength;
        int n5 = Math.min(this.numRows - n3 * this.blockLength, this.blockLength);
        int n6 = n3 * this.blockLength * this.numCols + n4 * n5 * this.blockLength;
        int n7 = Math.min(this.numCols - this.blockLength * n4, this.blockLength);
        return n6 + n7 * (n %= this.blockLength) + (n2 %= this.blockLength);
    }

    @Override
    public double get(int n, int n2) {
        return this.data[this.getIndex(n, n2)];
    }

    @Override
    public double unsafe_get(int n, int n2) {
        return this.data[this.getIndex(n, n2)];
    }

    @Override
    public void set(int n, int n2, double d) {
        this.data[this.getIndex((int)n, (int)n2)] = d;
    }

    @Override
    public void unsafe_set(int n, int n2, double d) {
        this.data[this.getIndex((int)n, (int)n2)] = d;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols() {
        return this.numCols;
    }

    @Override
    public int getNumElements() {
        return this.numRows * this.numCols;
    }

    @Override
    public void print() {
        MatrixIO.print(System.out, this);
    }

    public BlockMatrix64F copy() {
        BlockMatrix64F blockMatrix64F = new BlockMatrix64F(this.numRows, this.numCols, this.blockLength);
        blockMatrix64F.set(this);
        return blockMatrix64F;
    }
}

