/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.generic;

import java.util.Random;
import org.ejml.data.Matrix64F;

public class GenericMatrixOps {
    public static boolean isEquivalent(Matrix64F matrix64F, Matrix64F matrix64F2, double d) {
        if (matrix64F.numRows != matrix64F2.numRows || matrix64F.numCols != matrix64F2.numCols) {
            return false;
        }
        for (int i = 0; i < matrix64F.numRows; ++i) {
            for (int j = 0; j < matrix64F.numCols; ++j) {
                double d2 = Math.abs(matrix64F.get(i, j) - matrix64F2.get(i, j));
                if (!(d2 > d)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isIdentity(Matrix64F matrix64F, double d) {
        for (int i = 0; i < matrix64F.numRows; ++i) {
            for (int j = 0; j < matrix64F.numCols; ++j) {
                if (!(i == j ? Math.abs(matrix64F.get(i, j) - 1.0) > d : Math.abs(matrix64F.get(i, j)) > d)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEquivalentTriangle(boolean bl, Matrix64F matrix64F, Matrix64F matrix64F2, double d) {
        if (matrix64F.numRows != matrix64F2.numRows || matrix64F.numCols != matrix64F2.numCols) {
            return false;
        }
        if (bl) {
            for (int i = 0; i < matrix64F.numRows; ++i) {
                for (int j = i; j < matrix64F.numCols; ++j) {
                    double d2 = Math.abs(matrix64F.get(i, j) - matrix64F2.get(i, j));
                    if (!(d2 > d)) continue;
                    return false;
                }
            }
        } else {
            for (int i = 0; i < matrix64F.numCols; ++i) {
                for (int j = i; j < matrix64F.numRows; ++j) {
                    double d3 = Math.abs(matrix64F.get(j, i) - matrix64F2.get(j, i));
                    if (!(d3 > d)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void copy(Matrix64F matrix64F, Matrix64F matrix64F2) {
        int n = matrix64F.getNumCols();
        int n2 = matrix64F.getNumRows();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                matrix64F2.set(i, j, matrix64F.get(i, j));
            }
        }
    }

    public static void setRandom(Matrix64F matrix64F, double d, double d2, Random random) {
        for (int i = 0; i < matrix64F.numRows; ++i) {
            for (int j = 0; j < matrix64F.numCols; ++j) {
                double d3 = random.nextDouble() * (d2 - d) + d;
                matrix64F.set(i, j, d3);
            }
        }
    }
}

