/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition;

public class TriangularSolver {
    public static void invertLower(double[] dArray, int n) {
        for (int i = 0; i < n; ++i) {
            double d = dArray[i * n + i];
            for (int j = 0; j < i; ++j) {
                double d2 = 0.0;
                for (int k = j; k < i; ++k) {
                    d2 += dArray[i * n + k] * dArray[k * n + j];
                }
                dArray[i * n + j] = -d2 / d;
            }
            dArray[i * n + i] = 1.0 / d;
        }
    }

    public static void invertLower(double[] dArray, double[] dArray2, int n) {
        for (int i = 0; i < n; ++i) {
            double d = dArray[i * n + i];
            for (int j = 0; j < i; ++j) {
                double d2 = 0.0;
                for (int k = j; k < i; ++k) {
                    d2 -= dArray[i * n + k] * dArray2[k * n + j];
                }
                dArray2[i * n + j] = d2 / d;
            }
            dArray2[i * n + i] = 1.0 / d;
        }
    }

    public static void solveL(double[] dArray, double[] dArray2, int n) {
        for (int i = 0; i < n; ++i) {
            double d = dArray2[i];
            int n2 = i * n;
            for (int j = 0; j < i; ++j) {
                d -= dArray[n2++] * dArray2[j];
            }
            dArray2[i] = d / dArray[n2];
        }
    }

    public static void solveL(double[] dArray, double[] dArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = dArray2[j * n2 + i];
                for (int k = 0; k < j; ++k) {
                    d -= dArray[j * n + k] * dArray2[k * n2 + i];
                }
                dArray2[j * n2 + i] = d / dArray[j * n + j];
            }
        }
    }

    public static void solveTranL(double[] dArray, double[] dArray2, int n) {
        for (int i = n - 1; i >= 0; --i) {
            double d = dArray2[i];
            for (int j = i + 1; j < n; ++j) {
                d -= dArray[j * n + i] * dArray2[j];
            }
            dArray2[i] = d / dArray[i * n + i];
        }
    }

    public static void solveU(double[] dArray, double[] dArray2, int n) {
        for (int i = n - 1; i >= 0; --i) {
            double d = dArray2[i];
            int n2 = i * n + i + 1;
            for (int j = i + 1; j < n; ++j) {
                d -= dArray[n2++] * dArray2[j];
            }
            dArray2[i] = d / dArray[i * n + i];
        }
    }

    public static void solveU(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        for (int i = n3 - 1; i >= n2; --i) {
            double d = dArray2[i];
            int n4 = i * n + i + 1;
            for (int j = i + 1; j < n3; ++j) {
                d -= dArray[n4++] * dArray2[j];
            }
            dArray2[i] = d / dArray[i * n + i];
        }
    }

    public static void solveU(double[] dArray, int n, int n2, int n3, double[] dArray2, int n4, int n5, int n6) {
        for (int i = 0; i < n6; ++i) {
            for (int j = n3 - 1; j >= 0; --j) {
                double d = dArray2[n4 + j * n5 + i];
                for (int k = j + 1; k < n3; ++k) {
                    d -= dArray[n + j * n2 + k] * dArray2[n4 + k * n5 + i];
                }
                dArray2[n4 + j * n5 + i] = d / dArray[n + j * n2 + j];
            }
        }
    }
}

