/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block;

import org.ejml.alg.block.BlockInnerMultiplication;
import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.data.D1Submatrix64F;

public class BlockMultiplication {
    public static void mult(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, D1Submatrix64F d1Submatrix64F3) {
        for (int i = d1Submatrix64F.row0; i < d1Submatrix64F.row1; i += n) {
            int n2 = Math.min(n, d1Submatrix64F.row1 - i);
            for (int j = d1Submatrix64F2.col0; j < d1Submatrix64F2.col1; j += n) {
                int n3 = Math.min(n, d1Submatrix64F2.col1 - j);
                int n4 = (i - d1Submatrix64F.row0 + d1Submatrix64F3.row0) * d1Submatrix64F3.original.numCols + (j - d1Submatrix64F2.col0 + d1Submatrix64F3.col0) * n2;
                for (int k = d1Submatrix64F.col0; k < d1Submatrix64F.col1; k += n) {
                    int n5 = Math.min(n, d1Submatrix64F.col1 - k);
                    int n6 = i * d1Submatrix64F.original.numCols + k * n2;
                    int n7 = (k - d1Submatrix64F.col0 + d1Submatrix64F2.row0) * d1Submatrix64F2.original.numCols + j * n5;
                    if (k == d1Submatrix64F.col0) {
                        BlockInnerMultiplication.blockMultSet(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n6, n7, n4, n2, n5, n3);
                        continue;
                    }
                    BlockInnerMultiplication.blockMultPlus(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n6, n7, n4, n2, n5, n3);
                }
            }
        }
    }

    public static void multPlus(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, D1Submatrix64F d1Submatrix64F3) {
        for (int i = d1Submatrix64F.row0; i < d1Submatrix64F.row1; i += n) {
            int n2 = Math.min(n, d1Submatrix64F.row1 - i);
            for (int j = d1Submatrix64F2.col0; j < d1Submatrix64F2.col1; j += n) {
                int n3 = Math.min(n, d1Submatrix64F2.col1 - j);
                int n4 = (i - d1Submatrix64F.row0 + d1Submatrix64F3.row0) * d1Submatrix64F3.original.numCols + (j - d1Submatrix64F2.col0 + d1Submatrix64F3.col0) * n2;
                for (int k = d1Submatrix64F.col0; k < d1Submatrix64F.col1; k += n) {
                    int n5 = Math.min(n, d1Submatrix64F.col1 - k);
                    int n6 = i * d1Submatrix64F.original.numCols + k * n2;
                    int n7 = (k - d1Submatrix64F.col0 + d1Submatrix64F2.row0) * d1Submatrix64F2.original.numCols + j * n5;
                    BlockInnerMultiplication.blockMultPlus(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n6, n7, n4, n2, n5, n3);
                }
            }
        }
    }

    public static void multMinus(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, D1Submatrix64F d1Submatrix64F3) {
        BlockMultiplication.checkInput(n, d1Submatrix64F, d1Submatrix64F2, d1Submatrix64F3);
        for (int i = d1Submatrix64F.row0; i < d1Submatrix64F.row1; i += n) {
            int n2 = Math.min(n, d1Submatrix64F.row1 - i);
            for (int j = d1Submatrix64F2.col0; j < d1Submatrix64F2.col1; j += n) {
                int n3 = Math.min(n, d1Submatrix64F2.col1 - j);
                int n4 = (i - d1Submatrix64F.row0 + d1Submatrix64F3.row0) * d1Submatrix64F3.original.numCols + (j - d1Submatrix64F2.col0 + d1Submatrix64F3.col0) * n2;
                for (int k = d1Submatrix64F.col0; k < d1Submatrix64F.col1; k += n) {
                    int n5 = Math.min(n, d1Submatrix64F.col1 - k);
                    int n6 = i * d1Submatrix64F.original.numCols + k * n2;
                    int n7 = (k - d1Submatrix64F.col0 + d1Submatrix64F2.row0) * d1Submatrix64F2.original.numCols + j * n5;
                    BlockInnerMultiplication.blockMultMinus(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n6, n7, n4, n2, n5, n3);
                }
            }
        }
    }

    private static void checkInput(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, D1Submatrix64F d1Submatrix64F3) {
        int n2 = d1Submatrix64F.getRows();
        int n3 = d1Submatrix64F.getCols();
        int n4 = d1Submatrix64F2.getRows();
        int n5 = d1Submatrix64F2.getCols();
        int n6 = d1Submatrix64F3.getRows();
        int n7 = d1Submatrix64F3.getCols();
        if (n2 != n6) {
            throw new RuntimeException("Mismatch A and C rows");
        }
        if (n5 != n7) {
            throw new RuntimeException("Mismatch B and C columns");
        }
        if (n3 != n4) {
            throw new RuntimeException("Mismatch A columns and B rows");
        }
        if (!BlockMatrixOps.blockAligned(n, d1Submatrix64F)) {
            throw new RuntimeException("Sub-Matrix A is not block aligned");
        }
        if (!BlockMatrixOps.blockAligned(n, d1Submatrix64F2)) {
            throw new RuntimeException("Sub-Matrix B is not block aligned");
        }
        if (!BlockMatrixOps.blockAligned(n, d1Submatrix64F3)) {
            throw new RuntimeException("Sub-Matrix C is not block aligned");
        }
    }

    public static void multTransA(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, D1Submatrix64F d1Submatrix64F3) {
        for (int i = d1Submatrix64F.col0; i < d1Submatrix64F.col1; i += n) {
            int n2 = Math.min(n, d1Submatrix64F.col1 - i);
            for (int j = d1Submatrix64F2.col0; j < d1Submatrix64F2.col1; j += n) {
                int n3 = Math.min(n, d1Submatrix64F2.col1 - j);
                int n4 = (i - d1Submatrix64F.col0 + d1Submatrix64F3.row0) * d1Submatrix64F3.original.numCols + (j - d1Submatrix64F2.col0 + d1Submatrix64F3.col0) * n2;
                for (int k = d1Submatrix64F.row0; k < d1Submatrix64F.row1; k += n) {
                    int n5 = Math.min(n, d1Submatrix64F.row1 - k);
                    int n6 = k * d1Submatrix64F.original.numCols + i * n5;
                    int n7 = (k - d1Submatrix64F.row0 + d1Submatrix64F2.row0) * d1Submatrix64F2.original.numCols + j * n5;
                    if (k == d1Submatrix64F.row0) {
                        BlockInnerMultiplication.blockMultSetTransA(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n6, n7, n4, n5, n2, n3);
                        continue;
                    }
                    BlockInnerMultiplication.blockMultPlusTransA(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n6, n7, n4, n5, n2, n3);
                }
            }
        }
    }

    public static void multPlusTransA(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, D1Submatrix64F d1Submatrix64F3) {
        for (int i = d1Submatrix64F.col0; i < d1Submatrix64F.col1; i += n) {
            int n2 = Math.min(n, d1Submatrix64F.col1 - i);
            for (int j = d1Submatrix64F2.col0; j < d1Submatrix64F2.col1; j += n) {
                int n3 = Math.min(n, d1Submatrix64F2.col1 - j);
                int n4 = (i - d1Submatrix64F.col0 + d1Submatrix64F3.row0) * d1Submatrix64F3.original.numCols + (j - d1Submatrix64F2.col0 + d1Submatrix64F3.col0) * n2;
                for (int k = d1Submatrix64F.row0; k < d1Submatrix64F.row1; k += n) {
                    int n5 = Math.min(n, d1Submatrix64F.row1 - k);
                    int n6 = k * d1Submatrix64F.original.numCols + i * n5;
                    int n7 = (k - d1Submatrix64F.row0 + d1Submatrix64F2.row0) * d1Submatrix64F2.original.numCols + j * n5;
                    BlockInnerMultiplication.blockMultPlusTransA(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n6, n7, n4, n5, n2, n3);
                }
            }
        }
    }

    public static void multMinusTransA(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, D1Submatrix64F d1Submatrix64F3) {
        for (int i = d1Submatrix64F.col0; i < d1Submatrix64F.col1; i += n) {
            int n2 = Math.min(n, d1Submatrix64F.col1 - i);
            for (int j = d1Submatrix64F2.col0; j < d1Submatrix64F2.col1; j += n) {
                int n3 = Math.min(n, d1Submatrix64F2.col1 - j);
                int n4 = (i - d1Submatrix64F.col0 + d1Submatrix64F3.row0) * d1Submatrix64F3.original.numCols + (j - d1Submatrix64F2.col0 + d1Submatrix64F3.col0) * n2;
                for (int k = d1Submatrix64F.row0; k < d1Submatrix64F.row1; k += n) {
                    int n5 = Math.min(n, d1Submatrix64F.row1 - k);
                    int n6 = k * d1Submatrix64F.original.numCols + i * n5;
                    int n7 = (k - d1Submatrix64F.row0 + d1Submatrix64F2.row0) * d1Submatrix64F2.original.numCols + j * n5;
                    BlockInnerMultiplication.blockMultMinusTransA(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n6, n7, n4, n5, n2, n3);
                }
            }
        }
    }

    public static void multTransB(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, D1Submatrix64F d1Submatrix64F3) {
        for (int i = d1Submatrix64F.row0; i < d1Submatrix64F.row1; i += n) {
            int n2 = Math.min(n, d1Submatrix64F.row1 - i);
            for (int j = d1Submatrix64F2.row0; j < d1Submatrix64F2.row1; j += n) {
                int n3 = Math.min(n, d1Submatrix64F2.row1 - j);
                int n4 = (i - d1Submatrix64F.row0 + d1Submatrix64F3.row0) * d1Submatrix64F3.original.numCols + (j - d1Submatrix64F2.row0 + d1Submatrix64F3.col0) * n2;
                for (int k = d1Submatrix64F.col0; k < d1Submatrix64F.col1; k += n) {
                    int n5 = Math.min(n, d1Submatrix64F.col1 - k);
                    int n6 = i * d1Submatrix64F.original.numCols + k * n2;
                    int n7 = j * d1Submatrix64F2.original.numCols + (k - d1Submatrix64F.col0 + d1Submatrix64F2.col0) * n3;
                    if (k == d1Submatrix64F.col0) {
                        BlockInnerMultiplication.blockMultSetTransB(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n6, n7, n4, n2, n5, n3);
                        continue;
                    }
                    BlockInnerMultiplication.blockMultPlusTransB(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n6, n7, n4, n2, n5, n3);
                }
            }
        }
    }
}

