/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.FixedWeekdayInMonth;
import de.jollyday.config.Holidays;
import de.jollyday.config.Which;
import de.jollyday.parser.AbstractHolidayParser;
import java.util.Set;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedWeekdayInMonthParser
extends AbstractHolidayParser {
    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (FixedWeekdayInMonth fwm : config.getFixedWeekday()) {
            if (!this.isValid(fwm, year)) continue;
            LocalDate date = this.parse(year, fwm);
            HolidayType type = this.xmlUtil.getType(fwm.getLocalizedType());
            holidays.add(new Holiday(date, fwm.getDescriptionPropertiesKey(), type));
        }
    }

    protected LocalDate parse(int year, FixedWeekdayInMonth fwm) {
        LocalDate date = this.calendarUtil.create(year, this.xmlUtil.getMonth(fwm.getMonth()), 1);
        int direction = 1;
        if (Which.LAST.equals((Object)fwm.getWhich())) {
            date = date.withDayOfMonth(date.dayOfMonth().getMaximumValue());
            direction = -1;
        }
        date = this.moveToNextRequestedWeekdayByDirection(fwm, date, direction);
        date = this.moveNumberOfRequestedWeeks(fwm, date);
        return date;
    }

    private LocalDate moveNumberOfRequestedWeeks(FixedWeekdayInMonth fwm, LocalDate date) {
        switch (fwm.getWhich()) {
            case SECOND: {
                return date.plusDays(7);
            }
            case THIRD: {
                return date.plusDays(14);
            }
            case FOURTH: {
                return date.plusDays(21);
            }
        }
        return date;
    }

    private LocalDate moveToNextRequestedWeekdayByDirection(FixedWeekdayInMonth fwm, LocalDate date, int direction) {
        int weekDay = this.xmlUtil.getWeekday(fwm.getWeekday());
        while (date.getDayOfWeek() != weekDay) {
            date = date.plusDays(direction);
        }
        return date;
    }
}

