/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.ejb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EJBInvokerJob
implements Job {
    public static final String EJB_JNDI_NAME_KEY = "ejb";
    public static final String EJB_METHOD_KEY = "method";
    public static final String EJB_ARG_TYPES_KEY = "argTypes";
    public static final String EJB_ARGS_KEY = "args";
    public static final String INITIAL_CONTEXT_FACTORY = "java.naming.factory.initial";
    public static final String PROVIDER_URL = "java.naming.provider.url";
    public static final String PRINCIPAL = "java.naming.security.principal";
    public static final String CREDENTIALS = "java.naming.security.credentials";
    static /* synthetic */ Class class$javax$ejb$EJBHome;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDetail detail = context.getJobDetail();
        JobDataMap dataMap = context.getMergedJobDataMap();
        String ejb = dataMap.getString(EJB_JNDI_NAME_KEY);
        String method = dataMap.getString(EJB_METHOD_KEY);
        Object[] arguments = (Object[])dataMap.get(EJB_ARGS_KEY);
        if (arguments == null) {
            arguments = new Object[]{};
        }
        if (ejb == null) {
            throw new JobExecutionException();
        }
        InitialContext jndiContext = null;
        try {
            jndiContext = this.getInitialContext(dataMap);
        }
        catch (NamingException ne) {
            throw new JobExecutionException(ne);
        }
        try {
            Object value = null;
            try {
                value = jndiContext.lookup(ejb);
            }
            catch (NamingException ne) {
                throw new JobExecutionException(ne);
            }
            EJBHome ejbHome = (EJBHome)PortableRemoteObject.narrow((Object)value, (Class)(class$javax$ejb$EJBHome == null ? (class$javax$ejb$EJBHome = EJBInvokerJob.class$("javax.ejb.EJBHome")) : class$javax$ejb$EJBHome));
            EJBMetaData metaData = null;
            try {
                metaData = ejbHome.getEJBMetaData();
            }
            catch (RemoteException re) {
                throw new JobExecutionException(re);
            }
            Class homeClass = metaData.getHomeInterfaceClass();
            Class remoteClass = metaData.getRemoteInterfaceClass();
            ejbHome = (EJBHome)PortableRemoteObject.narrow((Object)ejbHome, (Class)homeClass);
            Method methodCreate = null;
            try {
                methodCreate = homeClass.getMethod("create", null);
            }
            catch (NoSuchMethodException nsme) {
                throw new JobExecutionException(nsme);
            }
            EJBObject remoteObj = null;
            try {
                remoteObj = (EJBObject)methodCreate.invoke((Object)ejbHome, (Object[])null);
            }
            catch (IllegalAccessException iae) {
                throw new JobExecutionException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new JobExecutionException(ite);
            }
            Method methodExecute = null;
            try {
                Class[] argTypes = (Class[])dataMap.get(EJB_ARG_TYPES_KEY);
                if (argTypes == null) {
                    argTypes = new Class[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        argTypes[i] = arguments[i].getClass();
                    }
                }
                methodExecute = remoteClass.getMethod(method, argTypes);
            }
            catch (NoSuchMethodException nsme) {
                throw new JobExecutionException(nsme);
            }
            try {
                Object returnObj = methodExecute.invoke((Object)remoteObj, arguments);
                context.setResult(returnObj);
            }
            catch (IllegalAccessException iae) {
                throw new JobExecutionException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new JobExecutionException(ite);
            }
        }
        finally {
            if (jndiContext != null) {
                try {
                    jndiContext.close();
                }
                catch (NamingException e) {}
            }
        }
    }

    private InitialContext getInitialContext(JobDataMap jobDataMap) throws NamingException {
        String credentials;
        String principal;
        String providerUrl;
        Hashtable<String, String> params = new Hashtable<String, String>(2);
        String initialContextFactory = jobDataMap.getString(INITIAL_CONTEXT_FACTORY);
        if (initialContextFactory != null) {
            params.put(INITIAL_CONTEXT_FACTORY, initialContextFactory);
        }
        if ((providerUrl = jobDataMap.getString(PROVIDER_URL)) != null) {
            params.put(PROVIDER_URL, providerUrl);
        }
        if ((principal = jobDataMap.getString(PRINCIPAL)) != null) {
            params.put(PRINCIPAL, principal);
        }
        if ((credentials = jobDataMap.getString(CREDENTIALS)) != null) {
            params.put(CREDENTIALS, credentials);
        }
        return params.size() == 0 ? new InitialContext() : new InitialContext(params);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

