/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGenerator;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.schema.XMLSchemaParser;
import org.apache.openjpa.jdbc.schema.XMLSchemaSerializer;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Files;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.util.InvalidStateException;

public class SchemaTool {
    public static final String ACTION_ADD = "add";
    public static final String ACTION_DROP = "drop";
    public static final String ACTION_RETAIN = "retain";
    public static final String ACTION_REFRESH = "refresh";
    public static final String ACTION_BUILD = "build";
    public static final String ACTION_REFLECT = "reflect";
    public static final String ACTION_CREATEDB = "createDB";
    public static final String ACTION_DROPDB = "dropDB";
    public static final String ACTION_IMPORT = "import";
    public static final String ACTION_EXPORT = "export";
    public static final String ACTION_DELETE_TABLE_CONTENTS = "deleteTableContents";
    public static final String[] ACTIONS = new String[]{"add", "drop", "retain", "refresh", "build", "reflect", "createDB", "dropDB", "import", "export", "deleteTableContents"};
    private static final Localizer _loc = Localizer.forPackage(SchemaTool.class);
    private final JDBCConfiguration _conf;
    private final DataSource _ds;
    private final Log _log;
    private final DBDictionary _dict;
    private final String _action;
    private boolean _ignoreErrs = false;
    private boolean _openjpaTables = false;
    private boolean _dropTables = true;
    private boolean _dropSeqs = true;
    private boolean _pks = true;
    private boolean _fks = true;
    private boolean _indexes = true;
    private boolean _seqs = true;
    private PrintWriter _writer = null;
    private SchemaGroup _group = null;
    private SchemaGroup _db = null;
    private boolean _fullDB = false;

    public SchemaTool(JDBCConfiguration conf) {
        this(conf, null);
    }

    public SchemaTool(JDBCConfiguration conf, String action) {
        if (action != null && !Arrays.asList(ACTIONS).contains(action)) {
            throw new IllegalArgumentException("action == " + action);
        }
        this._conf = conf;
        this._action = action;
        this._ds = conf.getDataSource2(null);
        this._log = conf.getLog("openjpa.jdbc.Schema");
        this._dict = this._conf.getDBDictionaryInstance();
    }

    public String getAction() {
        return this._action;
    }

    public boolean getIgnoreErrors() {
        return this._ignoreErrs;
    }

    public void setIgnoreErrors(boolean ignoreErrs) {
        this._ignoreErrs = ignoreErrs;
    }

    public boolean getOpenJPATables() {
        return this._openjpaTables;
    }

    public void setOpenJPATables(boolean openjpaTables) {
        this._openjpaTables = openjpaTables;
    }

    public boolean getDropTables() {
        return this._dropTables;
    }

    public void setDropTables(boolean dropTables) {
        this._dropTables = dropTables;
    }

    public boolean getDropSequences() {
        return this._dropSeqs;
    }

    public void setDropSequences(boolean dropSeqs) {
        this._dropSeqs = dropSeqs;
        if (dropSeqs) {
            this.setSequences(true);
        }
    }

    public boolean getSequences() {
        return this._seqs;
    }

    public void setSequences(boolean seqs) {
        this._seqs = seqs;
    }

    public boolean getIndexes() {
        return this._indexes;
    }

    public void setIndexes(boolean indexes) {
        this._indexes = indexes;
    }

    public boolean getForeignKeys() {
        return this._fks;
    }

    public void setForeignKeys(boolean fks) {
        this._fks = fks;
    }

    public boolean getPrimaryKeys() {
        return this._pks;
    }

    public void setPrimaryKeys(boolean pks) {
        this._pks = pks;
    }

    public Writer getWriter() {
        return this._writer;
    }

    public void setWriter(Writer writer) {
        this._writer = writer == null ? null : (writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer));
    }

    public SchemaGroup getSchemaGroup() {
        return this._group;
    }

    public void setSchemaGroup(SchemaGroup group) {
        this._group = group;
    }

    public void run() throws SQLException {
        if (this._action == null) {
            return;
        }
        if (ACTION_ADD.equals(this._action)) {
            this.add();
        } else if (ACTION_DROP.equals(this._action)) {
            this.drop();
        } else if (ACTION_RETAIN.equals(this._action)) {
            this.retain();
        } else if (ACTION_REFRESH.equals(this._action)) {
            this.refresh();
        } else if (ACTION_BUILD.equals(this._action)) {
            this.build();
        } else if (ACTION_CREATEDB.equals(this._action)) {
            this.createDB();
        } else if (ACTION_DROPDB.equals(this._action)) {
            this.dropDB();
        } else if (ACTION_DELETE_TABLE_CONTENTS.equals(this._action)) {
            this.deleteTableContents();
        }
    }

    void add() throws SQLException {
        this.add(this.getDBSchemaGroup(false), this.assertSchemaGroup());
    }

    void drop() throws SQLException {
        this.drop(this.getDBSchemaGroup(false), this.assertSchemaGroup());
    }

    void retain() throws SQLException {
        this.retain(this.getDBSchemaGroup(true), this.assertSchemaGroup(), this.getDropTables(), this.getDropSequences());
    }

    void refresh() throws SQLException {
        SchemaGroup local = this.assertSchemaGroup();
        SchemaGroup db = this.getDBSchemaGroup(true);
        this.retain(db, local, this.getDropTables(), this.getDropSequences());
        this.add(db, local);
    }

    void createDB() throws SQLException {
        SchemaGroup group = new SchemaGroup();
        group.addSchema();
        this.add(group, this.getDBSchemaGroup(true));
    }

    void build() throws SQLException {
        SchemaGroup group = new SchemaGroup();
        group.addSchema();
        this.add(group, this.assertSchemaGroup());
    }

    void dropDB() throws SQLException {
        this.retain(this.getDBSchemaGroup(true), new SchemaGroup(), true, true);
    }

    private void deleteTableContents() throws SQLException {
        SchemaGroup group = this.getSchemaGroup();
        Schema[] schemas = group.getSchemas();
        LinkedHashSet<Table> tables = new LinkedHashSet<Table>();
        for (int i = 0; i < schemas.length; ++i) {
            Table[] ts = schemas[i].getTables();
            for (int j = 0; j < ts.length; ++j) {
                tables.add(ts[j]);
            }
        }
        Table[] tableArray = tables.toArray(new Table[tables.size()]);
        String[] sql2 = this._conf.getDBDictionaryInstance().getDeleteTableContentsSQL(tableArray);
        if (!this.executeSQL(sql2)) {
            this._log.warn(_loc.get("delete-table-contents"));
        }
    }

    public void record() {
        if (this._db != null && this._writer == null) {
            this._conf.getSchemaFactoryInstance().storeSchema(this._db);
        }
    }

    private void add(SchemaGroup db, SchemaGroup repos) throws SQLException {
        int j;
        int i;
        Table[] tabs;
        Schema schema;
        Schema[] schemas = repos.getSchemas();
        if (this._seqs) {
            for (int i2 = 0; i2 < schemas.length; ++i2) {
                Sequence[] seqs = schemas[i2].getSequences();
                for (int j2 = 0; j2 < seqs.length; ++j2) {
                    if (db.findSequence(schemas[i2], seqs[j2].getFullName()) != null) continue;
                    if (this.createSequence(seqs[j2])) {
                        schema = db.getSchema(seqs[j2].getSchemaName());
                        if (schema == null) {
                            schema = db.addSchema(seqs[j2].getSchemaName());
                        }
                        schema.importSequence(seqs[j2]);
                        continue;
                    }
                    this._log.warn(_loc.get("add-seq", seqs[j2]));
                }
            }
        }
        for (int i3 = 0; i3 < schemas.length; ++i3) {
            tabs = schemas[i3].getTables();
            for (int j3 = 0; j3 < tabs.length; ++j3) {
                Column[] cols = tabs[j3].getColumns();
                Table dbTable = db.findTable(schemas[i3], tabs[j3].getFullName());
                for (int k = 0; k < cols.length; ++k) {
                    if (dbTable == null) continue;
                    Column col = dbTable.getColumn(cols[k].getName());
                    if (col == null) {
                        if (this.addColumn(cols[k])) {
                            dbTable.importColumn(cols[k]);
                            continue;
                        }
                        this._log.warn(_loc.get("add-col", cols[k], tabs[j3]));
                        continue;
                    }
                    if (cols[k].equalsColumn(col)) continue;
                    this._log.warn(_loc.get("bad-col", new Object[]{col, dbTable, col.getDescription(), cols[k].getDescription()}));
                }
            }
        }
        if (this._pks) {
            for (i = 0; i < schemas.length; ++i) {
                tabs = schemas[i].getTables();
                for (j = 0; j < tabs.length; ++j) {
                    PrimaryKey pk = tabs[j].getPrimaryKey();
                    Table dbTable = db.findTable(schemas[i], tabs[j].getFullName());
                    if (pk == null || pk.isLogical() || dbTable == null) continue;
                    if (dbTable.getPrimaryKey() == null && this.addPrimaryKey(pk)) {
                        dbTable.importPrimaryKey(pk);
                        continue;
                    }
                    if (dbTable.getPrimaryKey() == null) {
                        this._log.warn(_loc.get("add-pk", pk, tabs[j]));
                        continue;
                    }
                    if (pk.equalsPrimaryKey(dbTable.getPrimaryKey())) continue;
                    this._log.warn(_loc.get("bad-pk", dbTable.getPrimaryKey(), dbTable));
                }
            }
        }
        HashSet<Table> newTables = new HashSet<Table>();
        for (i = 0; i < schemas.length; ++i) {
            tabs = schemas[i].getTables();
            for (j = 0; j < tabs.length; ++j) {
                if (db.findTable(schemas[i], tabs[j].getFullName()) != null) continue;
                if (this.createTable(tabs[j])) {
                    newTables.add(tabs[j]);
                    schema = db.getSchema(tabs[j].getSchemaName());
                    if (schema == null) {
                        schema = db.addSchema(tabs[j].getSchemaName());
                    }
                    schema.importTable(tabs[j]);
                    continue;
                }
                this._log.warn(_loc.get("add-table", tabs[j]));
            }
        }
        for (int i4 = 0; i4 < schemas.length; ++i4) {
            tabs = schemas[i4].getTables();
            for (int j4 = 0; j4 < tabs.length; ++j4) {
                if (!this._indexes && !newTables.contains(tabs[j4])) continue;
                Index[] idxs = tabs[j4].getIndexes();
                Table dbTable = db.findTable(schemas[i4], tabs[j4].getFullName());
                for (int k = 0; k < idxs.length; ++k) {
                    if (dbTable == null) continue;
                    Index idx = this.findIndex(dbTable, idxs[k]);
                    if (idx == null) {
                        if (this.createIndex(idxs[k], dbTable)) {
                            dbTable.importIndex(idxs[k]);
                            continue;
                        }
                        this._log.warn(_loc.get("add-index", idxs[k], tabs[j4]));
                        continue;
                    }
                    if (idxs[k].equalsIndex(idx)) continue;
                    this._log.warn(_loc.get("bad-index", idx, dbTable));
                }
            }
        }
        for (int i5 = 0; i5 < schemas.length; ++i5) {
            tabs = schemas[i5].getTables();
            for (int j5 = 0; j5 < tabs.length; ++j5) {
                Table dbTable;
                Unique[] uniques;
                if (!newTables.contains(tabs[j5]) || (uniques = tabs[j5].getUniques()) == null || uniques.length == 0 || (dbTable = db.findTable(tabs[j5])) == null) continue;
                for (int k = 0; k < uniques.length; ++k) {
                    dbTable.importUnique(uniques[k]);
                }
            }
        }
        for (int i6 = 0; i6 < schemas.length; ++i6) {
            tabs = schemas[i6].getTables();
            for (int j6 = 0; j6 < tabs.length; ++j6) {
                if (!this._fks && !newTables.contains(tabs[j6])) continue;
                ForeignKey[] fks = tabs[j6].getForeignKeys();
                Table dbTable = db.findTable(schemas[i6], tabs[j6].getFullName());
                for (int k = 0; k < fks.length; ++k) {
                    if (fks[k].isLogical() || dbTable == null) continue;
                    ForeignKey fk = this.findForeignKey(dbTable, fks[k]);
                    if (fk == null) {
                        if (this.addForeignKey(fks[k])) {
                            dbTable.importForeignKey(fks[k]);
                            continue;
                        }
                        this._log.warn(_loc.get("add-fk", fks[k], tabs[j6]));
                        continue;
                    }
                    if (fks[k].equalsForeignKey(fk)) continue;
                    this._log.warn(_loc.get("bad-fk", fk, dbTable));
                }
            }
        }
    }

    private void retain(SchemaGroup db, SchemaGroup repos, boolean tables, boolean sequences) throws SQLException {
        int j;
        int i;
        Table[] tabs;
        Schema[] schemas = db.getSchemas();
        if (this._seqs && sequences) {
            for (int i2 = 0; i2 < schemas.length; ++i2) {
                Sequence[] seqs = schemas[i2].getSequences();
                for (int j2 = 0; j2 < seqs.length; ++j2) {
                    if (!this.isDroppable(seqs[j2]) || repos.findSequence(seqs[j2]) != null) continue;
                    if (this.dropSequence(seqs[j2])) {
                        schemas[i2].removeSequence(seqs[j2]);
                        continue;
                    }
                    this._log.warn(_loc.get("drop-seq", seqs[j2]));
                }
            }
        }
        if (this._fks) {
            for (int i3 = 0; i3 < schemas.length; ++i3) {
                tabs = schemas[i3].getTables();
                for (int j3 = 0; j3 < tabs.length; ++j3) {
                    if (!this.isDroppable(tabs[j3])) continue;
                    ForeignKey[] fks = tabs[j3].getForeignKeys();
                    Table reposTable = repos.findTable(tabs[j3]);
                    if (!tables && reposTable == null) continue;
                    for (int k = 0; k < fks.length; ++k) {
                        if (fks[k].isLogical()) continue;
                        ForeignKey fk = null;
                        if (reposTable != null) {
                            fk = this.findForeignKey(reposTable, fks[k]);
                        }
                        if (reposTable != null && fk != null && fks[k].equalsForeignKey(fk)) continue;
                        if (this.dropForeignKey(fks[k])) {
                            tabs[j3].removeForeignKey(fks[k]);
                            continue;
                        }
                        this._log.warn(_loc.get("drop-fk", fks[k], tabs[j3]));
                    }
                }
            }
        }
        if (this._pks) {
            for (int i4 = 0; i4 < schemas.length; ++i4) {
                tabs = schemas[i4].getTables();
                for (int j4 = 0; j4 < tabs.length; ++j4) {
                    PrimaryKey pk;
                    if (!this.isDroppable(tabs[j4]) || (pk = tabs[j4].getPrimaryKey()) != null && pk.isLogical()) continue;
                    Table reposTable = repos.findTable(tabs[j4]);
                    if (pk == null || reposTable == null || reposTable.getPrimaryKey() != null && pk.equalsPrimaryKey(reposTable.getPrimaryKey())) continue;
                    if (this.dropPrimaryKey(pk)) {
                        tabs[j4].removePrimaryKey();
                        continue;
                    }
                    this._log.warn(_loc.get("drop-pk", pk, tabs[j4]));
                }
            }
        }
        LinkedList<Table> drops = new LinkedList<Table>();
        for (i = 0; i < schemas.length; ++i) {
            tabs = schemas[i].getTables();
            for (j = 0; j < tabs.length; ++j) {
                if (!this.isDroppable(tabs[j])) continue;
                Column[] cols = tabs[j].getColumns();
                Table reposTable = repos.findTable(tabs[j]);
                if (reposTable == null) continue;
                for (int k = 0; k < cols.length; ++k) {
                    Column col = reposTable.getColumn(cols[k].getName());
                    if (col != null && cols[k].equalsColumn(col)) continue;
                    if (tabs[j].getColumns().length == 1) {
                        drops.add(tabs[j]);
                        continue;
                    }
                    if (this.dropColumn(cols[k])) {
                        tabs[j].removeColumn(cols[k]);
                        continue;
                    }
                    this._log.warn(_loc.get("drop-col", cols[k], tabs[j]));
                }
            }
        }
        if (tables) {
            for (i = 0; i < schemas.length; ++i) {
                tabs = schemas[i].getTables();
                for (j = 0; j < tabs.length; ++j) {
                    if (!this.isDroppable(tabs[j]) || repos.findTable(tabs[j]) != null) continue;
                    drops.add(tabs[j]);
                }
            }
        }
        this.dropTables(drops, db);
    }

    private void drop(SchemaGroup db, SchemaGroup repos) throws SQLException {
        int k;
        Table[] tabs;
        Schema[] schemas = repos.getSchemas();
        if (this._seqs) {
            for (int i = 0; i < schemas.length; ++i) {
                Sequence[] seqs = schemas[i].getSequences();
                for (int j = 0; j < seqs.length; ++j) {
                    Sequence dbSeq;
                    if (!this.isDroppable(seqs[j]) || (dbSeq = db.findSequence(seqs[j])) == null) continue;
                    if (this.dropSequence(seqs[j])) {
                        dbSeq.getSchema().removeSequence(dbSeq);
                        continue;
                    }
                    this._log.warn(_loc.get("drop-seq", seqs[j]));
                }
            }
        }
        LinkedList<Table> drops = new LinkedList<Table>();
        for (int i = 0; i < schemas.length; ++i) {
            tabs = schemas[i].getTables();
            block3: for (int j = 0; j < tabs.length; ++j) {
                Table dbTable;
                if (!this.isDroppable(tabs[j]) || (dbTable = db.findTable(tabs[j])) == null) continue;
                Column[] dbCols = dbTable.getColumns();
                for (int k2 = 0; k2 < dbCols.length; ++k2) {
                    if (tabs[j].getColumn(dbCols[k2].getName()) == null) continue block3;
                }
                drops.add(tabs[j]);
            }
        }
        if (this._fks) {
            for (int i = 0; i < schemas.length; ++i) {
                tabs = schemas[i].getTables();
                for (int j = 0; j < tabs.length; ++j) {
                    if (!this.isDroppable(tabs[j])) continue;
                    ForeignKey[] fks = tabs[j].getForeignKeys();
                    Table dbTable = db.findTable(tabs[j]);
                    for (k = 0; k < fks.length; ++k) {
                        if (fks[k].isLogical()) continue;
                        ForeignKey fk = null;
                        if (dbTable != null) {
                            fk = this.findForeignKey(dbTable, fks[k]);
                        }
                        if (dbTable == null || fk == null || !this.dropForeignKey(fks[k])) continue;
                        if (dbTable != null) {
                            dbTable.removeForeignKey(fk);
                            continue;
                        }
                        this._log.warn(_loc.get("drop-fk", fks[k], tabs[j]));
                    }
                }
            }
            for (Table tab : drops) {
                Table dbTable = db.findTable(tab);
                if (dbTable == null) continue;
                ForeignKey[] fks = db.findExportedForeignKeys(dbTable.getPrimaryKey());
                for (int i = 0; i < fks.length; ++i) {
                    if (this.dropForeignKey(fks[i])) {
                        dbTable.removeForeignKey(fks[i]);
                        continue;
                    }
                    this._log.warn(_loc.get("drop-fk", fks[i], dbTable));
                }
            }
        }
        this.dropTables(drops, db);
        for (int i = 0; i < schemas.length; ++i) {
            tabs = schemas[i].getTables();
            for (int j = 0; j < tabs.length; ++j) {
                if (!this.isDroppable(tabs[j])) continue;
                Column[] cols = tabs[j].getColumns();
                Table dbTable = db.findTable(tabs[j]);
                for (k = 0; k < cols.length; ++k) {
                    Column col = null;
                    if (dbTable != null) {
                        col = dbTable.getColumn(cols[k].getName());
                    }
                    if (dbTable == null || col == null || !this.dropColumn(cols[k])) continue;
                    if (dbTable != null) {
                        dbTable.removeColumn(col);
                        continue;
                    }
                    this._log.warn(_loc.get("drop-col", cols[k], tabs[j]));
                }
            }
        }
    }

    private boolean isDroppable(Table table) {
        return this._openjpaTables || !table.getName().toUpperCase().startsWith("OPENJPA_") && !table.getName().toUpperCase().startsWith("JDO_");
    }

    private boolean isDroppable(Sequence seq) {
        return this._openjpaTables || !seq.getName().toUpperCase().startsWith("OPENJPA_") && !seq.getName().toUpperCase().startsWith("JDO_");
    }

    private Index findIndex(Table dbTable, Index idx) {
        Index[] idxs = dbTable.getIndexes();
        for (int i = 0; i < idxs.length; ++i) {
            if (!idx.columnsMatch(idxs[i].getColumns())) continue;
            return idxs[i];
        }
        return null;
    }

    private ForeignKey findForeignKey(Table dbTable, ForeignKey fk) {
        if (fk.getConstantColumns().length > 0 || fk.getConstantPrimaryKeyColumns().length > 0) {
            return null;
        }
        ForeignKey[] fks = dbTable.getForeignKeys();
        for (int i = 0; i < fks.length; ++i) {
            if (!fk.columnsMatch(fks[i].getColumns(), fks[i].getPrimaryKeyColumns())) continue;
            return fks[i];
        }
        return null;
    }

    private void dropTables(Collection tables, SchemaGroup change) throws SQLException {
        if (tables.isEmpty()) {
            return;
        }
        for (Table table : tables) {
            if (this.dropTable(table)) {
                Table changeTable = change.findTable(table);
                if (changeTable == null) continue;
                changeTable.getSchema().removeTable(changeTable);
                continue;
            }
            this._log.warn(_loc.get("drop-table", table));
        }
    }

    public boolean createTable(Table table) throws SQLException {
        return this.executeSQL(this._dict.getCreateTableSQL(table));
    }

    public boolean dropTable(Table table) throws SQLException {
        return this.executeSQL(this._dict.getDropTableSQL(table));
    }

    public boolean createSequence(Sequence seq) throws SQLException {
        return this.executeSQL(this._dict.getCreateSequenceSQL(seq));
    }

    public boolean dropSequence(Sequence seq) throws SQLException {
        return this.executeSQL(this._dict.getDropSequenceSQL(seq));
    }

    public boolean createIndex(Index idx, Table table) throws SQLException {
        int max = this._dict.maxIndexesPerTable;
        int len = table.getIndexes().length;
        if (table.getPrimaryKey() != null) {
            len += table.getPrimaryKey().getColumns().length;
        }
        if (len >= max) {
            this._log.warn(_loc.get("too-many-indexes", idx, table, max + ""));
            return false;
        }
        return this.executeSQL(this._dict.getCreateIndexSQL(idx));
    }

    public boolean dropIndex(Index idx) throws SQLException {
        return this.executeSQL(this._dict.getDropIndexSQL(idx));
    }

    public boolean addColumn(Column col) throws SQLException {
        return this.executeSQL(this._dict.getAddColumnSQL(col));
    }

    public boolean dropColumn(Column col) throws SQLException {
        return this.executeSQL(this._dict.getDropColumnSQL(col));
    }

    public boolean addPrimaryKey(PrimaryKey pk) throws SQLException {
        return this.executeSQL(this._dict.getAddPrimaryKeySQL(pk));
    }

    public boolean dropPrimaryKey(PrimaryKey pk) throws SQLException {
        return this.executeSQL(this._dict.getDropPrimaryKeySQL(pk));
    }

    public boolean addForeignKey(ForeignKey fk) throws SQLException {
        return this.executeSQL(this._dict.getAddForeignKeySQL(fk));
    }

    public boolean dropForeignKey(ForeignKey fk) throws SQLException {
        return this.executeSQL(this._dict.getDropForeignKeySQL(fk));
    }

    public SchemaGroup getDBSchemaGroup() {
        try {
            return this.getDBSchemaGroup(true);
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, this._dict);
        }
    }

    public void setDBSchemaGroup(SchemaGroup db) {
        this._db = db;
        if (db != null) {
            this._fullDB = true;
        }
    }

    private SchemaGroup getDBSchemaGroup(boolean full) throws SQLException {
        if (this._db == null || full && !this._fullDB) {
            SchemaGenerator gen = new SchemaGenerator(this._conf);
            gen.setPrimaryKeys(this._pks);
            gen.setForeignKeys(this._fks);
            gen.setIndexes(this._indexes);
            if (full) {
                gen.generateSchemas();
            } else {
                LinkedList<String> tables = new LinkedList<String>();
                SchemaGroup group = this.assertSchemaGroup();
                Schema[] schemas = group.getSchemas();
                for (int i = 0; i < schemas.length; ++i) {
                    Table[] tabs = schemas[i].getTables();
                    for (int j = 0; j < tabs.length; ++j) {
                        if (tabs[j].getSchemaName() == null) {
                            tables.add("." + tabs[j].getName());
                            continue;
                        }
                        tables.add(tabs[j].getFullName());
                    }
                }
                if (!tables.isEmpty()) {
                    gen.generateSchemas(tables.toArray(new String[tables.size()]));
                }
            }
            this._db = gen.getSchemaGroup();
        }
        return this._db;
    }

    private SchemaGroup assertSchemaGroup() {
        SchemaGroup local = this.getSchemaGroup();
        if (local == null) {
            throw new InvalidStateException(_loc.get("tool-norepos"));
        }
        return local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeSQL(String[] sql2) throws SQLException {
        if (sql2.length == 0) {
            return false;
        }
        boolean err = false;
        if (this._writer == null) {
            Connection conn = this._ds.getConnection();
            Statement statement = null;
            boolean wasAuto = true;
            try {
                wasAuto = conn.getAutoCommit();
                if (!wasAuto) {
                    conn.setAutoCommit(true);
                }
                for (int i = 0; i < sql2.length; ++i) {
                    try {
                        try {
                            conn.rollback();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        statement = conn.createStatement();
                        statement.executeUpdate(sql2[i]);
                        try {
                            conn.commit();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        continue;
                    }
                    catch (SQLException se) {
                        err = true;
                        this.handleException(se);
                        continue;
                    }
                    finally {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException se) {}
                        }
                    }
                }
            }
            finally {
                if (!wasAuto) {
                    conn.setAutoCommit(false);
                }
                try {
                    conn.close();
                }
                catch (SQLException se) {}
            }
        }
        for (int i = 0; i < sql2.length; ++i) {
            this._writer.println(sql2[i] + ";");
        }
        this._writer.flush();
        return !err;
    }

    private void handleException(SQLException sql2) throws SQLException {
        if (!this._ignoreErrs) {
            throw sql2;
        }
        this._log.warn(sql2.getMessage(), sql2);
    }

    public static void main(String[] args) throws IOException, SQLException {
        Options opts = new Options();
        final String[] arguments = opts.setFromCmdLine(args);
        boolean ret = Configurations.runAgainstAllAnchors(opts, new Configurations.Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean run(Options opts) throws Exception {
                JDBCConfigurationImpl conf = new JDBCConfigurationImpl();
                try {
                    boolean bl = SchemaTool.run(conf, arguments, opts);
                    return bl;
                }
                finally {
                    conf.close();
                }
            }
        });
        if (!ret) {
            System.out.println(_loc.get("tool-usage"));
        }
    }

    public static boolean run(JDBCConfiguration conf, String[] args, Options opts) throws IOException, SQLException {
        Flags flags = new Flags();
        flags.dropTables = opts.removeBooleanProperty("dropTables", "dt", flags.dropTables);
        flags.dropSequences = opts.removeBooleanProperty("dropSequences", "dsq", flags.dropSequences);
        flags.ignoreErrors = opts.removeBooleanProperty("ignoreErrors", "i", flags.ignoreErrors);
        flags.openjpaTables = opts.removeBooleanProperty("openjpaTables", "ot", flags.openjpaTables);
        flags.primaryKeys = opts.removeBooleanProperty("primaryKeys", "pk", flags.primaryKeys);
        flags.foreignKeys = opts.removeBooleanProperty("foreignKeys", "fks", flags.foreignKeys);
        flags.indexes = opts.removeBooleanProperty("indexes", "ix", flags.indexes);
        flags.sequences = opts.removeBooleanProperty("sequences", "sq", flags.sequences);
        flags.record = opts.removeBooleanProperty("record", "r", flags.record);
        String fileName = opts.removeProperty("file", "f", null);
        String schemas = opts.removeProperty("s");
        if (schemas != null) {
            opts.setProperty("schemas", schemas);
        }
        String[] actions = opts.removeProperty("action", "a", flags.action).split(",");
        Configurations.populateConfiguration(conf, opts);
        ClassLoader loader = conf.getClassResolverInstance().getClassLoader(SchemaTool.class, null);
        flags.writer = Files.getWriter(fileName, loader);
        boolean returnValue = true;
        for (int i = 0; i < actions.length; ++i) {
            flags.action = actions[i];
            returnValue &= SchemaTool.run(conf, args, flags, loader);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean run(JDBCConfiguration conf, String[] args, Flags flags, ClassLoader loader) throws IOException, SQLException {
        Log log = conf.getLog("openjpa.Tool");
        if (ACTION_REFLECT.equals(flags.action)) {
            if (args.length > 0) {
                return false;
            }
            if (flags.writer == null) {
                flags.writer = new PrintWriter(System.out);
            }
            SchemaGenerator gen = new SchemaGenerator(conf);
            gen.setPrimaryKeys(flags.primaryKeys);
            gen.setIndexes(flags.indexes);
            gen.setForeignKeys(flags.foreignKeys);
            gen.setSequences(flags.sequences);
            gen.setOpenJPATables(flags.openjpaTables);
            String schemas = conf.getSchemas();
            if (StringUtils.isEmpty((String)schemas)) {
                schemas = "all";
            }
            log.info(_loc.get("sch-reflect", schemas));
            gen.generateSchemas();
            log.info(_loc.get("sch-reflect-write"));
            XMLSchemaSerializer ser = new XMLSchemaSerializer(conf);
            ser.addAll(gen.getSchemaGroup());
            ser.serialize(flags.writer, 1);
            return true;
        }
        if (!(args.length != 0 || ACTION_CREATEDB.equals(flags.action) || ACTION_DROPDB.equals(flags.action) || ACTION_EXPORT.equals(flags.action) || ACTION_DELETE_TABLE_CONTENTS.equals(flags.action))) {
            return false;
        }
        XMLSchemaParser parser = new XMLSchemaParser(conf);
        parser.setDelayConstraintResolve(true);
        for (int i = 0; i < args.length; ++i) {
            File file = Files.getFile(args[i], loader);
            log.info(_loc.get("tool-running", file));
            parser.parse(file);
        }
        parser.resolveConstraints();
        if (ACTION_IMPORT.equals(flags.action)) {
            log.info(_loc.get("tool-import-store"));
            SchemaGroup schema = parser.getSchemaGroup();
            conf.getSchemaFactoryInstance().storeSchema(schema);
            return true;
        }
        if (ACTION_EXPORT.equals(flags.action)) {
            if (flags.writer == null) {
                flags.writer = new PrintWriter(System.out);
            }
            log.info(_loc.get("tool-export-gen"));
            SchemaGroup schema = conf.getSchemaFactoryInstance().readSchema();
            log.info(_loc.get("tool-export-write"));
            XMLSchemaSerializer ser = new XMLSchemaSerializer(conf);
            ser.addAll(schema);
            ser.serialize(flags.writer, 1);
            return true;
        }
        SchemaTool tool = new SchemaTool(conf, flags.action);
        tool.setIgnoreErrors(flags.ignoreErrors);
        tool.setDropTables(flags.dropTables);
        tool.setSequences(flags.sequences);
        tool.setDropSequences(flags.dropSequences);
        tool.setPrimaryKeys(flags.primaryKeys);
        tool.setForeignKeys(flags.foreignKeys);
        tool.setIndexes(flags.indexes);
        tool.setOpenJPATables(flags.openjpaTables);
        if (args.length > 0) {
            tool.setSchemaGroup(parser.getSchemaGroup());
        }
        if (flags.writer != null) {
            tool.setWriter(flags.writer);
        }
        log.info(_loc.get("tool-action", flags.action));
        try {
            tool.run();
        }
        finally {
            if (flags.record) {
                log.info(_loc.get("tool-record"));
                tool.record();
            }
        }
        if (flags.writer != null) {
            flags.writer.flush();
        }
        return true;
    }

    public static class Flags {
        public String action = "add";
        public Writer writer = null;
        public boolean dropTables = true;
        public boolean dropSequences = true;
        public boolean ignoreErrors = false;
        public boolean openjpaTables = false;
        public boolean primaryKeys = true;
        public boolean foreignKeys = true;
        public boolean indexes = true;
        public boolean sequences = true;
        public boolean record = true;
    }
}

