/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.logging;

import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.logging.SessionLog;
import oracle.toplink.logging.SessionLogEntry;
import oracle.toplink.sessions.Session;

public abstract class AbstractSessionLog
implements SessionLog,
Cloneable {
    protected int level;
    protected static SessionLog defaultLog;
    protected Session session;
    protected String sessionType;
    protected String sessionHashCode;
    protected static String SEVERE_PREFIX;
    protected static String WARNING_PREFIX;
    protected static String INFO_PREFIX;
    protected static String CONFIG_PREFIX;
    protected static String FINE_PREFIX;
    protected static String FINER_PREFIX;
    protected static String FINEST_PREFIX;
    protected static String TOPLINK_PREFIX;
    protected static String CONNECTION_STRING;
    protected static String THREAD_STRING;
    protected Writer writer = new PrintWriter(System.out);
    protected DateFormat dateFormat;
    protected Boolean shouldLogExceptionStackTrace;
    protected Boolean shouldPrintDate;
    protected Boolean shouldPrintThread;
    protected Boolean shouldPrintSession;

    static {
        SEVERE_PREFIX = null;
        WARNING_PREFIX = null;
        INFO_PREFIX = null;
        CONFIG_PREFIX = null;
        FINE_PREFIX = null;
        FINER_PREFIX = null;
        FINEST_PREFIX = null;
        TOPLINK_PREFIX = null;
        CONNECTION_STRING = "Connection";
        THREAD_STRING = "Thread";
    }

    public int getLevel() {
        return this.getLevel(null);
    }

    public int getLevel(String category) {
        return this.level;
    }

    public void setLevel(int level) {
        this.setLevel(level, null);
    }

    public void setLevel(int level, String category) {
        this.level = level;
    }

    public boolean shouldLog(int level) {
        return this.shouldLog(level, null);
    }

    public boolean shouldLog(int level, String category) {
        return this.level <= level && !this.isOff();
    }

    public static SessionLog getLog() {
        return null;
    }

    public static void setLog(SessionLog sessionLog) {
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        if (this.session == null) {
            this.session = session;
            this.buildSessionType();
            this.buildSessionHashCode();
        }
    }

    public void log(int level, String message) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, message, null);
    }

    public void log(int level, String message, Object param) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, message, new Object[]{param});
    }

    public void log(int level, String message, Object param1, Object param2) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, message, new Object[]{param1, param2});
    }

    public void log(int level, String message, Object param1, Object param2, Object param3) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, message, new Object[]{param1, param2, param3});
    }

    public void log(int level, String message, Object[] params) {
        this.log(level, message, params, true);
    }

    public void log(int level, String message, Object[] params, boolean shouldTranslate) {
    }

    public abstract void log(SessionLogEntry var1);

    public synchronized void log(oracle.toplink.sessions.SessionLogEntry entry) {
    }

    public boolean shouldPrintSession() {
        return this.shouldPrintSession == null || this.shouldPrintSession != false;
    }

    public void setShouldPrintSession(boolean shouldPrintSession) {
        this.shouldPrintSession = shouldPrintSession ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldPrintConnection() {
        return true;
    }

    public void setShouldPrintConnection(boolean shouldPrintConnection) {
    }

    public boolean shouldLogExceptions() {
        return this.level <= 6;
    }

    public void setShouldLogExceptions(boolean shouldLogExceptions) {
        if (shouldLogExceptions && this.level > 6) {
            this.setLevel(6);
        }
    }

    public boolean shouldLogExceptionStackTrace() {
        if (this.shouldLogExceptionStackTrace == null) {
            return this.getLevel() <= 2;
        }
        return this.shouldLogExceptionStackTrace;
    }

    public void setShouldLogExceptionStackTrace(boolean shouldLogExceptionStackTrace) {
        this.shouldLogExceptionStackTrace = shouldLogExceptionStackTrace ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldPrintDate() {
        return this.shouldPrintDate == null || this.shouldPrintDate != false;
    }

    public void setShouldPrintDate(boolean shouldPrintDate) {
        this.shouldPrintDate = shouldPrintDate ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldPrintThread() {
        if (this.shouldPrintThread == null) {
            return this.getLevel() <= 3;
        }
        return this.shouldPrintThread;
    }

    public void setShouldPrintThread(boolean shouldPrintThread) {
        this.shouldPrintThread = shouldPrintThread ? Boolean.TRUE : Boolean.FALSE;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public boolean shouldLogDebug() {
        return this.level <= 1;
    }

    public void setShouldLogDebug(boolean shouldLogDebug) {
        if (shouldLogDebug) {
            this.setLevel(1);
        }
    }

    protected DateFormat buildDefaultDateFormat() {
        return new SimpleDateFormat("yyyy.MM.dd hh:mm:ss.SSS");
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = this.buildDefaultDateFormat();
        }
        return this.dateFormat;
    }

    protected String getDateString(Date date) {
        return this.getDateFormat().format(date);
    }

    protected String getSupplementDetailString(SessionLogEntry entry) {
        return null;
    }

    protected String getSessionString(Session session) {
        return null;
    }

    protected void buildSessionType() {
    }

    protected void buildSessionHashCode() {
        this.sessionHashCode = this.session != null ? String.valueOf(System.identityHashCode(this.session)) : null;
    }

    protected String getSessionString() {
        return String.valueOf(this.sessionType) + "(" + this.sessionHashCode + ")";
    }

    protected String getConnectionString(Accessor connection) {
        return null;
    }

    protected String getThreadString(Thread thread) {
        return String.valueOf(THREAD_STRING) + "(" + String.valueOf(thread) + ")";
    }

    protected void printPrefixString(int level) {
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    protected String formatMessage(SessionLogEntry entry) {
        return null;
    }

    public void throwing(Throwable throwable) {
    }

    public void severe(String message) {
        this.log(7, message, null);
    }

    public void warning(String message) {
        this.log(6, message, null);
    }

    public void info(String message) {
        this.log(5, message, null);
    }

    public void config(String message) {
        this.log(4, message, null);
    }

    public void fine(String message) {
        this.log(3, message, null);
    }

    public void finer(String message) {
        this.log(2, message, null);
    }

    public void finest(String message) {
        this.log(1, message, null);
    }

    public void logThrowable(int level, Throwable throwable) {
    }

    public boolean isOff() {
        return this.level == 8;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

