/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.generic.ClientAdmin;
import com.sun.jmx.remote.generic.ProfileClient;
import com.sun.jmx.remote.generic.ProfileClientFactory;
import com.sun.jmx.remote.generic.SelectProfiles;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.HandshakeBeginMessage;
import javax.management.remote.message.HandshakeEndMessage;
import javax.management.remote.message.HandshakeErrorMessage;
import javax.management.remote.message.Message;
import javax.management.remote.message.ProfileMessage;
import javax.management.remote.message.VersionMessage;

public class AdminClient
implements ClientAdmin {
    private Map env = null;
    private String connectionId = null;
    private List profilesList = new ArrayList();
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "AdminClient");

    public AdminClient(Map map) {
        this.env = map != null ? map : Collections.EMPTY_MAP;
    }

    public MessageConnection connectionOpen(MessageConnection messageConnection) throws IOException {
        boolean bl = true;
        HandshakeErrorMessage handshakeErrorMessage = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            String string;
            HandshakeBeginMessage handshakeBeginMessage = null;
            Message message = messageConnection.readMessage();
            if (message instanceof HandshakeBeginMessage) {
                handshakeBeginMessage = (HandshakeBeginMessage)message;
            } else if (message instanceof HandshakeErrorMessage) {
                bl = false;
                handshakeErrorMessage = (HandshakeErrorMessage)message;
                AdminClient.throwExceptionOnError(handshakeErrorMessage);
            } else {
                throw new IOException("Unexpected message: " + message.getClass().getName());
            }
            String string2 = handshakeBeginMessage.getProfiles();
            String string3 = handshakeBeginMessage.getVersion();
            if (logger.traceOn()) {
                logger.trace("connectionOpen", ">>>>> Handshake Begin <<<<<");
                logger.trace("connectionOpen", "Server Supported Profiles [ " + string2 + " ]");
                logger.trace("connectionOpen", "Server JMXMP Version [ " + string3 + " ]");
            }
            if (!(string = "1.0").equals(string3)) {
                if (string.compareTo(string3) > 0) {
                    throw new IOException("The client is already using the lowest JMXMP protocol version [" + string + "]");
                }
                object5 = new VersionMessage(string);
                messageConnection.writeMessage((Message)object5);
                message = messageConnection.readMessage();
                if (message instanceof VersionMessage) {
                    object4 = (VersionMessage)message;
                    if (!string.equals(((VersionMessage)object4).getVersion())) {
                        throw new IOException("Protocol version mismatch: Client [" + string + "] vs. Server [" + ((VersionMessage)object4).getVersion() + "]");
                    }
                } else if (message instanceof HandshakeErrorMessage) {
                    bl = false;
                    handshakeErrorMessage = (HandshakeErrorMessage)message;
                    AdminClient.throwExceptionOnError(handshakeErrorMessage);
                } else {
                    throw new IOException("Unexpected message: " + message.getClass().getName());
                }
            }
            object5 = this.selectProfiles(string2);
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                object2 = ProfileClientFactory.createProfile((String)object3, this.env);
                if (logger.traceOn()) {
                    logger.trace("connectionOpen", ">>>>> Profile " + object2.getClass().getName() + " <<<<<");
                }
                object = null;
                object2.initialize(messageConnection);
                while (!object2.isComplete()) {
                    object = object2.produceMessage();
                    messageConnection.writeMessage((Message)object);
                    message = messageConnection.readMessage();
                    if (message instanceof ProfileMessage) {
                        object2.consumeMessage((ProfileMessage)message);
                        continue;
                    }
                    if (message instanceof HandshakeErrorMessage) {
                        bl = false;
                        handshakeErrorMessage = (HandshakeErrorMessage)message;
                        AdminClient.throwExceptionOnError(handshakeErrorMessage);
                        continue;
                    }
                    throw new IOException("Unexpected message: " + message.getClass().getName());
                }
                object2.activate();
                this.profilesList.add(object2);
            }
            object4 = this.env.get("jmx.remote.context");
            object3 = new HandshakeEndMessage(object4, null);
            if (logger.traceOn()) {
                logger.trace("connectionOpen", ">>>>> Handshake End <<<<<");
                logger.trace("connectionOpen", "Client Context Object [ " + object4 + " ]");
            }
            messageConnection.writeMessage((Message)object3);
            object2 = null;
            message = messageConnection.readMessage();
            if (message instanceof HandshakeEndMessage) {
                object2 = (HandshakeEndMessage)message;
            } else if (message instanceof HandshakeErrorMessage) {
                bl = false;
                handshakeErrorMessage = (HandshakeErrorMessage)message;
                AdminClient.throwExceptionOnError(handshakeErrorMessage);
            } else {
                throw new IOException("Unexpected message: " + message.getClass().getName());
            }
            object = ((HandshakeEndMessage)object2).getContext();
            this.connectionId = ((HandshakeEndMessage)object2).getConnectionId();
            if (logger.traceOn()) {
                logger.trace("connectionOpen", "Server Context Object [ " + object + " ]");
                logger.trace("connectionOpen", "Server Connection Id [ " + this.connectionId + " ]");
            }
        }
        catch (Exception exception) {
            block30: {
                if (bl) {
                    try {
                        messageConnection.writeMessage(new HandshakeErrorMessage(exception.toString()));
                    }
                    catch (Exception exception2) {
                        if (!logger.debugOn()) break block30;
                        logger.debug("connectionOpen", "Could not send HandshakeErrorMessage to the server", exception2);
                    }
                }
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw (IOException)EnvHelp.initCause(new IOException(exception.getMessage()), exception);
        }
        return messageConnection;
    }

    public void connectionClosed(MessageConnection messageConnection) {
        Iterator iterator = this.profilesList.iterator();
        while (iterator.hasNext()) {
            ProfileClient profileClient = (ProfileClient)iterator.next();
            try {
                profileClient.terminate();
            }
            catch (Exception exception) {
                if (!logger.debugOn()) continue;
                logger.debug("connectionClosed", "Got an exception to terminate a ProfileClient: " + profileClient.getName(), exception);
            }
        }
        this.profilesList.clear();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    private List selectProfiles(String string) throws Exception {
        boolean bl;
        SelectProfiles selectProfiles = (SelectProfiles)this.env.get("com.sun.jmx.remote.profile.selector");
        if (selectProfiles != null) {
            selectProfiles.selectProfiles(this.env, string);
            String string2 = (String)this.env.get("jmx.remote.profiles");
            if (string2 == null) {
                return Collections.EMPTY_LIST;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                arrayList.add(string3);
            }
            return arrayList;
        }
        String string4 = (String)this.env.get("jmx.remote.profiles");
        boolean bl2 = string == null || string.equals("");
        boolean bl3 = bl = string4 == null || string4.equals("");
        if (bl2 && bl) {
            return Collections.EMPTY_LIST;
        }
        if (bl2) {
            throw new IOException("The server does not support any profile but the client requires one");
        }
        if (bl) {
            throw new IOException("The client does not require any profile but the server mandates one");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            arrayList.add(string5);
        }
        int n = arrayList.size();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, " ");
        ArrayList<String> arrayList2 = new ArrayList<String>(stringTokenizer2.countTokens());
        while (stringTokenizer2.hasMoreTokens()) {
            String string6 = stringTokenizer2.nextToken();
            arrayList2.add(string6);
        }
        int n2 = arrayList2.size();
        if (n < n2 || !arrayList.containsAll(arrayList2)) {
            throw new IOException("The server supported profiles " + arrayList + " do not " + "match the client required profiles " + arrayList2 + ".");
        }
        return arrayList2;
    }

    static void throwExceptionOnError(HandshakeErrorMessage handshakeErrorMessage) throws IOException, SecurityException {
        String string = handshakeErrorMessage.getDetail();
        if (string.startsWith("java.lang.SecurityException") || string.startsWith("java.security.") || string.startsWith("javax.net.ssl.") || string.startsWith("javax.security.")) {
            throw new SecurityException(string);
        }
        throw new IOException(string);
    }
}

