/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public final class LocaleContext {
    private static final ThreadLocalFormatterStorage formatterStorage = new ThreadLocalFormatterStorage();

    public static DecimalFormat getFloatingPointFormatter() {
        return LocaleContext.getFormatters().getFloatingPointFormatter();
    }

    public static DecimalFormat getIntegerFormatter() {
        return LocaleContext.getFormatters().getIntegerFormatter();
    }

    public static DecimalFormat getPercentFormatter() {
        return LocaleContext.getFormatters().getPercentFormatter();
    }

    public static DecimalFormat getCurrencyFormatter() {
        return LocaleContext.getFormatters().getCurrencyFormatter();
    }

    public static char getDecimalGroupSeparator() {
        return LocaleContext.getFormatters().getDecimalGroupSeparator();
    }

    public static DateFormat getDateFormatter() {
        return LocaleContext.getFormatters().getDateFormatter();
    }

    public static void setLocale(Locale locale) {
        LocaleContext.getFormatters().setLocale(locale);
    }

    private static Formatters getFormatters() {
        return (Formatters)formatterStorage.get();
    }

    private LocaleContext() {
    }

    private static class Formatters {
        private Locale locale;
        private DecimalFormat floatingPointFormatter;
        private DecimalFormat integerFormatter;
        private char decimalSeparator = '\u0000';
        private DateFormat dateFormatter;
        private DecimalFormat percentFormatter;
        private DecimalFormat currencyFormatter;

        private Formatters() {
        }

        void setLocale(Locale locale) {
            this.locale = locale;
            this.floatingPointFormatter = null;
            this.integerFormatter = null;
            this.decimalSeparator = '\u0000';
            this.dateFormatter = null;
            this.percentFormatter = null;
            this.currencyFormatter = null;
        }

        Locale getLocale() {
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
            return this.locale;
        }

        DecimalFormat getFloatingPointFormatter() {
            if (this.floatingPointFormatter == null) {
                this.floatingPointFormatter = (DecimalFormat)NumberFormat.getNumberInstance(this.getLocale());
                this.floatingPointFormatter.applyPattern("#,###.#");
            }
            return this.floatingPointFormatter;
        }

        DecimalFormat getIntegerFormatter() {
            if (this.integerFormatter == null) {
                this.integerFormatter = (DecimalFormat)NumberFormat.getNumberInstance(this.getLocale());
                this.integerFormatter.applyPattern("#,###");
            }
            return this.integerFormatter;
        }

        DecimalFormat getPercentFormatter() {
            if (this.percentFormatter == null) {
                this.percentFormatter = (DecimalFormat)NumberFormat.getPercentInstance(this.getLocale());
            }
            return this.percentFormatter;
        }

        DecimalFormat getCurrencyFormatter() {
            if (this.currencyFormatter == null) {
                this.currencyFormatter = (DecimalFormat)NumberFormat.getCurrencyInstance(this.getLocale());
            }
            return this.currencyFormatter;
        }

        char getDecimalGroupSeparator() {
            if (this.decimalSeparator == '\u0000') {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(this.getLocale());
                this.decimalSeparator = new Character(symbols.getGroupingSeparator()).charValue();
            }
            return this.decimalSeparator;
        }

        DateFormat getDateFormatter() {
            if (this.dateFormatter == null) {
                this.dateFormatter = DateFormat.getDateTimeInstance(3, 2, this.getLocale());
            }
            return this.dateFormatter;
        }
    }

    private static final class ThreadLocalFormatterStorage
    extends ThreadLocal {
        private ThreadLocalFormatterStorage() {
        }

        protected Object initialValue() {
            return new Formatters();
        }
    }
}

