/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaMethod
extends JavaCallable {
    private final Method method;
    private final Class[] parameterTypes;

    public static RubyClass createJavaMethodClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaMethod", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaMethod.class);
        JavaAccessibleObject.registerRubyMethods(runtime, result);
        result.defineFastMethod("name", callbackFactory.getFastMethod("name"));
        result.defineFastMethod("arity", callbackFactory.getFastMethod("arity"));
        result.defineFastMethod("public?", callbackFactory.getFastMethod("public_p"));
        result.defineFastMethod("final?", callbackFactory.getFastMethod("final_p"));
        result.defineFastMethod("static?", callbackFactory.getFastMethod("static_p"));
        result.defineFastMethod("invoke", callbackFactory.getFastOptMethod("invoke"));
        result.defineFastMethod("invoke_static", callbackFactory.getFastOptMethod("invoke_static"));
        result.defineFastMethod("argument_types", callbackFactory.getFastMethod("argument_types"));
        result.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
        result.defineFastMethod("return_type", callbackFactory.getFastMethod("return_type"));
        return result;
    }

    public JavaMethod(Ruby runtime, Method method) {
        super(runtime, runtime.getModule("Java").getClass("JavaMethod"));
        this.method = method;
        this.parameterTypes = method.getParameterTypes();
        if (Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getClass().getModifiers()) && !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            this.accesibleObject().setAccessible(true);
        }
    }

    public static JavaMethod create(Ruby runtime, Method method) {
        return new JavaMethod(runtime, method);
    }

    public static JavaMethod create(Ruby runtime, Class javaClass, String methodName, Class[] argumentTypes) {
        try {
            Method method = javaClass.getMethod(methodName, argumentTypes);
            return JavaMethod.create(runtime, method);
        }
        catch (NoSuchMethodException e) {
            throw runtime.newNameError("undefined method '" + methodName + "' for class '" + javaClass.getName() + "'", methodName);
        }
    }

    public static JavaMethod createDeclared(Ruby runtime, Class javaClass, String methodName, Class[] argumentTypes) {
        try {
            Method method = javaClass.getDeclaredMethod(methodName, argumentTypes);
            return JavaMethod.create(runtime, method);
        }
        catch (NoSuchMethodException e) {
            throw runtime.newNameError("undefined method '" + methodName + "' for class '" + javaClass.getName() + "'", methodName);
        }
    }

    public RubyString name() {
        return this.getRuntime().newString(this.method.getName());
    }

    protected int getArity() {
        return this.parameterTypes.length;
    }

    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.method.getModifiers()));
    }

    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.method.getModifiers()));
    }

    public IRubyObject invoke(IRubyObject[] args) {
        JavaProxyClass jpc;
        JavaProxyMethod jpm;
        if (args.length != 1 + this.getArity()) {
            throw this.getRuntime().newArgumentError(args.length, 1 + this.getArity());
        }
        IRubyObject invokee = args[0];
        if (!(invokee instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("invokee not a java object");
        }
        Object javaInvokee = ((JavaObject)invokee).getValue();
        Object[] arguments = new Object[args.length - 1];
        this.convertArguments(arguments, args, 1);
        if (!this.method.getDeclaringClass().isInstance(javaInvokee)) {
            throw this.getRuntime().newTypeError("invokee not instance of method's class (got" + javaInvokee.getClass().getName() + " wanted " + this.method.getDeclaringClass().getName() + ")");
        }
        if (javaInvokee instanceof InternalJavaProxy && !Modifier.isFinal(this.method.getModifiers()) && (jpm = (jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass()).getMethod(this.method.getName(), this.parameterTypes)) != null && jpm.hasSuperImplementation()) {
            return this.invokeWithExceptionHandling(jpm.getSuperMethod(), javaInvokee, arguments);
        }
        return this.invokeWithExceptionHandling(this.method, javaInvokee, arguments);
    }

    public IRubyObject invoke_static(IRubyObject[] args) {
        if (args.length != this.getArity()) {
            throw this.getRuntime().newArgumentError(args.length, this.getArity());
        }
        Object[] arguments = new Object[args.length];
        System.arraycopy(args, 0, arguments, 0, arguments.length);
        this.convertArguments(arguments, args, 0);
        return this.invokeWithExceptionHandling(this.method, null, arguments);
    }

    public IRubyObject return_type() {
        Class<?> klass = this.method.getReturnType();
        if (klass.equals(Void.TYPE)) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), klass);
    }

    private IRubyObject invokeWithExceptionHandling(Method method, Object javaInvokee, Object[] arguments) {
        try {
            Object result = method.invoke(javaInvokee, arguments);
            return JavaObject.wrap(this.getRuntime(), result);
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newTypeError("expected " + this.argument_types().inspect() + "; got: " + this.dumpArgTypes(arguments) + "; error: " + iae.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access on '" + method.getName() + "': " + iae.getMessage());
        }
        catch (InvocationTargetException ite) {
            this.getRuntime().getJavaSupport().handleNativeException(ite.getTargetException());
            return this.getRuntime().getNil();
        }
    }

    private String dumpArgTypes(Object[] arguments) {
        StringBuffer str = new StringBuffer("[");
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            if (arguments[i] == null) {
                str.append("null");
                continue;
            }
            str.append(arguments[i].getClass().getName());
        }
        str.append("]");
        return str.toString();
    }

    private void convertArguments(Object[] arguments, Object[] args, int from) {
        Class[] parameterTypes = this.parameterTypes();
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = JavaUtil.convertArgument(args[i + from], parameterTypes[i]);
        }
    }

    protected Class[] parameterTypes() {
        return this.parameterTypes;
    }

    protected String nameOnInspection() {
        return "#<" + this.getType().toString() + "/" + this.method.getName() + "(";
    }

    public RubyBoolean static_p() {
        return this.getRuntime().newBoolean(this.isStatic());
    }

    private boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    protected int getModifiers() {
        return this.method.getModifiers();
    }

    protected AccessibleObject accesibleObject() {
        return this.method;
    }
}

