/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.classextension.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.VisibilityPredicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.easymock.classextension.internal.ClassInstantiatorFactory;
import org.easymock.internal.IProxyFactory;

public class ClassProxyFactory
implements IProxyFactory {
    private Set mockedMethods;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$easymock$internal$ObjectMethodsFilter;

    public ClassProxyFactory(Method[] mockedMethods) {
        this.mockedMethods = mockedMethods == null ? null : new HashSet<Method>(Arrays.asList(mockedMethods));
    }

    public Object createProxy(Class toMock, final InvocationHandler handler) {
        try {
            this.updateMethod(handler, toMock.getMethod("equals", class$java$lang$Object == null ? (class$java$lang$Object = ClassProxyFactory.class$("java.lang.Object")) : class$java$lang$Object));
            this.updateMethod(handler, toMock.getMethod("hashCode", new Class[0]));
            this.updateMethod(handler, toMock.getMethod("toString", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("We strangly failed to retrieve methods that always exist on an object...");
        }
        MethodInterceptor interceptor = new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                if (ClassProxyFactory.this.mockedMethods != null && !ClassProxyFactory.this.mockedMethods.contains(method)) {
                    return proxy.invokeSuper(obj, args);
                }
                return handler.invoke(obj, method, args);
            }
        };
        Enhancer enhancer = new Enhancer(){

            protected void filterConstructors(Class sc, List constructors) {
                CollectionUtils.filter((Collection)constructors, (Predicate)new VisibilityPredicate(sc, true));
            }
        };
        enhancer.setSuperclass(toMock);
        enhancer.setCallbackType(interceptor.getClass());
        enhancer.setUseFactory(false);
        enhancer.setUseCache(false);
        Class mock = enhancer.createClass();
        Enhancer.registerCallbacks((Class)mock, (Callback[])new Callback[]{interceptor});
        try {
            return ClassInstantiatorFactory.getInstantiator().newInstance(mock);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Fail to instantiate mock for " + toMock + " on " + ClassInstantiatorFactory.getJVM() + " JVM");
        }
    }

    private void updateMethod(InvocationHandler objectMethodsFilter, Method correctMethod) {
        Field methodField = this.retrieveField(class$org$easymock$internal$ObjectMethodsFilter == null ? (class$org$easymock$internal$ObjectMethodsFilter = ClassProxyFactory.class$("org.easymock.internal.ObjectMethodsFilter")) : class$org$easymock$internal$ObjectMethodsFilter, correctMethod.getName() + "Method");
        this.updateField(objectMethodsFilter, correctMethod, methodField);
    }

    private Field retrieveField(Class clazz, String field) {
        try {
            return clazz.getDeclaredField(field);
        }
        catch (NoSuchFieldException e) {
            throw new InternalError("There must be some refactoring because the " + field + " field was there...");
        }
    }

    private void updateField(Object instance, Object value, Field field) {
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new InternalError("Should be accessible since we set it ourselves");
        }
        field.setAccessible(accessible);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

