/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.RowSetMetaData;

public class RowSetMetaDataImpl
implements RowSetMetaData,
Serializable {
    private int colCount;
    private ColInfo[] colInfo;
    static final long serialVersionUID = 6893806403181801867L;
    static /* synthetic */ Class class$java$sql$Types;

    private void checkColRange(int n) throws SQLException {
        if (n <= 0 || n > this.colCount) {
            throw new SQLException("Invalid column index :" + n);
        }
    }

    private void checkColType(int n) throws SQLException {
        try {
            Class clazz = class$java$sql$Types == null ? (class$java$sql$Types = RowSetMetaDataImpl.class$("java.sql.Types")) : class$java$sql$Types;
            Field[] fieldArray = clazz.getFields();
            int n2 = 0;
            for (int i = 0; i < fieldArray.length; ++i) {
                n2 = fieldArray[i].getInt(clazz);
                if (n2 != n) continue;
                return;
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
        throw new SQLException("Invalid SQL type for column");
    }

    public void setColumnCount(int n) throws SQLException {
        if (n <= 0) {
            throw new SQLException("Invalid column count. Cannot be less or equal to zero");
        }
        this.colCount = n;
        if (this.colCount != Integer.MAX_VALUE) {
            this.colInfo = new ColInfo[this.colCount + 1];
            for (int i = 1; i <= this.colCount; ++i) {
                this.colInfo[i] = new ColInfo();
            }
        }
    }

    public void setAutoIncrement(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].autoIncrement = bl;
    }

    public void setCaseSensitive(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].caseSensitive = bl;
    }

    public void setSearchable(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].searchable = bl;
    }

    public void setCurrency(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].currency = bl;
    }

    public void setNullable(int n, int n2) throws SQLException {
        if (n2 < 0 || n2 > 2) {
            throw new SQLException("Invalid nullable constant set. Must be either columnNoNulls, columnNullable or columnNullableUnknown");
        }
        this.checkColRange(n);
        this.colInfo[n].nullable = n2;
    }

    public void setSigned(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].signed = bl;
    }

    public void setColumnDisplaySize(int n, int n2) throws SQLException {
        if (n2 < 0) {
            throw new SQLException("Invalid column display size. Cannot be less than zero");
        }
        this.checkColRange(n);
        this.colInfo[n].columnDisplaySize = n2;
    }

    public void setColumnLabel(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].columnLabel = string != null ? new String(string) : new String("");
    }

    public void setColumnName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].columnName = string != null ? new String(string) : new String("");
    }

    public void setSchemaName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].schemaName = string != null ? new String(string) : new String("");
    }

    public void setPrecision(int n, int n2) throws SQLException {
        if (n2 < 0) {
            throw new SQLException("Invalid precision value. Cannot be less than zero");
        }
        this.checkColRange(n);
        this.colInfo[n].colPrecision = n2;
    }

    public void setScale(int n, int n2) throws SQLException {
        if (n2 < 0) {
            throw new SQLException("Invalid scale size. Cannot be less than zero");
        }
        this.checkColRange(n);
        this.colInfo[n].colScale = n2;
    }

    public void setTableName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].tableName = string != null ? new String(string) : new String("");
    }

    public void setCatalogName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].catName = string != null ? new String(string) : new String("");
    }

    public void setColumnType(int n, int n2) throws SQLException {
        this.checkColType(n2);
        this.checkColRange(n);
        this.colInfo[n].colType = n2;
    }

    public void setColumnTypeName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].colTypeName = string != null ? new String(string) : new String("");
    }

    public int getColumnCount() throws SQLException {
        return this.colCount;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].autoIncrement;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].caseSensitive;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].searchable;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].currency;
    }

    public int isNullable(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].nullable;
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].signed;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].columnDisplaySize;
    }

    public String getColumnLabel(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].columnLabel;
    }

    public String getColumnName(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].columnName;
    }

    public String getSchemaName(int n) throws SQLException {
        this.checkColRange(n);
        String string = "";
        if (this.colInfo[n].schemaName != null) {
            string = this.colInfo[n].schemaName;
        }
        return string;
    }

    public int getPrecision(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].colPrecision;
    }

    public int getScale(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].colScale;
    }

    public String getTableName(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].tableName;
    }

    public String getCatalogName(int n) throws SQLException {
        this.checkColRange(n);
        String string = "";
        if (this.colInfo[n].catName != null) {
            string = this.colInfo[n].catName;
        }
        return string;
    }

    public int getColumnType(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].colType;
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].colTypeName;
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].readOnly;
    }

    public boolean isWritable(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].writable;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return true;
    }

    public String getColumnClassName(int n) throws SQLException {
        String string = new String().getClass().getName();
        int n2 = this.getColumnType(n);
        switch (n2) {
            case 2: 
            case 3: {
                string = new BigDecimal(0.0).getClass().getName();
                break;
            }
            case -7: {
                string = new Boolean(false).getClass().getName();
                break;
            }
            case -6: {
                string = new Byte("0").getClass().getName();
                break;
            }
            case 5: {
                string = new Short("0").getClass().getName();
                break;
            }
            case 4: {
                string = new Integer(0).getClass().getName();
                break;
            }
            case -5: {
                string = new Long(0L).getClass().getName();
                break;
            }
            case 7: {
                string = new Float(0.0f).getClass().getName();
                break;
            }
            case 6: 
            case 8: {
                string = new Double(0.0).getClass().getName();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray = new byte[]{};
                string = byArray.getClass().getName();
                break;
            }
            case 91: {
                string = new Date(123456L).getClass().getName();
                break;
            }
            case 92: {
                string = new Time(123456L).getClass().getName();
                break;
            }
            case 93: {
                string = new Timestamp(123456L).getClass().getName();
                break;
            }
            case 2004: {
                byte[] byArray = new byte[]{};
                string = byArray.getClass().getName();
                break;
            }
            case 2005: {
                char[] cArray = new char[]{};
                string = cArray.getClass().getName();
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ColInfo
    implements Serializable {
        public boolean autoIncrement;
        public boolean caseSensitive;
        public boolean currency;
        public int nullable;
        public boolean signed;
        public boolean searchable;
        public int columnDisplaySize;
        public String columnLabel;
        public String columnName;
        public String schemaName;
        public int colPrecision;
        public int colScale;
        public String tableName = "";
        public String catName;
        public int colType;
        public String colTypeName;
        public boolean readOnly = false;
        public boolean writable = true;

        private ColInfo() {
        }
    }
}

