/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.model.SelectItem;

final class SelectItemsIterator
implements Iterator {
    private Iterator items = null;
    private Iterator kids = null;
    private UIComponent parent = null;

    public SelectItemsIterator(UIComponent parent) {
        this.parent = parent;
        this.kids = parent.getChildren().iterator();
    }

    public boolean hasNext() {
        if (this.items != null) {
            if (this.items.hasNext()) {
                return true;
            }
            this.items = null;
        }
        return this.kids.hasNext();
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.items != null) {
            return this.items.next();
        }
        UIComponent kid = (UIComponent)this.kids.next();
        if (kid instanceof UISelectItem) {
            UISelectItem ui = (UISelectItem)kid;
            SelectItem item = (SelectItem)ui.getValue();
            if (item == null) {
                item = new SelectItem(ui.getItemValue(), ui.getItemLabel(), ui.getItemDescription(), ui.isItemDisabled());
            }
            return item;
        }
        if (kid instanceof UISelectItems) {
            UISelectItems ui = (UISelectItems)kid;
            Object value = ui.getValue();
            if (value instanceof SelectItem) {
                return value;
            }
            if (value instanceof SelectItem[]) {
                this.items = Arrays.asList((Object[])value).iterator();
                return this.next();
            }
            if (value instanceof List) {
                this.items = ((List)value).iterator();
                return this.next();
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

