/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;

public abstract class ElementDrawer {
    public abstract void draw(Graphics2D var1, JRPrintElement var2, int var3, int var4) throws JRException;

    protected void drawBox(Graphics2D grx, JRLineBox box, JRPrintElement element, int offsetX, int offsetY) {
        this.drawTopPen(grx, box.getTopPen(), box.getLeftPen(), box.getRightPen(), element, offsetX, offsetY);
        this.drawLeftPen(grx, box.getTopPen(), box.getLeftPen(), box.getBottomPen(), element, offsetX, offsetY);
        this.drawBottomPen(grx, box.getLeftPen(), box.getBottomPen(), box.getRightPen(), element, offsetX, offsetY);
        this.drawRightPen(grx, box.getTopPen(), box.getBottomPen(), box.getRightPen(), element, offsetX, offsetY);
    }

    protected void drawPen(Graphics2D grx, JRPen pen, JRPrintElement element, int offsetX, int offsetY) {
        this.drawTopPen(grx, pen, pen, pen, element, offsetX, offsetY);
        this.drawLeftPen(grx, pen, pen, pen, element, offsetX, offsetY);
        this.drawBottomPen(grx, pen, pen, pen, element, offsetX, offsetY);
        this.drawRightPen(grx, pen, pen, pen, element, offsetX, offsetY);
    }

    protected void drawTopPen(Graphics2D grx, JRPen topPen, JRPen leftPen, JRPen rightPen, JRPrintElement element, int offsetX, int offsetY) {
        Stroke topStroke = ElementDrawer.getStroke(topPen, 0);
        if (topStroke != null) {
            grx.setStroke(topStroke);
            grx.setColor(topPen.getLineColor());
            AffineTransform oldTx = grx.getTransform();
            if (topPen.getLineStyle() == 3) {
                grx.translate((float)(element.getX() + offsetX) - leftPen.getLineWidth().floatValue() / 2.0f, (float)(element.getY() + offsetY) - topPen.getLineWidth().floatValue() / 3.0f);
                grx.scale(((float)element.getWidth() + (leftPen.getLineWidth().floatValue() + rightPen.getLineWidth().floatValue()) / 2.0f) / (float)element.getWidth(), 1.0);
                grx.drawLine(0, 0, element.getWidth(), 0);
                grx.setTransform(oldTx);
                grx.translate((float)(element.getX() + offsetX) + leftPen.getLineWidth().floatValue() / 6.0f, (float)(element.getY() + offsetY) + topPen.getLineWidth().floatValue() / 3.0f);
                grx.scale(((float)element.getWidth() - (leftPen.getLineWidth().floatValue() + rightPen.getLineWidth().floatValue()) / 6.0f) / (float)element.getWidth(), 1.0);
                grx.drawLine(0, 0, element.getWidth(), 0);
            } else {
                grx.translate((float)(element.getX() + offsetX) - leftPen.getLineWidth().floatValue() / 2.0f, (double)(element.getY() + offsetY));
                grx.scale(((float)element.getWidth() + (leftPen.getLineWidth().floatValue() + rightPen.getLineWidth().floatValue()) / 2.0f) / (float)element.getWidth(), 1.0);
                grx.drawLine(0, 0, element.getWidth(), 0);
            }
            grx.setTransform(oldTx);
        }
    }

    protected void drawLeftPen(Graphics2D grx, JRPen topPen, JRPen leftPen, JRPen bottomPen, JRPrintElement element, int offsetX, int offsetY) {
        Stroke leftStroke = ElementDrawer.getStroke(leftPen, 0);
        if (leftStroke != null) {
            grx.setStroke(leftStroke);
            grx.setColor(leftPen.getLineColor());
            AffineTransform oldTx = grx.getTransform();
            if (leftPen.getLineStyle() == 3) {
                grx.translate((float)(element.getX() + offsetX) - leftPen.getLineWidth().floatValue() / 3.0f, (float)(element.getY() + offsetY) - topPen.getLineWidth().floatValue() / 2.0f);
                grx.scale(1.0, ((float)element.getHeight() + (topPen.getLineWidth().floatValue() + bottomPen.getLineWidth().floatValue()) / 2.0f) / (float)element.getHeight());
                grx.drawLine(0, 0, 0, element.getHeight());
                grx.setTransform(oldTx);
                grx.translate((float)(element.getX() + offsetX) + leftPen.getLineWidth().floatValue() / 3.0f, (float)(element.getY() + offsetY) + topPen.getLineWidth().floatValue() / 6.0f);
                grx.scale(1.0, ((float)element.getHeight() - (topPen.getLineWidth().floatValue() + bottomPen.getLineWidth().floatValue()) / 6.0f) / (float)element.getHeight());
                grx.drawLine(0, 0, 0, element.getHeight());
            } else {
                grx.translate((double)(element.getX() + offsetX), (float)(element.getY() + offsetY) - topPen.getLineWidth().floatValue() / 2.0f);
                grx.scale(1.0, ((float)element.getHeight() + (topPen.getLineWidth().floatValue() + bottomPen.getLineWidth().floatValue()) / 2.0f) / (float)element.getHeight());
                grx.drawLine(0, 0, 0, element.getHeight());
            }
            grx.setTransform(oldTx);
        }
    }

    protected void drawBottomPen(Graphics2D grx, JRPen leftPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element, int offsetX, int offsetY) {
        Stroke bottomStroke = ElementDrawer.getStroke(bottomPen, 0);
        if (bottomStroke != null) {
            grx.setStroke(bottomStroke);
            grx.setColor(bottomPen.getLineColor());
            AffineTransform oldTx = grx.getTransform();
            if (bottomPen.getLineStyle() == 3) {
                grx.translate((float)(element.getX() + offsetX) - leftPen.getLineWidth().floatValue() / 2.0f, (float)(element.getY() + offsetY + element.getHeight()) + bottomPen.getLineWidth().floatValue() / 3.0f);
                grx.scale(((float)element.getWidth() + (leftPen.getLineWidth().floatValue() + rightPen.getLineWidth().floatValue()) / 2.0f) / (float)element.getWidth(), 1.0);
                grx.drawLine(0, 0, element.getWidth(), 0);
                grx.setTransform(oldTx);
                grx.translate((float)(element.getX() + offsetX) + leftPen.getLineWidth().floatValue() / 6.0f, (float)(element.getY() + offsetY + element.getHeight()) - bottomPen.getLineWidth().floatValue() / 3.0f);
                grx.scale(((float)element.getWidth() - (leftPen.getLineWidth().floatValue() + rightPen.getLineWidth().floatValue()) / 6.0f) / (float)element.getWidth(), 1.0);
                grx.drawLine(0, 0, element.getWidth(), 0);
            } else {
                grx.translate((float)(element.getX() + offsetX) - leftPen.getLineWidth().floatValue() / 2.0f, (double)(element.getY() + offsetY + element.getHeight()));
                grx.scale(((float)element.getWidth() + (leftPen.getLineWidth().floatValue() + rightPen.getLineWidth().floatValue()) / 2.0f) / (float)element.getWidth(), 1.0);
                grx.drawLine(0, 0, element.getWidth(), 0);
            }
            grx.setTransform(oldTx);
        }
    }

    protected void drawRightPen(Graphics2D grx, JRPen topPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element, int offsetX, int offsetY) {
        Stroke rightStroke = ElementDrawer.getStroke(rightPen, 0);
        if (rightStroke != null) {
            grx.setStroke(rightStroke);
            grx.setColor(rightPen.getLineColor());
            AffineTransform oldTx = grx.getTransform();
            if (rightPen.getLineStyle() == 3) {
                grx.translate((float)(element.getX() + offsetX + element.getWidth()) + rightPen.getLineWidth().floatValue() / 3.0f, (float)(element.getY() + offsetY) - topPen.getLineWidth().floatValue() / 2.0f);
                grx.scale(1.0, ((float)element.getHeight() + (topPen.getLineWidth().floatValue() + bottomPen.getLineWidth().floatValue()) / 2.0f) / (float)element.getHeight());
                grx.drawLine(0, 0, 0, element.getHeight());
                grx.setTransform(oldTx);
                grx.translate((float)(element.getX() + offsetX + element.getWidth()) - rightPen.getLineWidth().floatValue() / 3.0f, (float)(element.getY() + offsetY) + topPen.getLineWidth().floatValue() / 6.0f);
                grx.scale(1.0, ((float)element.getHeight() - (topPen.getLineWidth().floatValue() + bottomPen.getLineWidth().floatValue()) / 6.0f) / (float)element.getHeight());
                grx.drawLine(0, 0, 0, element.getHeight());
            } else {
                grx.translate((double)(element.getX() + offsetX + element.getWidth()), (float)(element.getY() + offsetY) - topPen.getLineWidth().floatValue() / 2.0f);
                grx.scale(1.0, ((float)element.getHeight() + (topPen.getLineWidth().floatValue() + bottomPen.getLineWidth().floatValue()) / 2.0f) / (float)element.getHeight());
                grx.drawLine(0, 0, 0, element.getHeight());
            }
            grx.setTransform(oldTx);
        }
    }

    protected static Stroke getStroke(JRPen pen, int lineCap) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            byte lineStyle = pen.getLineStyle();
            switch (lineStyle) {
                case 3: {
                    return new BasicStroke(lineWidth / 3.0f, lineCap, 0);
                }
                case 2: {
                    switch (lineCap) {
                        case 2: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{0.0f, 2.0f * lineWidth}, 0.0f);
                        }
                        case 0: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{lineWidth, lineWidth}, 0.0f);
                        }
                    }
                }
                case 1: {
                    switch (lineCap) {
                        case 2: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{4.0f * lineWidth, 4.0f * lineWidth}, 0.0f);
                        }
                        case 0: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{5.0f * lineWidth, 3.0f * lineWidth}, 0.0f);
                        }
                    }
                }
            }
            return new BasicStroke(lineWidth, lineCap, 0);
        }
        return null;
    }
}

