/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.web.servlet.ModelAndView;

public abstract class ModelAndViewAssert {
    public static Object assertAndReturnModelAttributeOfType(ModelAndView mav, Object modelName, Class expectedType) throws AssertionError {
        ModelAndViewAssert.assertCondition(mav != null, "ModelAndView is null");
        ModelAndViewAssert.assertCondition(mav.getModel() != null, "Model is null");
        Object obj = mav.getModel().get(modelName);
        ModelAndViewAssert.assertCondition(obj != null, "Model attribute with name '" + modelName + "' is null");
        ModelAndViewAssert.assertCondition(expectedType.isAssignableFrom(obj.getClass()), "Model attribute is not of expected type '" + expectedType.getName() + "' but rather of type '" + obj.getClass().getName() + "'");
        return obj;
    }

    public static void assertCompareListModelAttribute(ModelAndView mav, Object modelName, List expectedList) throws AssertionError {
        ModelAndViewAssert.assertCondition(mav != null, "ModelAndView is null");
        List modelList = (List)ModelAndViewAssert.assertAndReturnModelAttributeOfType(mav, modelName, List.class);
        ModelAndViewAssert.assertCondition(expectedList.size() == modelList.size(), "Size of model list is '" + modelList.size() + "' while size of expected list is '" + expectedList.size() + "'");
        ModelAndViewAssert.assertCondition(((Object)expectedList).equals(modelList), "List in model under name '" + modelName + "' is not equal to the expected list.");
    }

    public static void assertModelAttributeAvailable(ModelAndView mav, Object modelName) throws AssertionError {
        ModelAndViewAssert.assertCondition(mav != null, "ModelAndView is null");
        ModelAndViewAssert.assertCondition(mav.getModel() != null, "Model is null");
        ModelAndViewAssert.assertCondition(mav.getModel().containsKey(modelName), "Model attribute with name '" + modelName + "' is not available");
    }

    public static void assertModelAttributeValue(ModelAndView mav, Object modelName, Object expectedValue) throws AssertionError {
        ModelAndViewAssert.assertCondition(mav != null, "ModelAndView is null");
        Object modelValue = ModelAndViewAssert.assertAndReturnModelAttributeOfType(mav, modelName, Object.class);
        ModelAndViewAssert.assertCondition(modelValue.equals(expectedValue), "Model value with name '" + modelName + "' is not the same as the expected value which was '" + expectedValue + "'");
    }

    public static void assertModelAttributeValues(ModelAndView mav, Map expectedModel) throws AssertionError {
        StringBuffer buf;
        ModelAndViewAssert.assertCondition(mav != null, "ModelAndView is null");
        ModelAndViewAssert.assertCondition(mav.getModel() != null, "Model is null");
        if (!((Object)mav.getModel().keySet()).equals(expectedModel.keySet())) {
            buf = new StringBuffer("Keyset of expected model does not match.\n");
            ModelAndViewAssert.appendNonMatchingSetsErrorMessage(expectedModel.keySet(), mav.getModel().keySet(), buf);
            ModelAndViewAssert.fail(buf.toString());
        }
        buf = new StringBuffer();
        Iterator it = mav.getModel().keySet().iterator();
        while (it.hasNext()) {
            Object mavValue;
            Object modelName = it.next();
            Object assertionValue = expectedModel.get(modelName);
            if (assertionValue.equals(mavValue = mav.getModel().get(modelName))) continue;
            buf.append("Value under name '" + modelName + "' differs, should have been '" + assertionValue + "' but was '" + mavValue + "'\n");
        }
        if (buf.length() != 0) {
            buf.insert(0, "Values of expected model do not match.\n");
            ModelAndViewAssert.fail(buf.toString());
        }
    }

    public static void assertSortAndCompareListModelAttribute(ModelAndView mav, Object modelName, List expectedList, Comparator comparator) throws AssertionError {
        ModelAndViewAssert.assertCondition(mav != null, "ModelAndView is null");
        List modelList = (List)ModelAndViewAssert.assertAndReturnModelAttributeOfType(mav, modelName, List.class);
        ModelAndViewAssert.assertCondition(expectedList.size() == modelList.size(), "Size of model list is '" + modelList.size() + "' while size of expected list is '" + expectedList.size() + "'");
        if (comparator != null) {
            Collections.sort(modelList, comparator);
            Collections.sort(expectedList, comparator);
        } else {
            Collections.sort(modelList);
            Collections.sort(expectedList);
        }
        ModelAndViewAssert.assertCondition(((Object)expectedList).equals(modelList), "List in model under name '" + modelName + "' is not equal to the expected list.");
    }

    public static void assertViewName(ModelAndView mav, String expectedName) throws AssertionError {
        ModelAndViewAssert.assertCondition(mav != null, "ModelAndView is null");
        ModelAndViewAssert.assertCondition(expectedName.equals(mav.getViewName()), "View name is not equal to '" + expectedName + "' but was '" + mav.getViewName() + "'");
    }

    private static void fail(String message) throws AssertionError {
        throw new AssertionError((Object)message);
    }

    private static void assertCondition(boolean condition, String message) throws AssertionError {
        if (!condition) {
            ModelAndViewAssert.fail(message);
        }
    }

    private static void appendNonMatchingSetsErrorMessage(Set assertionSet, Set incorrectSet, StringBuffer buf) {
        Object o;
        Iterator it;
        HashSet tempSet = new HashSet();
        tempSet.addAll(incorrectSet);
        tempSet.removeAll(assertionSet);
        if (tempSet.size() > 0) {
            buf.append("Set has too many elements:\n");
            it = tempSet.iterator();
            while (it.hasNext()) {
                o = it.next();
                buf.append('-');
                buf.append(o.toString());
                buf.append('\n');
            }
        }
        tempSet = new HashSet();
        tempSet.addAll(assertionSet);
        tempSet.removeAll(incorrectSet);
        if (tempSet.size() > 0) {
            buf.append("Set is missing elements:\n");
            it = tempSet.iterator();
            while (it.hasNext()) {
                o = it.next();
                buf.append('-');
                buf.append(o.toString());
                buf.append('\n');
            }
        }
    }
}

