/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination;

import java.io.IOException;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.sessions.coordination.Command;

public class MergeChangeSetCommand
extends Command {
    protected transient UnitOfWorkChangeSet changeSet;
    protected byte[] changeSetBytes;

    public UnitOfWorkChangeSet getChangeSet() {
        if (this.changeSet == null && this.changeSetBytes != null) {
            try {
                this.changeSet = new UnitOfWorkChangeSet(this.changeSetBytes);
            }
            catch (IOException exception) {
                throw CommunicationException.unableToPropagateChanges(this.getServiceId().toString(), exception);
            }
            catch (ClassNotFoundException exception) {
                throw CommunicationException.unableToPropagateChanges(this.getServiceId().toString(), exception);
            }
        }
        return this.changeSet;
    }

    public void setChangeSet(UnitOfWorkChangeSet newChangeSet) {
        this.changeSet = newChangeSet;
    }

    public boolean convertChangeSetToByteArray(AbstractSession session) throws IOException {
        this.changeSetBytes = this.changeSet.getByteArrayRepresentation(session);
        return this.changeSetBytes != null;
    }

    public void executeWithSession(AbstractSession session) {
        MergeManager manager = new MergeManager(session);
        manager.mergeIntoDistributedCache();
        manager.setCascadePolicy(3);
        manager.mergeChangesFromChangeSet(this.getChangeSet());
    }
}

