/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.ForUpdateOfClause;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.NonSynchronizedSubVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinedAttributeManager
implements Cloneable,
Serializable {
    protected List<Expression> joinedAttributeExpressions;
    protected List<Expression> joinedMappingExpressions;
    protected List<String> joinedAttributes;
    protected boolean isToManyJoin = false;
    protected boolean hasOuterJoinedAttribute = true;
    protected transient Map<DatabaseMapping, Object> joinedMappingIndexes;
    protected transient Map<DatabaseMapping, ObjectLevelReadQuery> joinedMappingQueries;
    protected transient Map<DatabaseMapping, ObjectLevelReadQuery> joinedMappingQueryClones;
    protected transient List<AbstractRecord> dataResults;
    protected transient Map<CacheKey, List> dataResultsByPrimaryKey;
    protected transient ClassDescriptor descriptor;
    protected ExpressionBuilder baseExpressionBuilder;
    protected ObjectBuildingQuery baseQuery;
    protected int parentResultIndex;
    protected boolean shouldFilterDuplicates = true;

    public JoinedAttributeManager() {
    }

    public JoinedAttributeManager(ClassDescriptor descriptor, ExpressionBuilder baseBuilder, ObjectBuildingQuery baseQuery) {
        this.descriptor = descriptor;
        this.baseQuery = baseQuery;
        this.baseExpressionBuilder = baseBuilder;
        this.parentResultIndex = 0;
    }

    public boolean shouldFilterDuplicates() {
        return this.shouldFilterDuplicates;
    }

    public void setShouldFilterDuplicates(boolean shouldFilterDuplicates) {
        this.shouldFilterDuplicates = shouldFilterDuplicates;
    }

    public void addJoinedAttribute(String attributeExpression) {
        this.getJoinedAttributes().add(attributeExpression);
    }

    public void addJoinedAttributeExpression(Expression attributeExpression) {
        this.getJoinedAttributeExpressions().add(attributeExpression);
    }

    public void addJoinedMappingExpression(Expression mappingExpression) {
        this.getJoinedMappingExpressions().add(mappingExpression);
    }

    public void addJoinedMapping(String attributeName) {
        this.addJoinedMappingExpression(this.baseExpressionBuilder.get(attributeName));
    }

    public Object clone() {
        JoinedAttributeManager joinManager = null;
        try {
            joinManager = (JoinedAttributeManager)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.toString());
        }
        if (this.joinedAttributeExpressions != null) {
            joinManager.joinedAttributeExpressions = new ArrayList<Expression>(this.joinedAttributeExpressions);
        }
        if (this.joinedMappingExpressions != null) {
            joinManager.joinedMappingExpressions = new ArrayList<Expression>(this.joinedMappingExpressions);
        }
        if (this.joinedAttributes != null) {
            joinManager.joinedAttributes = new ArrayList<String>(this.joinedAttributes);
        }
        if (this.joinedMappingIndexes != null) {
            joinManager.joinedMappingIndexes = new HashMap<DatabaseMapping, Object>(this.joinedMappingIndexes);
        }
        if (this.joinedMappingQueries != null) {
            joinManager.joinedMappingQueries = new HashMap<DatabaseMapping, ObjectLevelReadQuery>(this.joinedMappingQueries);
        }
        return joinManager;
    }

    public void clear() {
        this.joinedAttributeExpressions = null;
        this.joinedMappingExpressions = null;
        this.joinedAttributes = null;
        this.joinedMappingIndexes = null;
        this.isToManyJoin = false;
        this.hasOuterJoinedAttribute = false;
        this.joinedMappingQueries = null;
        this.joinedMappingQueryClones = null;
    }

    public int computeJoiningMappingIndexes(boolean includeAllSubclassFields, AbstractSession session, int offset) {
        if (!this.hasJoinedExpressions()) {
            return offset;
        }
        this.setJoinedMappingIndexes_(new HashMap(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size()));
        int fieldIndex = 0;
        if (this.getBaseQuery().hasPartialAttributeExpressions()) {
            fieldIndex = this.getDescriptor().getPrimaryKeyFields().size();
            for (Expression expression : ((ObjectLevelReadQuery)this.getBaseQuery()).getPartialAttributeExpressions()) {
                if (!expression.isQueryKeyExpression() || this.getJoinedMappingExpressions().contains(expression) || this.getJoinedAttributeExpressions().contains(expression)) continue;
                fieldIndex += ((QueryKeyExpression)expression).getFields().size();
            }
        } else {
            fieldIndex = includeAllSubclassFields ? this.getDescriptor().getAllFields().size() : this.getDescriptor().getFields().size();
        }
        fieldIndex += offset;
        fieldIndex = this.computeIndexesForJoinedExpressions(this.getJoinedAttributeExpressions(), fieldIndex, session);
        fieldIndex = this.computeIndexesForJoinedExpressions(this.getJoinedMappingExpressions(), fieldIndex, session);
        return fieldIndex;
    }

    protected void computeNestedQueriesForJoinedExpressions(List joinedExpressions, AbstractSession session, ObjectLevelReadQuery readQuery) {
        for (int index = 0; index < joinedExpressions.size(); ++index) {
            ForeignReferenceMapping mapping;
            ObjectLevelReadQuery nestedQuery;
            ObjectExpression objectExpression = (ObjectExpression)joinedExpressions.get(index);
            objectExpression.getBuilder().setSession(session.getRootSession(null));
            if (objectExpression.getBuilder().getQueryClass() == null) {
                objectExpression.getBuilder().setQueryClass(this.descriptor.getJavaClass());
            }
            ObjectExpression baseExpression = objectExpression;
            while (!baseExpression.getBaseExpression().isExpressionBuilder()) {
                baseExpression = (ObjectExpression)baseExpression.getBaseExpression();
            }
            this.addJoinedAttribute(baseExpression.getName());
            if (objectExpression.getBaseExpression() != objectExpression.getBuilder() || !objectExpression.getMapping().isForeignReferenceMapping() || (nestedQuery = (mapping = (ForeignReferenceMapping)objectExpression.getMapping()).prepareNestedJoins(this, readQuery, session)) == null) continue;
            this.getJoinedMappingQueries_().put(mapping, nestedQuery);
        }
    }

    public void computeJoiningMappingQueries(AbstractSession session) {
        if (this.hasJoinedExpressions()) {
            this.joinedAttributes = new ArrayList<String>(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size());
            this.setJoinedMappingQueries_(new HashMap(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size()));
            this.computeNestedQueriesForJoinedExpressions(this.getJoinedAttributeExpressions(), session, (ObjectLevelReadQuery)this.baseQuery);
            this.computeNestedQueriesForJoinedExpressions(this.getJoinedMappingExpressions(), session, (ObjectLevelReadQuery)this.baseQuery);
        }
    }

    protected int computeIndexesForJoinedExpressions(List joinedExpressions, int currentIndex, AbstractSession session) {
        for (int index = 0; index < joinedExpressions.size(); ++index) {
            ObjectExpression objectExpression = (ObjectExpression)joinedExpressions.get(index);
            DatabaseMapping mapping = objectExpression.getMapping();
            if (objectExpression.getBaseExpression() == objectExpression.getBuilder() && mapping != null && mapping.isForeignReferenceMapping()) {
                this.getJoinedMappingIndexes_().put(mapping, new Integer(currentIndex));
            }
            ClassDescriptor descriptor = mapping.getReferenceDescriptor();
            int numberOfFields = 0;
            if (descriptor == null) {
                if (mapping.isDirectCollectionMapping()) {
                    numberOfFields = 1;
                } else if (mapping.isDirectMapMapping()) {
                    numberOfFields = 2;
                }
            } else {
                numberOfFields = objectExpression.isQueryKeyExpression() && objectExpression.isUsingOuterJoinForMultitableInheritance() ? descriptor.getAllFields().size() : descriptor.getFields().size();
            }
            currentIndex += numberOfFields;
        }
        return currentIndex;
    }

    public ExpressionBuilder getBaseExpressionBuilder() {
        return this.baseExpressionBuilder;
    }

    public ObjectBuildingQuery getBaseQuery() {
        return this.baseQuery;
    }

    public List<AbstractRecord> getDataResults_() {
        return this.dataResults;
    }

    public ClassDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = this.baseQuery.getDescriptor();
        }
        return this.descriptor;
    }

    public List<String> getJoinedAttributes() {
        if (this.joinedAttributes == null) {
            this.joinedAttributes = new ArrayList<String>();
        }
        return this.joinedAttributes;
    }

    public List<Expression> getJoinedAttributeExpressions() {
        if (this.joinedAttributeExpressions == null) {
            this.joinedAttributeExpressions = new ArrayList<Expression>();
        }
        return this.joinedAttributeExpressions;
    }

    public List<Expression> getJoinedMappingExpressions() {
        if (this.joinedMappingExpressions == null) {
            this.joinedMappingExpressions = new ArrayList<Expression>();
        }
        return this.joinedMappingExpressions;
    }

    public boolean hasJoinedAttributeExpressions() {
        return this.joinedAttributeExpressions != null && !this.joinedAttributeExpressions.isEmpty();
    }

    public boolean hasJoinedExpressions() {
        return this.hasJoinedAttributeExpressions() || this.hasJoinedMappingExpressions();
    }

    public boolean hasJoinedMappingExpressions() {
        return this.joinedMappingExpressions != null && !this.joinedMappingExpressions.isEmpty();
    }

    public boolean hasJoinedAttributes() {
        return this.joinedAttributes != null && !this.joinedAttributes.isEmpty();
    }

    public boolean hasOuterJoinedAttributeQuery() {
        return this.hasOuterJoinedAttribute;
    }

    public boolean isToManyJoin() {
        return this.isToManyJoin;
    }

    public boolean isAttributeJoined(ClassDescriptor mappingDescriptor, String attributeName) {
        if (mappingDescriptor.isAggregateDescriptor() && mappingDescriptor != this.getDescriptor()) {
            return false;
        }
        if (this.hasJoinedAttributes()) {
            return this.joinedAttributes.contains(attributeName);
        }
        return this.isAttributeExpressionJoined(attributeName) || this.isAttributeMappingJoined(attributeName);
    }

    protected boolean isAttributeNameInJoinedExpressionList(String attributeName, List joinedExpressionList) {
        for (QueryKeyExpression expression : joinedExpressionList) {
            while (!expression.getBaseExpression().isExpressionBuilder()) {
                expression = (QueryKeyExpression)expression.getBaseExpression();
            }
            if (!expression.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAttributeExpressionJoined(String attributeName) {
        return this.isAttributeNameInJoinedExpressionList(attributeName, this.getJoinedAttributeExpressions());
    }

    protected boolean isAttributeMappingJoined(String attributeName) {
        return this.isAttributeNameInJoinedExpressionList(attributeName, this.getJoinedMappingExpressions());
    }

    public void setJoinedAttributeExpressions_(List joinedExpressions) {
        this.joinedAttributeExpressions = joinedExpressions;
    }

    public void setJoinedMappingExpressions_(List joinedMappingExpressions) {
        this.joinedMappingExpressions = joinedMappingExpressions;
    }

    public Map<DatabaseMapping, Object> getJoinedMappingIndexes_() {
        return this.joinedMappingIndexes;
    }

    public Map<DatabaseMapping, ObjectLevelReadQuery> getJoinedMappingQueries_() {
        return this.joinedMappingQueries;
    }

    public void setJoinedMappingQueries_(Map joinedMappingQueries) {
        this.joinedMappingQueries = joinedMappingQueries;
    }

    public void setJoinedMappingIndexes_(Map joinedMappingIndexes) {
        this.joinedMappingIndexes = joinedMappingIndexes;
    }

    protected void setIsOuterJoinedAttributeQuery(boolean isOuterJoinedAttribute) {
        this.hasOuterJoinedAttribute = isOuterJoinedAttribute;
    }

    public void setIsToManyJoinQuery(boolean isToManyJoin) {
        this.isToManyJoin = isToManyJoin;
    }

    public void prepareJoinExpressions(AbstractSession session) {
        Expression expression;
        int index;
        this.setIsOuterJoinedAttributeQuery(false);
        for (index = 0; index < this.getJoinedAttributeExpressions().size(); ++index) {
            expression = this.getJoinedAttributeExpressions().get(index);
            if (expression.isObjectExpression()) {
                ((ObjectExpression)expression).setShouldUseOuterJoinForMultitableInheritance(true);
            }
            this.prepareJoinExpression(expression, session);
        }
        for (index = 0; index < this.getJoinedMappingExpressions().size(); ++index) {
            expression = this.getJoinedMappingExpressions().get(index);
            if (expression.isObjectExpression()) {
                ((ObjectExpression)expression).setShouldUseOuterJoinForMultitableInheritance(true);
            }
            this.prepareJoinExpression(expression, session);
        }
    }

    protected void prepareJoinExpression(Expression expression, AbstractSession session) {
        if (!expression.isQueryKeyExpression()) {
            throw QueryException.mappingForExpressionDoesNotSupportJoining(expression);
        }
        QueryKeyExpression objectExpression = (QueryKeyExpression)expression;
        objectExpression.getBuilder().setSession(session.getRootSession(null));
        if (objectExpression.getBuilder().getQueryClass() == null) {
            objectExpression.getBuilder().setQueryClass(this.descriptor.getJavaClass());
        }
        if (objectExpression.getMapping() == null || !objectExpression.getMapping().isJoiningSupported()) {
            throw QueryException.mappingForExpressionDoesNotSupportJoining(objectExpression);
        }
        ObjectExpression baseExpression = objectExpression;
        while (!baseExpression.isExpressionBuilder()) {
            if (baseExpression.shouldQueryToManyRelationship()) {
                this.setIsToManyJoinQuery(true);
            }
            if (baseExpression.shouldUseOuterJoin()) {
                this.setIsOuterJoinedAttributeQuery(true);
            }
            baseExpression = (ObjectExpression)baseExpression.getBaseExpression();
        }
    }

    public void processJoinedMappings() {
        block4: {
            ObjectBuilder objectBuilder = this.getDescriptor().getObjectBuilder();
            if (!objectBuilder.hasJoinedAttributes()) break block4;
            List<DatabaseMapping> mappingJoinedAttributes = objectBuilder.getJoinedAttributes();
            if (!this.hasJoinedAttributeExpressions()) {
                for (int i = 0; i < mappingJoinedAttributes.size(); ++i) {
                    this.addJoinedMapping((ForeignReferenceMapping)mappingJoinedAttributes.get(i));
                }
            } else {
                for (int i = 0; i < mappingJoinedAttributes.size(); ++i) {
                    ForeignReferenceMapping mapping = (ForeignReferenceMapping)mappingJoinedAttributes.get(i);
                    if (this.isAttributeExpressionJoined(mapping.getAttributeName())) continue;
                    this.addJoinedMapping(mapping);
                }
            }
        }
    }

    public void addJoinedMapping(ForeignReferenceMapping mapping) {
        if (mapping.isCollectionMapping()) {
            if (mapping.isInnerJoinFetched()) {
                this.addJoinedMappingExpression(this.getBaseExpressionBuilder().anyOf(mapping.getAttributeName()));
            } else if (mapping.isOuterJoinFetched()) {
                this.addJoinedMappingExpression(this.getBaseExpressionBuilder().anyOfAllowingNone(mapping.getAttributeName()));
            }
        } else if (mapping.isInnerJoinFetched()) {
            this.addJoinedMappingExpression(this.getBaseExpressionBuilder().get(mapping.getAttributeName()));
        } else if (mapping.isOuterJoinFetched()) {
            this.addJoinedMappingExpression(this.getBaseExpressionBuilder().getAllowingNull(mapping.getAttributeName()));
        }
    }

    public void reset() {
        this.joinedMappingExpressions = null;
        this.joinedAttributes = null;
        this.isToManyJoin = false;
        this.hasOuterJoinedAttribute = true;
        this.joinedMappingIndexes = null;
        this.joinedMappingQueries = null;
        this.dataResults = null;
    }

    public void setBaseQuery(ObjectLevelReadQuery query) {
        this.baseQuery = query;
    }

    protected void setBaseExpressionBuilder(ExpressionBuilder builder) {
        this.baseExpressionBuilder = builder;
    }

    public Map<CacheKey, List> getDataResultsByPrimaryKey() {
        return this.dataResultsByPrimaryKey;
    }

    protected void setDataResultsByPrimaryKey(Map<CacheKey, List> dataResultsByPrimaryKey) {
        this.dataResultsByPrimaryKey = dataResultsByPrimaryKey;
    }

    public void setDataResults(List dataResults, AbstractSession session) {
        this.dataResults = dataResults;
        this.processDataResults(session);
    }

    protected void processDataResults(AbstractSession session) {
        this.dataResultsByPrimaryKey = new HashMap<CacheKey, List>();
        int size = this.dataResults.size();
        CacheKey lastCacheKey = null;
        ArrayList<AbstractRecord> childRows = null;
        ObjectBuilder builder = this.getDescriptor().getObjectBuilder();
        int parentIndex = this.getParentResultIndex();
        for (int dataResultsIndex = 0; dataResultsIndex < size; ++dataResultsIndex) {
            Vector sourceKey;
            AbstractRecord row;
            AbstractRecord parentRow = row = this.dataResults.get(dataResultsIndex);
            if (parentIndex > 0) {
                NonSynchronizedSubVector trimedFields = new NonSynchronizedSubVector(row.getFields(), parentIndex, row.size());
                NonSynchronizedSubVector trimedValues = new NonSynchronizedSubVector(row.getValues(), parentIndex, row.size());
                parentRow = new DatabaseRecord(trimedFields, trimedValues);
            }
            if ((sourceKey = builder.extractPrimaryKeyFromRow(parentRow, session)) == null) continue;
            CacheKey sourceCacheKey = new CacheKey(sourceKey);
            if (lastCacheKey != null && lastCacheKey.equals(sourceCacheKey)) {
                childRows.add(row);
                if (!this.shouldFilterDuplicates()) continue;
                this.dataResults.set(dataResultsIndex, null);
                continue;
            }
            childRows = this.dataResultsByPrimaryKey.get(sourceCacheKey);
            if (childRows == null) {
                childRows = new ArrayList<AbstractRecord>();
                this.dataResultsByPrimaryKey.put(sourceCacheKey, childRows);
            } else if (this.shouldFilterDuplicates()) {
                this.dataResults.set(dataResultsIndex, null);
            }
            childRows.add(row);
            lastCacheKey = sourceCacheKey;
        }
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ForUpdateOfClause setupLockingClauseForJoinedExpressions(ForUpdateOfClause lockingClause, AbstractSession session) {
        if (this.hasJoinedAttributeExpressions()) {
            return this.setupLockingClauseForJoinedExpressions(this.getJoinedAttributeExpressions(), session, lockingClause);
        }
        if (this.hasJoinedMappingExpressions()) {
            return this.setupLockingClauseForJoinedExpressions(this.getJoinedMappingExpressions(), session, lockingClause);
        }
        return lockingClause;
    }

    private ForUpdateOfClause setupLockingClauseForJoinedExpressions(List joinedExpressions, AbstractSession session, ForUpdateOfClause lockingClause) {
        for (Expression expression : joinedExpressions) {
            ClassDescriptor nestedDescriptor;
            if (!expression.isObjectExpression()) continue;
            ObjectExpression joinedAttribute = (ObjectExpression)expression;
            joinedAttribute.getBuilder().setSession(session.getRootSession(null));
            if (joinedAttribute.getBuilder().getQueryClass() == null) {
                joinedAttribute.getBuilder().setQueryClass(this.descriptor.getJavaClass());
            }
            if ((nestedDescriptor = joinedAttribute.getDescriptor()) == null) {
                return lockingClause;
            }
            if (!nestedDescriptor.hasPessimisticLockingPolicy()) continue;
            if (lockingClause == null) {
                lockingClause = new ForUpdateOfClause();
                lockingClause.setLockMode(nestedDescriptor.getCMPPolicy().getPessimisticLockingPolicy().getLockingMode());
            }
            lockingClause.addLockedExpression(joinedAttribute);
        }
        return lockingClause;
    }

    public void setParentResultIndex(int parentsResultIndex) {
        this.parentResultIndex = parentsResultIndex;
    }

    public int getParentResultIndex() {
        return this.parentResultIndex;
    }

    public Map<DatabaseMapping, ObjectLevelReadQuery> getJoinedMappingQueryClones() {
        return this.joinedMappingQueryClones;
    }

    public void setJoinedMappingQueryClones(Map joinedMappingQueryClones) {
        this.joinedMappingQueryClones = joinedMappingQueryClones;
    }
}

