/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.lang.reflect.Modifier;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLRelationshipMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.deferred.CompositeObjectMappingContentHandler;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.Session;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLCompositeObjectMappingNodeValue
extends XMLRelationshipMappingNodeValue
implements NullCapableValue {
    private XMLCompositeObjectMapping xmlCompositeObjectMapping;

    public XMLCompositeObjectMappingNodeValue(XMLCompositeObjectMapping xmlCompositeObjectMapping) {
        this.xmlCompositeObjectMapping = xmlCompositeObjectMapping;
    }

    public boolean marshalSelfAttributes(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, XMLMarshaller marshaller) {
        Object objectValue = this.xmlCompositeObjectMapping.getAttributeValueFromObject(object);
        if (this.xmlCompositeObjectMapping.getConverter() != null) {
            Converter converter = this.xmlCompositeObjectMapping.getConverter();
            objectValue = converter instanceof XMLConverter ? ((XMLConverter)converter).convertObjectValueToDataValue(objectValue, session, marshaller) : converter.convertObjectValueToDataValue(objectValue, session);
        }
        XMLDescriptor descriptor = (XMLDescriptor)session.getDescriptor(objectValue);
        TreeObjectBuilder objectBuilder = (TreeObjectBuilder)descriptor.getObjectBuilder();
        return objectBuilder.marshalAttributes(marshalRecord, objectValue, session);
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlCompositeObjectMapping.isReadOnly()) {
            return false;
        }
        if (xPathFragment.hasLeafElementType()) {
            marshalRecord.setLeafElementType(xPathFragment.getLeafElementType());
        }
        XMLMarshaller marshaller = marshalRecord.getMarshaller();
        Object objectValue = marshalContext.getAttributeValue(object, this.xmlCompositeObjectMapping);
        if (this.xmlCompositeObjectMapping.getConverter() != null) {
            Converter converter = this.xmlCompositeObjectMapping.getConverter();
            objectValue = converter instanceof XMLConverter ? ((XMLConverter)converter).convertObjectValueToDataValue(objectValue, session, marshaller) : converter.convertObjectValueToDataValue(objectValue, session);
        }
        if (null == objectValue) {
            return this.xmlCompositeObjectMapping.getNullPolicy().compositeObjectMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
        }
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().beforeMarshal(objectValue);
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        XMLDescriptor descriptor = (XMLDescriptor)session.getDescriptor(objectValue);
        TreeObjectBuilder objectBuilder = (TreeObjectBuilder)descriptor.getObjectBuilder();
        if (!xPathFragment.isSelfFragment()) {
            this.getXPathNode().startElement(marshalRecord, xPathFragment, object, session, namespaceResolver, objectBuilder, objectValue);
        }
        List extraNamespaces = objectBuilder.addExtraNamespacesToNamespaceResolver(descriptor, marshalRecord, session);
        this.writeExtraNamespaces(extraNamespaces, marshalRecord, session);
        if (this.xmlCompositeObjectMapping.getReferenceDescriptor() == null && descriptor.getSchemaReference() != null) {
            this.addTypeAttributeIfNeeded(descriptor, this.xmlCompositeObjectMapping, marshalRecord);
        }
        objectBuilder.buildRow((AbstractRecord)marshalRecord, objectValue, session, marshaller);
        if (!xPathFragment.isSelfFragment()) {
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        }
        objectBuilder.removeExtraNamespacesFromNamespaceResolver(marshalRecord, extraNamespaces, session);
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().afterMarshal(objectValue);
        }
        return true;
    }

    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        try {
            unmarshalRecord.removeNullCapableValue(this);
            XMLDescriptor xmlDescriptor = (XMLDescriptor)this.xmlCompositeObjectMapping.getReferenceDescriptor();
            if (null == xmlDescriptor) {
                xmlDescriptor = this.findReferenceDescriptor(unmarshalRecord, atts, this.xmlCompositeObjectMapping);
            }
            if (this.xmlCompositeObjectMapping.getNullPolicy().isNullRepresentedByEmptyNode() || this.xmlCompositeObjectMapping.getNullPolicy().isNullRepresentedByXsiNil()) {
                if (null != xmlDescriptor) {
                    String qnameString = xPathFragment.getLocalName();
                    if (xPathFragment.getPrefix() != null) {
                        qnameString = xPathFragment.getPrefix() + ":" + qnameString;
                    }
                    CompositeObjectMappingContentHandler aHandler = new CompositeObjectMappingContentHandler(unmarshalRecord, this, this.xmlCompositeObjectMapping, atts, xPathFragment, xmlDescriptor);
                    aHandler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), qnameString, atts);
                    unmarshalRecord.getXMLReader().setContentHandler(aHandler);
                }
            } else {
                boolean isNull = this.xmlCompositeObjectMapping.getNullPolicy().valueIsNull(atts);
                if (isNull) {
                    this.xmlCompositeObjectMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), null);
                } else {
                    XMLField xmlFld = (XMLField)this.xmlCompositeObjectMapping.getField();
                    if (xmlFld.hasLastXPathFragment()) {
                        unmarshalRecord.setLeafElementType(xmlFld.getLastXPathFragment().getLeafElementType());
                    }
                    this.processChild(xPathFragment, unmarshalRecord, atts, xmlDescriptor);
                }
            }
        }
        catch (SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        return true;
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        if (null == unmarshalRecord.getChildRecord()) {
            return;
        }
        Object object = unmarshalRecord.getChildRecord().getCurrentObject();
        if (this.xmlCompositeObjectMapping.getConverter() != null) {
            Converter converter = this.xmlCompositeObjectMapping.getConverter();
            object = converter instanceof XMLConverter ? ((XMLConverter)converter).convertDataValueToObjectValue(object, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller()) : converter.convertDataValueToObjectValue(object, unmarshalRecord.getSession());
        }
        unmarshalRecord.setAttributeValue(object, this.xmlCompositeObjectMapping);
        unmarshalRecord.setChildRecord(null);
    }

    public UnmarshalRecord buildSelfRecord(UnmarshalRecord unmarshalRecord, Attributes atts) {
        try {
            XMLDescriptor xmlDescriptor = (XMLDescriptor)this.xmlCompositeObjectMapping.getReferenceDescriptor();
            if (xmlDescriptor.hasInheritance()) {
                QName leafElementType;
                unmarshalRecord.setAttributes(atts);
                Class clazz = xmlDescriptor.getInheritancePolicy().classFromRow(unmarshalRecord, unmarshalRecord.getSession());
                if (clazz == null && (leafElementType = unmarshalRecord.getLeafElementType()) != null) {
                    Object indicator = xmlDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(leafElementType);
                    if (indicator == null) {
                        throw DescriptorException.missingClassForIndicatorFieldValue(leafElementType, xmlDescriptor.getInheritancePolicy().getDescriptor());
                    }
                    clazz = (Class)indicator;
                }
                if (clazz != null) {
                    xmlDescriptor = (XMLDescriptor)unmarshalRecord.getSession().getDescriptor(clazz);
                } else if (Modifier.isAbstract(xmlDescriptor.getJavaClass().getModifiers())) {
                    throw DescriptorException.missingClassIndicatorField(unmarshalRecord, xmlDescriptor.getInheritancePolicy().getDescriptor());
                }
            }
            TreeObjectBuilder stob2 = (TreeObjectBuilder)xmlDescriptor.getObjectBuilder();
            UnmarshalRecord childRecord = (UnmarshalRecord)stob2.createRecord(unmarshalRecord.getSession());
            childRecord.setSelfRecord(true);
            unmarshalRecord.setChildRecord(childRecord);
            childRecord.setXMLReader(unmarshalRecord.getXMLReader());
            childRecord.startDocument(this.xmlCompositeObjectMapping);
            this.xmlCompositeObjectMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), childRecord.getCurrentObject());
            return childRecord;
        }
        catch (SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public void setNullValue(Object object, Session session) {
        this.xmlCompositeObjectMapping.setAttributeValueInObject(object, null);
    }

    public boolean isNullCapableValue() {
        XMLField xmlField = (XMLField)this.xmlCompositeObjectMapping.getField();
        if (xmlField.getLastXPathFragment().isSelfFragment) {
            return false;
        }
        return this.xmlCompositeObjectMapping.getNullPolicy().getIsSetPerformedForAbsentNode();
    }

    protected void addTypeAttributeIfNeeded(XMLDescriptor descriptor, DatabaseMapping mapping, MarshalRecord marshalRecord) {
        XMLSchemaReference xmlRef = descriptor.getSchemaReference();
        if (this.xmlCompositeObjectMapping.shouldAddXsiType(marshalRecord, descriptor) && xmlRef != null) {
            this.addTypeAttribute(descriptor, marshalRecord, xmlRef.getSchemaContext());
        }
    }
}

