/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ManualQueryKeyExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;

public abstract class ObjectExpression
extends DataExpression {
    public transient ClassDescriptor descriptor;
    public Vector derivedExpressions;
    protected boolean shouldUseOuterJoinForMultitableInheritance;
    protected boolean shouldUseOuterJoin = false;

    public boolean equals(Object expression) {
        if (this == expression) {
            return true;
        }
        return super.equals(expression) && this.shouldUseOuterJoin() == ((ObjectExpression)expression).shouldUseOuterJoin();
    }

    public void addDerivedExpression(Expression addThis) {
        if (this.derivedExpressions == null) {
            this.derivedExpressions = NonSynchronizedVector.newInstance();
        }
        this.derivedExpressions.addElement(addThis);
    }

    public Expression additionalExpressionCriteria() {
        if (this.getDescriptor() == null) {
            return null;
        }
        Expression criteria = this.getDescriptor().getQueryManager().getAdditionalJoinExpression();
        if (this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() && this.isUsingOuterJoinForMultitableInheritance()) {
            Expression childrenCriteria = this.getDescriptor().getInheritancePolicy().getChildrenJoinExpression();
            childrenCriteria = this.getBaseExpression().twist(childrenCriteria, this);
            childrenCriteria.convertToUseOuterJoin();
            criteria = criteria == null ? childrenCriteria : criteria.and(childrenCriteria);
        }
        return criteria;
    }

    public Map additionalExpressionCriteriaMap() {
        if (this.getDescriptor() == null) {
            return null;
        }
        HashMap<DatabaseTable, Expression> tablesJoinExpressions = null;
        if (this.isUsingOuterJoinForMultitableInheritance()) {
            tablesJoinExpressions = new HashMap<DatabaseTable, Expression>();
            List childrenTables = this.getDescriptor().getInheritancePolicy().getChildrenTables();
            for (int i = 0; i < childrenTables.size(); ++i) {
                DatabaseTable table = (DatabaseTable)childrenTables.get(i);
                Expression joinExpression = (Expression)this.getDescriptor().getInheritancePolicy().getChildrenTablesJoinExpressions().get(table);
                joinExpression = this.getBaseExpression() != null ? this.getBaseExpression().twist(joinExpression, this) : this.twist(joinExpression, this);
                tablesJoinExpressions.put(table, joinExpression);
            }
        }
        return tablesJoinExpressions;
    }

    public Expression anyOf(String attributeName) {
        QueryKeyExpression queryKey = this.newDerivedExpressionNamed(attributeName);
        queryKey.doQueryToManyRelationship();
        return queryKey;
    }

    public Expression anyOfAllowingNone(String attributeName) {
        QueryKeyExpression queryKey = this.newDerivedExpressionNamed(attributeName);
        queryKey.doUseOuterJoin();
        queryKey.doQueryToManyRelationship();
        return queryKey;
    }

    public QueryKeyExpression derivedExpressionNamed(String attributeName) {
        QueryKeyExpression existing = this.existingDerivedExpressionNamed(attributeName);
        if (existing != null) {
            return existing;
        }
        return this.newDerivedExpressionNamed(attributeName);
    }

    public Expression derivedManualExpressionNamed(String attributeName, ClassDescriptor aDescriptor) {
        QueryKeyExpression existing = this.existingDerivedExpressionNamed(attributeName);
        if (existing != null) {
            return existing;
        }
        return this.newManualDerivedExpressionNamed(attributeName, aDescriptor);
    }

    protected void doNotUseOuterJoin() {
        this.shouldUseOuterJoin = false;
    }

    protected void doUseOuterJoin() {
        this.shouldUseOuterJoin = true;
    }

    public QueryKeyExpression existingDerivedExpressionNamed(String attributeName) {
        if (this.derivedExpressions == null) {
            return null;
        }
        Enumeration e = this.derivedExpressions.elements();
        while (e.hasMoreElements()) {
            QueryKeyExpression exp = (QueryKeyExpression)e.nextElement();
            if (!exp.getName().equals(attributeName)) continue;
            return exp;
        }
        return null;
    }

    public Expression get(String attributeName, Vector arguments) {
        Expression operatorExpression = super.get(attributeName, arguments);
        if (operatorExpression != null) {
            return operatorExpression;
        }
        QueryKeyExpression result = this.derivedExpressionNamed(attributeName);
        result.doNotUseOuterJoin();
        return result;
    }

    public Expression getAllowingNull(String attributeName, Vector arguments) {
        QueryKeyExpression exp = this.existingDerivedExpressionNamed(attributeName);
        if (exp != null) {
            return exp;
        }
        exp = this.derivedExpressionNamed(attributeName);
        exp.doUseOuterJoin();
        return exp;
    }

    public ClassDescriptor getDescriptor() {
        if (this.isAttribute()) {
            return null;
        }
        if (this.descriptor == null) {
            ForeignReferenceQueryKey queryKey = (ForeignReferenceQueryKey)this.getQueryKeyOrNull();
            if (queryKey != null) {
                this.descriptor = this.getSession().getDescriptor(queryKey.getReferenceClass());
                return this.descriptor;
            }
            if (this.getMapping() == null) {
                throw QueryException.invalidQueryKeyInExpression(this);
            }
            this.descriptor = this.getMapping().getReferenceDescriptor();
            if (this.getMapping().isVariableOneToOneMapping()) {
                throw QueryException.cannotQueryAcrossAVariableOneToOneMapping(this.getMapping(), this.descriptor);
            }
        }
        return this.descriptor;
    }

    public Vector getFields() {
        if (this.getDescriptor() == null) {
            DatabaseMapping mapping = this.getMapping();
            if (mapping != null) {
                return mapping.getSelectFields();
            }
            return new NonSynchronizedVector(0);
        }
        if (this.descriptor.hasInheritance() && this.descriptor.getInheritancePolicy().shouldReadSubclasses() && !this.descriptor.getInheritancePolicy().hasMultipleTableChild() || this.shouldUseOuterJoinForMultitableInheritance()) {
            return this.descriptor.getAllFields();
        }
        return this.descriptor.getFields();
    }

    protected Vector getForUpdateOfFields() {
        Vector allFields = this.getFields();
        int expected = this.getTableAliases().size();
        Vector<DatabaseField> firstFields = new Vector<DatabaseField>(expected);
        DatabaseTable lastTable = null;
        DatabaseField field = null;
        int i = 0;
        while (i < allFields.size() && firstFields.size() < expected) {
            int j;
            field = (DatabaseField)allFields.elementAt(i++);
            if (lastTable != null && field.getTable().equals(lastTable)) continue;
            lastTable = field.getTable();
            for (j = 0; j < firstFields.size() && !lastTable.equals(((DatabaseField)firstFields.elementAt(j)).getTable()); ++j) {
            }
            if (j != firstFields.size()) continue;
            firstFields.addElement(field);
        }
        return firstFields;
    }

    public Expression getManualQueryKey(String attributeName, ClassDescriptor aDescriptor) {
        return this.derivedManualExpressionNamed(attributeName, aDescriptor);
    }

    public Vector getOwnedTables() {
        if (this.isUsingOuterJoinForMultitableInheritance()) {
            return this.getDescriptor().getInheritancePolicy().getAllTables();
        }
        return super.getOwnedTables();
    }

    protected boolean hasDerivedExpressions() {
        return this.derivedExpressions != null;
    }

    public boolean isObjectExpression() {
        return true;
    }

    public boolean isUsingOuterJoinForMultitableInheritance() {
        return this.shouldUseOuterJoinForMultitableInheritance() && this.getDescriptor() != null && this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().hasMultipleTableChild() && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses();
    }

    public QueryKeyExpression newDerivedExpressionNamed(String attributeName) {
        QueryKeyExpression result = new QueryKeyExpression(attributeName, this);
        this.addDerivedExpression(result);
        return result;
    }

    public Expression newManualDerivedExpressionNamed(String attributeName, ClassDescriptor aDescriptor) {
        ManualQueryKeyExpression result = new ManualQueryKeyExpression(attributeName, this, aDescriptor);
        this.addDerivedExpression(result);
        return result;
    }

    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        this.derivedExpressions = this.copyCollection(this.derivedExpressions, alreadyDone);
    }

    public void postCopyIn(Map alreadyDone, Vector oldDerivedFields, Vector oldDerivedTables) {
        if (oldDerivedFields != null) {
            if (this.derivedFields == null) {
                this.derivedFields = this.copyCollection(oldDerivedFields, alreadyDone);
            } else {
                this.derivedFields.addAll(this.copyCollection(oldDerivedFields, alreadyDone));
            }
        }
        if (oldDerivedTables != null) {
            if (this.derivedTables == null) {
                this.derivedTables = this.copyCollection(oldDerivedTables, alreadyDone);
            } else {
                this.derivedTables.addAll(this.copyCollection(oldDerivedTables, alreadyDone));
            }
        }
    }

    public void setShouldUseOuterJoinForMultitableInheritance(boolean shouldUseOuterJoinForMultitableInheritance) {
        this.shouldUseOuterJoinForMultitableInheritance = shouldUseOuterJoinForMultitableInheritance;
    }

    public boolean shouldUseOuterJoin() {
        return this.shouldUseOuterJoin;
    }

    public boolean shouldUseOuterJoinForMultitableInheritance() {
        return this.shouldUseOuterJoinForMultitableInheritance;
    }

    protected void writeForUpdateOfFields(ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        Enumeration fieldsEnum = this.getForUpdateOfFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            DatabaseField field = (DatabaseField)fieldsEnum.nextElement();
            this.writeField(printer, field, statement);
        }
    }
}

