/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.jsc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.optimizer.ClassCompiler;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class Main {
    private boolean printHelp;
    private ToolErrorReporter reporter = new ToolErrorReporter(true);
    private CompilerEnvirons compilerEnv = new CompilerEnvirons();
    private ClassCompiler compiler;
    private String targetName;
    private String targetPackage;
    private String destinationDir;
    static /* synthetic */ Class class$org$mozilla$javascript$tools$jsc$Main;

    public static void main(String[] args) {
        Main main = new Main();
        if ((args = main.processOptions(args)) == null) {
            if (main.printHelp) {
                System.out.println(ToolErrorReporter.getMessage("msg.jsc.usage", (class$org$mozilla$javascript$tools$jsc$Main == null ? (class$org$mozilla$javascript$tools$jsc$Main = Main.class$("org.mozilla.javascript.tools.jsc.Main")) : class$org$mozilla$javascript$tools$jsc$Main).getName()));
                System.exit(0);
            }
            System.exit(1);
        }
        if (!main.reporter.hasReportedError()) {
            main.processSource(args);
        }
    }

    public Main() {
        this.compilerEnv.setErrorReporter(this.reporter);
        this.compiler = new ClassCompiler(this.compilerEnv);
    }

    public String[] processOptions(String[] args) {
        this.targetPackage = "";
        this.compilerEnv.setGenerateDebugInfo(false);
        int i = 0;
        while (i < args.length) {
            block30: {
                String arg;
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    arg = args[i];
                                    if (!arg.startsWith("-")) {
                                        int tail = args.length - i;
                                        if (this.targetName != null && tail > 1) {
                                            this.addError("msg.multiple.js.to.file", this.targetName);
                                            return null;
                                        }
                                        String[] result = new String[tail];
                                        int j = 0;
                                        while (j != tail) {
                                            result[j] = args[i + j];
                                            ++j;
                                        }
                                        return result;
                                    }
                                    if (arg.equals("-help") || arg.equals("-h") || arg.equals("--help")) {
                                        this.printHelp = true;
                                        return null;
                                    }
                                    try {
                                        if (arg.equals("-version") && ++i < args.length) {
                                            int version = Integer.parseInt(args[i]);
                                            this.compilerEnv.setLanguageVersion(version);
                                            break block30;
                                        }
                                        if (!arg.equals("-opt") && !arg.equals("-O") || ++i >= args.length) break block31;
                                        int optLevel = Integer.parseInt(args[i]);
                                        this.compilerEnv.setOptimizationLevel(optLevel);
                                        break block30;
                                    }
                                    catch (NumberFormatException e) {
                                        Main.badUsage(args[i]);
                                        return null;
                                    }
                                }
                                if (!arg.equals("-nosource")) break block32;
                                this.compilerEnv.setGeneratingSource(false);
                                break block30;
                            }
                            if (!arg.equals("-debug") && !arg.equals("-g")) break block33;
                            this.compilerEnv.setGenerateDebugInfo(true);
                            break block30;
                        }
                        if (!arg.equals("-o") || ++i >= args.length) break block34;
                        String name = args[i];
                        int end = name.length();
                        if (end == 0 || !Character.isJavaIdentifierStart(name.charAt(0))) {
                            this.addError("msg.invalid.classfile.name", name);
                        } else {
                            int j = 1;
                            while (j < end) {
                                char c = name.charAt(j);
                                if (!Character.isJavaIdentifierPart(c)) {
                                    if (c == '.' && j == end - 6 && name.endsWith(".class")) {
                                        name = name.substring(0, j);
                                        break;
                                    }
                                    this.addError("msg.invalid.classfile.name", name);
                                    break;
                                }
                                ++j;
                            }
                            this.targetName = name;
                        }
                        break block30;
                    }
                    if (!arg.equals("-package") || ++i >= args.length) break block35;
                    String pkg = args[i];
                    int end = pkg.length();
                    int j = 0;
                    while (j != end) {
                        block37: {
                            block36: {
                                char c = pkg.charAt(j);
                                if (!Character.isJavaIdentifierStart(c)) break block36;
                                ++j;
                                while (j != end) {
                                    c = pkg.charAt(j);
                                    if (!Character.isJavaIdentifierPart(c)) break;
                                    ++j;
                                }
                                if (j == end) break;
                                if (c == '.' && j != end - 1) break block37;
                            }
                            this.addError("msg.package.name", this.targetPackage);
                            return null;
                        }
                        ++j;
                    }
                    this.targetPackage = pkg;
                    break block30;
                }
                if (arg.equals("-extends") && ++i < args.length) {
                    Class<?> superClass;
                    String targetExtends = args[i];
                    try {
                        superClass = Class.forName(targetExtends);
                    }
                    catch (ClassNotFoundException e) {
                        throw new Error(e.toString());
                    }
                    this.compiler.setTargetExtends(superClass);
                } else if (arg.equals("-implements") && ++i < args.length) {
                    String targetImplements = args[i];
                    StringTokenizer st = new StringTokenizer(targetImplements, ",");
                    Vector v = new Vector();
                    while (st.hasMoreTokens()) {
                        String className = st.nextToken();
                        try {
                            v.addElement(Class.forName(className));
                        }
                        catch (ClassNotFoundException e) {
                            throw new Error(e.toString());
                        }
                    }
                    Object[] implementsClasses = new Class[v.size()];
                    v.copyInto(implementsClasses);
                    this.compiler.setTargetImplements((Class[])implementsClasses);
                } else if (arg.equals("-d") && ++i < args.length) {
                    this.destinationDir = args[i];
                } else {
                    Main.badUsage(arg);
                    return null;
                }
            }
            ++i;
        }
        Main.p(ToolErrorReporter.getMessage("msg.no.file"));
        return null;
    }

    private static void badUsage(String s) {
        System.err.println(ToolErrorReporter.getMessage("msg.jsc.bad.usage", (class$org$mozilla$javascript$tools$jsc$Main == null ? (class$org$mozilla$javascript$tools$jsc$Main = Main.class$("org.mozilla.javascript.tools.jsc.Main")) : class$org$mozilla$javascript$tools$jsc$Main).getName(), s));
    }

    public void processSource(String[] filenames) {
        int i = 0;
        while (i != filenames.length) {
            Object[] compiled;
            String filename = filenames[i];
            if (!filename.endsWith(".js")) {
                this.addError("msg.extension.not.js", filename);
                return;
            }
            File f = new File(filename);
            String source = this.readSource(f);
            if (source == null) {
                return;
            }
            String mainClassName = this.targetName;
            if (mainClassName == null) {
                String name = f.getName();
                String nojs = name.substring(0, name.length() - 3);
                mainClassName = this.getClassName(nojs);
            }
            if (this.targetPackage.length() != 0) {
                mainClassName = this.targetPackage + "." + mainClassName;
            }
            if ((compiled = this.compiler.compileToClassFiles(source, filename, 1, mainClassName)) == null || compiled.length == 0) {
                return;
            }
            File targetTopDir = null;
            if (this.destinationDir != null) {
                targetTopDir = new File(this.destinationDir);
            } else {
                String parent = f.getParent();
                if (parent != null) {
                    targetTopDir = new File(parent);
                }
            }
            int j = 0;
            while (j != compiled.length) {
                String className = (String)compiled[j];
                byte[] bytes = (byte[])compiled[j + 1];
                File outfile = this.getOutputFile(targetTopDir, className);
                try {
                    Object var15_16;
                    FileOutputStream os = new FileOutputStream(outfile);
                    try {
                        os.write(bytes);
                        var15_16 = null;
                    }
                    catch (Throwable throwable) {
                        var15_16 = null;
                        os.close();
                        throw throwable;
                    }
                    os.close();
                    {
                    }
                }
                catch (IOException ioe) {
                    this.addFormatedError(ioe.toString());
                }
                j += 2;
            }
            ++i;
        }
    }

    private String readSource(File f) {
        if (!f.exists()) {
            this.addError("msg.jsfile.not.found", f.getAbsolutePath());
            return null;
        }
        try {
            String string;
            FileReader in = new FileReader(f);
            try {
                string = Kit.readReader(in);
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ((Reader)in).close();
                throw throwable;
            }
            ((Reader)in).close();
            return string;
        }
        catch (FileNotFoundException ex) {
            this.addError("msg.couldnt.open", f.getAbsolutePath());
        }
        catch (IOException ioe) {
            this.addFormatedError(ioe.toString());
        }
        return null;
    }

    private File getOutputFile(File parentDir, String className) {
        File dir;
        String path = className.replace('.', File.separatorChar);
        File f = new File(parentDir, path = path.concat(".class"));
        String dirPath = f.getParent();
        if (dirPath != null && !(dir = new File(dirPath)).exists()) {
            dir.mkdirs();
        }
        return f;
    }

    String getClassName(String name) {
        char[] s = new char[name.length() + 1];
        int j = 0;
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            s[j++] = 95;
        }
        int i = 0;
        while (i < name.length()) {
            int c = name.charAt(i);
            s[j] = Character.isJavaIdentifierPart((char)c) ? c : 95;
            ++i;
            ++j;
        }
        return new String(s).trim();
    }

    private static void p(String s) {
        System.out.println(s);
    }

    private void addError(String messageId, String arg) {
        String msg = arg == null ? ToolErrorReporter.getMessage(messageId) : ToolErrorReporter.getMessage(messageId, arg);
        this.addFormatedError(msg);
    }

    private void addFormatedError(String message) {
        this.reporter.error(message, null, -1, null, -1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

